/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.event.AepEngineStoppedEvent;
import com.neeve.aep.event.AepSendExceptionEvent;
import com.neeve.aep.event.AepSendStabilityEvent;
import com.neeve.aep.test.unit.AepEngineTestMessage;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.aep.test.unit.AepSFRTestAppBase;
import com.neeve.aep.test.unit.AepSFRTestBase;
import com.neeve.aep.test.unit.generated.json.Message;
import com.neeve.aep.test.unit.generated.proto.Repository;
import com.neeve.aep.test.unit.generated.xbuf.Factory;
import com.neeve.rog.IRogMessage;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageView;
import com.neeve.sma.impl.loopback.LoopbackBus;
import com.neeve.sma.impl.loopback.LoopbackMessageChannel;
import com.neeve.util.UtlThrowable;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AepEngineSendStabilityTest
extends AepSFRTestBase {
    @Parameterized.Parameter(value=0)
    public boolean hasStore;
    @Parameterized.Parameter(value=1)
    public AepEngine.HAPolicy haPolicy;
    @Parameterized.Parameter(value=2)
    public boolean persistent;
    @Parameterized.Parameter(value=3)
    public boolean clustered;
    @Parameterized.Parameter(value=4)
    public boolean sequenceUnsolicitedSendsWithSolicitedSends;
    @Parameterized.Parameter(value=5)
    public boolean dispatchSendStabilityEvents;
    @Parameterized.Parameter(value=6)
    public AepEngineTestObject.EncodingType encoding;
    @Parameterized.Parameter(value=7)
    public MessageChannel.Qos qos;
    @Rule
    public ExpectedException storeRequiredForRollback = ExpectedException.none();
    public ExpectedException eventSourcingNoSupported = ExpectedException.none();
    private UnsolicitedSender senderPrimary;
    private UnsolicitedSender senderBackup;
    private AepSFRTestBase.Forwarder forwarder;

    @Parameterized.Parameters(name="{index}: hasStore={0}, haPolicy={1}, persistent={2}, clustered={3}, seqUnsolicitedWithSolicited={4}, dispatchSendStabilityEvents= {5}, encoding={6}, qos={7}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{false, AepEngine.HAPolicy.EventSourcing, false, false, true, true, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.BestEffort}, {false, AepEngine.HAPolicy.StateReplication, false, false, true, true, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.BestEffort}, {true, AepEngine.HAPolicy.EventSourcing, true, false, true, true, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.BestEffort}, {true, AepEngine.HAPolicy.StateReplication, true, false, true, true, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.BestEffort}, {true, AepEngine.HAPolicy.EventSourcing, true, true, true, true, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.BestEffort}, {true, AepEngine.HAPolicy.StateReplication, true, true, true, true, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.BestEffort}, {false, AepEngine.HAPolicy.EventSourcing, false, false, true, true, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.Guaranteed}, {false, AepEngine.HAPolicy.StateReplication, false, false, true, true, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.Guaranteed}, {true, AepEngine.HAPolicy.EventSourcing, true, false, true, true, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.Guaranteed}, {true, AepEngine.HAPolicy.StateReplication, true, false, true, true, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.Guaranteed}, {true, AepEngine.HAPolicy.EventSourcing, true, true, true, true, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.Guaranteed}, {true, AepEngine.HAPolicy.StateReplication, true, true, true, true, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.Guaranteed}, {false, AepEngine.HAPolicy.EventSourcing, false, false, false, true, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.BestEffort}, {false, AepEngine.HAPolicy.StateReplication, false, false, false, true, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.BestEffort}, {true, AepEngine.HAPolicy.EventSourcing, true, false, false, true, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.BestEffort}, {true, AepEngine.HAPolicy.StateReplication, true, false, false, true, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.BestEffort}, {true, AepEngine.HAPolicy.EventSourcing, true, true, false, true, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.BestEffort}, {true, AepEngine.HAPolicy.StateReplication, true, true, false, true, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.BestEffort}, {false, AepEngine.HAPolicy.EventSourcing, false, false, false, true, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.Guaranteed}, {false, AepEngine.HAPolicy.StateReplication, false, false, false, true, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.Guaranteed}, {true, AepEngine.HAPolicy.EventSourcing, true, false, false, true, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.Guaranteed}, {true, AepEngine.HAPolicy.StateReplication, true, false, false, true, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.Guaranteed}, {true, AepEngine.HAPolicy.EventSourcing, true, true, false, true, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.Guaranteed}, {true, AepEngine.HAPolicy.StateReplication, true, true, false, true, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.Guaranteed}, {false, AepEngine.HAPolicy.EventSourcing, false, false, true, false, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.BestEffort}, {false, AepEngine.HAPolicy.StateReplication, false, false, true, false, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.BestEffort}, {true, AepEngine.HAPolicy.EventSourcing, true, false, true, false, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.BestEffort}, {true, AepEngine.HAPolicy.StateReplication, true, false, true, false, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.BestEffort}, {true, AepEngine.HAPolicy.EventSourcing, true, true, true, false, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.BestEffort}, {true, AepEngine.HAPolicy.StateReplication, true, true, true, false, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.BestEffort}, {false, AepEngine.HAPolicy.EventSourcing, false, false, true, false, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.Guaranteed}, {false, AepEngine.HAPolicy.StateReplication, false, false, true, false, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.Guaranteed}, {true, AepEngine.HAPolicy.EventSourcing, true, false, true, false, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.Guaranteed}, {true, AepEngine.HAPolicy.StateReplication, true, false, true, false, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.Guaranteed}, {true, AepEngine.HAPolicy.EventSourcing, true, true, true, false, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.Guaranteed}, {true, AepEngine.HAPolicy.StateReplication, true, true, true, false, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.Guaranteed}, {false, AepEngine.HAPolicy.EventSourcing, false, false, false, false, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.BestEffort}, {false, AepEngine.HAPolicy.StateReplication, false, false, false, false, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.BestEffort}, {true, AepEngine.HAPolicy.EventSourcing, true, false, false, false, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.BestEffort}, {true, AepEngine.HAPolicy.StateReplication, true, false, false, false, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.BestEffort}, {true, AepEngine.HAPolicy.EventSourcing, true, true, false, false, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.BestEffort}, {true, AepEngine.HAPolicy.StateReplication, true, true, false, false, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.BestEffort}, {false, AepEngine.HAPolicy.EventSourcing, false, false, false, false, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.Guaranteed}, {false, AepEngine.HAPolicy.StateReplication, false, false, false, false, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.Guaranteed}, {true, AepEngine.HAPolicy.EventSourcing, true, false, false, false, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.Guaranteed}, {true, AepEngine.HAPolicy.StateReplication, true, false, false, false, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.Guaranteed}, {true, AepEngine.HAPolicy.EventSourcing, true, true, false, false, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.Guaranteed}, {true, AepEngine.HAPolicy.StateReplication, true, true, false, false, AepEngineTestObject.EncodingType.Proto, MessageChannel.Qos.Guaranteed}};
        return Arrays.asList(data);
    }

    @Override
    public String testCaseId() {
        String methodName = this.testcaseName.getMethodName();
        return methodName.substring(0, methodName.indexOf(":")).replace('[', '-');
    }

    @Before
    public void setupTestcase() {
        AepEngineSendStabilityTest.setVerbose((boolean)false);
        this.senderPrimary = (UnsolicitedSender)((AepSFRTestBase.Sender)((AepSFRTestBase.Sender)((AepSFRTestBase.Sender)((AepSFRTestBase.Sender)this.createSender(this.clustered ? "primary" : "standalone", UnsolicitedSender.class).setStoreEnabled(this.hasStore)).setClustered(this.clustered)).setStoreReplicatorProperty("initWaitTime", "100")).setStoreReplicatorProperty("memberElectionPriority", "0")).setPersistent(this.persistent);
        this.senderPrimary.engineDescriptor.setOutboundMessageLoggingPolicy(AepEngine.OutboundMessageLoggingPolicy.UseDedicated);
        this.senderPrimary.engineDescriptor.setAdaptiveCommitBatchCeiling(10);
        this.senderPrimary.engineDescriptor.setDispatchSendStabilityEvents(this.dispatchSendStabilityEvents);
        this.senderPrimary.engineDescriptor.setSequenceUnsolicitedSends(true);
        this.senderPrimary.engineDescriptor.setSequenceUnsolicitedWithSolicitedSends(this.sequenceUnsolicitedSendsWithSolicitedSends);
        if (this.clustered) {
            this.senderBackup = (UnsolicitedSender)((AepSFRTestBase.Sender)((AepSFRTestBase.Sender)((AepSFRTestBase.Sender)((AepSFRTestBase.Sender)this.createSender("backup", UnsolicitedSender.class).setStoreEnabled(this.hasStore)).setClustered(this.clustered)).setStoreReplicatorProperty("initWaitTime", "100")).setStoreReplicatorProperty("memberElectionPriority", "1")).setPersistent(this.persistent);
            this.senderBackup.engineDescriptor.setOutboundMessageLoggingPolicy(AepEngine.OutboundMessageLoggingPolicy.UseDedicated);
            this.senderBackup.engineDescriptor.setAdaptiveCommitBatchCeiling(10);
            this.senderBackup.engineDescriptor.setDispatchSendStabilityEvents(this.dispatchSendStabilityEvents);
            this.senderBackup.engineDescriptor.setSequenceUnsolicitedSends(true);
            this.senderBackup.engineDescriptor.setSequenceUnsolicitedWithSolicitedSends(this.sequenceUnsolicitedSendsWithSolicitedSends);
        }
        this.forwarder = this.createForwarder("standalone");
        this.forwarder.engineDescriptor.setPerformDuplicateChecking(false);
        this.forwarder.addEventHandler(new MessageHandler());
        for (AepSFRTestAppBase app : this.apps) {
            app.engineDescriptor.setHAPolicy(this.haPolicy);
        }
        switch (this.encoding) {
            case Proto: {
                for (AepSFRTestAppBase app : this.apps) {
                    app.setStateType(Repository.class);
                    app.engineDescriptor.addStateFactory(com.neeve.aep.test.unit.generated.proto.Factory.class.getName());
                    if (!(app instanceof AepSFRTestBase.Sender)) continue;
                    app.engineDescriptor.addMessageFactory(com.neeve.aep.test.unit.generated.proto.Factory.class.getName());
                }
                break;
            }
            case Xbuf: {
                for (AepSFRTestAppBase app : this.apps) {
                    app.setStateType(com.neeve.aep.test.unit.generated.xbuf.Repository.class);
                    app.engineDescriptor.addStateFactory(Factory.class.getName());
                    if (!(app instanceof AepSFRTestBase.Sender)) continue;
                    app.engineDescriptor.addMessageFactory(com.neeve.aep.test.unit.generated.proto.Factory.class.getName());
                }
                break;
            }
            case Json: {
                for (AepSFRTestAppBase app : this.apps) {
                    app.setStateType(com.neeve.aep.test.unit.generated.json.Repository.class);
                    app.engineDescriptor.addStateFactory(com.neeve.aep.test.unit.generated.json.Factory.class.getName());
                    if (!(app instanceof AepSFRTestBase.Sender)) continue;
                    app.engineDescriptor.addMessageFactory(com.neeve.aep.test.unit.generated.proto.Factory.class.getName());
                }
                break;
            }
            case Raw: {
                throw new UnsupportedOperationException("Raw support not enabled");
            }
        }
    }

    @Test
    public void testSendStabilityEventsDispatch() throws Throwable {
        AepEngineSendStabilityTest.setVerbose((boolean)false);
        this.startApps();
        for (int i = 1; i <= 10; ++i) {
            IRogMessage message = AepEngineTestMessage.create(this.encoding, false).getMessage();
            message.setAttachment((Object)new Integer(i));
            this.senderPrimary.sendMessage(this.CHANNELS[0][this.qos == MessageChannel.Qos.Guaranteed ? 1 : 0][0][1], message);
        }
        this.forwarder.assertExpectedReceipt(5, 10);
        if (this.dispatchSendStabilityEvents) {
            this.senderPrimary.waitForSendStability(5, 10);
            Assert.assertEquals((String)"Wrong number of send stability events received", (long)10L, (long)this.senderPrimary.receivedSendStabilityEvents);
            Assert.assertEquals((String)"Stability Event errors detected (see trace)", (long)0L, (long)this.senderPrimary.stabilityEventErrors);
        } else {
            this.senderPrimary.waitForTransactionStability(1);
            Assert.assertEquals((String)"Wrong number of send stability events received", (long)0L, (long)this.senderPrimary.receivedSendStabilityEvents);
        }
        Assert.assertEquals((String)"Wrong number of send exception events received", (long)0L, (long)this.senderPrimary.sendExceptionEvents);
        Assert.assertEquals((String)"Should nothave gotten a send stability event exception", (long)0L, (long)this.senderPrimary.stabilityExceptions);
        if (this.clustered) {
            this.senderBackup.waitForTransactionStability(1);
            Assert.assertEquals((String)"Wrong number of send stability events received on backup gateway", (long)0L, (long)this.senderBackup.receivedSendStabilityEvents);
        }
    }

    @Test
    public void testSendStabilityEventsDispatchForFailedSendLogExceptionAndContinue() throws Throwable {
        AepEngineSendStabilityTest.setVerbose((boolean)false);
        this.senderPrimary.engineDescriptor.setMessageSendExceptionHandlingPolicy(AepEngine.MessageSendExceptionHandlingPolicy.LogExceptionAndContinue);
        this.senderPrimary.engineDescriptor.setInboundEventAcknowledgementPolicy(AepEngine.InboundEventAcknowledgementPolicy.OnSendStability);
        this.startApps();
        LoopbackMessageChannel senderChannel = (LoopbackMessageChannel)this.senderPrimary.getChannelMessageTracker((String)this.CHANNELS[0][this.qos == MessageChannel.Qos.Guaranteed ? 1 : 0][0][1]).channel;
        LoopbackBus.getInstance((String)senderChannel.getMessageBusBinding().getName()).getAgent(this.senderPrimary.appName).getTestController().failNextPublishWithException(true);
        for (int i = 1; i <= 2; ++i) {
            IRogMessage message = AepEngineTestMessage.create(this.encoding, false).getMessage();
            message.setAttachment((Object)new Integer(i));
            try {
                this.senderPrimary.sendMessage(this.CHANNELS[0][this.qos == MessageChannel.Qos.Guaranteed ? 1 : 0][0][1], message);
                if (i != 1 || this.sequenceUnsolicitedSendsWithSolicitedSends) continue;
                Assert.fail((String)"Send exception expected in sender thread but send succeeded");
                continue;
            }
            catch (Exception e) {
                if (i == 1 && !this.sequenceUnsolicitedSendsWithSolicitedSends) {
                    if (!this.dispatchSendStabilityEvents) continue;
                    ++this.senderPrimary.receivedSendStabilityEvents;
                    ++this.senderPrimary.stabilityExceptions;
                    continue;
                }
                Assert.fail((String)("Unepxected send exception: " + UtlThrowable.prepareStackTrace((Throwable)e)));
            }
        }
        if (this.dispatchSendStabilityEvents) {
            this.senderPrimary.waitForSendStability(5, 2);
            Assert.assertEquals((String)"Wrong number of send stability events received", (long)2L, (long)this.senderPrimary.receivedSendStabilityEvents);
            Assert.assertEquals((String)"Didn't get send stability event exception", (long)1L, (long)this.senderPrimary.stabilityExceptions);
            Assert.assertEquals((String)"Stability Event errors detected (see trace)", (long)0L, (long)this.senderPrimary.stabilityEventErrors);
            Assert.assertEquals((String)"Wrong number of send exception events received", (long)(this.sequenceUnsolicitedSendsWithSolicitedSends ? 1L : 0L), (long)this.senderPrimary.sendExceptionEvents);
        } else {
            this.senderPrimary.waitForTransactionStability(5, 2L);
            Assert.assertEquals((String)"Wrong number of send stability events received", (long)0L, (long)this.senderPrimary.receivedSendStabilityEvents);
            Assert.assertEquals((String)"Wrong number of send exception events received", (long)(this.sequenceUnsolicitedSendsWithSolicitedSends ? 1L : 0L), (long)this.senderPrimary.sendExceptionEvents);
        }
    }

    @Test
    public void testSendStabilityEventsDispatchForFailedSendTreatedAsStabilityFailure() throws Throwable {
        AepEngineSendStabilityTest.setVerbose((boolean)false);
        this.senderPrimary.engineDescriptor.setMessageSendExceptionHandlingPolicy(AepEngine.MessageSendExceptionHandlingPolicy.TreatAsStabilityFailure);
        this.senderPrimary.engineDescriptor.setInboundEventAcknowledgementPolicy(AepEngine.InboundEventAcknowledgementPolicy.OnSendStability);
        this.startApps();
        LoopbackMessageChannel senderChannel = (LoopbackMessageChannel)this.senderPrimary.getChannelMessageTracker((String)this.CHANNELS[0][this.qos == MessageChannel.Qos.Guaranteed ? 1 : 0][0][1]).channel;
        LoopbackBus.getInstance((String)senderChannel.getMessageBusBinding().getName()).getAgent(this.senderPrimary.appName).getTestController().failNextPublishWithException(true);
        for (int i = 1; i <= 2; ++i) {
            IRogMessage message = AepEngineTestMessage.create(this.encoding, false).getMessage();
            message.setAttachment((Object)new Integer(i));
            try {
                this.senderPrimary.sendMessage(this.CHANNELS[0][this.qos == MessageChannel.Qos.Guaranteed ? 1 : 0][0][1], message);
                if (i != 1 || this.sequenceUnsolicitedSendsWithSolicitedSends) continue;
                Assert.fail((String)"Send exception expected in sender thread but send succeeded");
                continue;
            }
            catch (Exception e) {
                if (i != 1 || this.sequenceUnsolicitedSendsWithSolicitedSends) continue;
                this.senderPrimary.engine.stop(e);
                break;
            }
        }
        this.senderPrimary.waitForSendStability(5, 2);
        Assert.assertEquals((String)"Wrong number of send stability events received", (long)0L, (long)this.senderPrimary.receivedSendStabilityEvents);
        Assert.assertEquals((String)"Wrong number of send exception events received", (long)0L, (long)this.senderPrimary.sendExceptionEvents);
    }

    @Test
    public void testSendStabilityEventsDispatchForFailedSendLogExceptionAndContinueOnStoreStability() throws Throwable {
        AepEngineSendStabilityTest.setVerbose((boolean)false);
        this.senderPrimary.engineDescriptor.setMessageSendExceptionHandlingPolicy(AepEngine.MessageSendExceptionHandlingPolicy.LogExceptionAndContinue);
        this.senderPrimary.engineDescriptor.setInboundEventAcknowledgementPolicy(AepEngine.InboundEventAcknowledgementPolicy.OnStoreStability);
        this.startApps();
        LoopbackMessageChannel senderChannel = (LoopbackMessageChannel)this.senderPrimary.getChannelMessageTracker((String)this.CHANNELS[0][this.qos == MessageChannel.Qos.Guaranteed ? 1 : 0][0][1]).channel;
        LoopbackBus.getInstance((String)senderChannel.getMessageBusBinding().getName()).getAgent(this.senderPrimary.appName).getTestController().failNextPublishWithException(true);
        for (int i = 1; i <= 2; ++i) {
            IRogMessage message = AepEngineTestMessage.create(this.encoding, false).getMessage();
            message.setAttachment((Object)new Integer(i));
            try {
                this.senderPrimary.sendMessage(this.CHANNELS[0][this.qos == MessageChannel.Qos.Guaranteed ? 1 : 0][0][1], message);
                if (i != 1 || this.sequenceUnsolicitedSendsWithSolicitedSends) continue;
                Assert.fail((String)"Send exception expected in sender thread but send succeeded");
                continue;
            }
            catch (Exception e) {
                if (i == 1 && !this.sequenceUnsolicitedSendsWithSolicitedSends) {
                    if (!this.dispatchSendStabilityEvents) continue;
                    ++this.senderPrimary.receivedSendStabilityEvents;
                    continue;
                }
                Assert.fail((String)("Unepxected send exception: " + UtlThrowable.prepareStackTrace((Throwable)e)));
            }
        }
        if (this.dispatchSendStabilityEvents) {
            this.senderPrimary.waitForSendStability(5, 2);
            Assert.assertEquals((String)"Wrong number of send stability events received", (long)2L, (long)this.senderPrimary.receivedSendStabilityEvents);
            Assert.assertEquals((String)"Wrong number of send stability events exceptions received", (long)(!this.hasStore && this.sequenceUnsolicitedSendsWithSolicitedSends ? 1L : 0L), (long)this.senderPrimary.stabilityExceptions);
            Assert.assertEquals((String)"Stability Event errors detected (see trace)", (long)0L, (long)this.senderPrimary.stabilityEventErrors);
            Assert.assertEquals((String)"Wrong number of send exception events received", (long)(this.sequenceUnsolicitedSendsWithSolicitedSends ? 1L : 0L), (long)this.senderPrimary.sendExceptionEvents);
        } else {
            this.senderPrimary.waitForTransactionStability(5, 2L);
            Assert.assertEquals((String)"Wrong number of send stability events received", (long)0L, (long)this.senderPrimary.receivedSendStabilityEvents);
            Assert.assertEquals((String)"Wrong number of send exception events received", (long)(this.sequenceUnsolicitedSendsWithSolicitedSends ? 1L : 0L), (long)this.senderPrimary.sendExceptionEvents);
        }
        Assert.assertEquals((String)"Wrong number of incomplete transactions", (long)0L, (long)(this.senderPrimary.engine.getStats().getNumCommitsStarted() - this.senderPrimary.engine.getStats().getNumCommitsCompleted()));
    }

    @Test
    public void testSendStabilityEventsDispatchForFailedSendTreatedAsStabilityFailureOnStoreStability() throws Throwable {
        AepEngineSendStabilityTest.setVerbose((boolean)false);
        this.senderPrimary.engineDescriptor.setMessageSendExceptionHandlingPolicy(AepEngine.MessageSendExceptionHandlingPolicy.TreatAsStabilityFailure);
        this.senderPrimary.engineDescriptor.setInboundEventAcknowledgementPolicy(AepEngine.InboundEventAcknowledgementPolicy.OnStoreStability);
        this.startApps();
        long initialCommitsCompleted = this.senderPrimary.engine.getStats().getNumCommitsCompleted();
        LoopbackMessageChannel senderChannel = (LoopbackMessageChannel)this.senderPrimary.getChannelMessageTracker((String)this.CHANNELS[0][this.qos == MessageChannel.Qos.Guaranteed ? 1 : 0][0][1]).channel;
        LoopbackBus.getInstance((String)senderChannel.getMessageBusBinding().getName()).getAgent(this.senderPrimary.appName).getTestController().failNextPublishWithException(true);
        for (int i = 1; i <= 2; ++i) {
            IRogMessage message = AepEngineTestMessage.create(this.encoding, false).getMessage();
            message.setAttachment((Object)new Integer(i));
            try {
                this.senderPrimary.sendMessage(this.CHANNELS[0][this.qos == MessageChannel.Qos.Guaranteed ? 1 : 0][0][1], message);
                if (i != 1 || this.sequenceUnsolicitedSendsWithSolicitedSends) continue;
                Assert.fail((String)"Send exception expected in sender thread but send succeeded");
                continue;
            }
            catch (Exception e) {
                if (i != 1 || this.sequenceUnsolicitedSendsWithSolicitedSends) continue;
                this.senderPrimary.engine.stop(e);
                break;
            }
        }
        this.senderPrimary.waitForTransactionsStarted(2, 2L);
        this.senderPrimary.waitForSendStability(5, 2);
        Assert.assertEquals((String)"Wrong number of send stability events received", (long)(this.dispatchSendStabilityEvents && this.hasStore && this.sequenceUnsolicitedSendsWithSolicitedSends ? 2L : 0L), (long)this.senderPrimary.receivedSendStabilityEvents);
        Assert.assertEquals((String)"Wrong number of send exception events received", (long)0L, (long)this.senderPrimary.sendExceptionEvents);
        Assert.assertEquals((String)"Wrong number of completed transactions", (long)initialCommitsCompleted, (long)this.senderPrimary.engine.getStats().getNumCommitsCompleted());
    }

    public class MessageHandler {
        protected Object state;
        volatile Throwable handlerError;

        @EventHandler
        public void onProtoMessage(com.neeve.aep.test.unit.generated.proto.Message message) {
            this.handleInternal((MessageView)message);
        }

        @EventHandler
        public void onXbufMessage(com.neeve.aep.test.unit.generated.xbuf.Message message) {
            this.handleInternal((MessageView)message);
        }

        @EventHandler
        public void onJsonMessage(Message message) {
            this.handleInternal((MessageView)message);
        }

        private void handleInternal(MessageView message) {
        }

        protected Object getState(MessageView message) {
            if (AepEngineSendStabilityTest.this.haPolicy == AepEngine.HAPolicy.StateReplication) {
                this.state = ((AepEngineSendStabilityTest)AepEngineSendStabilityTest.this).forwarder.engine.getApplicationState(message);
            } else if (this.state == null) {
                switch (AepEngineSendStabilityTest.this.encoding) {
                    case Json: {
                        this.state = com.neeve.aep.test.unit.generated.json.Repository.create();
                        break;
                    }
                    case Proto: {
                        this.state = Repository.create();
                        break;
                    }
                    case Xbuf: {
                        this.state = com.neeve.aep.test.unit.generated.xbuf.Repository.create();
                        break;
                    }
                }
            }
            return this.state;
        }
    }

    class UnsolicitedSender
    extends AepSFRTestBase.Sender {
        volatile int receivedSendStabilityEvents;
        volatile int stabilityEventErrors;
        volatile int stabilityExceptions;
        volatile int sendExceptionEvents;
        volatile boolean engineStopped;
        volatile Exception stopCause;
        long lastSno;

        public UnsolicitedSender(AepSFRTestBase parent, String appName, String instanceId) {
            super((AepSFRTestBase)AepEngineSendStabilityTest.this, parent, appName, instanceId);
            this.receivedSendStabilityEvents = 0;
            this.stabilityEventErrors = 0;
            this.stabilityExceptions = 0;
            this.sendExceptionEvents = 0;
            this.engineStopped = false;
            this.stopCause = null;
            this.lastSno = -1L;
            this.engineDescriptor.setBusManagerProperty(AepEngineSendStabilityTest.this.getForwarderBusName(), "detachedCommit", "true");
        }

        @EventHandler
        public void onSendStability(AepEngineStoppedEvent stopEvent) {
            this.stopCause = stopEvent.getCause();
            this.engineStopped = true;
        }

        @EventHandler
        public void onSendStability(AepSendExceptionEvent sendExceptionEvent) {
            ++this.sendExceptionEvents;
        }

        @EventHandler
        public void onSendStability(AepSendStabilityEvent stabilityEvent) {
            ++this.receivedSendStabilityEvents;
            long sno = stabilityEvent.getMessage().getMessageSequenceNumber();
            Integer attachment = (Integer)((IRogMessage)stabilityEvent.getMessage()).getAttachment();
            if (stabilityEvent.getMessage().getMessageSequenceNumber() <= this.lastSno) {
                System.err.println("Got out of order seq no in send stability event. Last=" + this.lastSno + ", current=" + sno);
                ++this.stabilityEventErrors;
            }
            if (attachment == null || sno != (long)attachment.intValue()) {
                System.err.println("Got wrong attachment in send stability event. expected=" + sno + ", got=" + attachment);
                ++this.stabilityEventErrors;
            }
            if (stabilityEvent.getStatus() != null) {
                ++this.stabilityExceptions;
                System.err.println("Got stability Event Exception " + ((Object)((Object)stabilityEvent)).hashCode() + ", sno=" + sno + " status= " + stabilityEvent.getStatus().hashCode());
            }
            this.lastSno = sno;
        }

        public boolean waitForSendStability(int seconds, int minMessages) throws InterruptedException {
            boolean waiting = true;
            long timeout = System.currentTimeMillis() + (long)(seconds * 1000);
            while ((waiting = this.receivedSendStabilityEvents < minMessages && !this.engineStopped) && System.currentTimeMillis() < timeout) {
                Thread.sleep(100L);
            }
            return !waiting;
        }
    }
}

