/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.event.AepChannelDownEvent;
import com.neeve.aep.event.AepChannelUpEvent;
import com.neeve.aep.event.AepEngineStoppedEvent;
import com.neeve.aep.test.unit.AepEngineTestMessage;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.aep.test.unit.generated.proto.Message;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.event.MessageStabilityEvent;

public final class AepEngineSendFailTestApp {
    AepEngine engine;
    int stabilitySuccessCount;
    int stabilityFailCount;
    MessageChannel channel4;
    MessageChannel channel5;
    boolean engineStopped;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean waitForStabilityNotification(int count) {
        AepEngineSendFailTestApp aepEngineSendFailTestApp = this;
        synchronized (aepEngineSendFailTestApp) {
            long startTime = System.currentTimeMillis();
            long remainingTime = 20000L;
            while (this.stabilitySuccessCount + this.stabilityFailCount < count && remainingTime > 0L) {
                try {
                    this.wait(remainingTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                remainingTime = 20000L - (System.currentTimeMillis() - startTime);
            }
            return this.stabilitySuccessCount + this.stabilityFailCount == count;
        }
    }

    final boolean waitForEngineStopped() {
        for (int i = 0; i < 10; ++i) {
            if (!this.engineStopped) {
                System.out.println("Engine not stopped");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            return true;
        }
        return false;
    }

    @EventHandler(source="channel4@aeptest1")
    public void onChannel4UpEventHandler(AepChannelUpEvent event) {
        this.channel4 = event.getMessageChannel();
    }

    @EventHandler(source="channel4@aeptest1")
    public void onChannel4DownEventHandler(AepChannelDownEvent event) {
        this.channel4 = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(source="channel4@aeptest1")
    public void onChannel4StabilityNotificationHandler(MessageStabilityEvent event) {
        AepEngineSendFailTestApp aepEngineSendFailTestApp = this;
        synchronized (aepEngineSendFailTestApp) {
            if (event.getStatus() == null) {
                ++this.stabilitySuccessCount;
            } else {
                ++this.stabilityFailCount;
            }
            this.notifyAll();
        }
    }

    @EventHandler(source="channel5@aeptest1")
    public void onChannel5UpEventHandler(AepChannelUpEvent event) {
        this.channel5 = event.getMessageChannel();
    }

    @EventHandler(source="channel5@aeptest1")
    public void onChannel5DownEventHandler(AepChannelDownEvent event) {
        this.channel5 = null;
    }

    @EventHandler
    public void onProtoMessageHandler(Message message) {
        AepEngineTestMessage out = new AepEngineTestMessage(AepEngineTestObject.EncodingType.Proto);
        out.getMessage().setMessageBus("aeptest1");
        out.getMessage().setMessageChannel("channel4");
        this.engine.sendMessage(this.channel4, out.getMessage());
    }

    @EventHandler
    public void onEngineStopped(AepEngineStoppedEvent event) {
        this.engineStopped = true;
    }
}

