/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.test.unit.AepEngineTestMessage;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.aep.test.unit.generated.json.Message;
import com.neeve.aep.test.unit.generated.xbuf.Factory;
import com.neeve.rog.IRogNode;
import com.neeve.rog.log.RogLogUtil;
import com.neeve.sma.MessageViewFactory;
import com.neeve.sma.MessageViewFactoryRegistry;
import com.neeve.test.UnitTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AepEngineLogDivergenceTests
extends UnitTest {
    @Before
    public void before() {
    }

    @Test
    public void testNodeComparisonJson() throws Exception {
        MessageViewFactoryRegistry.getInstance().registerMessageViewFactory((MessageViewFactory)com.neeve.aep.test.unit.generated.json.Factory.create(null));
        Message message = (Message)AepEngineTestMessage.create(AepEngineTestObject.EncodingType.Json).getMessage();
        Message message2 = Message.createFrom(message.serializeToByteArray());
        message = Message.createFrom(message.serializeToByteArray());
        StringBuffer diffs = new StringBuffer();
        boolean same = RogLogUtil.compareRogNodes((IRogNode)message, (IRogNode)message2, null, (StringBuffer)diffs);
        Assert.assertTrue((String)("Messages should be the same, but diffs were reported:\n" + diffs), (boolean)same);
    }

    @Test
    public void testNodeComparisonXbuf() throws Exception {
        MessageViewFactoryRegistry.getInstance().registerMessageViewFactory((MessageViewFactory)Factory.create(null));
        com.neeve.aep.test.unit.generated.xbuf.Message message = (com.neeve.aep.test.unit.generated.xbuf.Message)AepEngineTestMessage.create(AepEngineTestObject.EncodingType.Xbuf).getMessage();
        com.neeve.aep.test.unit.generated.xbuf.Message message2 = com.neeve.aep.test.unit.generated.xbuf.Message.createFrom(message.serializeToByteArray());
        message = com.neeve.aep.test.unit.generated.xbuf.Message.createFrom(message.serializeToByteArray());
        StringBuffer diffs = new StringBuffer();
        boolean same = RogLogUtil.compareRogNodes((IRogNode)message, (IRogNode)message2, null, (StringBuffer)diffs);
        Assert.assertTrue((String)("Messages should be the same, but diffs were reported:\n" + diffs), (boolean)same);
    }

    @Test
    public void testNodeComparisonProto() throws Exception {
        MessageViewFactoryRegistry.getInstance().registerMessageViewFactory((MessageViewFactory)com.neeve.aep.test.unit.generated.proto.Factory.create(null));
        com.neeve.aep.test.unit.generated.proto.Message message = (com.neeve.aep.test.unit.generated.proto.Message)AepEngineTestMessage.create(AepEngineTestObject.EncodingType.Proto).getMessage();
        com.neeve.aep.test.unit.generated.proto.Message message2 = com.neeve.aep.test.unit.generated.proto.Message.createFrom(message.serializeToByteArray());
        message = com.neeve.aep.test.unit.generated.proto.Message.createFrom(message.serializeToByteArray());
        StringBuffer diffs = new StringBuffer();
        boolean same = RogLogUtil.compareRogNodes((IRogNode)message, (IRogNode)message2, null, (StringBuffer)diffs);
        Assert.assertTrue((String)("Messages should be the same, but diffs were reported:\n" + diffs), (boolean)same);
    }

    @Test
    public void testNodeComparisonFailureTopLevelFieldJson() throws Exception {
        MessageViewFactoryRegistry.getInstance().registerMessageViewFactory((MessageViewFactory)com.neeve.aep.test.unit.generated.json.Factory.create(null));
        Message message = (Message)AepEngineTestMessage.create(AepEngineTestObject.EncodingType.Json).getMessage();
        Message message2 = Message.createFrom(message.serializeToByteArray());
        message = Message.createFrom(message.serializeToByteArray());
        message2.setStringField("UH-OH!");
        StringBuffer diffs = new StringBuffer();
        Assert.assertFalse((String)"Messages should not be the same", (boolean)RogLogUtil.compareRogNodes((IRogNode)message, (IRogNode)message2, null, (StringBuffer)diffs));
        Assert.assertTrue((String)"Messages diff should contain UH-OH", (diffs.toString().indexOf("UH-OH") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testNodeComparisonFailureTopLevelFieldXbuf() throws Exception {
        MessageViewFactoryRegistry.getInstance().registerMessageViewFactory((MessageViewFactory)Factory.create(null));
        com.neeve.aep.test.unit.generated.xbuf.Message message = (com.neeve.aep.test.unit.generated.xbuf.Message)AepEngineTestMessage.create(AepEngineTestObject.EncodingType.Xbuf).getMessage();
        com.neeve.aep.test.unit.generated.xbuf.Message message2 = com.neeve.aep.test.unit.generated.xbuf.Message.createFrom(message.serializeToByteArray());
        message = com.neeve.aep.test.unit.generated.xbuf.Message.createFrom(message.serializeToByteArray());
        message2.setStringField("UH-OH!");
        StringBuffer diffs = new StringBuffer();
        Assert.assertFalse((String)"Messages should not be the same", (boolean)RogLogUtil.compareRogNodes((IRogNode)message, (IRogNode)message2, null, (StringBuffer)diffs));
        Assert.assertTrue((String)"Messages diff should contain UH-OH", (diffs.toString().indexOf("UH-OH") != -1 ? 1 : 0) != 0);
        if (AepEngineLogDivergenceTests.verbose()) {
            System.out.println(diffs);
        }
    }

    @Test
    public void testNodeComparisonFailureTopLevelFieldProto() throws Exception {
        MessageViewFactoryRegistry.getInstance().registerMessageViewFactory((MessageViewFactory)com.neeve.aep.test.unit.generated.proto.Factory.create(null));
        com.neeve.aep.test.unit.generated.proto.Message message = (com.neeve.aep.test.unit.generated.proto.Message)AepEngineTestMessage.create(AepEngineTestObject.EncodingType.Proto).getMessage();
        com.neeve.aep.test.unit.generated.proto.Message message2 = com.neeve.aep.test.unit.generated.proto.Message.createFrom(message.serializeToByteArray());
        message = com.neeve.aep.test.unit.generated.proto.Message.createFrom(message.serializeToByteArray());
        message2.setStringField("UH-OH!");
        StringBuffer diffs = new StringBuffer();
        Assert.assertFalse((String)"Messages should not be the same", (boolean)RogLogUtil.compareRogNodes((IRogNode)message, (IRogNode)message2, null, (StringBuffer)diffs));
        Assert.assertTrue((String)"Messages diff should contain UH-OH", (diffs.toString().indexOf("UH-OH") != -1 ? 1 : 0) != 0);
        if (AepEngineLogDivergenceTests.verbose()) {
            System.out.println(diffs);
        }
    }

    @Test
    public void testNodeComparisonFailureEmbeddedFieldJson() throws Exception {
        MessageViewFactoryRegistry.getInstance().registerMessageViewFactory((MessageViewFactory)com.neeve.aep.test.unit.generated.json.Factory.create(null));
        Message message = (Message)AepEngineTestMessage.create(AepEngineTestObject.EncodingType.Json).getMessage();
        Message message2 = Message.createFrom(message.serializeToByteArray());
        message = Message.createFrom(message.serializeToByteArray());
        message2.getChild2Field().setStringField("UH-OH!");
        StringBuffer diffs = new StringBuffer();
        Assert.assertFalse((String)"Messages should not be the same", (boolean)RogLogUtil.compareRogNodes((IRogNode)message, (IRogNode)message2, null, (StringBuffer)diffs));
        Assert.assertTrue((String)"Messages diff should contain UH-OH", (diffs.toString().indexOf("UH-OH") != -1 ? 1 : 0) != 0);
        if (AepEngineLogDivergenceTests.verbose()) {
            System.out.println(diffs);
        }
    }

    @Test
    public void testNodeComparisonFailureEmbeddedFieldXbuf() throws Exception {
        MessageViewFactoryRegistry.getInstance().registerMessageViewFactory((MessageViewFactory)Factory.create(null));
        com.neeve.aep.test.unit.generated.xbuf.Message message = (com.neeve.aep.test.unit.generated.xbuf.Message)AepEngineTestMessage.create(AepEngineTestObject.EncodingType.Xbuf).getMessage();
        com.neeve.aep.test.unit.generated.xbuf.Message message2 = com.neeve.aep.test.unit.generated.xbuf.Message.createFrom(message.serializeToByteArray());
        message = com.neeve.aep.test.unit.generated.xbuf.Message.createFrom(message.serializeToByteArray());
        message2.getChild2Field().setStringField("UH-OH!");
        StringBuffer diffs = new StringBuffer();
        Assert.assertFalse((String)"Messages should not be the same", (boolean)RogLogUtil.compareRogNodes((IRogNode)message, (IRogNode)message2, null, (StringBuffer)diffs));
        Assert.assertTrue((String)"Messages diff should contain UH-OH", (diffs.toString().indexOf("UH-OH") != -1 ? 1 : 0) != 0);
        if (AepEngineLogDivergenceTests.verbose()) {
            System.out.println(diffs);
        }
    }

    @Test
    public void testNodeComparisonFailureEmbeddedFieldProto() throws Exception {
        MessageViewFactoryRegistry.getInstance().registerMessageViewFactory((MessageViewFactory)com.neeve.aep.test.unit.generated.proto.Factory.create(null));
        com.neeve.aep.test.unit.generated.proto.Message message = (com.neeve.aep.test.unit.generated.proto.Message)AepEngineTestMessage.create(AepEngineTestObject.EncodingType.Proto).getMessage();
        com.neeve.aep.test.unit.generated.proto.Message message2 = com.neeve.aep.test.unit.generated.proto.Message.createFrom(message.serializeToByteArray());
        message = com.neeve.aep.test.unit.generated.proto.Message.createFrom(message.serializeToByteArray());
        message2.getChild2Field().setStringField("UH-OH!");
        StringBuffer diffs = new StringBuffer();
        Assert.assertFalse((String)"Messages should not be the same", (boolean)RogLogUtil.compareRogNodes((IRogNode)message, (IRogNode)message2, null, (StringBuffer)diffs));
        Assert.assertTrue((String)"Messages diff should contain UH-OH", (diffs.toString().indexOf("UH-OH") != -1 ? 1 : 0) != 0);
        if (AepEngineLogDivergenceTests.verbose()) {
            System.out.println(diffs);
        }
    }
}

