/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.IAepEngineStats;
import com.neeve.aep.test.unit.AepEngineFailoverTestApp;
import com.neeve.aep.test.unit.AepEngineTest;
import com.neeve.aep.test.unit.AepEngineTestMessage;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.ods.IStoreBinding;
import com.neeve.rog.IRogMessage;
import com.neeve.sma.MessageChannel;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class AepEngineFailoverTest
extends AepEngineTest {
    private static final void compareSequenceNumbers(ArrayList<IRogMessage> list1, ArrayList<IRogMessage> list2) {
        Assert.assertEquals((String)"Message Counts Don't match", (long)list1.size(), (long)list2.size());
        int size = list1.size();
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((String)("Message " + (i + 1) + " has wrong sequence number"), (long)list1.get(i).getMessageSequenceNumber(), (long)list2.get(i).getMessageSequenceNumber());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void testFailover_StandaloneReceiver_EventSourcing_RestartSameReceiverDiffEngine(AepEngineTestObject.EncodingType encodingType) throws Exception {
        AepEngineFailoverTestApp sender = new AepEngineFailoverTestApp();
        AepEngine engine1 = this.createEngine("engine1", null, null, null, null, null, false, false, false, false, null, 15, 0, sender, null, null, 0, false, false, null, null, null, false, true);
        engine1.start();
        engine1.waitForMessagingToStart();
        AepEngineFailoverTestApp receiver = new AepEngineFailoverTestApp(sender);
        AepEngine engine2 = this.createEngine("engine2", AepEngine.HAPolicy.EventSourcing, null, AepEngine.MessageBusBindingFailPolicy.FailIfAnyBindingFails, null, null, false, false, false, false, null, 15, 15, receiver, null, null, 0, false, false, null, null, null, false, false);
        engine2.registerFactory(AepEngineTestMessage.getFactory(encodingType));
        engine2.start();
        engine2.waitForMessagingToStart();
        SenderThread senderThread = new SenderThread(engine1, sender.channel4, sender, encodingType);
        senderThread.start();
        Thread.sleep(1100L);
        this.messagingController.failBinding("aeptest1", "engine2");
        Assert.assertTrue((boolean)receiver.waitForBindingToFail());
        Assert.assertTrue((boolean)receiver.waitForMessagingToFail());
        Assert.assertTrue((boolean)receiver.waitForEngineToStop());
        AepEngine engine3 = this.createEngine("engine2", AepEngine.HAPolicy.EventSourcing, null, AepEngine.MessageBusBindingFailPolicy.FailIfAnyBindingFails, null, null, false, false, false, false, null, 15, 15, receiver, null, null, 0, false, false, null, null, null, false, false);
        engine3.registerFactory(AepEngineTestMessage.getFactory(encodingType));
        engine3.start();
        engine3.waitForMessagingToStart();
        Thread.sleep(100L);
        senderThread.shutdown();
        Assert.assertNull((Object)senderThread.e);
        try {
            Assert.assertTrue((boolean)sender.waitForExpectedMessageStability(senderThread.count));
            Assert.assertTrue((boolean)receiver.waitForExpectedMessageReceipt(senderThread.count));
            AepEngineFailoverTest.compareSequenceNumbers(senderThread.messages, receiver.messages);
        }
        finally {
            IAepEngineStats senderStats = engine1.getStats();
            System.out.println("Sender    [Sent=" + senderStats.getOutboundSequenceNumber() + ", Stable=" + senderStats.getOutboundStableSequenceNumber() + "]");
            IAepEngineStats receiver1Stats = engine2.getStats();
            System.out.println("Receiver1 [Received=" + receiver1Stats.getNumMsgsRcvdGuaranteed() + ", Dups=" + receiver1Stats.getNumDupMsgsRcvd() + "]");
            IAepEngineStats receiver2Stats = engine3.getStats();
            System.out.println("Receiver2 [Received=" + receiver2Stats.getNumMsgsRcvdGuaranteed() + ", Dups=" + receiver2Stats.getNumDupMsgsRcvd() + "]");
        }
    }

    @Test
    public void testFailover_StandaloneReceiver_EventSourcing_RestartSameReceiverDiffEngine_Xbuf() throws Exception {
        this.testFailover_StandaloneReceiver_EventSourcing_RestartSameReceiverDiffEngine(AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testFailover_StandaloneReceiver_EventSourcing_RestartSameReceiverDiffEngine_Proto() throws Exception {
        this.testFailover_StandaloneReceiver_EventSourcing_RestartSameReceiverDiffEngine(AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testFailover_StandaloneReceiver_EventSourcing_RestartSameReceiverDiffEngine_Json() throws Exception {
        this.testFailover_StandaloneReceiver_EventSourcing_RestartSameReceiverDiffEngine(AepEngineTestObject.EncodingType.Json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void testFailover_StandaloneReceiver_EventSourcing_RestartDiffReceiverDiffEngine(AepEngineTestObject.EncodingType encodingType) throws Exception {
        AepEngineFailoverTestApp sender = new AepEngineFailoverTestApp();
        AepEngine engine1 = this.createEngine("engine1", null, null, null, null, null, false, false, false, false, null, 15, 0, sender, null, null, 0, false, false, null, null, null, false, true);
        engine1.start();
        engine1.waitForMessagingToStart();
        Thread.sleep(100L);
        String receiverName = "engine-" + System.currentTimeMillis();
        AepEngineFailoverTestApp receiver = new AepEngineFailoverTestApp(sender);
        AepEngine engine2 = this.createEngine(receiverName, AepEngine.HAPolicy.EventSourcing, null, AepEngine.MessageBusBindingFailPolicy.FailIfAnyBindingFails, null, null, true, true, false, false, null, 15, 15, receiver, null, null, 0, false, false, null, null, null, false, false);
        engine2.registerFactory(AepEngineTestMessage.getFactory(encodingType));
        engine2.start();
        engine2.waitForMessagingToStart();
        SenderThread senderThread = new SenderThread(engine1, sender.channel4, sender, encodingType);
        senderThread.start();
        Thread.sleep(1100L);
        System.out.println("Failing the receiver...");
        this.messagingController.failBinding("aeptest1", receiverName);
        Assert.assertTrue((boolean)receiver.waitForBindingToFail());
        Assert.assertTrue((boolean)receiver.waitForMessagingToFail());
        Assert.assertTrue((boolean)receiver.waitForEngineToStop());
        Thread.sleep(100L);
        System.out.println("Receiver stopped.");
        System.out.println("Starting a new receiver...");
        receiver = new AepEngineFailoverTestApp(sender);
        AepEngine engine3 = this.createEngine(receiverName, AepEngine.HAPolicy.EventSourcing, null, AepEngine.MessageBusBindingFailPolicy.FailIfAnyBindingFails, null, null, true, true, false, false, null, 15, 15, receiver, null, null, 0, false, false, null, null, null, false, false);
        engine3.registerFactory(AepEngineTestMessage.getFactory(encodingType));
        engine3.start();
        engine3.waitForMessagingToStart();
        System.out.println("New receiver started.");
        Thread.sleep(100L);
        System.out.println("Stopping the sender...");
        senderThread.shutdown();
        Assert.assertNull((Object)senderThread.e);
        System.out.println("Sender stopped");
        System.out.println("Validating...");
        try {
            Assert.assertTrue((boolean)sender.waitForExpectedMessageStability(senderThread.count));
            Assert.assertTrue((boolean)receiver.waitForExpectedMessageReceipt(senderThread.count));
            AepEngineFailoverTest.compareSequenceNumbers(senderThread.messages, receiver.messages);
        }
        finally {
            IAepEngineStats senderStats = engine1.getStats();
            System.out.println("Sender    [Sent=" + senderStats.getOutboundSequenceNumber() + ", Stable=" + senderStats.getOutboundStableSequenceNumber() + "]");
            IAepEngineStats receiver1Stats = engine2.getStats();
            System.out.println("Receiver1 [Received=" + receiver1Stats.getNumMsgsRcvdGuaranteed() + ", Dups=" + receiver1Stats.getNumDupMsgsRcvd() + "]");
            IAepEngineStats receiver2Stats = engine3.getStats();
            System.out.println("Receiver2 [Received=" + receiver2Stats.getNumMsgsRcvdGuaranteed() + ", Dups=" + receiver2Stats.getNumDupMsgsRcvd() + "]");
        }
    }

    @Test
    @Ignore(value="XPLATFORM-52")
    public void testFailover_StandaloneReceiver_EventSourcing_RestartDiffReceiverDiffEngine_Xbuf() throws Exception {
        this.testFailover_StandaloneReceiver_EventSourcing_RestartDiffReceiverDiffEngine(AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    @Ignore(value="XPLATFORM-52")
    public void testFailover_StandaloneReceiver_EventSourcing_RestartDiffReceiverDiffEngine_Proto() throws Exception {
        this.testFailover_StandaloneReceiver_EventSourcing_RestartDiffReceiverDiffEngine(AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    @Ignore(value="XPLATFORM-52")
    public void testFailover_StandaloneReceiver_EventSourcing_RestartDiffReceiverDiffEngine_Json() throws Exception {
        this.testFailover_StandaloneReceiver_EventSourcing_RestartDiffReceiverDiffEngine(AepEngineTestObject.EncodingType.Json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void testFailover_ClusteredReceiver_EventSourcing_PrimaryFail(AepEngineTestObject.EncodingType encodingType) throws Exception {
        AepEngineFailoverTestApp sender = new AepEngineFailoverTestApp();
        AepEngine engine1 = this.createEngine("engine1", null, null, null, null, null, false, false, false, false, null, 15, 0, sender, null, null, 0, false, false, null, null, null, false, true);
        engine1.start();
        engine1.waitForMessagingToStart();
        AepEngineFailoverTestApp receiver1 = new AepEngineFailoverTestApp(sender);
        AepEngine engine2 = this.createEngine("engine2", AepEngine.HAPolicy.EventSourcing, null, AepEngine.MessageBusBindingFailPolicy.FailIfAnyBindingFails, null, null, true, false, false, false, null, 15, 15, receiver1, null, null, 0, false, false, null, null, null, false, false);
        engine2.registerFactory(AepEngineTestMessage.getFactory(encodingType));
        engine2.start();
        engine2.waitForMessagingToStart();
        Assert.assertEquals((Object)IStoreBinding.Role.Primary, (Object)engine2.getStore().getRole());
        AepEngineFailoverTestApp receiver2 = new AepEngineFailoverTestApp(sender);
        AepEngine engine3 = this.createEngine("engine2", AepEngine.HAPolicy.EventSourcing, null, AepEngine.MessageBusBindingFailPolicy.FailIfAnyBindingFails, null, null, true, false, false, false, null, 15, 15, receiver2, null, null, 0, false, false, null, null, null, false, false);
        engine3.registerFactory(AepEngineTestMessage.getFactory(encodingType));
        engine3.start();
        Assert.assertEquals((Object)IStoreBinding.Role.Backup, (Object)engine3.getStore().getRole());
        SenderThread senderThread = new SenderThread(engine1, sender.channel4, sender, encodingType);
        senderThread.start();
        Thread.sleep(1100L);
        System.out.println("Failing the primary receiver...");
        this.messagingController.failBinding("aeptest1", "engine2");
        Assert.assertTrue((boolean)receiver1.waitForEngineToStop());
        System.out.println("Primary stopped.");
        engine3.waitForMessagingToStart();
        Assert.assertEquals((Object)IStoreBinding.Role.Primary, (Object)engine3.getStore().getRole());
        System.out.println("Received failed over.");
        Thread.sleep(10L);
        System.out.println("Stopping the sender...");
        senderThread.shutdown();
        Assert.assertNull((Object)senderThread.e);
        System.out.println("Sender stopped.");
        System.out.println("Validating...");
        try {
            System.out.println("...waiting for stability completion...");
            Assert.assertTrue((boolean)sender.waitForExpectedMessageStability(senderThread.count));
            System.out.println("...waiting for message completion...");
            Assert.assertTrue((boolean)receiver2.waitForExpectedMessageReceipt(senderThread.count));
            AepEngineFailoverTest.compareSequenceNumbers(senderThread.messages, receiver2.messages);
        }
        finally {
            IAepEngineStats senderStats = engine1.getStats();
            System.out.println("Sender    [Sent=" + senderStats.getOutboundSequenceNumber() + ", Stable=" + senderStats.getOutboundStableSequenceNumber() + "]");
            IAepEngineStats receiver1Stats = engine2.getStats();
            System.out.println("Receiver1 [Received=" + receiver1Stats.getNumMsgsRcvdGuaranteed() + ", Dups=" + receiver1Stats.getNumDupMsgsRcvd() + "]");
            IAepEngineStats receiver2Stats = engine3.getStats();
            System.out.println("Receiver2 [Received=" + receiver2Stats.getNumMsgsRcvdGuaranteed() + ", Dups=" + receiver2Stats.getNumDupMsgsRcvd() + "]");
        }
    }

    @Ignore
    @Test
    public void testFailover_ClusteredReceiver_EventSourcing_PrimaryFail_Xbuf() throws Exception {
        this.testFailover_ClusteredReceiver_EventSourcing_PrimaryFail(AepEngineTestObject.EncodingType.Xbuf);
    }

    @Ignore
    @Test
    public void testFailover_ClusteredReceiver_EventSourcing_PrimaryFail_Proto() throws Exception {
        this.testFailover_ClusteredReceiver_EventSourcing_PrimaryFail(AepEngineTestObject.EncodingType.Proto);
    }

    @Ignore
    @Test
    public void testFailover_ClusteredReceiver_EventSourcing_PrimaryFail_Json() throws Exception {
        this.testFailover_ClusteredReceiver_EventSourcing_PrimaryFail(AepEngineTestObject.EncodingType.Json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void testFailover_ClusteredReceiver_EventSourcing_BackupFail(AepEngineTestObject.EncodingType encodingType) throws Exception {
        AepEngineFailoverTestApp sender = new AepEngineFailoverTestApp();
        AepEngine engine1 = this.createEngine("engine1", null, null, null, null, null, false, false, false, false, null, 15, 0, sender, null, null, 0, false, false, null, null, null, false, true);
        engine1.start();
        engine1.waitForMessagingToStart();
        AepEngineFailoverTestApp receiver1 = new AepEngineFailoverTestApp(sender);
        AepEngine engine2 = this.createEngine("engine2", AepEngine.HAPolicy.EventSourcing, null, AepEngine.MessageBusBindingFailPolicy.FailIfAnyBindingFails, null, null, true, false, false, false, null, 15, 15, receiver1, null, null, 0, false, false, null, null, null, false, false);
        engine2.registerFactory(AepEngineTestMessage.getFactory(encodingType));
        engine2.start();
        engine2.waitForMessagingToStart();
        Assert.assertEquals((Object)IStoreBinding.Role.Primary, (Object)engine2.getStore().getRole());
        AepEngineFailoverTestApp receiver2 = new AepEngineFailoverTestApp(sender);
        AepEngine engine3 = this.createEngine("engine2", AepEngine.HAPolicy.EventSourcing, null, AepEngine.MessageBusBindingFailPolicy.FailIfAnyBindingFails, null, null, true, false, false, false, null, 15, 15, receiver2, null, null, 0, false, false, null, null, null, false, false);
        engine3.registerFactory(AepEngineTestMessage.getFactory(encodingType));
        engine3.start();
        Assert.assertEquals((Object)IStoreBinding.Role.Backup, (Object)engine3.getStore().getRole());
        SenderThread senderThread = new SenderThread(engine1, sender.channel4, sender, encodingType);
        senderThread.start();
        Thread.sleep(1100L);
        System.out.println("Failing the backup receiver...");
        engine3.stop(new Exception("force failed the backup"));
        Assert.assertTrue((boolean)receiver2.waitForEngineToStop());
        System.out.println("Backup stopped.");
        Thread.sleep(10L);
        System.out.println("Stopping the sender...");
        senderThread.shutdown();
        Assert.assertNull((Object)senderThread.e);
        System.out.println("Sender stopped.");
        System.out.println("Validating...");
        try {
            System.out.println("...waiting for stability completion...");
            Assert.assertTrue((boolean)sender.waitForExpectedMessageStability(senderThread.count));
            System.out.println("...waiting for message completion...");
            Assert.assertTrue((boolean)receiver1.waitForExpectedMessageReceipt(senderThread.count));
            AepEngineFailoverTest.compareSequenceNumbers(senderThread.messages, receiver1.messages);
        }
        finally {
            IAepEngineStats senderStats = engine1.getStats();
            System.out.println("Sender    [Sent=" + senderStats.getOutboundSequenceNumber() + ", Stable=" + senderStats.getOutboundStableSequenceNumber() + "]");
            IAepEngineStats receiver1Stats = engine2.getStats();
            System.out.println("Receiver1 [Received=" + receiver1Stats.getNumMsgsRcvdGuaranteed() + ", Dups=" + receiver1Stats.getNumDupMsgsRcvd() + "]");
        }
    }

    @Test
    public void testFailover_ClusteredReceiver_EventSourcing_BackupFail_Xbuf() throws Exception {
        this.testFailover_ClusteredReceiver_EventSourcing_BackupFail(AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testFailover_ClusteredReceiver_EventSourcing_BackupFail_Proto() throws Exception {
        this.testFailover_ClusteredReceiver_EventSourcing_BackupFail(AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testFailover_ClusteredReceiver_EventSourcing_BackupFail_Json() throws Exception {
        this.testFailover_ClusteredReceiver_EventSourcing_BackupFail(AepEngineTestObject.EncodingType.Json);
    }

    private final class SenderThread
    extends Thread {
        final AepEngineFailoverTestApp sender;
        private final AepEngine engine;
        private final MessageChannel channel;
        private final AepEngineTestObject.EncodingType encodingType;
        final ArrayList<IRogMessage> messages = new ArrayList();
        Throwable e;
        int count;
        volatile boolean done;

        SenderThread(AepEngine engine, MessageChannel channel, AepEngineFailoverTestApp sender, AepEngineTestObject.EncodingType encodingType) {
            this.engine = engine;
            this.channel = channel;
            this.sender = sender;
            this.encodingType = encodingType;
        }

        private final void send() {
            this.sender.onSend();
            if (!this.done) {
                IRogMessage message = new AepEngineTestMessage(this.encodingType).getMessage();
                message.acquire();
                this.messages.add(message);
                this.engine.sendMessage(this.channel, message);
                ++this.count;
            }
        }

        final void shutdown() {
            this.done = true;
            this.sender.sendDone();
            while (true) {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        @Override
        public final void run() {
            this.send();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            while (!this.done) {
                try {
                    this.send();
                }
                catch (Throwable e) {
                    this.e = e;
                    this.done = true;
                }
            }
        }
    }
}

