/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.event.AepChannelUpEvent;
import com.neeve.aep.event.AepEngineStoppedEvent;
import com.neeve.aep.event.AepInboundLogExceptionEvent;
import com.neeve.aep.event.AepOutboundLogExceptionEvent;
import com.neeve.aep.event.AepUnhandledMessageEvent;
import com.neeve.aep.test.unit.generated.proto.Message;
import com.neeve.aep.test.unit.generated.proto.UpdateStateMessage;
import com.neeve.ods.impl.StoreMemberDownEvent;
import com.neeve.ods.impl.StoreMemberUpEvent;
import com.neeve.rog.log.RogLog;
import com.neeve.sma.MessageChannel;

public final class AepEngineDiskFailTestApp {
    volatile AepEngine engine;
    MessageChannel receiveChannel;
    MessageChannel sendChannel;
    private volatile boolean receivedEngineStoppedEvent;
    private volatile int memberUpEventCount;
    private volatile int memberDownEventCount;
    private volatile int numInboundLogExceptions = 0;
    private volatile int numOutboundLogExceptions = 0;
    private volatile int messageCount;
    private volatile int failPersisterOn;

    final void failPersisterOn(int count) {
        this.failPersisterOn = count;
    }

    final boolean waitForEngineStoppedEvent() {
        for (int i = 0; i < 20; ++i) {
            System.out.println("engine stopped event still not received...nook");
            if (!this.receivedEngineStoppedEvent) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            System.out.println("received engine stopped event...ok");
            return true;
        }
        return false;
    }

    @EventHandler(source="channel1@aeptest1")
    public void onReceiveChannelUpEventHandler(AepChannelUpEvent event) {
        this.receiveChannel = event.getMessageChannel();
    }

    @EventHandler(source="channel2@aeptest1")
    public void onSendChannelUpEventHandler(AepChannelUpEvent event) {
        this.sendChannel = event.getMessageChannel();
    }

    @EventHandler
    public void onMessageFromSender(Message message) {
        ++this.messageCount;
        if (this.failPersisterOn > 0 && this.failPersisterOn == this.messageCount && this.engine != null) {
            ((RogLog)this.engine.getStore().getPersister()).fail();
        }
        UpdateStateMessage outMessage = UpdateStateMessage.create();
        if (this.engine != null) {
            outMessage.setMessageBus("aeptest1");
            outMessage.setMessageChannel("channel2");
            this.engine.sendMessage(this.sendChannel, outMessage);
        }
    }

    @EventHandler
    public void onMessageFromReceiver(UpdateStateMessage message) {
        ++this.messageCount;
    }

    @EventHandler
    public void onUnhandledMessage(AepUnhandledMessageEvent event) {
        System.out.println("UNHANDLED MESSAGE: " + event.getTriggeringMessage());
    }

    @EventHandler
    public void onMemberUpEvent(StoreMemberUpEvent event) {
        System.out.println("Got StoreMemberUpEvent: " + event);
        ++this.memberUpEventCount;
    }

    @EventHandler
    public void onMemberDownEvent(StoreMemberDownEvent event) {
        System.out.println("Got StoreMemberDownEvent: " + event);
        ++this.memberDownEventCount;
    }

    @EventHandler
    public void onEngineStoppedEvent(AepEngineStoppedEvent event) {
        System.out.println("Got AepEngineStoppedEvent: " + (Object)((Object)event));
        this.receivedEngineStoppedEvent = event.getCause() != null;
    }

    @EventHandler
    public void onInboundLoggingException(AepInboundLogExceptionEvent event) {
        System.out.println("Got AepInboundLogExceptionEvent: " + (Object)((Object)event));
        ++this.numInboundLogExceptions;
    }

    @EventHandler
    public void onOutboundLoggingException(AepOutboundLogExceptionEvent event) {
        System.out.println("Got AepOutboundLogExceptionEvent: " + (Object)((Object)event));
        ++this.numOutboundLogExceptions;
    }

    public int waitForMemberDownEvents(int seconds, int expected) {
        long timeout = System.currentTimeMillis() + (long)(seconds * 1000);
        while (this.memberDownEventCount < expected && System.currentTimeMillis() < timeout) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.memberDownEventCount;
    }

    public int waitForMemberUpEvents(int seconds, int expected) {
        long timeout = System.currentTimeMillis() + (long)(seconds * 1000);
        while (this.memberUpEventCount < expected && System.currentTimeMillis() < timeout) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.memberUpEventCount;
    }

    public int waitForInboundLoggingException(int seconds, int expected) {
        long timeout = System.currentTimeMillis() + (long)(seconds * 1000);
        while (this.numInboundLogExceptions < expected && System.currentTimeMillis() < timeout) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.numInboundLogExceptions;
    }

    public int waitForOutboundLoggingException(int seconds, int expected) {
        long timeout = System.currentTimeMillis() + (long)(seconds * 1000);
        while (this.numOutboundLogExceptions < expected && System.currentTimeMillis() < timeout) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.numOutboundLogExceptions;
    }

    public long waitForCommitCompletions(int seconds, int expected) {
        long timeout = System.currentTimeMillis() + (long)(seconds * 1000);
        while (this.engine.getStats().getNumCommitsCompleted() < (long)expected && System.currentTimeMillis() < timeout) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.engine.getStats().getNumCommitsCompleted();
    }
}

