/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.eaio.uuid.UUID;
import com.neeve.aep.AepEngine;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.event.AepEngineActiveEvent;
import com.neeve.aep.event.AepEngineStoppingEvent;
import com.neeve.aep.test.unit.AepEngineTestMessage;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.aep.test.unit.AepSFRTestAppBase;
import com.neeve.aep.test.unit.AepSFRTestBase;
import com.neeve.aep.test.unit.generated.json.Message;
import com.neeve.aep.test.unit.generated.proto.Repository;
import com.neeve.aep.test.unit.generated.xbuf.Factory;
import com.neeve.ods.IStoreCheckpointingController;
import com.neeve.ods.OdsException;
import com.neeve.query.QueryRepository;
import com.neeve.query.QueryResultSet;
import com.neeve.query.impl.util.UtlQueryResultFormatter;
import com.neeve.rog.IRogChangeDataCaptureHandler;
import com.neeve.rog.IRogMessage;
import com.neeve.rog.IRogNode;
import com.neeve.rog.log.RogLog;
import com.neeve.rog.log.RogLogCdcProcessor;
import com.neeve.rog.log.RogLogFactory;
import com.neeve.rog.log.RogLogQueryEngine;
import com.neeve.rog.log.RogLogRepository;
import com.neeve.rog.log.RogLogResultSet;
import com.neeve.sma.MessageView;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlGovernor;
import com.neeve.util.UtlReflection;
import com.neeve.util.UtlTableFormatter;
import com.neeve.util.UtlThrowable;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AepCdcAndCompactionTest
extends AepSFRTestBase {
    @Parameterized.Parameter(value=0)
    public boolean clustered;
    @Parameterized.Parameter(value=1)
    public AepEngineTestObject.EncodingType encoding;
    private AepSFRTestBase.Sender sender;
    private AepSFRTestBase.Forwarder forwarder;
    private AepSFRTestBase.Forwarder forwarderBackup;
    private AepSFRTestBase.Receiver receiver;

    @Parameterized.Parameters(name="{index}: clustered={0}, encoding={1}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{false, AepEngineTestObject.EncodingType.Proto}};
        return Arrays.asList(data);
    }

    @Override
    public String testCaseId() {
        String methodName = this.testcaseName.getMethodName();
        return methodName.substring(0, methodName.indexOf(":")).replace('[', '-');
    }

    @Before
    public void setupTestcase() throws OdsException {
        AepCdcAndCompactionTest.setVerbose((boolean)false);
        this.sender = this.createSender("standalone");
        this.sender.engineDescriptor.setEnableTransactionSavepoints(true);
        this.forwarder = (AepSFRTestBase.Forwarder)((AepSFRTestBase.Forwarder)((AepSFRTestBase.Forwarder)this.createForwarder(this.clustered ? "primary" : "standalone").setStoreEnabled(true)).setClustered(this.clustered)).setPersistent(true);
        this.forwarder.engineDescriptor.setOutboundMessageLoggingPolicy(AepEngine.OutboundMessageLoggingPolicy.Off);
        this.forwarder.engineDescriptor.setAdaptiveCommitBatchCeiling(0);
        this.forwarder.storeDescriptor.setCheckpointingType(IStoreCheckpointingController.Type.Default);
        this.forwarder.storeDescriptor.setCheckpointMaxInterval(1L);
        this.forwarder.storeDescriptor.setCheckpointThreshold(1);
        this.forwarder.storeDescriptor.setPersistenceQuorum(1);
        this.forwarder.storeDescriptor.save();
        this.forwarder.storePersisterDescriptor.setProperty("detachedPersist", "false");
        this.forwarder.storePersisterDescriptor.setProperty("flushOnCommit", "true");
        this.forwarder.storePersisterDescriptor.setProperty("autoRepair", "true");
        this.forwarder.storePersisterDescriptor.setProperty("initialLogLength", "0");
        this.forwarder.storePersisterDescriptor.setProperty("compactionThreshold", "5");
        this.forwarder.storePersisterDescriptor.setProperty("cdcEnabled", "true");
        this.forwarder.storePersisterDescriptor.setProperty("maxCompactionWindowSize", "1");
        this.forwarder.storePersisterDescriptor.save();
        if (this.clustered) {
            this.forwarderBackup = (AepSFRTestBase.Forwarder)((AepSFRTestBase.Forwarder)((AepSFRTestBase.Forwarder)this.createForwarder("backup").setStoreEnabled(true)).setClustered(this.clustered)).setPersistent(true);
            this.forwarderBackup.engineDescriptor.setOutboundMessageLoggingPolicy(AepEngine.OutboundMessageLoggingPolicy.UseDedicated);
            this.forwarderBackup.engineDescriptor.setAdaptiveCommitBatchCeiling(0);
        }
        this.receiver = this.createReceiver("standalone");
        this.receiver.engineDescriptor.setEnableTransactionSavepoints(true);
        this.receiver.engineDescriptor.setPerformDuplicateChecking(false);
        for (AepSFRTestAppBase app : this.apps) {
            app.engineDescriptor.setHAPolicy(AepEngine.HAPolicy.StateReplication);
            app.holdMessages = false;
        }
        switch (this.encoding) {
            case Proto: {
                for (AepSFRTestAppBase app : this.apps) {
                    app.setStateType(Repository.class);
                    app.engineDescriptor.addStateFactory(com.neeve.aep.test.unit.generated.proto.Factory.class.getName());
                    this.sender.engineDescriptor.addMessageFactory(com.neeve.aep.test.unit.generated.proto.Factory.class.getName());
                }
                break;
            }
            case Xbuf: {
                for (AepSFRTestAppBase app : this.apps) {
                    app.setStateType(com.neeve.aep.test.unit.generated.xbuf.Repository.class);
                    app.engineDescriptor.addStateFactory(Factory.class.getName());
                    this.sender.engineDescriptor.addMessageFactory(Factory.class.getName());
                }
                break;
            }
            case Json: {
                for (AepSFRTestAppBase app : this.apps) {
                    app.setStateType(com.neeve.aep.test.unit.generated.json.Repository.class);
                    app.engineDescriptor.addStateFactory(com.neeve.aep.test.unit.generated.json.Factory.class.getName());
                    this.sender.engineDescriptor.addMessageFactory(com.neeve.aep.test.unit.generated.json.Factory.class.getName());
                }
                break;
            }
            case Raw: {
                throw new UnsupportedOperationException("Raw support not enabled");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCDCAndCompaction() throws Throwable {
        PureUpdateStateHandler handler = new PureUpdateStateHandler(this.forwarder);
        this.forwarder.addEventHandler(handler);
        PureUpdateStateHandler backupHandler = null;
        if (this.clustered) {
            backupHandler = new PureUpdateStateHandler(this.forwarderBackup);
            this.forwarderBackup.addEventHandler(backupHandler);
        }
        this.startApps();
        int numToSend = 50000;
        UtlGovernor.run((int)numToSend, (int)5000, (Runnable)new Runnable(){
            int i = 0;

            @Override
            public void run() {
                try {
                    IRogMessage m = AepEngineTestMessage.create(AepCdcAndCompactionTest.this.encoding, false).getMessage();
                    UtlReflection.setNonNestedProperty((Object)m, (String)"stringField", (Object)("SenderSend " + ++this.i));
                    AepCdcAndCompactionTest.this.sender.sendMessage(AepCdcAndCompactionTest.this.CHANNELS[0][0][0][1], m);
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
        });
        this.receiver.waitForMessages(120, numToSend);
        System.out.println("Receiver received all messages");
        System.out.println("Waiting for forwarder transaction stability");
        this.forwarder.waitForTransactionStability(10);
        RogLog forwarderPersister = (RogLog)this.forwarder.engine.getStore().getPersister();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        RogLogRepository repository = forwarderPersister.asRepository();
        repository.open();
        int lastExpectedFixLenFieldValue = numToSend;
        try {
            queryEngine.addRepository((QueryRepository)repository, "primary");
            RogLogResultSet results = queryEngine.execute("SELECT max(stableTransactionId) from logs");
            results.first();
            long stableTransactionId = results.getLong(1);
            results.close();
            results = queryEngine.execute("SELECT max(Repository.fixlenField) FROM logs where transactionId <= " + stableTransactionId);
            results.first();
            lastExpectedFixLenFieldValue = results.getInteger(1);
            results.close();
            System.out.println("Transactions stabilized: last fixLenField value stabilized in log was '" + lastExpectedFixLenFieldValue + "' ... validating CDC handler saw it. ");
            if (handler.cdcHandler.error != null) {
                Assert.fail((String)("CDC encountered an error: " + UtlThrowable.prepareStackTrace((Throwable)handler.cdcHandler.error)));
            }
            Assert.assertEquals((String)"CDC handler has the wrong field value for FixlenField", (Object)String.valueOf(lastExpectedFixLenFieldValue), (Object)String.valueOf(handler.cdcHandler.lastValueReceived));
            results = queryEngine.execute("SELECT timestamp, filePosition, entryType, simpleClassName, id, fixlenField, transactionId, stableTransactionId, checkpointVersion from logs");
            BufferedWriter bw = new BufferedWriter(new FileWriter(new File(AepCdcAndCompactionTest.getTestbedRoot(), "tlog.csv")));
            UtlQueryResultFormatter.dumpResults((QueryResultSet)results, (int)50000, (UtlTableFormatter.Format)UtlTableFormatter.Format.CSV, (BufferedWriter)bw);
            bw.flush();
            System.out.println("Wrote compacted log dump to: " + new File(AepCdcAndCompactionTest.getTestbedRoot(), "tlog.csv"));
        }
        finally {
            queryEngine.close();
            repository.close();
        }
    }

    public class PureUpdateStateHandler
    extends MessageHandler {
        AepSFRTestBase.Forwarder forwarder;

        public PureUpdateStateHandler(AepSFRTestBase.Forwarder forwarder) {
            this.forwarder = forwarder;
        }

        @Override
        public void handle(MessageView message, Object state) throws Exception {
            Integer current = (Integer)UtlReflection.getProperty((Object)state, (String)"FixlenField");
            if (current == null) {
                current = 0;
            }
            UtlReflection.setNonNestedProperty((Object)state, (String)"FixlenField", (Object)(current + 1));
            IRogMessage m = AepEngineTestMessage.create(AepCdcAndCompactionTest.this.encoding, false).getMessage();
            UtlReflection.setNonNestedProperty((Object)m, (String)"stringField", (Object)("ForwarderSend " + UtlReflection.getProperty((Object)state, (String)"FixlenField")));
            this.forwarder.sendMessage(AepCdcAndCompactionTest.this.CHANNELS[1][0][0][1], m);
        }
    }

    public abstract class MessageHandler {
        protected Object state;
        volatile Throwable handlerError;
        volatile CdcHandler cdcHandler;
        RogLogCdcProcessor cdcProcessor;
        volatile boolean cdcStopped = false;
        volatile Thread cdcThread;

        @EventHandler
        public void onEngineActive(AepEngineActiveEvent event) throws Exception {
            RogLog persister = (RogLog)((AepEngine)event.getSource()).getStore().getPersister();
            this.cdcHandler = new CdcHandler();
            this.cdcProcessor = persister.createCdcProcessor((IRogChangeDataCaptureHandler)this.cdcHandler);
            this.cdcThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (!MessageHandler.this.cdcStopped) {
                        try {
                            MessageHandler.this.cdcProcessor.run();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException e1) {
                                e1.printStackTrace();
                            }
                            System.exit(1);
                        }
                    }
                }
            }, "CDC Processor");
            this.cdcThread.start();
        }

        @EventHandler
        public void onEngineStopping(AepEngineStoppingEvent event) throws Exception {
            this.cdcStopped = true;
            this.cdcProcessor.close();
            this.cdcThread.join();
        }

        @EventHandler
        public void onProtoMessage(com.neeve.aep.test.unit.generated.proto.Message message, Repository state) {
            this.handleInternal((MessageView)message, state);
        }

        @EventHandler
        public void onXbufMessage(com.neeve.aep.test.unit.generated.xbuf.Message message, com.neeve.aep.test.unit.generated.xbuf.Repository state) {
            this.handleInternal((MessageView)message, state);
        }

        @EventHandler
        public void onJsonMessage(Message message, com.neeve.aep.test.unit.generated.json.Repository state) {
            this.handleInternal((MessageView)message, state);
        }

        private void handleInternal(MessageView message, Object state) {
            try {
                this.handle(message, state);
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.handlerError = t;
            }
        }

        protected Object getState(MessageView message) {
            return ((AepCdcAndCompactionTest)AepCdcAndCompactionTest.this).forwarder.engine.getApplicationState(message);
        }

        public abstract void handle(MessageView var1, Object var2) throws Exception;
    }

    public class CdcHandler
    implements IRogChangeDataCaptureHandler {
        private final String tracePrefix = "[CDCHANDLER] ";
        private final Tracer tracer = Tracer.create((Tracer.Level)Tracer.Level.INFO);
        volatile Throwable error;
        volatile Object lastValueReceived;
        volatile int lastLogNumber;

        CdcHandler() {
            this.tracer.bind("app.cdchandler");
        }

        public boolean handleChange(UUID objectId, IRogChangeDataCaptureHandler.ChangeType changeType, List<IRogNode> entries) {
            if (this.tracer.debug) {
                this.tracer.log("[CDCHANDLER] handleChange id: " + objectId + " type: " + changeType + " entries: " + entries.size(), Tracer.Level.DEBUG);
            }
            if (entries.get(0).getClass().getSimpleName().equals("Repository")) {
                this.lastValueReceived = UtlReflection.getProperty((Object)entries.get(entries.size() - 1), (String)"FixlenField");
            }
            return true;
        }

        public boolean onCheckpointComplete(long checkpointVersion) {
            if (this.tracer.debug) {
                this.tracer.log("[CDCHANDLER] onCheckpointComplete " + checkpointVersion, Tracer.Level.DEBUG);
            }
            return true;
        }

        public void onCheckpointStart(long checkpointVersion) {
            if (this.tracer.debug) {
                this.tracer.log("[CDCHANDLER] onCheckpointStart " + checkpointVersion, Tracer.Level.DEBUG);
            }
        }

        public void onLogComplete(int logNumber, IRogChangeDataCaptureHandler.LogCompletionReason reason, Throwable errorCause) {
            this.tracer.log("[CDCHANDLER] onLogComplete " + logNumber + ", status: " + reason + (errorCause != null ? ", ERROR: " + UtlThrowable.prepareStackTrace((Throwable)errorCause) : ""), Tracer.Level.INFO);
            this.lastLogNumber = logNumber;
            if (reason == IRogChangeDataCaptureHandler.LogCompletionReason.Error) {
                this.error = errorCause;
            }
        }

        public void onLogStart(int logNumber) {
            this.tracer.log("[CDCHANDLER] onLogStart " + logNumber, Tracer.Level.INFO);
        }

        public void onWait() {
            if (this.tracer.debug) {
                this.tracer.log("[CDCHANDLER] onWait", Tracer.Level.DEBUG);
            }
        }
    }
}

