/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.perf.serialization.rumi.xbuf2;

import com.eaio.uuid.UUID;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.neeve.adm.runtime.AdmRuntime;
import com.neeve.adm.runtime.annotations.AdmFactoryInfo;
import com.neeve.adm.runtime.annotations.AdmGenerated;
import com.neeve.ci.XRuntime;
import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XString;
import com.neeve.memory.MemoryStats;
import com.neeve.perf.serialization.rumi.xbuf2.IEngine;
import com.neeve.perf.serialization.rumi.xbuf2.MessageFactory;
import com.neeve.pkt.PktBody;
import com.neeve.pkt.PktBuffer;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.types.PktBodyData;
import com.neeve.quark.QuarkBuffer;
import com.neeve.quark.QuarkHeuristics;
import com.neeve.quark.QuarkString;
import com.neeve.quark.QuarkStringDeserializer;
import com.neeve.util.UtlPool;
import com.neeve.xbuf2.XbufUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;

@AdmGenerated(encoding="Xbuf2", compatLevel="4.1.0", admVersion="Unknown Version", date="11/16/25 4:17 AM", buildInfo="nvx-perf-models-3.16-SNAPSHOT (nvx-codegen-plugin)")
@AdmFactoryInfo(factoryClass=MessageFactory.class, vfid=-1, ofid=-1, typeId=101)
@JsonPropertyOrder(value={"capacity", "numCylinders", "maxRpm", "manufacturerCode", "fuel"})
public final class Engine
implements IEngine,
UtlPool.Item<Engine>,
AdmRuntime.BufferSizer {
    private static final MemoryStats _memoryStats = MemoryStats.getInstance();
    private static final EnginePoolFactory _engineFactory = new EnginePoolFactory();
    private static final EnginePojoPoolFactory _enginePojoFactory = new EnginePojoPoolFactory();
    private static final EngineSerializerPoolFactory _engineSerializerFactory = new EngineSerializerPoolFactory();
    private static final EngineDeserializerPoolFactory _engineDeserializerFactory = new EngineDeserializerPoolFactory();
    static final UtlPool<Engine> _entityPool = UtlPool.create((String)"quark.entity", (String)"EngineQuarkEntity.1.101", (UtlPool.Factory)_engineFactory, (UtlPool.Params)QuarkHeuristics.configurePoolParams(Engine.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new EnginePoolEvictedItemReceiver());
    static final UtlPool<Pojo> _entityPojoPool = UtlPool.create((String)"quark.entity.pojo", (String)"EngineQuarkEntityPojo.1.101", (UtlPool.Factory)_enginePojoFactory, (UtlPool.Params)QuarkHeuristics.configurePoolParams(Pojo.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new EnginePojoPoolEvictedItemReceiver());
    static final UtlPool<Serializer> _entitySerializerPool = UtlPool.create((String)"quark.entity.serializer", (String)"EngineQuarkEntitySerializer.1.101", (UtlPool.Factory)_engineSerializerFactory, (UtlPool.Params)QuarkHeuristics.configurePoolParams(Serializer.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new EngineSerializerPoolEvictedItemReceiver());
    static final UtlPool<Deserializer> _entityDeserializerPool = UtlPool.create((String)"quark.entity.deserializer", (String)"EngineQuarkEntityDeserializer.1.101", (UtlPool.Factory)_engineDeserializerFactory, (UtlPool.Params)QuarkHeuristics.configurePoolParams(Deserializer.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new EngineDeserializerPoolEvictedItemReceiver());
    private final AtomicInteger _ownershipCount = new AtomicInteger(1);
    private UtlPool<Engine> _pool;
    private QuarkBuffer _serializedBuffer;
    private int _serializedBufferLength;
    private Serializer _serializer;
    private Deserializer _deserializer;
    private Pojo _pojo;
    private boolean readOnly;
    private boolean created = true;
    public static final Engine[] EMPTY_ARRAY = new Engine[0];

    Engine() {
    }

    public static Engine create() {
        Engine entity = (Engine)_entityPool.get(null);
        _memoryStats.onEntityAllocated(Engine.class, MemoryStats.EntityType.EmbeddedEntity, !entity.created);
        return entity;
    }

    private final QuarkBuffer serializedBuffer(int len) {
        QuarkBuffer oldBuffer = this._serializedBuffer;
        int oldCapacity = oldBuffer != null ? oldBuffer.getCapacity() : 0;
        this._serializedBuffer = QuarkBuffer.ensureCapacity((QuarkBuffer)this._serializedBuffer, (int)len, (boolean)false);
        int newCapacity = this._serializedBuffer.getCapacity();
        if (newCapacity > oldCapacity) {
            if (oldBuffer != null) {
                _memoryStats.onEntityDataDisposed(Engine.class, MemoryStats.EntityType.EmbeddedEntity, oldCapacity, true);
            }
            _memoryStats.onEntityDataAllocated(Engine.class, MemoryStats.EntityType.EmbeddedEntity, newCapacity);
        }
        return this._serializedBuffer;
    }

    public final boolean hasSerializedBuffer() {
        return this._serializedBuffer != null;
    }

    @JsonIgnore
    public final QuarkBuffer getSerializedBuffer() {
        return this._serializedBuffer;
    }

    @Deprecated
    @JsonIgnore
    public final QuarkBuffer getBackingBuffer() {
        return this.getSerializedBuffer();
    }

    final void setSerializedBufferLength(int val) {
        this._serializedBufferLength = val;
    }

    @JsonIgnore
    public final int getSerializedBufferLength() {
        return this._serializedBufferLength;
    }

    @Deprecated
    @JsonIgnore
    public final int getSerializeToNativeLength() {
        return this.getSerializedBufferLength();
    }

    public final Serializer serializer(int length, boolean autoResizeTargetBuffer) {
        if (this._serializer == null) {
            this._serializer = Serializer.create();
        }
        this.serializedBuffer(length);
        if (autoResizeTargetBuffer) {
            this._serializer.setSizer(this);
        }
        return this._serializer.init(this);
    }

    public final Serializer serializer(int minimumLength) {
        return this.serializer(minimumLength, true);
    }

    public final Serializer serializer() {
        return this.serializer(1024, true);
    }

    public final long ensureCapacity(long addr, int capacity) {
        if (capacity <= this._serializedBufferLength) {
            return addr;
        }
        int newLength = capacity <= this._serializedBuffer.getCapacity() ? capacity : Math.max(capacity, this._serializedBuffer.getCapacity() * 2);
        this._serializedBuffer = QuarkBuffer.ensureCapacity((QuarkBuffer)this._serializedBuffer, (int)newLength, (boolean)true);
        return this._serializedBuffer.getNativeAddress();
    }

    public final Deserializer deserializer(boolean createBuffer) {
        if (!this.hasSerializedBuffer() && createBuffer) {
            this.serializedBuffer(0);
        }
        if (!this.hasSerializedBuffer()) {
            throw new IllegalStateException("no backing serialized buffer");
        }
        if (this._deserializer == null) {
            this._deserializer = Deserializer.create();
        }
        return this._deserializer.init(this._serializedBuffer, 0, this._serializedBufferLength);
    }

    public final Deserializer deserializer() {
        return this.deserializer(false);
    }

    public final boolean hasPojo() {
        return this._pojo != null && this._pojo.isInitialized();
    }

    public final boolean hasDirtyPojo() {
        return this.hasPojo() && this._pojo.isDirty();
    }

    public final Pojo pojo() {
        if (this._pojo == null) {
            this._pojo = Pojo.create();
        }
        if (!this._pojo.isInitialized()) {
            if (this.hasSerializedBuffer()) {
                this._pojo.deserialize(this.deserializer());
                this._pojo.clearDirty();
            } else {
                this._pojo.setInitialized();
            }
            if (this.readOnly) {
                this._pojo.setAsReadOnly();
            }
        }
        return this._pojo;
    }

    public final void disposeSerializedBuffer() {
        if (this._serializedBuffer != null) {
            int capacity = this._serializedBuffer.getCapacity();
            this._serializedBuffer.dispose();
            _memoryStats.onEntityDataDisposed(Engine.class, MemoryStats.EntityType.EmbeddedEntity, capacity, true);
            this._serializedBuffer = null;
            this._serializedBufferLength = 0;
        }
    }

    public final void disposeSerializer() {
        if (this._serializer != null) {
            this._serializer.dispose();
            this._serializer = null;
        }
    }

    public final void disposeDeserializer() {
        if (this._deserializer != null) {
            this._deserializer.dispose();
            this._deserializer = null;
        }
    }

    public final void disposePojo(boolean sync) {
        if (sync) {
            this.sync();
        }
        if (this._pojo != null) {
            this._pojo.dispose();
            this._pojo = null;
        }
    }

    public final void disposePojo() {
        this.disposePojo(false);
    }

    private final void conserveMemory() {
        this.sync();
        this.disposeSerializer();
        this.disposeDeserializer();
        this.disposePojo(false);
    }

    public final void clear(boolean disposeMembers) {
        if (this._pojo != null) {
            if (disposeMembers) {
                this.disposePojo(false);
            } else {
                this._pojo.reset();
            }
        }
        if (disposeMembers) {
            this.disposeSerializedBuffer();
        } else {
            this._serializedBufferLength = 0;
        }
        this.readOnly = false;
    }

    public final void clear() {
        this.clear(false);
    }

    @Deprecated
    public final void clearContent() {
        this.clear();
    }

    public final void reset(boolean disposeMembers) {
        this.clear(disposeMembers);
        if (disposeMembers) {
            this.disposeSerializer();
            this.disposeDeserializer();
        }
    }

    public final void reset() {
        this.reset(XRuntime.optimizeMemoryUsage());
    }

    public final String serializeToRawJson() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            MessageFactory.mapper.writeValue((OutputStream)baos, (Object)this);
            return new String(baos.toByteArray(), "utf-8");
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public final int serializeTo(Serializer serializer) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            serializer.putFrom(this._serializedBuffer, 0, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final int serializeTo(QuarkBuffer buffer, int offset) {
        this.sync();
        if (this._serializedBufferLength > buffer.getLength() - offset) {
            throw new IllegalArgumentException("buffer too small");
        }
        if (this.hasSerializedBuffer()) {
            this._serializedBuffer.getTo(0, buffer, offset, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final void sync() {
        if (!this.hasDirtyPojo()) {
            return;
        }
        this._serializedBufferLength = this._pojo.serialize(this.serializer(this._pojo.getSerializedLength(), false));
        this._pojo.clearDirty();
    }

    public final byte[] serializeToByteArray() {
        this.sync();
        byte[] array = new byte[this._serializedBufferLength];
        this.serializeTo(array, 0);
        return array;
    }

    public final int serializeTo(byte[] array, int offset) {
        this.sync();
        if (this._serializedBufferLength > array.length - offset) {
            throw new IllegalArgumentException("array too small");
        }
        if (this.hasSerializedBuffer()) {
            this._serializedBuffer.getTo(0, array, offset, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final ByteBuffer serializeToByteBuffer() {
        this.sync();
        ByteBuffer buffer = ByteBuffer.allocate(this._serializedBufferLength);
        this.serializeTo(buffer);
        return buffer;
    }

    public final int serializeTo(ByteBuffer buffer) {
        this.sync();
        if (this._serializedBufferLength > buffer.capacity() - buffer.position()) {
            throw new IllegalArgumentException("buffer too small");
        }
        buffer.limit(buffer.position() + this._serializedBufferLength);
        if (this.hasSerializedBuffer()) {
            this._serializedBuffer.getTo(0, buffer, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final IOBuffer serializeToIOBuffer(boolean useNative) {
        this.sync();
        IOBuffer buffer = IOBuffer.create((int)this._serializedBufferLength, (boolean)useNative);
        this.serializeTo(buffer, 0);
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int serializeTo(IOBuffer buffer, int offset) {
        this.sync();
        ByteBuffer bytebuf = buffer.takeBuffer();
        try {
            bytebuf.limit(bytebuf.capacity());
            bytebuf.position(offset);
            int n = this.serializeTo(bytebuf);
            return n;
        }
        finally {
            buffer.releaseBuffer();
        }
    }

    public final int serializeTo(IOElasticBuffer buffer, int offset) {
        this.sync();
        buffer.setLength(offset + this._serializedBufferLength);
        return this.serializeTo(buffer.getIOBuffer(), buffer.getOffset() + offset);
    }

    public final PktPacket serializeToPacket() {
        PktPacket packet = PktFactory.getInstance().createPacket(-32868);
        this.serializeTo(packet);
        return packet;
    }

    public final int serializeTo(PktPacket packet) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            packet.getBody().deserialize(this._serializedBuffer, 0, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final int serializeTo(long addr, int offset) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            this._serializedBuffer.getTo(0, addr, offset, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    @Deprecated
    public final int serializeToNative(long addr, int offset) {
        return this.serializeTo(addr, offset);
    }

    public final String serializeToJson() {
        return this.serializeToRawJson();
    }

    public final Engine deserializeFromRawJson(String json) {
        try {
            MessageFactory.mapper.reader().withValueToUpdate((Object)this).readValue(json);
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final Engine deserializeFrom(Deserializer deserializer) {
        if (!deserializer.isInitialized()) {
            throw new IllegalArgumentException("can only deserialize from an initialized deserializer");
        }
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this._serializedBufferLength = 0;
        if (deserializer != null) {
            this._serializedBufferLength = deserializer.getSerializedLength();
            deserializer.getTo(this.serializedBuffer(this._serializedBufferLength), 0);
        }
        return this;
    }

    public final Engine deserializeFrom(Engine val) {
        return this.deserializeFrom(val.getSerializedBuffer(), 0, val.getSerializedBufferLength());
    }

    public final Engine deserializeFrom(QuarkBuffer buffer, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = buffer != null ? len : 0;
        if (buffer != null) {
            this.serializedBuffer(len).putFrom(0, buffer, offset, len);
        }
        return this;
    }

    public final Engine wrap(QuarkBuffer buffer, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this.disposeSerializedBuffer();
        this._serializedBuffer = buffer;
        this._serializedBufferLength = len;
        return this;
    }

    public final Engine deserializeFromByteArray(byte[] array) {
        return this.deserializeFrom(array, 0, array.length);
    }

    public final Engine deserializeFrom(byte[] array, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = array != null ? len : 0;
        if (array != null) {
            this.serializedBuffer(len).putFrom(0, array, offset, len);
        }
        return this;
    }

    public final Engine deserializeFromByteBuffer(ByteBuffer buffer) {
        return this.deserializeFrom(buffer);
    }

    public final Engine deserializeFrom(ByteBuffer buffer) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = buffer != null ? buffer.remaining() : 0;
        if (buffer != null) {
            this.serializedBuffer(this._serializedBufferLength).putFrom(0, buffer);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Engine deserializeFrom(IOBuffer buffer, int offset, int len) {
        if (buffer == null) {
            return this.deserializeFrom((ByteBuffer)null);
        }
        ByteBuffer bytebuf = buffer.takeBuffer();
        try {
            bytebuf.limit(offset + len).position(offset);
            Engine engine = this.deserializeFrom(bytebuf);
            return engine;
        }
        finally {
            buffer.releaseBuffer();
        }
    }

    public final Engine deserializeFrom(IOElasticBuffer buffer, int offset, int len) {
        return this.deserializeFrom(buffer.getIOBuffer(), buffer.getOffset() + offset, len);
    }

    public final Engine deserializeFromPacket(PktPacket packet) {
        return this.deserializeFrom(packet);
    }

    public final Engine deserializeFrom(PktPacket packet) {
        try {
            PktBuffer buffer = packet.getBody().getBuffer();
            Engine engine = this.deserializeFrom((IOElasticBuffer)buffer, 0, buffer.getLength());
            return engine;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            packet.dispose();
        }
    }

    public final Engine deserializeFrom(long addr, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this._serializedBufferLength = len;
        this.serializedBuffer(this._serializedBufferLength).putFrom(0, addr, offset, len);
        return this;
    }

    @Deprecated
    public final Engine deserializeFromNative(long addr, int offset, int len) {
        return this.deserializeFrom(addr, offset, len);
    }

    public final Engine deserializeFromJson(String json) {
        this.deserializeFromRawJson(json);
        return this;
    }

    public final void copyInto(Engine copy) {
        copy.clear();
        this.sync();
        copy.deserializeFrom(this._serializedBuffer, 0, this._serializedBufferLength);
    }

    public final Engine copy() {
        Engine copy = Engine.create();
        this.copyInto(copy);
        return copy;
    }

    public final void setAsReadOnly() {
        this.readOnly = true;
        if (this._pojo != null) {
            this._pojo.setAsReadOnly();
        }
    }

    public static final int getCapacityFieldId() {
        return 16;
    }

    @Override
    @JsonProperty(value="capacity")
    public final void setCapacity(short val) {
        this.pojo().setCapacity(val);
    }

    @Override
    @JsonIgnore
    public final short getCapacity() {
        return this.pojo().getCapacity();
    }

    @Override
    @JsonProperty(value="capacity")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Short getCapacityAsObject() {
        if (!this.hasCapacity()) {
            return null;
        }
        return this.getCapacity();
    }

    @Override
    public final boolean hasCapacity() {
        return this.pojo().hasCapacity();
    }

    @Override
    public final void clearCapacity() {
        this.pojo().clearCapacity();
    }

    public static final int getNumCylindersFieldId() {
        return 17;
    }

    @Override
    @JsonProperty(value="numCylinders")
    public final void setNumCylinders(byte val) {
        this.pojo().setNumCylinders(val);
    }

    @Override
    @JsonIgnore
    public final byte getNumCylinders() {
        return this.pojo().getNumCylinders();
    }

    @Override
    @JsonProperty(value="numCylinders")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Byte getNumCylindersAsObject() {
        if (!this.hasNumCylinders()) {
            return null;
        }
        return this.getNumCylinders();
    }

    @Override
    public final boolean hasNumCylinders() {
        return this.pojo().hasNumCylinders();
    }

    @Override
    public final void clearNumCylinders() {
        this.pojo().clearNumCylinders();
    }

    public static final int getMaxRpmFieldId() {
        return 18;
    }

    @Override
    @JsonProperty(value="maxRpm")
    public final void setMaxRpm(short val) {
        this.pojo().setMaxRpm(val);
    }

    @Override
    @JsonIgnore
    public final short getMaxRpm() {
        return this.pojo().getMaxRpm();
    }

    @Override
    @JsonProperty(value="maxRpm")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Short getMaxRpmAsObject() {
        if (!this.hasMaxRpm()) {
            return null;
        }
        return this.getMaxRpm();
    }

    @Override
    public final boolean hasMaxRpm() {
        return this.pojo().hasMaxRpm();
    }

    @Override
    public final void clearMaxRpm() {
        this.pojo().clearMaxRpm();
    }

    public static final int getManufacturerCodeFieldId() {
        return 19;
    }

    @Override
    @JsonProperty(value="manufacturerCode")
    public final void setManufacturerCode(String val) {
        this.pojo().setManufacturerCodeFrom(val);
    }

    @Override
    @JsonProperty(value="manufacturerCode")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final String getManufacturerCode() {
        if (!this.hasManufacturerCode()) {
            return null;
        }
        return this.pojo()._usrManufacturerCode.getValue();
    }

    @Override
    @JsonIgnore
    public final void lendManufacturerCode(XString val) {
        if (val == null || !val.isInitialized() || val.isNull()) {
            this.setManufacturerCode(null);
            return;
        }
        if (!val.isImmutable()) {
            throw new IllegalArgumentException("value is mutable");
        }
        this.pojo().setManufacturerCodeFrom(val);
    }

    @Override
    @JsonIgnore
    public final void setManufacturerCodeFrom(long val) {
        this.pojo().setManufacturerCodeFrom(val);
    }

    @Override
    @JsonIgnore
    public final <T extends XString> T getManufacturerCodeTo(XString.Factory<T> factory) {
        XString to = factory.create(false);
        this.pojo().getManufacturerCodeTo(to);
        return (T)to;
    }

    @Override
    @JsonIgnore
    public final void setManufacturerCodeFrom(XString val) {
        this.pojo().setManufacturerCodeFrom(val);
    }

    @Override
    @JsonIgnore
    public final void getManufacturerCodeTo(XString val) {
        this.pojo().getManufacturerCodeTo(val);
    }

    @Override
    @JsonIgnore
    public final XString getManufacturerCodeUnsafe() {
        return this.pojo().getManufacturerCode();
    }

    @Override
    public final boolean hasManufacturerCode() {
        return this.pojo().hasManufacturerCode();
    }

    @Override
    public final void clearManufacturerCode() {
        this.pojo().clearManufacturerCode();
    }

    public static final int getFuelFieldId() {
        return 20;
    }

    @Override
    @JsonProperty(value="fuel")
    public final void setFuel(String val) {
        this.pojo().setFuelFrom(val);
    }

    @Override
    @JsonProperty(value="fuel")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final String getFuel() {
        if (!this.hasFuel()) {
            return null;
        }
        return this.pojo()._usrFuel.getValue();
    }

    @Override
    @JsonIgnore
    public final void lendFuel(XString val) {
        if (val == null || !val.isInitialized() || val.isNull()) {
            this.setFuel(null);
            return;
        }
        if (!val.isImmutable()) {
            throw new IllegalArgumentException("value is mutable");
        }
        this.pojo().setFuelFrom(val);
    }

    @Override
    @JsonIgnore
    public final void setFuelFrom(long val) {
        this.pojo().setFuelFrom(val);
    }

    @Override
    @JsonIgnore
    public final <T extends XString> T getFuelTo(XString.Factory<T> factory) {
        XString to = factory.create(false);
        this.pojo().getFuelTo(to);
        return (T)to;
    }

    @Override
    @JsonIgnore
    public final void setFuelFrom(XString val) {
        this.pojo().setFuelFrom(val);
    }

    @Override
    @JsonIgnore
    public final void getFuelTo(XString val) {
        this.pojo().getFuelTo(val);
    }

    @Override
    @JsonIgnore
    public final XString getFuelUnsafe() {
        return this.pojo().getFuel();
    }

    @Override
    public final boolean hasFuel() {
        return this.pojo().hasFuel();
    }

    @Override
    public final void clearFuel() {
        this.pojo().clearFuel();
    }

    public final Engine init() {
        this.reset();
        this._ownershipCount.set(1);
        return this;
    }

    public final Engine setPool(UtlPool<Engine> pool) {
        this._pool = pool;
        return this;
    }

    public final UtlPool<Engine> getPool() {
        return this._pool;
    }

    public final Engine acquire() {
        int val = this._ownershipCount.incrementAndGet();
        if (val <= 1 && this._pool != null) {
            throw new IllegalStateException("attempt to acquire an already disposed entity");
        }
        return this;
    }

    public final int getOwnershipCount() {
        return this._ownershipCount.get();
    }

    public final void dispose() {
        int val = this._ownershipCount.decrementAndGet();
        if (val < 0 && this._pool != null) {
            throw new IllegalStateException("attempt to dispose an already disposed entity");
        }
        if (val == 0 && this._pool != null) {
            this.created = false;
            this._pool.put((UtlPool.Item)this);
            _memoryStats.onEntityDisposed(Engine.class, MemoryStats.EntityType.EmbeddedEntity, true);
        }
    }

    public final Object clone() {
        Engine clonee = Engine.create();
        if (this.hasCapacity()) {
            clonee.setCapacity(this.getCapacity());
        }
        if (this.hasNumCylinders()) {
            clonee.setNumCylinders(this.getNumCylinders());
        }
        if (this.hasMaxRpm()) {
            clonee.setMaxRpm(this.getMaxRpm());
        }
        if (this.hasManufacturerCode()) {
            clonee.setManufacturerCode(this.getManufacturerCode());
        }
        if (this.hasFuel()) {
            clonee.setFuel(this.getFuel());
        }
        return clonee;
    }

    public final boolean isValid() {
        return true;
    }

    public final void getValidationErrors(List<XString> results, String errorPrefix) {
    }

    public final String toString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HH:mm:ss.SSS");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        int c = 0;
        if (this.hasCapacity()) {
            builder.append(0 == c++ ? "" : ",").append("Capacity=").append(this.getCapacity());
        }
        if (this.hasNumCylinders()) {
            builder.append(0 == c++ ? "" : ",").append("NumCylinders=").append(this.getNumCylinders());
        }
        if (this.hasMaxRpm()) {
            builder.append(0 == c++ ? "" : ",").append("MaxRpm=").append(this.getMaxRpm());
        }
        if (this.hasManufacturerCode()) {
            builder.append(0 == c++ ? "" : ",").append("ManufacturerCode=").append(this.getManufacturerCode());
        }
        if (this.hasFuel()) {
            builder.append(0 == c++ ? "" : ",").append("Fuel=").append(this.getFuel());
        }
        builder.append("}");
        return builder.toString();
    }

    public static final class Pojo
    implements UtlPool.Item<Pojo> {
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final MemoryStats _memoryStats = MemoryStats.getInstance();
        private final long[] _fieldBitmask = new long[1];
        private final DeserializationCallback _deserializationCallback = new DeserializationCallback();
        private UtlPool<Pojo> _pool;
        private boolean _initialized;
        private boolean _readonly;
        private boolean _dirty;
        private byte _flags;
        private short _usrCapacity;
        private byte _usrNumCylinders;
        private short _usrMaxRpm;
        private XString _usrManufacturerCode = XString.create((int)0, (boolean)true, (boolean)true);
        private XString _usrFuel = XString.create((int)0, (boolean)true, (boolean)true);

        Pojo() {
            this.setCreated();
        }

        public static final Pojo create(boolean pvt) {
            Pojo pojo = (Pojo)_entityPojoPool.get(null);
            if (pvt) {
                pojo.setPrivate();
            } else {
                pojo.clearPrivate();
                _memoryStats.onEntityPojoAllocated(Engine.class, MemoryStats.EntityType.EmbeddedEntity, !pojo.isCreated());
            }
            return pojo.clearPooled();
        }

        public static final Pojo create() {
            return Pojo.create(false);
        }

        public final boolean hasCapacity() {
            return (this._fieldBitmask[0] & 1L) != 0L;
        }

        public final short getCapacity() {
            return this._usrCapacity;
        }

        public final void setCapacity(short val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            this._fieldBitmask[0] = this._fieldBitmask[0] | 1L;
            this._usrCapacity = val;
            this._dirty = true;
        }

        public final void clearCapacity() {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasCapacity()) {
                return;
            }
            this._usrCapacity = 0;
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFFEL;
            this._dirty = true;
        }

        public final boolean hasNumCylinders() {
            return (this._fieldBitmask[0] & 2L) != 0L;
        }

        public final byte getNumCylinders() {
            return this._usrNumCylinders;
        }

        public final void setNumCylinders(byte val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            this._fieldBitmask[0] = this._fieldBitmask[0] | 2L;
            this._usrNumCylinders = val;
            this._dirty = true;
        }

        public final void clearNumCylinders() {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasNumCylinders()) {
                return;
            }
            this._usrNumCylinders = 0;
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFFDL;
            this._dirty = true;
        }

        public final boolean hasMaxRpm() {
            return (this._fieldBitmask[0] & 4L) != 0L;
        }

        public final short getMaxRpm() {
            return this._usrMaxRpm;
        }

        public final void setMaxRpm(short val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            this._fieldBitmask[0] = this._fieldBitmask[0] | 4L;
            this._usrMaxRpm = val;
            this._dirty = true;
        }

        public final void clearMaxRpm() {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasMaxRpm()) {
                return;
            }
            this._usrMaxRpm = 0;
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFFBL;
            this._dirty = true;
        }

        public final boolean hasManufacturerCode() {
            return (this._fieldBitmask[0] & 8L) != 0L;
        }

        public final XString getManufacturerCode() {
            if (!this.hasManufacturerCode() || this._usrManufacturerCode.isNull()) {
                return null;
            }
            return this._usrManufacturerCode;
        }

        public final void getManufacturerCodeTo(XString val) {
            if (!this.hasManufacturerCode() || this._usrManufacturerCode.isNull()) {
                val.clear();
                return;
            }
            val.setValue(this._usrManufacturerCode);
        }

        public final void setManufacturerCodeFrom(String val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearManufacturerCode();
                return;
            }
            this._usrManufacturerCode.setValue(val);
            if (!this.hasManufacturerCode()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 8L;
            }
            this._dirty = true;
        }

        public final void setManufacturerCodeFrom(XString val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.isNull()) {
                this.clearManufacturerCode();
                return;
            }
            this._usrManufacturerCode.setValue(val);
            if (!this.hasManufacturerCode()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 8L;
            }
            this._dirty = true;
        }

        public final void setManufacturerCodeFrom(CharSequence val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearManufacturerCode();
                return;
            }
            this._usrManufacturerCode.setValue(val);
            if (!this.hasManufacturerCode()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 8L;
            }
            this._dirty = true;
        }

        public final void setManufacturerCodeFrom(long val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            this._usrManufacturerCode.setValue(val);
            if (!this.hasManufacturerCode()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 8L;
            }
            this._dirty = true;
        }

        public final void setManufacturerCodeFrom(byte[] val, int offset, int len) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearManufacturerCode();
                return;
            }
            this._usrManufacturerCode.setValue(val, offset, len);
            if (!this.hasManufacturerCode()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 8L;
            }
            this._dirty = true;
        }

        public final void setManufacturerCodeFrom(QuarkString val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.isNull()) {
                this.clearManufacturerCode();
                return;
            }
            val.getTo(this._usrManufacturerCode);
            if (!this.hasManufacturerCode()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 8L;
            }
            this._dirty = true;
        }

        public final void setManufacturerCodeFrom(QuarkStringDeserializer val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearManufacturerCode();
                return;
            }
            val.getTo(this._usrManufacturerCode);
            if (!this.hasManufacturerCode()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 8L;
            }
            this._dirty = true;
        }

        public final void clearManufacturerCode() {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasManufacturerCode()) {
                return;
            }
            this._usrManufacturerCode.reset();
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFF7L;
            this._dirty = true;
        }

        public final boolean hasFuel() {
            return (this._fieldBitmask[0] & 0x10L) != 0L;
        }

        public final XString getFuel() {
            if (!this.hasFuel() || this._usrFuel.isNull()) {
                return null;
            }
            return this._usrFuel;
        }

        public final void getFuelTo(XString val) {
            if (!this.hasFuel() || this._usrFuel.isNull()) {
                val.clear();
                return;
            }
            val.setValue(this._usrFuel);
        }

        public final void setFuelFrom(String val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearFuel();
                return;
            }
            this._usrFuel.setValue(val);
            if (!this.hasFuel()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x10L;
            }
            this._dirty = true;
        }

        public final void setFuelFrom(XString val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.isNull()) {
                this.clearFuel();
                return;
            }
            this._usrFuel.setValue(val);
            if (!this.hasFuel()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x10L;
            }
            this._dirty = true;
        }

        public final void setFuelFrom(CharSequence val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearFuel();
                return;
            }
            this._usrFuel.setValue(val);
            if (!this.hasFuel()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x10L;
            }
            this._dirty = true;
        }

        public final void setFuelFrom(long val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            this._usrFuel.setValue(val);
            if (!this.hasFuel()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x10L;
            }
            this._dirty = true;
        }

        public final void setFuelFrom(byte[] val, int offset, int len) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearFuel();
                return;
            }
            this._usrFuel.setValue(val, offset, len);
            if (!this.hasFuel()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x10L;
            }
            this._dirty = true;
        }

        public final void setFuelFrom(QuarkString val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.isNull()) {
                this.clearFuel();
                return;
            }
            val.getTo(this._usrFuel);
            if (!this.hasFuel()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x10L;
            }
            this._dirty = true;
        }

        public final void setFuelFrom(QuarkStringDeserializer val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearFuel();
                return;
            }
            val.getTo(this._usrFuel);
            if (!this.hasFuel()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x10L;
            }
            this._dirty = true;
        }

        public final void clearFuel() {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasFuel()) {
                return;
            }
            this._usrFuel.reset();
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFEFL;
            this._dirty = true;
        }

        public final void clear() {
            this._readonly = false;
            this._usrCapacity = 0;
            this._usrNumCylinders = 0;
            this._usrMaxRpm = 0;
            this._fieldBitmask[0] = 0L;
            this._dirty = true;
        }

        private final Pojo setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Pojo clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Pojo setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Pojo clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Pojo setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Pojo clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        public final void setAsReadOnly() {
            this._readonly = true;
        }

        public final boolean isInitialized() {
            return this._initialized;
        }

        public final void setInitialized() {
            this._initialized = true;
        }

        public final void clearDirty() {
            this._dirty = false;
        }

        public final void forceDirty() {
            this._dirty = true;
        }

        public final boolean isDirty() {
            return this._dirty;
        }

        public final int getSerializedLength() {
            int len = 0;
            if (this.hasCapacity()) {
                len += XbufUtil.primitiveFieldSerializedLength((int)16, (short)this._usrCapacity);
            }
            if (this.hasNumCylinders()) {
                len += XbufUtil.primitiveFieldSerializedLength((int)17, (byte)this._usrNumCylinders);
            }
            if (this.hasMaxRpm()) {
                len += XbufUtil.primitiveFieldSerializedLength((int)18, (short)this._usrMaxRpm);
            }
            if (this.hasManufacturerCode()) {
                len += XbufUtil.varlenFieldSerializedLength((int)19, (int)this._usrManufacturerCode.length());
            }
            if (this.hasFuel()) {
                len += XbufUtil.varlenFieldSerializedLength((int)20, (int)this._usrFuel.length());
            }
            return len;
        }

        public final int serialize(Serializer serializer) {
            if (!serializer.isInitialized()) {
                throw new IllegalArgumentException("serializer not initialized");
            }
            if (this.hasCapacity()) {
                serializer.capacity(this._usrCapacity);
            }
            if (this.hasNumCylinders()) {
                serializer.numCylinders(this._usrNumCylinders);
            }
            if (this.hasMaxRpm()) {
                serializer.maxRpm(this._usrMaxRpm);
            }
            if (this.hasManufacturerCode()) {
                serializer.manufacturerCode(this._usrManufacturerCode);
            }
            if (this.hasFuel()) {
                serializer.fuel(this._usrFuel);
            }
            return serializer.done();
        }

        public final void deserialize(Deserializer deserializer) {
            if (!deserializer.isInitialized()) {
                throw new IllegalArgumentException("deserializer not initialized");
            }
            this.clear();
            deserializer.run(this._deserializationCallback);
            this._initialized = true;
        }

        public final Pojo reset() {
            this.clear();
            this._dirty = false;
            this._initialized = false;
            return this;
        }

        public final Pojo init() {
            return this.reset();
        }

        public final Pojo setPool(UtlPool<Pojo> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Pojo> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memoryStats.onEntityPojoDisposed(Engine.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        private final class DeserializationCallback
        implements Deserializer.Callback {
            private DeserializationCallback() {
            }

            @Override
            public final void handleCapacity(short val) {
                Pojo.this.setCapacity(val);
            }

            @Override
            public final void handleNumCylinders(byte val) {
                Pojo.this.setNumCylinders(val);
            }

            @Override
            public final void handleMaxRpm(short val) {
                Pojo.this.setMaxRpm(val);
            }

            @Override
            public final void handleManufacturerCode(QuarkStringDeserializer val) {
                Pojo.this.setManufacturerCodeFrom(val);
            }

            @Override
            public final void handleFuel(QuarkStringDeserializer val) {
                Pojo.this.setFuelFrom(val);
            }
        }
    }

    public static final class Deserializer
    implements UtlPool.Item<Deserializer> {
        private final QuarkStringDeserializer _stringDeserializer = QuarkStringDeserializer.create();
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final MemoryStats _memoryStats = MemoryStats.getInstance();
        private final QuarkBuffer.VarintDeserializeLength _varintDeserializeLength = new QuarkBuffer.VarintDeserializeLength();
        private long _addr;
        private int _offset;
        private int _len;
        private UtlPool<Deserializer> _pool;
        private byte _flags;

        Deserializer() {
            this.setCreated();
        }

        public static final Deserializer create(boolean pvt) {
            Deserializer deserializer = (Deserializer)_entityDeserializerPool.get(null);
            if (pvt) {
                deserializer.setPrivate();
            } else {
                deserializer.clearPrivate();
                _memoryStats.onEntityDeserializerAllocated(Engine.class, MemoryStats.EntityType.EmbeddedEntity, !deserializer.isCreated());
            }
            return deserializer.clearPooled();
        }

        public static final Deserializer create() {
            return Deserializer.create(false);
        }

        private final Deserializer setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Deserializer clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Deserializer setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Deserializer clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Deserializer setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Deserializer clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        public final Deserializer init(long addr, int offset, int len) {
            this._addr = addr;
            this._offset = offset;
            this._len = len;
            return this;
        }

        public final Deserializer init(QuarkBuffer buffer, int offset, int len) {
            this._addr = buffer.getNativeAddress();
            this._offset = offset;
            this._len = len;
            return this;
        }

        public final boolean isInitialized() {
            return this._addr != 0L;
        }

        public final int getSerializedLength() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            return this._len;
        }

        public final void getTo(QuarkBuffer buffer, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (buffer.getCapacity() - offset < this._len) {
                throw new IllegalArgumentException("not enough space in supplied buffer");
            }
            buffer.putFrom(offset, this._addr, this._offset, this._len);
        }

        public final int getTo(long addr, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            QuarkBuffer.copy((long)this._addr, (int)this._offset, (long)addr, (int)offset, (int)this._len);
            return this._len;
        }

        public final void run(Callback cb) {
            int flen;
            int tlen;
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            long addr = this._addr;
            int lim = this._offset + this._len;
            block13: for (int pos = this._offset; pos < lim; pos += tlen + flen) {
                int ftag = QuarkBuffer.getVarint32((long)addr, (int)pos, (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                int ftype = ftag & 7;
                switch (ftag >>> 3) {
                    case 16: {
                        if (ftype != 0) {
                            throw new IllegalStateException("field type mismatch (exp=0x00, actual=" + ftype + ") for field 16");
                        }
                        tlen = this._varintDeserializeLength.value;
                        cb.handleCapacity((short)QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength));
                        flen = this._varintDeserializeLength.value;
                        continue block13;
                    }
                    case 17: {
                        if (ftype != 0) {
                            throw new IllegalStateException("field type mismatch (exp=0x00, actual=" + ftype + ") for field 17");
                        }
                        tlen = this._varintDeserializeLength.value;
                        cb.handleNumCylinders((byte)QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength));
                        flen = this._varintDeserializeLength.value;
                        continue block13;
                    }
                    case 18: {
                        if (ftype != 0) {
                            throw new IllegalStateException("field type mismatch (exp=0x00, actual=" + ftype + ") for field 18");
                        }
                        tlen = this._varintDeserializeLength.value;
                        cb.handleMaxRpm((short)QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength));
                        flen = this._varintDeserializeLength.value;
                        continue block13;
                    }
                    case 19: {
                        if (ftype != 2) {
                            throw new IllegalStateException("field type mismatch (exp=0x02, actual=" + ftype + ") for field 19");
                        }
                        tlen = this._varintDeserializeLength.value;
                        flen = QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                        cb.handleManufacturerCode(this._stringDeserializer.init(addr, pos + tlen + this._varintDeserializeLength.value, flen));
                        flen += this._varintDeserializeLength.value;
                        continue block13;
                    }
                    case 20: {
                        if (ftype != 2) {
                            throw new IllegalStateException("field type mismatch (exp=0x02, actual=" + ftype + ") for field 20");
                        }
                        tlen = this._varintDeserializeLength.value;
                        flen = QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                        cb.handleFuel(this._stringDeserializer.init(addr, pos + tlen + this._varintDeserializeLength.value, flen));
                        flen += this._varintDeserializeLength.value;
                        continue block13;
                    }
                    default: {
                        switch (ftype) {
                            case 0: {
                                tlen = this._varintDeserializeLength.value;
                                QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                                flen = this._varintDeserializeLength.value;
                                continue block13;
                            }
                            case 1: {
                                tlen = this._varintDeserializeLength.value;
                                flen = 8;
                                continue block13;
                            }
                            case 2: {
                                tlen = this._varintDeserializeLength.value;
                                flen = QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                                flen += this._varintDeserializeLength.value;
                                continue block13;
                            }
                            case 5: {
                                tlen = this._varintDeserializeLength.value;
                                flen = 4;
                                continue block13;
                            }
                        }
                        throw new IllegalStateException("corrupt field - #" + (QuarkBuffer.getVarint32((long)addr, (int)pos, (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength) >>> 3));
                    }
                }
            }
        }

        public final Deserializer init() {
            return this;
        }

        public final Deserializer setPool(UtlPool<Deserializer> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Deserializer> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memoryStats.onEntityDeserializerDisposed(Engine.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        public static interface Callback {
            public void handleCapacity(short var1);

            public void handleNumCylinders(byte var1);

            public void handleMaxRpm(short var1);

            public void handleManufacturerCode(QuarkStringDeserializer var1);

            public void handleFuel(QuarkStringDeserializer var1);
        }
    }

    public static final class Serializer
    implements UtlPool.Item<Serializer>,
    AdmRuntime.BufferSizer {
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final MemoryStats _memoryStats = MemoryStats.getInstance();
        private Engine _entity;
        private int _len;
        private long _addr;
        private AdmRuntime.BufferSizer _sizer;
        private UtlPool<Serializer> _pool;
        private byte _flags;

        Serializer() {
            this.setCreated();
        }

        public static final Serializer create(boolean pvt) {
            Serializer serializer = (Serializer)_entitySerializerPool.get(null);
            if (pvt) {
                serializer.setPrivate();
            } else {
                serializer.clearPrivate();
                _memoryStats.onEntitySerializerAllocated(Engine.class, MemoryStats.EntityType.EmbeddedEntity, !serializer.isCreated());
            }
            return serializer.clearPooled();
        }

        public static final Serializer create() {
            return Serializer.create(false);
        }

        private final Serializer setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Serializer clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Serializer setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Serializer clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Serializer setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Serializer clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        private final void ensureCapacity(int val) {
            if (this._sizer != null) {
                this._addr = this._sizer.ensureCapacity(this._addr, val);
            }
        }

        final Serializer init(Engine entity) {
            this.init(entity.getSerializedBuffer(), 0);
            this._entity = entity;
            return this;
        }

        public final Serializer init(long addr, int len) {
            this._entity = null;
            this._len = len;
            this._addr = addr;
            return this;
        }

        public final Serializer init(QuarkBuffer buffer, int len) {
            return this.init(buffer.getNativeAddress(), len);
        }

        public final Serializer init(QuarkBuffer buffer) {
            return this.init(buffer.getNativeAddress(), 0);
        }

        public final Serializer setSizer(AdmRuntime.BufferSizer sizer) {
            this._sizer = sizer;
            return this;
        }

        public final boolean hasSizer() {
            return this._sizer != null;
        }

        public final boolean isInitialized() {
            return this._addr != 0L;
        }

        public final int getSerializedLength() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            return this._len;
        }

        public final void getTo(QuarkBuffer buffer, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (buffer.getCapacity() - offset < this._len) {
                throw new IllegalArgumentException("not enough space in supplied buffer");
            }
            buffer.putFrom(offset, this._addr, 0, this._len);
        }

        public final int getTo(long addr, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            QuarkBuffer.copy((long)this._addr, (int)0, (long)addr, (int)offset, (int)this._len);
            return this._len;
        }

        public final void putFrom(QuarkBuffer buffer, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + len);
            }
            buffer.getTo(offset, this._addr, this._len, len);
            this._len += len;
        }

        public final void putFrom(long addr, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + len);
            }
            QuarkBuffer.copy((long)addr, (int)offset, (long)this._addr, (int)this._len, (int)len);
            this._len += len;
        }

        public final Serializer capacity(short val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.primitiveFieldSerializedLength((int)16, (short)val));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)128);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val);
            return this;
        }

        public final Serializer numCylinders(byte val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.primitiveFieldSerializedLength((int)17, (byte)val));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)136);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val);
            return this;
        }

        public final Serializer maxRpm(short val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.primitiveFieldSerializedLength((int)18, (short)val));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)144);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val);
            return this;
        }

        public final Serializer manufacturerCode(String val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)19, (int)QuarkBuffer.calculateUTF8Length((CharSequence)val)));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)154);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            this._len += QuarkBuffer.putUTF8CharSequence((long)this._addr, (int)this._len, (CharSequence)val);
            return this;
        }

        public final Serializer manufacturerCode(QuarkString val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null || val.isNull()) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)19, (int)val.length()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)154);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer manufacturerCode(XString val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null || val.isNull()) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)19, (int)val.serializedLength()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)154);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            val.getBackingBuffer().getToNative(val.getBackingBufferOffset(), this._addr, this._len, val.serializedLength());
            this._len += val.serializedLength();
            return this;
        }

        public final Serializer manufacturerCode(byte[] val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)19, (int)len));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)154);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)len);
            QuarkBuffer.putFrom((long)this._addr, (int)this._len, (byte[])val, (int)offset, (int)len);
            this._len += len;
            return this;
        }

        public final Serializer manufacturerCode(byte[] val) {
            return this.manufacturerCode(val, 0, val.length);
        }

        public final Serializer manufacturerCode(QuarkStringDeserializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)19, (int)val.serializedLength()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)154);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.serializedLength());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer manufacturerCode(QuarkBuffer val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)19, (int)len));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)154);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)len);
            val.getTo(offset, this._addr, this._len, len);
            this._len += len;
            return this;
        }

        public final Serializer fuel(String val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)20, (int)QuarkBuffer.calculateUTF8Length((CharSequence)val)));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)162);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            this._len += QuarkBuffer.putUTF8CharSequence((long)this._addr, (int)this._len, (CharSequence)val);
            return this;
        }

        public final Serializer fuel(QuarkString val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null || val.isNull()) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)20, (int)val.length()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)162);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer fuel(XString val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null || val.isNull()) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)20, (int)val.serializedLength()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)162);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            val.getBackingBuffer().getToNative(val.getBackingBufferOffset(), this._addr, this._len, val.serializedLength());
            this._len += val.serializedLength();
            return this;
        }

        public final Serializer fuel(byte[] val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)20, (int)len));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)162);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)len);
            QuarkBuffer.putFrom((long)this._addr, (int)this._len, (byte[])val, (int)offset, (int)len);
            this._len += len;
            return this;
        }

        public final Serializer fuel(byte[] val) {
            return this.fuel(val, 0, val.length);
        }

        public final Serializer fuel(QuarkStringDeserializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)20, (int)val.serializedLength()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)162);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.serializedLength());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer fuel(QuarkBuffer val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)20, (int)len));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)162);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)len);
            val.getTo(offset, this._addr, this._len, len);
            this._len += len;
            return this;
        }

        public final int done() {
            if (this._entity != null) {
                this._entity.setSerializedBufferLength(this._len);
            }
            return this._len;
        }

        public final Serializer init() {
            return this;
        }

        public final Serializer setPool(UtlPool<Serializer> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Serializer> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memoryStats.onEntitySerializerDisposed(Engine.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        public final long ensureCapacity(long addr, int capacity) {
            this._addr = this._sizer.ensureCapacity(addr, capacity);
            return this._addr;
        }
    }

    private static final class EngineDeserializerPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Deserializer> {
        private EngineDeserializerPoolEvictedItemReceiver() {
        }

        public final void process(Deserializer evictedItem) {
            _memoryStats.onEntityDeserializerLeaked(Engine.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class EngineDeserializerPoolFactory
    implements UtlPool.Factory<Deserializer> {
        private EngineDeserializerPoolFactory() {
        }

        public final Deserializer createItem(Object object) {
            return new Deserializer();
        }

        public final Deserializer[] createItemArray(int size) {
            return new Deserializer[size];
        }
    }

    private static final class EngineSerializerPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Serializer> {
        private EngineSerializerPoolEvictedItemReceiver() {
        }

        public final void process(Serializer evictedItem) {
            _memoryStats.onEntitySerializerLeaked(Engine.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class EngineSerializerPoolFactory
    implements UtlPool.Factory<Serializer> {
        private EngineSerializerPoolFactory() {
        }

        public final Serializer createItem(Object object) {
            return new Serializer();
        }

        public final Serializer[] createItemArray(int size) {
            return new Serializer[size];
        }
    }

    private static final class EnginePojoPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Pojo> {
        private EnginePojoPoolEvictedItemReceiver() {
        }

        public final void process(Pojo evictedItem) {
            _memoryStats.onEntityPojoLeaked(Engine.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class EnginePojoPoolFactory
    implements UtlPool.Factory<Pojo> {
        private EnginePojoPoolFactory() {
        }

        public final Pojo createItem(Object object) {
            return new Pojo();
        }

        public final Pojo[] createItemArray(int size) {
            return new Pojo[size];
        }
    }

    private static final class EnginePoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Engine> {
        private EnginePoolEvictedItemReceiver() {
        }

        public final void process(Engine evictedItem) {
            _memoryStats.onEntityLeaked(Engine.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class EnginePoolFactory
    implements UtlPool.Factory<Engine> {
        private EnginePoolFactory() {
        }

        public final Engine createItem(Object object) {
            return new Engine();
        }

        public final Engine[] createItemArray(int size) {
            return new Engine[size];
        }
    }

    static final class EnginePoolFactoryItemCreateArgument {
        UUID id;
        boolean wasCreated;

        EnginePoolFactoryItemCreateArgument() {
        }

        EnginePoolFactoryItemCreateArgument init(UUID id) {
            this.id = id;
            this.wasCreated = false;
            return this;
        }
    }

    public static final class PacketBody
    extends PktBodyData {
        private PacketBody(Properties props, boolean direct) {
            super(-32868, props, direct);
        }

        public static PktBody create(Properties props) {
            return new PacketBody(props, true);
        }

        public static PktBody create() {
            return PacketBody.create(null);
        }
    }
}

