/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.embedded;

import com.neeve.config.VMConfigurer;
import com.neeve.daemon.controller.IDmnControllerEventHandler;
import com.neeve.daemon.controller.IDmnControllerLauncher;
import com.neeve.server.Configurer;
import com.neeve.server.Main;
import com.neeve.server.app.SrvAppLoader;
import com.neeve.server.config.SrvConfigAppDescriptor;
import com.neeve.server.config.SrvConfigDescriptor;
import com.neeve.server.controller.SrvController;
import com.neeve.util.UtlEnv;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlTailoring;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class EmbeddedXVM {
    private final SrvConfigDescriptor descriptor;
    private final SrvController controller;
    private final Thread thread;
    private final CountDownLatch startupLatch = new CountDownLatch(1);
    private volatile boolean verifyAppsLoaded = true;
    private volatile Throwable startupError;
    private volatile State state = State.Init;
    private final IDmnControllerEventHandler serverEventHandler = new IDmnControllerEventHandler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEvent(int type, Object data) {
            switch (type) {
                case 1: {
                    EmbeddedXVM.this.onInitBegin();
                    break;
                }
                case 2: {
                    try {
                        EmbeddedXVM.this.onInitEnd((Throwable)data);
                    }
                    catch (Throwable thrown) {
                        EmbeddedXVM.this.startupError = (Throwable)data;
                        EmbeddedXVM.this.state = State.Failed;
                        return;
                    }
                    if (data == null) break;
                    EmbeddedXVM.this.startupError = (Throwable)data;
                    EmbeddedXVM.this.state = State.Failed;
                    return;
                }
                case 3: {
                    EmbeddedXVM.this.onStartBegin();
                    break;
                }
                case 4: {
                    try {
                        try {
                            EmbeddedXVM.this.onStartEnd((Throwable)data);
                        }
                        catch (Throwable thrown) {
                            EmbeddedXVM.this.startupError = (Throwable)data;
                            EmbeddedXVM.this.state = State.Failed;
                            EmbeddedXVM.this.startupLatch.countDown();
                            return;
                        }
                        if (data != null) {
                            EmbeddedXVM.this.startupError = (Throwable)data;
                            EmbeddedXVM.this.state = State.Failed;
                            return;
                        }
                        if (EmbeddedXVM.this.verifyAppsLoaded) {
                            for (SrvConfigAppDescriptor appDescriptor : EmbeddedXVM.this.descriptor.getApps()) {
                                String appName = appDescriptor.getName();
                                SrvAppLoader loader = EmbeddedXVM.this.controller.getAppManager().getAppLoader(appName);
                                if (loader != null) continue;
                                try {
                                    EmbeddedXVM.this.controller.getAppManager().loadApp(appName);
                                    loader = EmbeddedXVM.this.controller.getAppManager().getAppLoader(appName);
                                    if (loader != null) continue;
                                    EmbeddedXVM.this.startupError = new Exception("Application '" + appName + "' was not loaded.");
                                    EmbeddedXVM.this.state = State.Failed;
                                    return;
                                }
                                catch (Throwable thrown) {
                                    EmbeddedXVM.this.startupError = thrown;
                                    EmbeddedXVM.this.state = State.Failed;
                                    return;
                                }
                            }
                        }
                        EmbeddedXVM.this.state = State.Started;
                        break;
                    }
                    finally {
                        EmbeddedXVM.this.startupLatch.countDown();
                    }
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                default: {
                    System.out.println("Got unexpected server event for '" + EmbeddedXVM.this.descriptor.getName() + "' type=" + type);
                }
            }
        }
    };

    protected EmbeddedXVM(Configurer configurer, final SrvConfigDescriptor descriptor) {
        this.descriptor = descriptor;
        this.controller = SrvController.getInstance(descriptor);
        this.controller.setBootstrapConfigurer(configurer);
        this.controller.setLauncher(new IDmnControllerLauncher(){

            @Override
            public void executeVMRestart() throws Exception {
                throw new UnsupportedOperationException("VMRestart not currently supported for embedded servers");
            }

            @Override
            public void executeVMKill() throws Exception {
                throw new UnsupportedOperationException("VMKill not currently supported for embedded servers");
            }
        });
        this.controller.setEventHandler(this.serverEventHandler);
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    EmbeddedXVM.this.controller.start();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    EmbeddedXVM.this.startupError = new Exception("Error starting server '" + descriptor.getName() + "' cause: " + e.getMessage(), e);
                    EmbeddedXVM.this.state = State.Failed;
                    EmbeddedXVM.this.startupLatch.countDown();
                }
            }
        }, "X-EmbeddedXVM-" + descriptor.getName() + "-Main");
    }

    protected void onInitBegin() {
    }

    protected void onInitEnd(Throwable error) throws Exception {
    }

    protected void onStartBegin() {
    }

    protected void onStartEnd(Throwable error) throws Exception {
    }

    public static EmbeddedXVM create(Properties ddlProperties, final String xvmName) throws Exception {
        if (ddlProperties == null) {
            throw new IllegalArgumentException("DDL properties must be specified");
        }
        final Properties copy = new Properties();
        copy.putAll((Map<?, ?>)ddlProperties);
        if (!copy.containsKey("nv.ddl.targetxvm")) {
            copy.put("nv.ddl.targetxvm", xvmName);
        }
        return EmbeddedXVM.create(new Configurer(){

            @Override
            public String[] configure(String[] args) throws Exception {
                VMConfigurer.configure(copy);
                return new String[]{"--name", xvmName, "--skipOverlayConfig"};
            }
        }, new String[0]);
    }

    public static EmbeddedXVM create(final URL ddlConfig, final String xvmName, final Properties configProperties) throws Exception {
        if (ddlConfig == null) {
            throw new IllegalArgumentException("DDL config URL must be specified");
        }
        return EmbeddedXVM.create(new Configurer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] configure(String[] args) throws Exception {
                final UtlTailoring.PropertySource defaultResolver = UtlTailoring.ENV_SUBSTITUTION_RESOLVER;
                try (InputStream is = ddlConfig.openStream();){
                    if (!UtlProps.getValue((Properties)configProperties, (String)"nv.server.embedded.suppressenvreset", (boolean)false)) {
                        UtlEnv.reset();
                    }
                    VMConfigurer.configure(is, new UtlTailoring.PropertySource(){

                        public String getValue(String key, String defaultValue) {
                            if ("nv.ddl.targetxvm".equals(key)) {
                                return xvmName;
                            }
                            return configProperties.getProperty(key, defaultResolver.getValue(key, defaultValue));
                        }
                    }, configProperties);
                }
                return new String[]{"--name", xvmName, "--skipOverlayConfig"};
            }
        }, new String[0]);
    }

    public static EmbeddedXVM create(String ... args) throws Exception {
        Configurer configurer = Main.loadBootstrapConfigurer();
        SrvConfigDescriptor descriptor = Main.seedServerConfig(configurer, args);
        return new EmbeddedXVM(configurer, descriptor);
    }

    public static EmbeddedXVM create(SrvConfigDescriptor configDescriptor) throws Exception {
        return new EmbeddedXVM(null, configDescriptor);
    }

    public static EmbeddedXVM create(Configurer configurer, String ... args) throws Exception {
        SrvConfigDescriptor descriptor = Main.seedServerConfig(configurer, args);
        return new EmbeddedXVM(configurer, descriptor);
    }

    public EmbeddedXVM verifyAppsLoaded(boolean val) {
        if (this.state != State.Init) {
            throw new IllegalStateException("this method can only be invoked in the Init state");
        }
        this.verifyAppsLoaded = val;
        return this;
    }

    public boolean start(long timeout) throws TimeoutException, Throwable {
        if (this.state != State.Init) {
            throw new IllegalStateException("XVM was already started (currently in " + (Object)((Object)this.state) + ")");
        }
        this.state = State.Starting;
        this.thread.start();
        return this.waitForStart(timeout);
    }

    public void start() throws Throwable {
        this.start(-1L);
    }

    public Throwable getStartupError() {
        return this.startupError;
    }

    public synchronized void shutdown() {
        this.shutdown(true);
    }

    public synchronized void shutdown(boolean sync) {
        if (this.state == State.Shutdown) {
            return;
        }
        if (this.controller != null) {
            this.controller.stop(sync);
        }
        this.state = State.Shutdown;
    }

    public State getState() {
        return this.state;
    }

    public boolean waitForStart(long timeout) throws Throwable {
        if (this.state == State.Init) {
            throw new IllegalStateException("XVM '" + this.descriptor.getName() + "' has not been started");
        }
        if (timeout > 0L) {
            this.startupLatch.await(timeout, TimeUnit.SECONDS);
        } else if (timeout < 0L) {
            this.startupLatch.await();
        }
        if (this.startupError != null) {
            throw new Exception("XVM startup failed for server '" + this.descriptor.getName() + "': " + this.startupError.getMessage(), this.startupError);
        }
        if (this.state == State.Started) {
            return true;
        }
        if (this.state == State.Starting) {
            return false;
        }
        throw new Exception("XVM '" + this.descriptor.getName() + "' state is " + (Object)((Object)this.state));
    }

    public SrvController getServerController() {
        return this.controller;
    }

    public Object getApplication(String appName) {
        SrvAppLoader loader = this.controller.getAppManager().getAppLoader(appName);
        if (loader != null) {
            return loader.getAppMain();
        }
        return null;
    }

    public static enum State {
        Init,
        Starting,
        Started,
        Failed,
        Shutdown;

    }
}

