/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ddl.test.unit;

import com.neeve.ddl.DdlConfigNode;
import com.neeve.ddl.DdlConfigTree;
import com.neeve.ddl.DdlXMLParser;
import com.neeve.ddl.jaxb.Model;
import com.neeve.test.UnitTest;
import com.neeve.util.UtlEnv;
import com.neeve.util.UtlTailoring;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;

public class DdlPropertyParserTest
extends UnitTest {
    @Test
    public void testConfigTreeValueRetrieval() throws Exception {
        DdlConfigTree tree = new DdlConfigTree(UtlTailoring.ENV_SUBSTITUTION_RESOLVER);
        tree.add("a.b", "c");
        Assert.assertEquals((String)"unexpected value", (Object)"c", (Object)tree.getValue("a.b"));
        Assert.assertEquals((String)"unexpected value", (Object)"c", (Object)tree.get("a").getValue("b"));
        Assert.assertEquals((String)"unexpected value", (Object)"c", (Object)tree.get("a").get("b").getValue());
    }

    @Test
    public void testConfigTreeEnvSubstitution() throws Exception {
        UtlEnv.getEnvProps().put("substitutionValue", "substituted");
        DdlConfigTree tree = new DdlConfigTree(UtlTailoring.ENV_SUBSTITUTION_RESOLVER);
        tree.add("a.b", "${substitutionValue}");
        Assert.assertEquals((String)"Value was not substituted", (Object)"substituted", (Object)tree.getValue("a.b"));
        Assert.assertEquals((String)"Value was not substituted", (Object)"substituted", (Object)tree.get("a").getValue("b"));
        Assert.assertEquals((String)"Value was not substituted", (Object)"substituted", (Object)tree.get("a").get("b").getValue());
    }

    @Test
    public void testConfigTreeSubstitution() throws Exception {
        DdlConfigTree tree = new DdlConfigTree(UtlTailoring.ENV_SUBSTITUTION_RESOLVER);
        tree.add("a.b", "${c}");
        tree.add("c", "substituted");
        Assert.assertEquals((String)"Value was not substituted", (Object)"substituted", (Object)tree.getValue("a.b"));
        Assert.assertEquals((String)"Value was not substituted", (Object)"substituted", (Object)tree.get("a").getValue("b"));
        Assert.assertEquals((String)"Value was not substituted", (Object)"substituted", (Object)tree.get("a").get("b").getValue());
    }

    @Test
    public void testConfigTreeChainedEnvSubstitution() throws Exception {
        UtlEnv.getEnvProps().put("substitutionValue", "substituted");
        DdlConfigTree tree = new DdlConfigTree(UtlTailoring.ENV_SUBSTITUTION_RESOLVER);
        tree.add("a.b", "${c}");
        tree.add("c", "${d}");
        tree.add("d", "${substitutionValue}");
        Assert.assertEquals((String)"Value was not substituted", (Object)"substituted", (Object)tree.getValue("a.b"));
        Assert.assertEquals((String)"Value was not substituted", (Object)"substituted", (Object)tree.get("a").getValue("b"));
        Assert.assertEquals((String)"Value was not substituted", (Object)"substituted", (Object)tree.get("a").get("b").getValue());
    }

    @Test
    public void testConfigTreeChainedSubstitution() throws Exception {
        DdlConfigTree tree = new DdlConfigTree(UtlTailoring.ENV_SUBSTITUTION_RESOLVER);
        tree.add("a.b", "${c}");
        tree.add("c", "${d}");
        tree.add("d", "substituted");
        Assert.assertEquals((String)"Value was not substituted", (Object)"substituted", (Object)tree.getValue("a.b"));
        Assert.assertEquals((String)"Value was not substituted", (Object)"substituted", (Object)tree.get("a").getValue("b"));
        Assert.assertEquals((String)"Value was not substituted", (Object)"substituted", (Object)tree.get("a").get("b").getValue());
    }

    @Test
    public void testOverrideSubstitionPrecedence() throws Exception {
        UtlEnv.getEnvProps().put("substitutionValue", "substituted");
        DdlConfigTree tree = new DdlConfigTree(UtlTailoring.ENV_SUBSTITUTION_RESOLVER);
        tree.add("a.b", "${substitutionValue}");
        tree.add("substitutionValue", "unsubstituted");
        Assert.assertEquals((String)"Value was not substituted", (Object)"substituted", (Object)tree.getValue("a.b"));
        Assert.assertEquals((String)"Value was not substituted", (Object)"substituted", (Object)tree.get("a").getValue("b"));
        Assert.assertEquals((String)"Value was not substituted", (Object)"substituted", (Object)tree.get("a").get("b").getValue());
    }

    @Test
    public void testEnvVariableSubstitution() throws Exception {
        UtlEnv.getEnvProps().put("substitutionValue", "${c}");
        DdlConfigTree tree = new DdlConfigTree(UtlTailoring.ENV_SUBSTITUTION_RESOLVER);
        tree.add("a.b", "${substitutionValue}");
        tree.add("c", "substituted");
        Assert.assertEquals((String)"Value was not substituted", (Object)"substituted", (Object)tree.getValue("a.b"));
        Assert.assertEquals((String)"Value was not substituted", (Object)"substituted", (Object)tree.get("a").getValue("b"));
        Assert.assertEquals((String)"Value was not substituted", (Object)"substituted", (Object)tree.get("a").get("b").getValue());
    }

    @Test
    public void testEnvSubstitionCycle() throws Exception {
        block8: {
            DdlConfigTree tree;
            block7: {
                block6: {
                    UtlEnv.getEnvProps().put("substitutionValue", "${substitutionValue1}");
                    UtlEnv.getEnvProps().put("substitutionValue1", "${substitutionValue2}");
                    UtlEnv.getEnvProps().put("substitutionValue2", "${substitutionValue1}");
                    tree = new DdlConfigTree(UtlTailoring.ENV_SUBSTITUTION_RESOLVER);
                    tree.add("a.b", "${substitutionValue}");
                    try {
                        tree.getValue("a.b");
                        Assert.fail((String)("Expected a substitution cycle error but got tree.getValue(\"a.b\")=" + tree.getValue("a.b")));
                    }
                    catch (Exception e) {
                        Assert.assertTrue((String)("Wrong exception expected 'cycle detected' but was" + e.getMessage()), (e.getMessage().indexOf("cycle detected") != -1 ? 1 : 0) != 0);
                        if (!DdlPropertyParserTest.verbose()) break block6;
                        System.out.println("Got Expected Exception: " + e.getMessage());
                    }
                }
                try {
                    tree.get("a").getValue("b");
                    Assert.fail((String)("Expected a substitution cycle error but got tree.getChildNode(\"a\").getValue(\"b\")=" + tree.getValue("a.b")));
                }
                catch (Exception e) {
                    Assert.assertTrue((String)("Wrong exception expected 'cycle detected' but was" + e.getMessage()), (e.getMessage().indexOf("cycle detected") != -1 ? 1 : 0) != 0);
                    if (!DdlPropertyParserTest.verbose()) break block7;
                    System.out.println("Got Expected Exception: " + e.getMessage());
                }
            }
            try {
                tree.get("a").get("b").getValue();
                Assert.fail((String)("Expected a substitution cycle error but got tree.getChildNode(\"a\").getChildNode(\"b\").getValue()=" + tree.getValue("a.b")));
            }
            catch (Exception e) {
                Assert.assertTrue((String)("Wrong exception expected 'cycle detected' but was" + e.getMessage()), (e.getMessage().indexOf("cycle detected") != -1 ? 1 : 0) != 0);
                if (!DdlPropertyParserTest.verbose()) break block8;
                System.out.println("Got Expected Exception: " + e.getMessage());
            }
        }
    }

    @Test
    public void testTreeSubstitionCycle() throws Exception {
        block8: {
            DdlConfigTree tree;
            block7: {
                block6: {
                    tree = new DdlConfigTree(UtlTailoring.ENV_SUBSTITUTION_RESOLVER);
                    tree.add("a.b", "${c.d::default}");
                    tree.add("c.d", "${e.f}");
                    tree.add("e.f", "${a.b}");
                    try {
                        tree.getValue("a.b");
                        Assert.fail((String)("Expected a substitution cycle error but got tree.getValue(\"a.b\")=" + tree.getValue("a.b")));
                    }
                    catch (Exception e) {
                        Assert.assertTrue((String)("Wrong exception expected 'cycle detected' but was" + e.getMessage()), (e.getMessage().indexOf("cycle detected") != -1 ? 1 : 0) != 0);
                        if (!DdlPropertyParserTest.verbose()) break block6;
                        System.out.println("Got Expected Exception: " + e.getMessage());
                    }
                }
                try {
                    tree.get("a").getValue("b");
                    Assert.fail((String)("Expected a substitution cycle error but got tree.getChildNode(\"a\").getValue(\"b\")=" + tree.getValue("a.b")));
                }
                catch (Exception e) {
                    Assert.assertTrue((String)("Wrong exception expected 'cycle detected' but was" + e.getMessage()), (e.getMessage().indexOf("cycle detected") != -1 ? 1 : 0) != 0);
                    if (!DdlPropertyParserTest.verbose()) break block7;
                    System.out.println("Got Expected Exception: " + e.getMessage());
                }
            }
            try {
                tree.get("a").get("b").getValue();
                Assert.fail((String)("Expected a substitution cycle error but got tree.getChildNode(\"a\").getChildNode(\"b\").getValue()=" + tree.getValue("a.b")));
            }
            catch (Exception e) {
                Assert.assertTrue((String)("Wrong exception expected 'cycle detected' but was" + e.getMessage()), (e.getMessage().indexOf("cycle detected") != -1 ? 1 : 0) != 0);
                if (!DdlPropertyParserTest.verbose()) break block8;
                System.out.println("Got Expected Exception: " + e.getMessage());
            }
        }
    }

    @Test
    public void testTreePruneAndRegraft() throws Exception {
        DdlConfigTree tree = new DdlConfigTree(UtlTailoring.ENV_SUBSTITUTION_RESOLVER);
        DdlConfigNode nodeA = tree.add("a", "NodeA");
        DdlConfigNode nodeB = tree.add("a.b", "NodeB");
        DdlConfigNode nodeC = tree.add("a.b.c", "NodeC");
        Assert.assertEquals((String)"Removed node should be node b", (Object)nodeB, (Object)nodeA.remove("b"));
        Assert.assertEquals((String)"Node B should be detached from graph", null, (Object)nodeB.getRoot());
        Assert.assertEquals((String)"Node B should no longer have a parent", null, (Object)nodeB.getParent());
        Assert.assertEquals((String)"Tree should no longer contain nodeB", null, (Object)tree.getValue("a.b"));
        Assert.assertEquals((String)"Node C should be detached from graph", null, (Object)nodeC.getRoot());
        Assert.assertEquals((String)"Node C should should still have B as its parent", (Object)nodeB, (Object)nodeC.getParent());
        Assert.assertEquals((String)"Tree should no longer contain nodeC", null, (Object)tree.getValue("a.b.c"));
        Assert.assertEquals((String)"Readded node should replace another node", null, (Object)nodeA.addNode("b", nodeB));
        Assert.assertEquals((String)"Readded node should be node b", (Object)nodeB, (Object)nodeA.get("b"));
        Assert.assertEquals((String)"Node B should not be detached from graph", (Object)tree, (Object)nodeB.getRoot());
        Assert.assertEquals((String)"Node B should no longer have a parent", (Object)nodeA, (Object)nodeB.getParent());
        Assert.assertEquals((String)"Tree should contain nodeB", (Object)"NodeB", (Object)tree.getValue("a.b"));
        Assert.assertEquals((String)"Node C should not be detached from graph", (Object)tree, (Object)nodeC.getRoot());
        Assert.assertEquals((String)"Node C should should still have B as its parent", (Object)nodeB, (Object)nodeC.getParent());
        Assert.assertEquals((String)"Tree should contain nodeC", (Object)"NodeC", (Object)tree.getValue("a.b.c"));
        Assert.assertEquals((String)"Removed node should be node b", (Object)nodeB, (Object)nodeA.remove("b"));
        Assert.assertEquals((String)"Node B should be detached from graph", null, (Object)nodeB.getRoot());
        Assert.assertEquals((String)"Node B should no longer have a parent", null, (Object)nodeB.getParent());
        Assert.assertEquals((String)"Tree should no longer contain nodeB", null, (Object)tree.getValue("a.b"));
        Assert.assertEquals((String)"Node C should be detached from graph", null, (Object)nodeC.getRoot());
        Assert.assertEquals((String)"Node C should should still have B as its parent", (Object)nodeB, (Object)nodeC.getParent());
        Assert.assertEquals((String)"Tree should no longer contain nodeC", null, (Object)tree.getValue("a.b.c"));
        Assert.assertEquals((String)"Readded node should replace another node", null, (Object)nodeA.addNode("b2", nodeB));
        Assert.assertEquals((String)"Readded node should be node b", (Object)nodeB, (Object)nodeA.get("b2"));
        Assert.assertEquals((String)"Node B should not be detached from graph", (Object)tree, (Object)nodeB.getRoot());
        Assert.assertEquals((String)"Node B should no longer have a parent", (Object)nodeA, (Object)nodeB.getParent());
        Assert.assertEquals((String)"Tree should contain nodeB", (Object)"NodeB", (Object)tree.getValue("a.b2"));
        Assert.assertEquals((String)"Node C should not be detached from graph", (Object)tree, (Object)nodeC.getRoot());
        Assert.assertEquals((String)"Node C should should still have B as its parent", (Object)nodeB, (Object)nodeC.getParent());
        Assert.assertEquals((String)"Tree should contain nodeC", (Object)"NodeC", (Object)tree.getValue("a.b2.c"));
    }

    @Test
    public void testDdlXmlPropertiesConversion() throws Exception {
        Model model = DdlXMLParser.parse(((Object)((Object)this)).getClass().getResourceAsStream("/com/neeve/config/test/unit/full-ddl-xml.xml"), UtlTailoring.ENV_SUBSTITUTION_RESOLVER);
        Properties props1 = DdlXMLParser.toDdlProperties(model);
        Model model2 = DdlXMLParser.fromDdlProperties(props1, UtlTailoring.ENV_SUBSTITUTION_RESOLVER);
        Properties props2 = DdlXMLParser.toDdlProperties(model2);
        Assert.assertTrue((String)"Conversion resulted in changed properties", (boolean)props1.equals(props2));
    }
}

