/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.client.link;

import cern.colt.list.ObjectArrayList;
import com.neeve.client.link.ClientLinkConfig;
import com.neeve.client.link.ClientLinkManagerEvent;
import com.neeve.client.link.EClientLinkAlreadyPresentException;
import com.neeve.client.link.EClientLinkDependeeLinkNotConfiguredException;
import com.neeve.client.link.EClientLinkDependeeOpenFailException;
import com.neeve.client.link.EClientLinkException;
import com.neeve.client.link.EClientLinkInvalidThreadingModelException;
import com.neeve.client.link.EClientLinkLinksOpenException;
import com.neeve.client.link.EClientLinkNotManagedException;
import com.neeve.client.link.EClientLinkNotPresentException;
import com.neeve.client.link.EClientLinkOpenInProgressException;
import com.neeve.client.link.EClientLinkRootLinkNotConfiguredException;
import com.neeve.client.link.IClientLinkManagerEventHandler;
import com.neeve.config.ConfigRepositoryFactory;
import com.neeve.config.IConfigSimpleEntity;
import com.neeve.emx.EEmxException;
import com.neeve.emx.EmxActionExecutor;
import com.neeve.emx.EmxFactory;
import com.neeve.emx.IEmxAction;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.link.ELnkAlreadyPresentException;
import com.neeve.link.ILnkClientEndpoint;
import com.neeve.link.ILnkContainerRunCompletionChecker;
import com.neeve.link.ILnkEndpoint;
import com.neeve.link.ILnkEventHandler;
import com.neeve.link.ILnkPeerEndpoint;
import com.neeve.link.ILnkRootEndpoint;
import com.neeve.link.LnkEvents;
import com.neeve.link.LnkFactory;
import com.neeve.link.LnkRegistry;
import com.neeve.link.LnkSTRRunnableContainer;
import com.neeve.link.LnkSynchronousConnector;
import com.neeve.root.RootConfig;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlThread;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class ClientLinkManager
extends LnkSTRRunnableContainer {
    private boolean flgDetached;
    private long detachedCPUAffinityMask;
    private ILnkRootEndpoint.ThreadingModel threadingModel;
    private String agentType;
    private Set<LinkTree> linkTrees;
    private final EmxActionExecutor<Object, Object> actionExecutor = new EmxActionExecutor();
    private OpenAction openAction = new OpenAction();
    private CloseAction closeAction = new CloseAction();
    private StopAction stopAction = new StopAction();
    private volatile IClientLinkManagerEventHandler eventHandler;
    private volatile OpenContext openContext;
    private static final String NAME_SEPARATOR = ".";
    public static final int OPENFLG_ASYNC = 1;

    protected ClientLinkManager(String name) throws ELnkAlreadyPresentException {
        super(ClientLinkConfig.getConfig(), name, null, 0);
    }

    public static ClientLinkManager create(String name, IClientLinkManagerEventHandler eventHandler, Set<String> descriptors, Properties props) throws EClientLinkAlreadyPresentException, EClientLinkInvalidThreadingModelException {
        try {
            ClientLinkManager manager = new ClientLinkManager(name);
            manager.setEventHandler(eventHandler);
            manager.init(null, descriptors, props == null ? new Properties() : props);
            return manager;
        }
        catch (ELnkAlreadyPresentException e) {
            throw new EClientLinkAlreadyPresentException();
        }
    }

    public static ClientLinkManager create(String name, IClientLinkManagerEventHandler eventHandler) throws EClientLinkNotPresentException, EClientLinkAlreadyPresentException, EClientLinkInvalidThreadingModelException, EClientLinkException {
        try {
            ClientLinkManager manager = new ClientLinkManager(name);
            manager.setEventHandler(eventHandler);
            manager.initFromRepository(null);
            return manager;
        }
        catch (ELnkAlreadyPresentException e) {
            throw new EClientLinkAlreadyPresentException();
        }
    }

    public static ClientLinkManager create(String name, Configuration config, IClientLinkManagerEventHandler eventHandler) throws EClientLinkAlreadyPresentException, EClientLinkInvalidThreadingModelException, EClientLinkException {
        try {
            ClientLinkManager manager = new ClientLinkManager(name);
            manager.setEventHandler(eventHandler);
            manager.init(null, config);
            return manager;
        }
        catch (ELnkAlreadyPresentException e) {
            throw new EClientLinkAlreadyPresentException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void init(IEmxDispatcher reader, Set<String> descriptors, Properties props) throws EClientLinkInvalidThreadingModelException {
        ILnkRootEndpoint.ThreadingModel threadingModel;
        if (this.tracer.debug) {
            this.tracer.log("Initializing link manager using descriptors and properties...", Tracer.Level.DEBUG);
        }
        this.flgDetached = UtlProps.getValue((Properties)props, (String)"Detached", (boolean)false);
        this.detachedCPUAffinityMask = UtlThread.parseAffinityMask((String)UtlProps.getValue((Properties)props, (String)"DetachedCPUAffinityMask", (String)"0"));
        try {
            threadingModel = ILnkRootEndpoint.ThreadingModel.valueOf((String)UtlProps.getValue((Properties)props, (String)"ThreadingModel", (String)"strw"));
        }
        catch (IllegalArgumentException e) {
            threadingModel = ILnkRootEndpoint.ThreadingModel.strw;
        }
        this.threadingModel = threadingModel;
        this.agentType = UtlProps.getValue((Properties)props, (String)"AgentType", (String)"client");
        if (this.tracer.debug) {
            this.tracer.log("Setting [detached=" + this.flgDetached + " threadingModel=" + threadingModel + " agentType=" + this.agentType + " threaded=" + this.threaded + "]", Tracer.Level.DEBUG);
        }
        if (this.tracer.debug) {
            this.tracer.log("Organizing descriptors into trees...", Tracer.Level.DEBUG);
        }
        this.linkTrees = new HashSet<LinkTree>();
        this.initLinkTrees(descriptors);
        if (reader == null) {
            if (this.tracer.debug) {
                this.tracer.log("Creating link manager reader dispatcher: X-Client-LinkManagerReader[" + this.getName() + "]...", Tracer.Level.DEBUG);
            }
            try {
                this.setReader(EmxFactory.getInstance().createDispatcher(EmxFactory.EmxImpl.DEFAULT, "X-Client-LinkManagerReader[" + this.getName() + "]", IEmxDispatcher.Params.create((boolean)false, (ILnkRootEndpoint.ThreadingModel.compareTo((ILnkRootEndpoint.ThreadingModel)ILnkRootEndpoint.ThreadingModel.strw, (ILnkRootEndpoint.ThreadingModel)this.threadingModel) != 0 ? 1 : 0) != 0)));
            }
            catch (EEmxException e) {
                throw new InternalError("Failed to create the dispatcher [" + e.toString() + "]");
            }
        } else {
            this.setReader(reader);
        }
        if (this.flgDetached) {
            if (this.tracer.debug) {
                this.tracer.log("Starting reader thread...", Tracer.Level.DEBUG);
            }
            ThreadStartCoordinator coordinator = new ThreadStartCoordinator();
            new Reader(coordinator).start();
            ThreadStartCoordinator threadStartCoordinator = coordinator;
            synchronized (threadStartCoordinator) {
                while (!coordinator.isStarted) {
                    try {
                        coordinator.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (this.tracer.debug) {
                this.tracer.log("Reader thread started.", Tracer.Level.DEBUG);
            }
        } else if (this.tracer.debug) {
            this.tracer.log("Started attached. Not starting reader thread.", Tracer.Level.DEBUG);
        }
    }

    protected final void init(IEmxDispatcher reader, Configuration config) throws EClientLinkInvalidThreadingModelException {
        this.init(reader, config.descriptors, config.props);
    }

    protected final void initFromRepository(IEmxDispatcher reader) throws EClientLinkNotPresentException, EClientLinkException {
        this.init(reader, Configuration.parse(this.getName()));
    }

    private final void dispatchEvent(ClientLinkManagerEvent event, ClientLinkManagerEvent.LinkOpCompleteEventData eventData) {
        if (this.tracer.debug) {
            this.tracer.log("Dispatching event [event=" + (Object)((Object)event) + " data=" + eventData + "]", Tracer.Level.DEBUG);
        }
        if (this.eventHandler != null) {
            this.eventHandler.onEvent(this, event, eventData);
        } else if (this.tracer.debug) {
            this.tracer.log("Not dispatching create event. Handler is null.", Tracer.Level.DEBUG);
        }
    }

    private final void dispatchLinkParseCompletionEvent(String descriptorStr, Exception e) {
        this.dispatchEvent(e == null ? ClientLinkManagerEvent.LINK_PARSE_SUCCESS : ClientLinkManagerEvent.LINK_PARSE_FAIL, new ClientLinkManagerEvent.LinkOpCompleteEventData(descriptorStr, e == null ? null : (e instanceof EClientLinkException ? (EClientLinkException)((Object)e) : new EClientLinkException(e))));
    }

    private final void dispatchLinkOpenCompletionEvent(String name, String descriptorStr, Exception e) {
        this.dispatchEvent(e == null ? ClientLinkManagerEvent.LINK_OPEN_SUCCESS : ClientLinkManagerEvent.LINK_OPEN_FAIL, new ClientLinkManagerEvent.LinkOpenCompleteEventData(name, descriptorStr, e == null ? null : (e instanceof EClientLinkException ? (EClientLinkException)((Object)e) : new EClientLinkException(e))));
    }

    private final void initLinkTrees(Set<String> descriptors) {
        if (descriptors.size() > 0) {
            ObjectArrayList bucket;
            int i;
            if (this.tracer.debug) {
                this.tracer.log("Partitioning descriptors into home trees (size= " + descriptors.size() + ").", Tracer.Level.DEBUG);
            }
            ObjectArrayList buckets = new ObjectArrayList();
            for (String descriptorStr : descriptors) {
                ObjectArrayList bucket2;
                int i2;
                if (this.tracer.debug) {
                    this.tracer.log("Descriptor '" + descriptorStr + "'...", Tracer.Level.DEBUG);
                }
                LinkTreeNode node = null;
                try {
                    node = new LinkTreeNode(descriptorStr);
                    if (this.tracer.debug) {
                        this.tracer.log("Descriptor parsed into node " + node, Tracer.Level.DEBUG);
                    }
                    this.dispatchLinkParseCompletionEvent(descriptorStr, null);
                }
                catch (IllegalArgumentException e) {
                    if (this.tracer.debug) {
                        this.tracer.log("Failure [" + e.toString() + "]", Tracer.Level.DEBUG);
                    }
                    this.dispatchLinkParseCompletionEvent(descriptorStr, e);
                }
                if (node == null) continue;
                for (i2 = 0; i2 < buckets.size(); ++i2) {
                    bucket2 = (ObjectArrayList)buckets.get(i2);
                    LinkTreeNode bucketFirstNode = (LinkTreeNode)bucket2.get(0);
                    if (this.tracer.debug) {
                        this.tracer.log("Checking if bucket's first node '" + bucketFirstNode + "' should be in same tree as node '" + node + "'...", Tracer.Level.DEBUG);
                    }
                    if (node.inSameTree(bucketFirstNode)) {
                        if (this.tracer.debug) {
                            this.tracer.log("Yes it should. Adding node " + node + " to bucket <first=" + bucketFirstNode + ">.", Tracer.Level.DEBUG);
                        }
                        bucket2.add((Object)node);
                        break;
                    }
                    if (!this.tracer.debug) continue;
                    this.tracer.log("No it shouldn't. Moving to next bucket.", Tracer.Level.DEBUG);
                }
                if (i2 != buckets.size()) continue;
                bucket2 = new ObjectArrayList();
                bucket2.add((Object)node);
                if (this.tracer.debug) {
                    this.tracer.log("No bucket found for node " + node + ". Creating new bucket <first=" + bucket2.get(0) + ">.", Tracer.Level.DEBUG);
                }
                buckets.add((Object)bucket2);
            }
            if (this.tracer.debug) {
                this.tracer.log("Sorting buckets by name depth...", Tracer.Level.DEBUG);
            }
            for (i = 0; i < buckets.size(); ++i) {
                if (this.tracer.debug) {
                    this.tracer.log("Sorting bucket #" + (i + 1) + "...", Tracer.Level.DEBUG);
                }
                bucket = (ObjectArrayList)buckets.get(i);
                bucket.sort();
                if (!this.tracer.debug) continue;
                this.tracer.log("First element after sort is " + bucket.get(0), Tracer.Level.DEBUG);
            }
            if (this.tracer.debug) {
                this.tracer.log("Creating link trees...", Tracer.Level.DEBUG);
            }
            for (i = 0; i < buckets.size(); ++i) {
                if (this.tracer.debug) {
                    this.tracer.log("Processing bucket #" + (i + 1) + "...", Tracer.Level.DEBUG);
                }
                bucket = (ObjectArrayList)buckets.get(i);
                LinkTreeNode root = (LinkTreeNode)bucket.get(0);
                if (root.depth == 1) {
                    if (this.tracer.debug) {
                        this.tracer.log("Creating tree for bucket [root=" + root + "].", Tracer.Level.DEBUG);
                    }
                    LinkTree tree = new LinkTree(root);
                    this.linkTrees.add(tree);
                    for (int j = 0; j < bucket.size(); ++j) {
                        LinkTreeNode node = (LinkTreeNode)bucket.get(j);
                        if (node == root) continue;
                        if (this.tracer.debug) {
                            this.tracer.log("Adding node " + node + " to tree " + tree + "...", Tracer.Level.DEBUG);
                        }
                        try {
                            tree.add(node);
                            continue;
                        }
                        catch (EClientLinkException e) {
                            if (this.tracer.debug) {
                                this.tracer.log("Failure [" + e.toString() + "]", Tracer.Level.DEBUG);
                            }
                            this.dispatchLinkParseCompletionEvent(node.descriptorStr, (Exception)((Object)e));
                        }
                    }
                    continue;
                }
                if (this.tracer.debug) {
                    this.tracer.log("No root node in bucket. Dispatching parse fail for all nodes in bucket.", Tracer.Level.DEBUG);
                }
                for (int j = 0; j < bucket.size(); ++j) {
                    LinkTreeNode node = (LinkTreeNode)bucket.get(j);
                    this.dispatchLinkParseCompletionEvent(node.descriptorStr, (Exception)((Object)new EClientLinkRootLinkNotConfiguredException()));
                }
            }
        } else if (this.tracer.debug) {
            this.tracer.log("Supplied descriptor list is empty.", Tracer.Level.DEBUG);
        }
    }

    private final LinkTree getTree(String name) {
        for (LinkTree tree : this.linkTrees) {
            if (tree.get(name) == null) continue;
            return tree;
        }
        return null;
    }

    private final Set<String> getDependents(LinkTreeNode node, boolean immediate) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (LinkTreeNode dependent : node.dependents) {
            set.add(dependent.name);
            if (immediate) continue;
            set.addAll(this.getDependents(dependent, immediate));
        }
        return set;
    }

    private final void openSingle(NodeOpenContext context, int timeout, int flags) {
        LinkTreeNode node = context.node;
        if (this.tracer.debug) {
            this.tracer.log("Opening '" + node + "'...", Tracer.Level.DEBUG);
        }
        if (this.getLink(node.name) == null) {
            boolean flgAsync = (flags & 1) == 1;
            try {
                try {
                    if (this.tracer.debug) {
                        this.tracer.log("Creating link client endpoint...", Tracer.Level.DEBUG);
                    }
                    node.descriptor.props.put("threadingmodel", this.getThreadingModel().toString());
                    node.descriptor.props.put("agenttype", this.agentType);
                    String dependee = this.getDependeeUnprotected(node.name);
                    if (dependee != null) {
                        node.descriptor.props.put("base", dependee);
                    }
                    context.onCreate(LnkFactory.getInstance().createClientEndpoint(this.touch(node.descriptor)));
                }
                catch (Exception e) {
                    if (this.tracer.debug) {
                        this.tracer.log("Failure [" + e.toString() + "]", Tracer.Level.DEBUG);
                    }
                    throw e;
                }
                try {
                    if (this.tracer.debug) {
                        this.tracer.log("Connecting link client endpoint (flgAsync=" + flgAsync + ")...", Tracer.Level.DEBUG);
                    }
                    if (flgAsync) {
                        context.cep.connectPost(this.getReader(), (ILnkEventHandler)context, timeout, 0);
                    } else {
                        LnkSynchronousConnector.create().run(context.cep, timeout <= 0 ? Integer.MAX_VALUE : timeout);
                        context.onCompletion(null, true);
                    }
                }
                catch (Exception e) {
                    if (this.tracer.debug) {
                        this.tracer.log("Failure [" + e.toString() + "]", Tracer.Level.DEBUG);
                    }
                    throw e;
                }
            }
            catch (Exception e) {
                context.onCompletion(e, true);
            }
        } else {
            if (this.tracer.debug) {
                this.tracer.log("Already opened (in link manager link container).", Tracer.Level.DEBUG);
            }
            context.onCompletion(null, false);
        }
    }

    private final void open() {
        Iterator<List<NodeOpenContext>> listsIterator = this.openContext.lists.iterator();
        boolean flgAsyncPending = false;
        while (!flgAsyncPending && listsIterator.hasNext()) {
            List<NodeOpenContext> list = listsIterator.next();
            Iterator<NodeOpenContext> listIterator = list.iterator();
            EClientLinkException status = null;
            while (!flgAsyncPending && listIterator.hasNext()) {
                NodeOpenContext nodeContext = listIterator.next();
                if (this.tracer.debug) {
                    this.tracer.log("Processing node " + nodeContext.node + "...", Tracer.Level.DEBUG);
                }
                if (nodeContext.isComplete()) {
                    if (this.tracer.debug) {
                        this.tracer.log("Node open is complete (async) [" + (nodeContext.getStatus() != null ? nodeContext.getStatus().toString() : null) + "]...", Tracer.Level.DEBUG);
                    }
                    listIterator.remove();
                    status = nodeContext.getStatus();
                    continue;
                }
                if (status == null) {
                    if (this.tracer.debug) {
                        this.tracer.log("Opening node (No dependee open failure)...", Tracer.Level.DEBUG);
                    }
                    this.openSingle(nodeContext, this.openContext.timeout, this.openContext.flags);
                    if (nodeContext.isComplete()) {
                        if (this.tracer.debug) {
                            this.tracer.log("Node open is complete [" + (nodeContext.getStatus() != null ? nodeContext.getStatus().toString() : null) + "]...", Tracer.Level.DEBUG);
                        }
                        listIterator.remove();
                        status = nodeContext.getStatus();
                        continue;
                    }
                    if (this.tracer.debug) {
                        this.tracer.log("Node open is pending async completion.", Tracer.Level.DEBUG);
                    }
                    flgAsyncPending = true;
                    continue;
                }
                if (this.tracer.debug) {
                    this.tracer.log("A dependee open had failed. Dispatching 'dependee open fail'...", Tracer.Level.DEBUG);
                }
                nodeContext.onCompletion((Exception)((Object)new EClientLinkDependeeOpenFailException((Throwable)((Object)status))), true);
            }
        }
        if (!flgAsyncPending) {
            if (this.tracer.debug) {
                this.tracer.log("Open process is done.", Tracer.Level.DEBUG);
            }
            this.dispatchEvent(ClientLinkManagerEvent.OPEN_END, null);
            this.openContext = null;
        } else if (this.tracer.debug) {
            this.tracer.log("Suspending open process until async open completes.", Tracer.Level.DEBUG);
        }
    }

    private final void preopenSingle(String name, List<NodeOpenContext> list) throws EClientLinkNotManagedException {
        LinkTree linkTree = this.getTree(name);
        if (linkTree != null) {
            if (this.tracer.debug) {
                this.tracer.log("Adding '" + name + "' to open context node list...", Tracer.Level.DEBUG);
            }
        } else {
            throw new EClientLinkNotManagedException();
        }
        list.add(new NodeOpenContext((LinkTreeNode)linkTree.get(name)));
    }

    private final void preopenTopDown(String name, List<NodeOpenContext> list) {
        if (this.tracer.debug) {
            this.tracer.log("Invoking pre-open top down from '" + name + "'", Tracer.Level.DEBUG);
        }
        try {
            String dependee = this.getDependeeUnprotected(name);
            if (dependee != null) {
                this.preopenTopDown(dependee, list);
                this.preopenSingle(name, list);
            } else {
                this.preopenSingle(name, list);
            }
        }
        catch (EClientLinkNotManagedException e) {
            throw new InternalError("Received 'not managed' exception during top down open for link verified to be part of a managed tree!");
        }
    }

    private final void preopenBottomUp(String name, List<NodeOpenContext> list) {
        try {
            Set<String> dependents = this.getDependents(name, true);
            if (dependents.size() > 0) {
                if (this.tracer.debug) {
                    this.tracer.log("Num immediate dependents=" + dependents.size(), Tracer.Level.DEBUG);
                }
                for (String dependent : dependents) {
                    if (this.tracer.debug) {
                        this.tracer.log("Invoking pre-open bottom up from dependent='" + dependent + "'", Tracer.Level.DEBUG);
                    }
                    this.preopenBottomUp(dependent, list);
                }
            } else {
                this.preopenTopDown(name, list);
            }
        }
        catch (EClientLinkNotManagedException e) {
            throw new InternalError("Received 'not managed' exception during bottom up pre-open for link verified to be part of a managed tree!");
        }
    }

    private final String getDependeeUnprotected(String name) throws EClientLinkNotManagedException {
        LinkTree tree = this.getTree(name);
        if (tree != null) {
            LinkTreeNode dependee = ((LinkTreeNode)tree.get(name)).dependee;
            return dependee == null ? null : dependee.name;
        }
        throw new EClientLinkNotManagedException();
    }

    public final boolean isDetached() {
        return this.flgDetached;
    }

    public final ILnkRootEndpoint.ThreadingModel getThreadingModel() {
        return this.threadingModel;
    }

    public final IClientLinkManagerEventHandler setEventHandler(IClientLinkManagerEventHandler eventHandler) {
        IClientLinkManagerEventHandler currentEventHandler = this.eventHandler;
        this.eventHandler = eventHandler;
        return currentEventHandler;
    }

    public final IClientLinkManagerEventHandler getEventHandler() {
        return this.eventHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void open(String name, int timeout, int flags) throws EClientLinkNotManagedException, EClientLinkOpenInProgressException {
        Set<LinkTree> set = this.linkTrees;
        synchronized (set) {
            if (this.openContext == null) {
                this.openContext = new OpenContext(name, timeout, flags);
                if (name == null) {
                    Set<String> roots = this.getRoots();
                    for (String root : roots) {
                        LinkedList<NodeOpenContext> list = new LinkedList<NodeOpenContext>();
                        this.openContext.lists.add(list);
                        if (this.tracer.debug) {
                            this.tracer.log("Invoking bottom up pre-open from root='" + root + "'", Tracer.Level.DEBUG);
                        }
                        this.preopenBottomUp(root, list);
                    }
                } else if (this.isManaged(name)) {
                    LinkedList<NodeOpenContext> list = new LinkedList<NodeOpenContext>();
                    this.openContext.lists.add(list);
                    this.preopenTopDown(name, list);
                } else {
                    this.openContext = null;
                    throw new EClientLinkNotManagedException();
                }
                if (this.tracer.debug) {
                    this.tracer.log("Starting the open process...", Tracer.Level.DEBUG);
                }
                try {
                    this.actionExecutor.invoke(this.getReader(), (IEmxAction)this.openAction, null, 1);
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new InternalError("Unexpected exception [" + e.toString() + "]");
                }
            } else {
                throw new EClientLinkOpenInProgressException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<String> getRoots() {
        Set<LinkTree> set = this.linkTrees;
        synchronized (set) {
            Iterator<LinkTree> iterator = this.linkTrees.iterator();
            HashSet<String> set2 = new HashSet<String>();
            while (iterator.hasNext()) {
                set2.add(((LinkTree)iterator.next()).root.name);
            }
            return set2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isManaged(String name) {
        Set<LinkTree> set = this.linkTrees;
        synchronized (set) {
            return this.getTree(name) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isOpenInProgress() {
        Set<LinkTree> set = this.linkTrees;
        synchronized (set) {
            return this.openContext != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getDependee(String name) throws EClientLinkNotManagedException {
        Set<LinkTree> set = this.linkTrees;
        synchronized (set) {
            return this.getDependeeUnprotected(name);
        }
    }

    public final Set<String> getDependents(String name, boolean immediate) throws EClientLinkNotManagedException {
        Set<LinkTree> set = this.linkTrees;
        synchronized (set) {
            LinkTree tree = this.getTree(name);
            if (tree != null) {
                return this.getDependents((LinkTreeNode)tree.get(name), immediate);
            }
            throw new EClientLinkNotManagedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close(String name) throws EClientLinkNotManagedException, EClientLinkOpenInProgressException, EClientLinkException {
        if (this.openContext == null) {
            if (name == null) {
                HashSet<LinkTreeNode> linksToClose = new HashSet<LinkTreeNode>();
                Set<LinkTree> set = this.linkTrees;
                synchronized (set) {
                    for (LinkTree tree : this.linkTrees) {
                        for (LinkTreeNode node : tree.values()) {
                            linksToClose.add(node);
                        }
                    }
                }
                for (LinkTreeNode nodeToClose : linksToClose) {
                    this.closeLinkTreeNode(nodeToClose);
                }
            } else {
                LinkTreeNode node = null;
                Set<LinkTree> set = this.linkTrees;
                synchronized (set) {
                    LinkTree tree = this.getTree(name);
                    if (tree == null) {
                        throw new EClientLinkNotManagedException();
                    }
                    node = (LinkTreeNode)tree.get(name);
                }
                this.closeLinkTreeNode(node);
            }
        } else {
            throw new EClientLinkOpenInProgressException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void closeLinkTreeNode(LinkTreeNode node) throws EClientLinkException {
        block9: {
            if (this.tracer.debug) {
                this.tracer.log("Closing node " + node + "...", Tracer.Level.DEBUG);
            }
            try {
                Thread owner = this.getReader().getOwner();
                if (this.flgDetached && !((Reader)owner).isDone()) {
                    this.actionExecutor.invoke(this.getReader(), (IEmxAction)this.closeAction, (Object)node, owner == Thread.currentThread() ? 1 : 0);
                    break block9;
                }
                if (this.flgDetached) {
                    this.tracer.log(this.getName() + " Link reader has exited prior to link tree close - closing '" + node.name + "' on calling thread instead...", Tracer.Level.WARNING);
                }
                Set<LinkTree> set = this.linkTrees;
                synchronized (set) {
                    this.closeAction.execute(null, node);
                }
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new EClientLinkException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void shutdown() throws EClientLinkLinksOpenException, EClientLinkException {
        Reader reader = null;
        Set<LinkTree> set = this.linkTrees;
        synchronized (set) {
            if (this.openContext != null) throw new EClientLinkOpenInProgressException();
            if (this.flgDetached) {
                if (this.tracer.debug) {
                    this.tracer.log("Operating in detached mode. Checking to shut down reader thread...", Tracer.Level.DEBUG);
                }
                for (LinkTree tree : this.linkTrees) {
                    for (LinkTreeNode node : tree.values()) {
                        ILnkPeerEndpoint pep = this.getLink(node.name);
                        if (pep == null || pep.getState() == ILnkPeerEndpoint.State.CLOSING || pep.getState() == ILnkPeerEndpoint.State.CLOSED) continue;
                        if (!this.tracer.debug) throw new EClientLinkLinksOpenException();
                        this.tracer.log("Node '" + node.name + "' is still open. Not shutting down reader thread.", Tracer.Level.DEBUG);
                        throw new EClientLinkLinksOpenException();
                    }
                }
                if (this.tracer.debug) {
                    this.tracer.log("All nodes are closed. Shutting down reader thread...", Tracer.Level.DEBUG);
                }
                try {
                    reader = (Reader)this.getReader().getOwner();
                    if (!reader.isDone()) {
                        if (this.tracer.debug) {
                            this.tracer.log("stopping reader '" + this.getReader().getName() + "'", Tracer.Level.DEBUG);
                        }
                        this.actionExecutor.invoke(this.getReader(), (IEmxAction)this.stopAction, null, reader == Thread.currentThread() ? 1 : 0);
                    } else if (this.tracer.debug) {
                        this.tracer.log("reader '" + this.getReader().getName() + "' already done on shutdown", Tracer.Level.DEBUG);
                    }
                }
                catch (Exception e) {
                    this.tracer.log("Failure encountered while shutting down reader thread [" + e.toString() + "]...", Tracer.Level.WARNING);
                    throw new EClientLinkException(e);
                }
            }
        }
        if (reader == null) return;
        try {
            reader.waitForStop();
            return;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            EClientLinkException e = new EClientLinkException("Interrupted stopping '" + this.getReader().getName() + "'");
            e.initCause(ie);
            throw e;
        }
    }

    public static final class Configuration {
        public final Set<String> descriptors;
        public final Properties props;

        public Configuration(Set<String> descriptors, Properties props) {
            if (descriptors == null) {
                throw new IllegalArgumentException("descriptor set cannot be null");
            }
            this.descriptors = descriptors;
            this.props = props == null ? new Properties() : props;
        }

        public static Configuration parse(String name) throws EClientLinkNotPresentException, EClientLinkException {
            String entityAddress = "/clients/linkmanagers/" + name.trim();
            IConfigSimpleEntity entity = ConfigRepositoryFactory.getInstance().getLocalRepository().getSimpleEntity(entityAddress);
            if (entity != null) {
                Tracer tracer = RootConfig.ObjectConfig.createTracer((RootConfig.ObjectConfig)ClientLinkConfig.getConfig());
                if (tracer.debug) {
                    tracer.log("Loading link manager configuration from entity at '" + entityAddress + "'...", Tracer.Level.DEBUG);
                }
                Properties props = (Properties)entity.getProperties().clone();
                HashSet<String> descriptors = new HashSet<String>();
                if (tracer.debug) {
                    tracer.log("Loading descriptors....", Tracer.Level.DEBUG);
                }
                String descriptorList = UtlProps.getValue((Properties)props, (String)"Links", null);
                props.remove("Links");
                if (descriptorList != null) {
                    StringTokenizer tokenizer = new StringTokenizer(descriptorList, ",");
                    if (tokenizer.hasMoreTokens()) {
                        while (tokenizer.hasMoreTokens()) {
                            descriptors.add(tokenizer.nextToken());
                        }
                    } else if (tracer.debug) {
                        tracer.log("No descriptors configured.", Tracer.Level.DEBUG);
                    }
                }
                return new Configuration(descriptors, props);
            }
            throw new EClientLinkNotPresentException();
        }

        public final String toString() {
            return "[descriptors=<" + this.descriptors.toString() + "> props=<" + this.props.toString() + ">]";
        }
    }

    private final class StopAction
    implements IEmxAction<Object, Object> {
        private StopAction() {
        }

        public final Object execute(IEmxDispatcher dispatcher, Object object) throws Exception {
            ((Reader)ClientLinkManager.this.getReader().getOwner()).shutdown();
            return null;
        }
    }

    private final class CloseAction
    implements IEmxAction<Object, Object> {
        private CloseAction() {
        }

        public final Object execute(IEmxDispatcher dispatcher, Object object) throws Exception {
            ILnkPeerEndpoint pep;
            LinkTreeNode node = (LinkTreeNode)object;
            if (((ClientLinkManager)ClientLinkManager.this).tracer.debug) {
                ClientLinkManager.this.tracer.log("Closing node's link (node=" + node + ")...", Tracer.Level.DEBUG);
            }
            if ((pep = ClientLinkManager.this.getLink(node.name)) != null) {
                pep.close((short)-1);
            } else if (((ClientLinkManager)ClientLinkManager.this).tracer.debug) {
                ClientLinkManager.this.tracer.log("Node does not have a link. Nothing to be done.", Tracer.Level.DEBUG);
            }
            LnkRegistry.getInstance().removeContainer(ClientLinkManager.this.getName());
            return null;
        }
    }

    private final class OpenAction
    implements IEmxAction<Object, Object> {
        private OpenAction() {
        }

        public final Object execute(IEmxDispatcher dispatcher, Object object) throws Exception {
            ClientLinkManager.this.dispatchEvent(ClientLinkManagerEvent.OPEN_BEGIN, null);
            ClientLinkManager.this.open();
            return null;
        }
    }

    private final class OpenContext {
        final String name;
        final int timeout;
        final int flags;
        final List<List<NodeOpenContext>> lists;

        OpenContext(String name, int timeout, int flags) {
            this.name = name;
            this.timeout = timeout * 1000;
            this.flags = flags;
            this.lists = new LinkedList<List<NodeOpenContext>>();
        }
    }

    private final class NodeOpenContext
    implements ILnkEventHandler {
        private boolean complete;
        private EClientLinkException status;
        private ILnkClientEndpoint cep;
        final LinkTreeNode node;

        NodeOpenContext(LinkTreeNode node) {
            this.node = node;
            this.complete = false;
            this.status = null;
        }

        final void onCreate(ILnkClientEndpoint cep) {
            this.cep = cep;
        }

        final void onCompletion(Exception e, boolean flgDispatch) {
            this.complete = true;
            EClientLinkException eClientLinkException = e == null ? null : (this.status = e instanceof EClientLinkException ? (EClientLinkException)((Object)e) : new EClientLinkException(e));
            if (this.status != null && this.cep != null) {
                try {
                    if (((ClientLinkManager)ClientLinkManager.this).tracer.debug) {
                        ClientLinkManager.this.tracer.log("Closing link client endpoint.", Tracer.Level.DEBUG);
                    }
                    this.cep.close();
                }
                catch (Exception e1) {
                    ClientLinkManager.this.tracer.log("Failure in closing link client endpoint on connect fail [" + e1.toString() + "]", Tracer.Level.DIAGNOSE);
                }
            }
            if (flgDispatch) {
                ClientLinkManager.this.dispatchLinkOpenCompletionEvent(this.node.name, this.node.descriptorStr, (Exception)((Object)this.status));
            }
        }

        final boolean isComplete() {
            return this.complete;
        }

        final EClientLinkException getStatus() {
            return this.status;
        }

        public final void onEvent(IEmxDispatcher dispatcher, ILnkEndpoint ep, int type, Object data) {
            switch (type) {
                case 1: {
                    LnkEvents.ConnectAcceptCompleteEventData eventData = (LnkEvents.ConnectAcceptCompleteEventData)data;
                    this.onCompletion((Exception)eventData.e, true);
                    if (((ClientLinkManager)ClientLinkManager.this).tracer.debug) {
                        ClientLinkManager.this.tracer.log("Received async open completion [" + (this.getStatus() != null ? this.getStatus().toString() : "null") + "]. Continuing the open process...", Tracer.Level.DEBUG);
                    }
                    ClientLinkManager.this.open();
                    break;
                }
                default: {
                    throw new InternalError("Received invalid event [type=" + type + "]");
                }
            }
        }
    }

    private final class Reader
    extends Thread
    implements ILnkContainerRunCompletionChecker {
        private final ThreadStartCoordinator coordinator;
        private boolean stopped;

        Reader(ThreadStartCoordinator coordinator) {
            this.coordinator = coordinator;
            ClientLinkManager.this.getReader().setAttachment((Object)this);
            this.setName(ClientLinkManager.this.getReader().getName());
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void shutdown() {
            Reader reader = this;
            synchronized (reader) {
                this.stopped = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void waitForStop() throws InterruptedException {
            Reader reader = this;
            synchronized (reader) {
                while (!this.stopped) {
                    this.wait();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            try {
                if (ClientLinkManager.this.detachedCPUAffinityMask != 0L) {
                    UtlThread.setCPUAffinityMask((long)ClientLinkManager.this.detachedCPUAffinityMask);
                } else {
                    UtlThread.setDefaultCPUAffinityMask();
                }
                ClientLinkManager.this.getReader().setOwner(1);
                ThreadStartCoordinator threadStartCoordinator = this.coordinator;
                synchronized (threadStartCoordinator) {
                    this.coordinator.isStarted = true;
                    this.coordinator.notify();
                }
                ClientLinkManager.this.run(-1, this);
                ClientLinkManager.this.getReader().close(false);
            }
            catch (Throwable e) {
                ClientLinkManager.this.tracer.log("Unhandled fault during thread execution [" + e.toString() + "]", Tracer.Level.SEVERE);
                e.printStackTrace();
            }
        }

        public final boolean isDone() {
            return this.stopped;
        }

        public final Object getCompletion() throws Exception {
            return null;
        }
    }

    private final class ThreadStartCoordinator {
        boolean isStarted = false;

        private ThreadStartCoordinator() {
        }
    }

    private final class LinkTree
    extends HashMap<String, LinkTreeNode> {
        private final LinkTreeNode root;

        LinkTree(LinkTreeNode root) {
            if (root.depth > 1) {
                throw new InternalError("link tree created with root depth > 1 [root=" + root + "]");
            }
            this.root = root;
            this.put(this.root.name, this.root);
        }

        final void add(LinkTreeNode node) throws EClientLinkException {
            LinkTreeNode dependee;
            if (node.depth == 1) {
                throw new InternalError("request to add root node to a link tree!");
            }
            if (((String)node.parsedName.get(node.depth - 1)).compareTo(this.root.name) != 0) {
                throw new InternalError("Root mismatch between a node and the tree it is being added to [node=" + node + " tree=" + this + "]");
            }
            String dependeeName = node.name.substring(node.name.indexOf(ClientLinkManager.NAME_SEPARATOR) + 1);
            if (((ClientLinkManager)ClientLinkManager.this).tracer.debug) {
                ClientLinkManager.this.tracer.log("Immediate dependee on node being added [" + node + "] is '" + dependeeName + "'.", Tracer.Level.DEBUG);
            }
            if ((dependee = (LinkTreeNode)this.get(dependeeName)) != null) {
                if (((ClientLinkManager)ClientLinkManager.this).tracer.debug) {
                    ClientLinkManager.this.tracer.log("Adding " + node + " as dependent on " + dependee + ClientLinkManager.NAME_SEPARATOR, Tracer.Level.DEBUG);
                }
                dependee.dependents.add(node);
                if (((ClientLinkManager)ClientLinkManager.this).tracer.debug) {
                    ClientLinkManager.this.tracer.log("Adding " + dependee + " as dependee of " + node + ClientLinkManager.NAME_SEPARATOR, Tracer.Level.DEBUG);
                }
            } else {
                throw new EClientLinkDependeeLinkNotConfiguredException();
            }
            node.dependee = dependee;
            this.put(node.name, node);
        }

        @Override
        public final String toString() {
            return "[" + this.root + "]";
        }
    }

    private final class LinkTreeNode
    implements Comparable<LinkTreeNode> {
        final String name;
        final ObjectArrayList parsedName;
        final int depth;
        final String descriptorStr;
        final UtlAddressDescriptor descriptor;
        private final Set<LinkTreeNode> dependents;
        private LinkTreeNode dependee;

        LinkTreeNode(String descriptorStr) throws IllegalArgumentException {
            this.descriptorStr = descriptorStr.trim();
            this.descriptor = UtlAddressDescriptor.parse((String)this.descriptorStr, null);
            String name = UtlProps.getValue((Map)this.descriptor.props, (String)"name", null);
            if (name == null) {
                throw new IllegalArgumentException("name property must be present in link descriptor");
            }
            this.parsedName = new ObjectArrayList();
            StringTokenizer tokenizer = new StringTokenizer(name, ClientLinkManager.NAME_SEPARATOR);
            while (tokenizer.hasMoreTokens()) {
                String str = tokenizer.nextToken();
                this.parsedName.add((Object)str);
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.parsedName.size(); ++i) {
                sb.append((String)this.parsedName.get(i));
                if (i >= this.parsedName.size() - 1) continue;
                sb.append(ClientLinkManager.NAME_SEPARATOR);
            }
            this.name = sb.toString();
            this.depth = this.parsedName.size();
            this.dependents = new HashSet<LinkTreeNode>();
        }

        final boolean inSameTree(LinkTreeNode node) {
            return ((String)node.parsedName.get(node.depth - 1)).compareTo((String)this.parsedName.get(this.depth - 1)) == 0;
        }

        public final boolean equals(Object obj) {
            return ((LinkTreeNode)obj).name.compareToIgnoreCase(this.name) == 0;
        }

        @Override
        public final int compareTo(LinkTreeNode node) {
            if (((ClientLinkManager)ClientLinkManager.this).tracer.debug) {
                ClientLinkManager.this.tracer.log("Comparing '" + this + "' with '" + node + "'...", Tracer.Level.DEBUG);
            }
            if (this.depth > node.depth) {
                if (((ClientLinkManager)ClientLinkManager.this).tracer.debug) {
                    ClientLinkManager.this.tracer.log("Returning GREATER.", Tracer.Level.DEBUG);
                }
                return 1;
            }
            if (this.depth < node.depth) {
                if (((ClientLinkManager)ClientLinkManager.this).tracer.debug) {
                    ClientLinkManager.this.tracer.log("Returning LESS.", Tracer.Level.DEBUG);
                }
                return -1;
            }
            if (((ClientLinkManager)ClientLinkManager.this).tracer.debug) {
                ClientLinkManager.this.tracer.log("Returning EQUAL.", Tracer.Level.DEBUG);
            }
            return 0;
        }

        public final String toString() {
            return "[" + this.name + "]";
        }
    }
}

