/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.client;

import com.neeve.client.Client;
import com.neeve.client.ClientConnectionPool;
import com.neeve.client.EClientException;
import com.neeve.client.EClientOpFailedException;
import com.neeve.client.EClientOpTimeoutException;
import com.neeve.client.IClientConnectionPoolEventHandler;
import com.neeve.client.link.ClientLinkManager;
import com.neeve.client.link.ClientLinkManagerEvent;
import com.neeve.client.link.EClientLinkAlreadyPresentException;
import com.neeve.client.link.EClientLinkException;
import com.neeve.client.link.EClientLinkInvalidThreadingModelException;
import com.neeve.client.link.EClientLinkNotManagedException;
import com.neeve.client.link.EClientLinkOpenInProgressException;
import com.neeve.client.link.IClientLinkManagerEventHandler;
import com.neeve.discovery.DiscoveryCacheFactory;
import com.neeve.discovery.IDiscoveryCache;
import com.neeve.discovery.IDiscoveryEntity;
import com.neeve.emx.EmxActionExecutor;
import com.neeve.emx.IEmxAction;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.link.ELnkException;
import com.neeve.link.ELnkOpTimeoutException;
import com.neeve.link.ILnkClientEndpoint;
import com.neeve.link.ILnkEndpoint;
import com.neeve.link.ILnkEventHandler;
import com.neeve.link.ILnkMessage;
import com.neeve.link.ILnkPeerEndpoint;
import com.neeve.link.ILnkSTRRootEndpoint;
import com.neeve.link.LnkFactory;
import com.neeve.link.LnkRequest;
import com.neeve.link.LnkSender;
import com.neeve.link.LnkSynchronousConnector;
import com.neeve.pkt.PktPacket;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;
import com.neeve.util.UtlList;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlThrowable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.UUID;

public abstract class ClientConnection
extends ClientConnectionPool {
    static final int FLAG_SUPPRESS_AUTO_READ_START = 1;
    private final LinkManagerEventHandler linkManagerEventHandler;
    private final LinkEventHandler linkEventHandler;
    private final EmxActionExecutor<Object, Object> actionExecutor;
    private final ReconnectContext reconnectContext;
    private ReconnectAction reconnectAction;
    private IDiscoveryCache discoveryCache;
    private DiscoveredLinkContext discoveredLinkContext;
    private LnkSender sender;
    protected final Client<?> client;
    protected final String name;
    protected volatile String group;
    protected volatile boolean faultTolerant;
    protected volatile int connectHandshakeTimeout;
    protected volatile int reconnectTimeout;
    protected volatile short threadAffinity;
    protected ClientLinkManager linkManager;
    protected String linkName;
    protected int flags;
    protected volatile ILnkPeerEndpoint pep;

    protected ClientConnection(String name, Client<?> client, IClientConnectionPoolEventHandler eventHandler) {
        super(eventHandler);
        this.name = name;
        this.client = client;
        this.linkManagerEventHandler = new LinkManagerEventHandler();
        this.linkEventHandler = new LinkEventHandler();
        this.connectHandshakeTimeout = Integer.MAX_VALUE;
        this.actionExecutor = new EmxActionExecutor();
        this.reconnectAction = new ReconnectAction();
        this.reconnectContext = new ReconnectContext();
        this.reconnectTimeout = 15;
        this.threadAffinity = (short)-1;
        this.state = ClientConnectionPool.State.INIT;
    }

    private final void dispatchFailureEvent(Exception e) {
        if (!this.handleFailure(e)) {
            this.onFailure(e);
        }
    }

    private final void onEventPacket(IEmxDispatcher dispatcher, PktPacket packet) {
        if (!this.handlePacket(packet)) {
            this.dispatchEvent(1, packet);
        }
    }

    private final void onEventPacketList(IEmxDispatcher dispatcher, UtlList list) {
        this.handlePacketList(list);
        if (list.count() > 0) {
            this.dispatchEvent(2, list);
        }
    }

    private final void onEventMessage(IEmxDispatcher dispatcher, ILnkMessage message) {
        if (!this.handleMessage(message)) {
            this.dispatchEvent(3, message);
        }
    }

    private final void onEventMessageList(IEmxDispatcher dispatcher, UtlList list) {
        this.handleMessageList(list);
        if (list.count() > 0) {
            this.dispatchEvent(4, list);
        }
    }

    private final void onEventFlushCompletion(IEmxDispatcher dispatcher, ILnkPeerEndpoint.AsynchronousFlushContext flushContext) {
        if (!this.handleFlushCompletion(flushContext)) {
            this.dispatchEvent(6, flushContext);
        }
    }

    private final void onEventFailure(IEmxDispatcher dispatcher, Exception e) {
        if (this.tracer.debug) {
            this.tracer.log("Connection has failed [" + e.toString() + "].", Tracer.Level.DEBUG);
        }
        if (this.faultTolerant) {
            try {
                if (this.tracer.debug) {
                    this.tracer.log("Reconnecting...", Tracer.Level.DEBUG);
                }
                this.startReconnect("failure handler", e);
            }
            catch (Exception e1) {
                if (this.tracer.debug) {
                    this.tracer.log("Reconnect failed [" + e1.toString() + "].", Tracer.Level.DEBUG);
                }
                this.dispatchFailureEvent(e1);
            }
        } else {
            if (this.tracer.debug) {
                this.tracer.log("Connection is not fault tolerant. Not reconnecting.", Tracer.Level.DEBUG);
            }
            this.dispatchFailureEvent(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ILnkPeerEndpoint connect() throws EClientException {
        boolean flgSuppressReadStart;
        String serverLinkDescriptor;
        ILnkPeerEndpoint pep = null;
        if (this.linkManager == null) {
            throw new IllegalStateException("link manager has not been set");
        }
        if (this.linkName == null) {
            throw new IllegalStateException("link name has not been set");
        }
        if (this.tracer.debug) {
            this.tracer.log("Opening link manager " + (Object)((Object)this.linkManager) + "...", Tracer.Level.DEBUG);
        }
        IClientLinkManagerEventHandler origEventHandler = this.linkManager.getEventHandler();
        this.linkManager.setEventHandler(this.linkManagerEventHandler);
        this.linkManagerEventHandler.resetOpenResult();
        try {
            try {
                if (this.tracer.debug) {
                    this.tracer.log("Opening underlying link '" + this.linkName + "'...", Tracer.Level.DEBUG);
                }
                this.linkManager.open(this.linkName, -1, 0);
                Exception e = this.linkManagerEventHandler.getOpenResult();
                if (e != null) {
                    if (this.tracer.debug) {
                        this.tracer.log("Open failed [" + e.toString() + "]", Tracer.Level.DEBUG);
                    }
                    throw new EClientException(e);
                }
                if (this.tracer.debug) {
                    this.tracer.log("Open succeeded.", Tracer.Level.DEBUG);
                }
            }
            catch (EClientLinkNotManagedException e) {
                if (this.tracer.debug) {
                    this.tracer.log("Open failed [link name not found]", Tracer.Level.DEBUG);
                }
                throw new EClientException("link name not found");
            }
            catch (EClientLinkOpenInProgressException e) {
                throw new InternalError("Received 'open in progress' when async open was never submitted!");
            }
        }
        finally {
            this.linkManager.setEventHandler(origEventHandler);
        }
        try {
            this.onLinkOpen(this.linkManager.getLink(this.linkName));
        }
        catch (Exception e) {
            if (this.tracer.debug) {
                this.tracer.log("Link rejected [" + e.toString() + "].", Tracer.Level.DEBUG);
            }
            try {
                this.linkManager.close(this.linkName);
            }
            catch (Exception e1) {
                this.tracer.log("Failed to close underlying link after a link rejection ['" + e1.toString() + "']...", Tracer.Level.DIAGNOSE);
            }
            throw new EClientException(e);
        }
        if (this.tracer.debug) {
            this.tracer.log("Getting descriptor of server link (to layer on link).", Tracer.Level.DEBUG);
        }
        if ((serverLinkDescriptor = this.getServerLinkDescriptor(this.linkName)) != null) {
            if (this.tracer.debug) {
                this.tracer.log("Opening server link ['" + serverLinkDescriptor + "']...", Tracer.Level.DEBUG);
            }
            ILnkClientEndpoint cep = null;
            try {
                cep = LnkFactory.getInstance().createClientEndpoint(this.linkManager.touch(serverLinkDescriptor), null);
                pep = LnkSynchronousConnector.create().run(cep, this.connectHandshakeTimeout);
            }
            catch (Exception e) {
                if (this.tracer.debug) {
                    this.tracer.log("Open failed [" + e.toString() + "].", Tracer.Level.DEBUG);
                }
                try {
                    this.linkManager.close(this.linkName);
                }
                catch (Exception e1) {
                    this.tracer.log("Failed to close underlying link after a server link open failure ['" + e1.toString() + "']...", Tracer.Level.DIAGNOSE);
                }
                throw new EClientException(e);
            }
            finally {
                if (pep == null && cep != null) {
                    if (this.tracer.debug) {
                        this.tracer.log("Open failed. Closing client endpoint...", Tracer.Level.DEBUG);
                    }
                    try {
                        cep.close();
                    }
                    catch (Exception e) {
                        this.tracer.log("Failed to close server link client endpoint after a server link open failure ['" + e.toString() + "']...", Tracer.Level.DIAGNOSE);
                    }
                }
            }
        }
        if (this.tracer.debug) {
            this.tracer.log("Server link descriptor is 'null'. Using underlying link as server link...", Tracer.Level.DEBUG);
        }
        pep = this.linkManager.getLink(this.linkName);
        if (this.messageFactory != null) {
            try {
                ((ILnkSTRRootEndpoint)pep.getRootEndpoint()).registerMessageFactory(this.messageFactory);
            }
            catch (Exception e) {
                throw new InternalError("Received exception [" + e.toString() + " while registering a message factory with a freshly created link!");
            }
        }
        try {
            if (this.tracer.debug) {
                this.tracer.log("Joining server link...", Tracer.Level.DEBUG);
            }
            pep.join((short)-1, (ILnkEventHandler)this.linkEventHandler);
        }
        catch (ELnkException e) {
            throw new InternalError("Received exception [" + e.toString() + " while joining a freshly created link!");
        }
        try {
            if (this.tracer.debug) {
                this.tracer.log("Creating/opening the server link sender object...", Tracer.Level.DEBUG);
            }
            this.sender = LnkSender.create((ILnkPeerEndpoint)pep);
            this.sender.open();
        }
        catch (ELnkException e) {
            throw new InternalError("Received exception [" + e.toString() + " while creating/opening a link sender object!");
        }
        if (!this.reconnectContext.reconnecting) {
            try {
                this.onOpen();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        boolean bl = flgSuppressReadStart = (this.flags & 1) == 1;
        if (!flgSuppressReadStart) {
            try {
                if (this.tracer.debug) {
                    this.tracer.log("Starting read on server link...", Tracer.Level.DEBUG);
                }
                this.linkManager.startRead(pep);
            }
            catch (ELnkException e) {
                throw new InternalError("Received exception [" + e.toString() + " while starting read on underlying link manager!");
            }
        } else if (this.tracer.debug) {
            this.tracer.log("User has requested to suppress auto read start. Not starting read.", Tracer.Level.DEBUG);
        }
        return pep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void startReconnect(String source, Exception cause) throws EClientOpFailedException {
        if (this.tracer.debug) {
            this.tracer.log("Reconnect kicked off from '" + source + "'.", Tracer.Level.DEBUG);
        }
        if (this.discoveredLinkContext == null) {
            throw new EClientOpFailedException(new Exception("Cannot kick off connection reconnect [connection does not use link context discovery]. Reconnect was kicked off by connection exception [" + cause.toString() + "]"));
        }
        ReconnectContext reconnectContext = this.reconnectContext;
        synchronized (reconnectContext) {
            if (!this.reconnectContext.reconnecting) {
                if (this.tracer.debug) {
                    this.tracer.log("Scheduling reconnect in the context of the reader thread...", Tracer.Level.DEBUG);
                }
                this.reconnectContext.reconnecting = true;
                this.reconnectContext.reconnectingThread = this.linkManager.getReader().getOwner();
                try {
                    this.actionExecutor.invoke(this.linkManager.getReader(), (IEmxAction)this.reconnectAction, (Object)cause, 0);
                }
                catch (Exception e) {
                    this.reconnectContext.reconnecting = false;
                    throw new EClientOpFailedException(new Exception("Failed to kick off connection reconnect [" + e.toString() + "]. Reconnect was kicked off by connection exception [" + cause.toString() + "]"));
                }
            } else if (this.tracer.debug) {
                this.tracer.log("Reconnect already in progress.", Tracer.Level.DEBUG);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void waitUntilReconnectCompletes() throws EClientOpFailedException {
        ReconnectContext reconnectContext = this.reconnectContext;
        synchronized (reconnectContext) {
            if (Thread.currentThread() != this.reconnectContext.reconnectingThread) {
                while (this.reconnectContext.reconnecting) {
                    try {
                        this.reconnectContext.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.reconnectContext.result != null) {
                    throw this.reconnectContext.result;
                }
            }
        }
    }

    private final void completeFailedReconnect(EClientOpFailedException result) {
        this.reconnectContext.reset();
        this.reconnectContext.reconnecting = false;
        this.reconnectContext.result = result;
        this.reconnectContext.notifyAll();
    }

    private final void completeSuccessfulReconnect(ILnkPeerEndpoint pep) {
        this.pep = pep;
        this.reconnectContext.reset();
        this.reconnectContext.notifyAll();
    }

    private final void setLinkContextCore(ClientLinkManager linkManager, String linkName) {
        this.linkManager = linkManager;
        this.linkName = linkName;
    }

    private final void setLinkContextCore(String descriptor, Properties linkManagerProps) throws EClientException {
        ClientLinkManager linkManager;
        if (this.getFaultTolerant() && !UtlProps.getValue((Properties)linkManagerProps, (String)"Detached", (boolean)false)) {
            throw new IllegalStateException("fault tolerant connections must be operating in a link manager operating in detached mode");
        }
        String linkManagerName = UUID.randomUUID().toString();
        HashSet<String> descriptors = new HashSet<String>();
        String linkName = UUID.randomUUID().toString();
        descriptors.add(descriptor + "&name=" + linkName);
        ClientLinkManager.Configuration linkManagerConfig = new ClientLinkManager.Configuration(descriptors, linkManagerProps);
        try {
            if (this.tracer.debug) {
                this.tracer.log("Creating new link manager [name=" + linkManagerName + " config=" + linkManagerConfig + " link=" + linkName + "]...", Tracer.Level.DEBUG);
            }
            linkManager = ClientLinkManager.create(linkManagerName, linkManagerConfig, this.linkManagerEventHandler);
        }
        catch (EClientLinkAlreadyPresentException e) {
            throw new EClientException("link manager with this name already present");
        }
        catch (EClientLinkInvalidThreadingModelException e) {
            throw new EClientException((Throwable)((Object)e));
        }
        catch (EClientLinkException e) {
            throw new EClientException((Throwable)((Object)e));
        }
        this.setLinkContextCore(linkManager, linkName);
    }

    private final void discoverLinkContextCore(String entityType, String entityName, Properties descriptorProps, Properties linkManagerProps) throws EClientException {
        if (entityType == null) {
            throw new IllegalArgumentException("entity type cannot be null");
        }
        if (entityName == null) {
            throw new IllegalArgumentException("entity name cannot be null");
        }
        if (this.tracer.debug) {
            this.tracer.log("Discovering link context (entity type=" + entityType + ", entity name=" + entityName + ")...", Tracer.Level.DEBUG);
        }
        this.discoveryCache = DiscoveryCacheFactory.getInstance().getDefaultCache();
        IDiscoveryEntity entity = this.discoveryCache.get(entityType, entityName);
        if (entity != null) {
            UtlAddressDescriptor descriptor = ((UtlAddressDescriptor)entity.getAddressDescriptors().get(0)).copy();
            if (descriptorProps != null) {
                Enumeration<?> enumeration = descriptorProps.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String key = (String)enumeration.nextElement();
                    descriptor.props.put(key, descriptorProps.get(key));
                }
            }
            this.discoveredLinkContext = new DiscoveredLinkContext(entityType, entityName, linkManagerProps, descriptorProps, descriptor.toFullString());
            if (this.tracer.debug) {
                this.tracer.log("Found entity. Setting link context using descriptor '" + this.discoveredLinkContext.descriptorStr + "'...", Tracer.Level.DEBUG);
            }
        } else {
            throw new EClientException("Entity <type=" + entityType + ", name=" + entityName + "> could not be found");
        }
        this.setLinkContextCore(this.discoveredLinkContext.descriptorStr, linkManagerProps);
    }

    private final void closeCore() {
        try {
            if (this.state != ClientConnectionPool.State.INIT) {
                this.pep.close((short)-1);
            }
        }
        catch (Exception e) {
            this.tracer.log("Failure in closing server link [" + e.toString() + "]", Tracer.Level.DIAGNOSE);
        }
    }

    protected abstract void onLinkOpen(ILnkPeerEndpoint var1) throws Exception;

    protected abstract String getServerLinkDescriptor(String var1);

    protected boolean canSetFaultTolerant() {
        return true;
    }

    protected abstract void onOpen();

    protected void onReconnect() {
    }

    protected abstract boolean handlePacket(PktPacket var1);

    protected abstract void handlePacketList(UtlList var1);

    protected abstract boolean handleMessage(ILnkMessage var1);

    protected abstract void handleMessageList(UtlList var1);

    protected boolean handleFlushCompletion(ILnkPeerEndpoint.AsynchronousFlushContext flushContext) {
        return false;
    }

    protected abstract boolean handleFailure(Exception var1);

    protected abstract void onClose();

    public final String getName() {
        return this.name;
    }

    public final Client<?> getClient() {
        return this.client;
    }

    public final ClientConnection setGroup(String group) {
        if (this.state != ClientConnectionPool.State.INIT) {
            throw this.prepareIllegalStateException(ClientConnectionPool.State.INIT, this.state);
        }
        this.group = group;
        return this;
    }

    public final String getGroup() {
        return this.group;
    }

    public final ClientConnection setAutoReadStart(boolean val) {
        if (this.state == ClientConnectionPool.State.INIT) {
            this.flags = val ? (this.flags &= 0xFFFFFFFE) : (this.flags |= 1);
        } else {
            throw this.prepareIllegalStateException(ClientConnectionPool.State.INIT, this.state);
        }
        return this;
    }

    public final boolean getAutoReadStart() {
        return (this.flags & 1) == 0;
    }

    public final ClientConnection setThreadAffinity(short threadAffinity) {
        if (this.state != ClientConnectionPool.State.INIT) {
            throw this.prepareIllegalStateException(ClientConnectionPool.State.INIT, this.state);
        }
        this.threadAffinity = threadAffinity;
        return this;
    }

    public final short getThreadAffinity() {
        return this.threadAffinity;
    }

    public final ClientConnection setFaultTolerant(boolean val) {
        if (this.state == ClientConnectionPool.State.INIT) {
            if (val && !this.canSetFaultTolerant()) {
                throw new UnsupportedOperationException("this connection implementation does not support fault tolerant connections");
            }
        } else {
            throw this.prepareIllegalStateException(ClientConnectionPool.State.INIT, this.state);
        }
        this.faultTolerant = val;
        return this;
    }

    public final boolean getFaultTolerant() {
        return this.faultTolerant;
    }

    public final ClientConnection setConnectHandshakeTimeout(int timeout) {
        if (timeout < 1) {
            throw new IllegalArgumentException("the handshake timeout must be at least 1 second");
        }
        if (this.state != ClientConnectionPool.State.INIT) {
            throw this.prepareIllegalStateException(ClientConnectionPool.State.INIT, this.state);
        }
        this.connectHandshakeTimeout = timeout;
        return this;
    }

    public final int getConnectHandshakeTimeout() {
        return this.connectHandshakeTimeout;
    }

    public final ClientConnection setReconnectTimeout(int timeout) {
        if (timeout < 1) {
            throw new IllegalArgumentException("the reconnect timeout must be at least 1 second");
        }
        if (this.state != ClientConnectionPool.State.INIT) {
            throw this.prepareIllegalStateException(ClientConnectionPool.State.INIT, this.state);
        }
        this.reconnectTimeout = timeout;
        return this;
    }

    public final int getReconnectTimeout() {
        return this.reconnectTimeout;
    }

    public final ClientConnection setLinkContext(ClientLinkManager linkManager, String linkName) {
        if (linkManager == null) {
            throw new IllegalArgumentException("link manager cannot be null");
        }
        if (linkName == null) {
            throw new IllegalArgumentException("link name cannot be null");
        }
        if (this.getFaultTolerant()) {
            throw new UnsupportedOperationException("fault tolerant connections must use link context discovery");
        }
        if (this.state == ClientConnectionPool.State.INIT) {
            this.setLinkContextCore(linkManager, linkName);
            return this;
        }
        throw this.prepareIllegalStateException(ClientConnectionPool.State.INIT, this.state);
    }

    public final ClientConnection setLinkContext(String descriptor, Properties linkManagerProps) throws EClientException {
        if (descriptor == null) {
            throw new IllegalArgumentException("descriptor cannot be null");
        }
        if (this.getFaultTolerant()) {
            throw new UnsupportedOperationException("fault tolerant connections must use link context discovery");
        }
        if (this.state == ClientConnectionPool.State.INIT) {
            this.setLinkContextCore(descriptor, linkManagerProps);
            return this;
        }
        throw this.prepareIllegalStateException(ClientConnectionPool.State.INIT, this.state);
    }

    public final ClientConnection discoverLinkContext(String entityType, String entityName, Properties descriptorProps, Properties linkManagerProps) throws EClientException {
        if (this.state != ClientConnectionPool.State.INIT) {
            throw this.prepareIllegalStateException(ClientConnectionPool.State.INIT, this.state);
        }
        this.discoverLinkContextCore(entityType, entityName, descriptorProps, linkManagerProps);
        return this;
    }

    public final DiscoveredLinkContext getDiscoveredLinkContext() {
        return this.discoveredLinkContext;
    }

    public final ClientLinkManager getLinkManager() {
        return this.linkManager;
    }

    public final String getLinkName() {
        return this.linkName;
    }

    @Override
    protected final void doOpen() throws EClientException {
        this.pep = this.connect();
    }

    @Override
    protected final boolean doSendStreaming(PktPacket packet, ILnkPeerEndpoint.FlushContext flushContext, int flags) throws EClientOpFailedException {
        if (this.reconnectContext.reconnecting) {
            this.waitUntilReconnectCompletes();
        } else {
            try {
                return this.pep.enque((short)-1, packet, flushContext, flags);
            }
            catch (ELnkException e) {
                if (this.faultTolerant) {
                    this.startReconnect("send streaming", (Exception)((Object)e));
                }
                throw new EClientOpFailedException(e);
            }
        }
        return false;
    }

    @Override
    protected final LnkRequest doSendSync(PktPacket packet, int timeout) throws EClientOpTimeoutException, EClientOpFailedException {
        if (this.faultTolerant) {
            throw new IllegalStateException("synchronous sends are not supported in fault tolerant connections");
        }
        try {
            LnkRequest request = this.sender.createRequest(packet);
            this.sender.sendSync(request, timeout);
            return request;
        }
        catch (ELnkOpTimeoutException e) {
            throw new EClientOpTimeoutException();
        }
        catch (ELnkException e) {
            throw new EClientOpFailedException(e);
        }
    }

    @Override
    protected final void doFlush(ILnkPeerEndpoint.FlushContext flushContext) throws EClientOpFailedException {
        if (this.reconnectContext.reconnecting) {
            this.waitUntilReconnectCompletes();
        } else {
            try {
                this.pep.flush((short)-1, flushContext);
            }
            catch (ELnkException e) {
                if (this.faultTolerant) {
                    this.startReconnect("flush", (Exception)((Object)e));
                }
                throw new EClientOpFailedException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void doClose() {
        if (this.state != ClientConnectionPool.State.CLOSED) {
            ReconnectContext reconnectContext = this.reconnectContext;
            synchronized (reconnectContext) {
                try {
                    if (this.reconnectContext.reconnecting) {
                        if (this.tracer.debug) {
                            this.tracer.log("Reconnect in progress on close. Aborting reconnect...", Tracer.Level.DEBUG);
                        }
                        this.completeFailedReconnect(new EClientOpFailedException("connection closed by user"));
                    } else {
                        this.closeCore();
                    }
                }
                finally {
                    this.state = ClientConnectionPool.State.CLOSED;
                    try {
                        this.onClose();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public final class DiscoveredLinkContext {
        public final String entityType;
        public final String entityName;
        public final Properties descriptorProps;
        public final Properties linkManagerProps;
        public final String descriptorStr;

        DiscoveredLinkContext(String entityType, String entityName, Properties linkManagerProps, Properties descriptorProps, String descriptorStr) {
            this.entityType = entityType;
            this.entityName = entityName;
            this.linkManagerProps = linkManagerProps;
            this.descriptorProps = descriptorProps;
            this.descriptorStr = descriptorStr;
        }
    }

    private final class ReconnectContext {
        volatile boolean reconnecting;
        volatile Thread reconnectingThread;
        volatile EClientOpFailedException result;

        private ReconnectContext() {
        }

        final void reset() {
            this.reconnecting = false;
            this.reconnectingThread = null;
            this.result = null;
        }
    }

    private final class ReconnectAction
    implements IEmxAction<Object, Object> {
        private ReconnectAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object execute(IEmxDispatcher dispatcher, Object object) throws Exception {
            EClientOpFailedException cause = object instanceof EClientOpFailedException ? (EClientOpFailedException)((Object)object) : new EClientOpFailedException((Exception)object);
            int intervals = ClientConnection.this.reconnectTimeout * 10;
            Object pep = null;
            if (((ClientConnection)ClientConnection.this).tracer.debug) {
                ClientConnection.this.tracer.log("Beginning connection reconnect...", Tracer.Level.DEBUG);
            }
            ReconnectContext reconnectContext = ClientConnection.this.reconnectContext;
            synchronized (reconnectContext) {
                int i;
                if (((ClientConnection)ClientConnection.this).tracer.debug) {
                    ClientConnection.this.tracer.log("Closing underlying link...", Tracer.Level.DEBUG);
                }
                ClientConnection.this.closeCore();
                ClientConnection.this.linkManager.shutdown();
                for (i = 0; i < intervals && ClientConnection.this.getState() != ClientConnectionPool.State.CLOSED; ++i) {
                    try {
                        if (((ClientConnection)ClientConnection.this).tracer.debug) {
                            ClientConnection.this.tracer.log(ClientConnection.this.client.getName() + ": Sleeping (100ms)...", Tracer.Level.DEBUG);
                        }
                        ClientConnection.this.reconnectContext.wait(100L);
                        if (ClientConnection.this.getState() == ClientConnectionPool.State.CLOSED) {
                            if (!((ClientConnection)ClientConnection.this).tracer.debug) break;
                            ClientConnection.this.tracer.log(ClientConnection.this.client.getName() + ": Connection was closed during wait between reconnect tries. Aborting reconnect.", Tracer.Level.DEBUG);
                            break;
                        }
                        try {
                            block16: {
                                ClientConnection.this.discoverLinkContextCore(((ClientConnection)ClientConnection.this).discoveredLinkContext.entityType, ((ClientConnection)ClientConnection.this).discoveredLinkContext.entityName, ((ClientConnection)ClientConnection.this).discoveredLinkContext.descriptorProps, ((ClientConnection)ClientConnection.this).discoveredLinkContext.linkManagerProps);
                                ClientConnection.this.completeSuccessfulReconnect(ClientConnection.this.connect());
                                try {
                                    ClientConnection.this.onReconnect();
                                }
                                catch (Exception e) {
                                    ClientConnection.this.tracer.log("Error reconnecting: " + e.getMessage(), Tracer.Level.WARNING);
                                    if (!((ClientConnection)ClientConnection.this).tracer.debug) break block16;
                                    ClientConnection.this.tracer.log(UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.DEBUG);
                                }
                            }
                            if (!((ClientConnection)ClientConnection.this).tracer.debug) break;
                            ClientConnection.this.tracer.log(ClientConnection.this.client.getName() + ": Reconnect completed successfully.", Tracer.Level.DEBUG);
                            break;
                        }
                        catch (EClientException e) {
                            if (!((ClientConnection)ClientConnection.this).tracer.debug) continue;
                            ClientConnection.this.tracer.log(ClientConnection.this.client.getName() + ": Reconnect failed [" + e.toString() + "].", Tracer.Level.DEBUG);
                            continue;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (i == intervals && ClientConnection.this.getState() != ClientConnectionPool.State.CLOSED) {
                    if (((ClientConnection)ClientConnection.this).tracer.debug) {
                        ClientConnection.this.tracer.log(ClientConnection.this.client.getName() + ": Could not reconnect within reconnect timeout (" + ClientConnection.this.reconnectTimeout + " seconds). Connection deemed as failed (cause=[" + cause.toString() + "].", Tracer.Level.DEBUG);
                    }
                    ClientConnection.this.completeFailedReconnect(cause);
                    ClientConnection.this.dispatchFailureEvent((Exception)((Object)cause));
                }
            }
            return null;
        }
    }

    private final class LinkEventHandler
    implements ILnkEventHandler {
        private LinkEventHandler() {
        }

        public final void onEvent(IEmxDispatcher dispatcher, ILnkEndpoint ep, int type, Object data) {
            switch (type) {
                case 5: {
                    ClientConnection.this.onEventPacket(dispatcher, (PktPacket)data);
                    break;
                }
                case 6: {
                    ClientConnection.this.onEventPacketList(dispatcher, (UtlList)data);
                    break;
                }
                case 11: {
                    ClientConnection.this.onEventMessage(dispatcher, (ILnkMessage)data);
                    break;
                }
                case 12: {
                    ClientConnection.this.onEventMessageList(dispatcher, (UtlList)data);
                    break;
                }
                case 7: {
                    ClientConnection.this.onEventFlushCompletion(dispatcher, (ILnkPeerEndpoint.AsynchronousFlushContext)data);
                    break;
                }
                case 8: {
                    ClientConnection.this.onEventFailure(dispatcher, (Exception)data);
                    break;
                }
            }
        }
    }

    private final class LinkManagerEventHandler
    implements IClientLinkManagerEventHandler {
        private Exception openResult;

        private LinkManagerEventHandler() {
        }

        final void resetOpenResult() {
            this.openResult = null;
        }

        final Exception getOpenResult() {
            return this.openResult;
        }

        @Override
        public final void onEvent(ClientLinkManager linkManager, ClientLinkManagerEvent event, Object data) {
            switch (event) {
                case LINK_PARSE_FAIL: {
                    ClientLinkManagerEvent.LinkOpCompleteEventData eventData = (ClientLinkManagerEvent.LinkOpCompleteEventData)data;
                    ClientConnection.this.tracer.log("Invalid descriptor '" + eventData.descriptor + "' supplied to connection pool [Descriptor parse error='" + eventData.e.toString() + "']", Tracer.Level.DEBUG);
                    break;
                }
                case LINK_OPEN_SUCCESS: 
                case LINK_OPEN_FAIL: {
                    ClientLinkManagerEvent.LinkOpenCompleteEventData eventData = (ClientLinkManagerEvent.LinkOpenCompleteEventData)data;
                    this.openResult = eventData.status ? null : eventData.e;
                    break;
                }
            }
        }
    }
}

