/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.perf.persist;

import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStoreObject;
import com.neeve.ods.IStoreObjectFactory;
import com.neeve.ods.IStoreReader;
import com.neeve.ods.StoreCommitEntry;
import com.neeve.ods.StoreObjectFactoryRegistry;
import com.neeve.perf.common.LatencyWriter;
import com.neeve.perf.serialization.rumi.xbuf2.MessageFactory;
import com.neeve.rog.IRogMessage;
import com.neeve.rog.log.RogLog;
import com.neeve.rog.log.RogLogReader;
import com.neeve.util.UtlThread;
import jargs.gnu.CmdLineParser;
import java.text.DecimalFormat;
import java.util.Properties;

public final class StoreLogger {
    private final RogLog _logger;
    private final DecimalFormat _dfmt = new DecimalFormat("#,###");

    StoreLogger(Properties props) throws Exception {
        this._logger = RogLog.create((String)"perf", (Properties)props);
    }

    private final void registerFactories() throws Exception {
        StoreObjectFactoryRegistry.getInstance().registerObjectFactory((IStoreObjectFactory)new MessageFactory());
    }

    private final IRogMessage createMessage() {
        return (IRogMessage)new com.neeve.perf.serialization.MessageFactory("rumi.xbuf2").createCar(true);
    }

    private final void prepareCommitEntry(StoreCommitEntry commitEntry, IRogMessage message, boolean commitEnd) {
        commitEntry.init(IStoreBinding.Operation.Remove, message.getId(), message.getOfid(), message.getType(), 0L, 0L, 0L, (IStoreObject)message, message.serialize(), message.getContentEncodingType(), false, commitEnd);
    }

    private final void clearCommitEntry(StoreCommitEntry commitEntry) {
        commitEntry.serializedObject.dispose();
        commitEntry.fin();
    }

    private final void write(int count, int warmupTime, int rate, int numPerCommit, boolean syncOnCommit, long nanoTimeOverhead, boolean noLatencyWrites, boolean printIntervalStats) throws Exception {
        IRogMessage message = (IRogMessage)new com.neeve.perf.serialization.MessageFactory("rumi.xbuf2").createCar(true);
        StoreCommitEntry commitEntry = StoreCommitEntry.create();
        LatencyWriter prepTimes = new LatencyWriter("prep", noLatencyWrites ? null : "latencies.prep.bin", true, printIntervalStats, false);
        LatencyWriter writeTimes = new LatencyWriter("write", noLatencyWrites ? null : "latencies.write.bin", false, printIntervalStats, false);
        LatencyWriter totalTimes = new LatencyWriter("total", noLatencyWrites ? null : "latencies.total.bin", false, printIntervalStats, false);
        System.out.println("Writing...");
        int i = 1;
        long start = System.nanoTime();
        long nanosPerMsg = rate > 0 ? 1000000000L / (long)rate : 0L;
        long next = start + nanosPerMsg;
        boolean warmupCompleted = false;
        int postWarmupCount = 0;
        long postWarmupStart = 0L;
        prepTimes.start(rate, count);
        writeTimes.start(rate, count);
        totalTimes.start(rate, count);
        while (i < count) {
            long current = System.nanoTime();
            if (current >= next) {
                boolean commitStart = numPerCommit == 1 || (i + 1) % numPerCommit == 1;
                boolean commitEnd = numPerCommit == 1 || (i + 1) % numPerCommit == 0;
                long t0 = System.nanoTime();
                this.prepareCommitEntry(commitEntry, message, commitEnd);
                long t1 = System.nanoTime();
                int prepTime = (int)(t1 - t0 - nanoTimeOverhead);
                this._logger.writeCommitEntry(commitEntry, true, commitEnd && syncOnCommit);
                this.clearCommitEntry(commitEntry);
                int writeTime = (int)(System.nanoTime() - t1 - nanoTimeOverhead);
                prepTimes.write(prepTime);
                writeTimes.write(writeTime);
                totalTimes.write(prepTime + writeTime);
                next += nanosPerMsg;
                ++i;
                if (warmupCompleted) {
                    ++postWarmupCount;
                }
            }
            if (warmupCompleted || current - start <= (long)warmupTime * 1000000000L) continue;
            System.out.println("Warm up complete.");
            postWarmupStart = System.nanoTime();
            warmupCompleted = true;
        }
        long stop = System.nanoTime();
        prepTimes.stop();
        writeTimes.stop();
        totalTimes.stop();
        prepTimes.close(false);
        writeTimes.close(false);
        totalTimes.close(false);
        prepTimes.finish();
        int overallRate = (int)((long)postWarmupCount * 1000000000L / (stop - postWarmupStart));
        System.out.println("Wrote " + this._dfmt.format(postWarmupCount) + " messages @ " + this._dfmt.format(overallRate) + " msgs/sec post warmup.");
        System.out.println("Write complete (run rumi-reporter on latencies.*.bin to calculate latency stats)");
    }

    private final void readUsingLogReader(int count, int warmupTime, boolean lazyDeserialize) throws Exception {
        System.out.println("Reading using log reader...");
        long ts = System.nanoTime();
        RogLogReader reader = this._logger.createReader();
        reader.setLazyDeserialization(lazyDeserialize);
        System.out.println("Created reader in " + (System.nanoTime() - ts) / 1000L + " us");
        ts = System.nanoTime();
        RogLog.Stats stats = reader.computeStats();
        System.out.println(stats.getHeaderRow());
        System.out.println(stats.toString());
        System.out.println("Computed stats in " + this._dfmt.format((System.nanoTime() - ts) / 1000L) + " us");
        reader.rewind();
        int i = 0;
        long start = System.nanoTime();
        boolean warmupCompleted = false;
        int postWarmupCount = 0;
        long postWarmupStart = 0L;
        for (int j = 0; j < count; ++j) {
            RogLog.Entry entry = reader.next();
            if (entry == null) continue;
            entry.dispose();
            ++i;
            if (warmupCompleted) {
                ++postWarmupCount;
            }
            long current = System.nanoTime();
            if (warmupCompleted || current - start <= (long)warmupTime * 1000000000L) continue;
            System.out.println("Warm up complete.");
            postWarmupStart = current;
            warmupCompleted = true;
        }
        long current = System.nanoTime();
        int overallRate = (int)((long)postWarmupCount * 1000000000L / (current - postWarmupStart));
        System.out.println("Read " + this._dfmt.format(postWarmupCount) + " messages @ " + this._dfmt.format(overallRate) + " msgs/sec post warmup.");
    }

    private final void readUsingStoreReader(int count, int warmupTime) throws Exception {
        System.out.println("Reading using store reader...");
        long ts = System.nanoTime();
        IStoreReader.IterativeReader reader = this._logger.iterativeReader(0);
        System.out.println("Created reader in " + (System.nanoTime() - ts) / 1000L + " us");
        int i = 0;
        long start = System.nanoTime();
        boolean warmupCompleted = false;
        int postWarmupCount = 0;
        long postWarmupStart = 0L;
        for (int j = 0; j < count; ++j) {
            StoreCommitEntry entry = reader.next();
            if (entry == null) continue;
            this.clearCommitEntry(entry);
            ++i;
            if (warmupCompleted) {
                ++postWarmupCount;
            }
            long current = System.nanoTime();
            if (warmupCompleted || current - start <= (long)warmupTime * 1000000000L) continue;
            System.out.println("Warm up complete.");
            postWarmupStart = current;
            warmupCompleted = true;
        }
        long current = System.nanoTime();
        int overallRate = (int)((long)postWarmupCount * 1000000000L / (current - postWarmupStart));
        System.out.println("Read " + this._dfmt.format(postWarmupCount) + " @ " + this._dfmt.format(overallRate) + " msgs/sec post warmup.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void run(int count, int warmupTime, int rate, boolean lazyDeserialize, int numPerCommit, boolean syncOnCommit, boolean noLatencyWrites, boolean printIntervalStats) throws Exception {
        try {
            long nanoTimeOverhead = 0L;
            long start = System.nanoTime();
            System.out.println("Calculating nanoTime() overhead...");
            for (int i = 0; i < 100000000; ++i) {
                System.nanoTime();
            }
            nanoTimeOverhead = (System.nanoTime() - start) / 100000000L;
            System.out.println("Registering factories...");
            this.registerFactories();
            System.out.println("Opening logger...");
            this._logger.open();
            this.write(count, warmupTime, rate, numPerCommit, syncOnCommit, nanoTimeOverhead, noLatencyWrites, printIntervalStats);
            System.out.println("");
            this._logger.flush(syncOnCommit);
            this.readUsingLogReader(count, warmupTime, lazyDeserialize);
            System.out.println("");
            this.readUsingStoreReader(count, warmupTime);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            System.out.println("Closing logger...");
            this._logger.close();
        }
    }

    private static void printUsage() {
        System.err.println("Usage StoreLogger");
        System.err.println("--------------------------------------------------------------------------------------------------------------------");
        System.err.println(" [{-o, --logMode} the transaction log open mode]");
        System.err.println("   Specifies the mode to open the transaction log in, Valid values are 'rw', 'rws' and 'rwd' (default='rw')");
        System.err.println(" [{-i, --initialLogLength} the preallocated length of the transaction log]");
        System.err.println("   Specifies the preallocated length (in gigabytes) of the transaction log (default=1)");
        System.err.println(" [{-z, --zeroOutInitial} zeroes out the preallocated length. only applies if --initialLength is specified and > 0]");
        System.err.println("   Specifies whether to zero out the preallocated length of the transaction log (default=false)");
        System.err.println("--------------------------------------------------------------------------------------------------------------------");
        System.err.println(" [{-n, --numPerCommit} number of writes per commit]");
        System.err.println("   Number of writes per commit (default=1)");
        System.err.println(" [{-m, --flushUsingMappedMemory} whether to flush using a memory mapped region of the log");
        System.err.println("   Specifies whether to use a memory mapped region of the log to perform flush operations (default=false)");
        System.err.println(" [{-f, --flushOnCommit} whether to flush the transaction log on every commit]");
        System.err.println("   Specifies whether the in memory cached entries of the log are forcibly flushed on every commit (default=false)");
        System.err.println("   <Note: A flush does not imply sync>");
        System.err.println(" [{-y, --syncOnCommit} force sync on every commit]");
        System.err.println("   Forcibly sync to disk on each commit (default=false)");
        System.err.println("--------------------------------------------------------------------------------------------------------------------");
        System.err.println(" [{-d, --detached} detached]");
        System.err.println("   Switches on detached writes (concurrent write in a separate thread) on or off (default=false)");
        System.err.println(" [{-q, --queueDepth} queue depth for detached writes]");
        System.err.println("   Specifies the queue depth for detached writes (default=1024)");
        System.err.println("   <This option only applies to detached writes>");
        System.err.println(" [{-l, --publisherClaimStrategy} disruptor publisher claim strategy for detached writes]");
        System.err.println("   Specifies the disruptor publisher claim strategy. Valid values are SingleThreaded | MultiThreaded | MultiThreadedSufficientCores (default=MultiThreadedSufficientCores)");
        System.err.println("   <This option only applies to detached writes>");
        System.err.println(" [{-w, --writerWaitStrategy} disruptor writer wait strategy for detached writes]");
        System.err.println("   Specifies the disruptor writer claim strategy. Valid values are Sleeping | Yielding | Blocking | BusySpin (default=Yielding)");
        System.err.println("   <This option only applies to detached writes>");
        System.err.println(" [{-x, --writerAffinity} disruptor writer thread affinity for detached writes]");
        System.err.println("   Specifies the disruptor writer thread affinity. (default=[0])");
        System.err.println("   <This option only applies to detached writes>");
        System.err.println("--------------------------------------------------------------------------------------------------------------------");
        System.err.println(" [{-p, --pageSize} specifies the disk subsystem page size]");
        System.err.println("   Specifies (in bytes) the page size to use when reading/writing from/to disk (default=8192)");
        System.err.println(" [{-k, --lazyDeserialize} do not invoke getObject() on read]");
        System.err.println("   A value of false will cause Entry.getObject() to be invoked on read. A value of true will not (default=false)");
        System.err.println("--------------------------------------------------------------------------------------------------------------------");
        System.err.println(" [{-c, --count} number of messages to persist]");
        System.err.println("   Number of messages to persist (default=10,000,000)");
        System.err.println(" [{-t, --warmupTime} Warmup time]");
        System.err.println("   Warmup time, in seconds, for calculation of throughput stats (default=2 (2 seconds))");
        System.err.println(" [{-r, --rate} write rate]");
        System.err.println("   Rate at which to persist messages (default=-1 (unlimited))");
        System.err.println("--------------------------------------------------------------------------------------------------------------------");
        System.err.println(" [{-a, --noLatencyWrites} don't write latencies to a file");
        System.err.println("   Indicates that latencies should not be written to a file (default=false)");
        System.err.println(" [{-b, --printIntervalStats} print interval latency stats");
        System.err.println("   Indicates that latencies stats should be printed on a periodic basis in addition to at the end (default=false)");
        System.err.println("--------------------------------------------------------------------------------------------------------------------");
        System.err.println(" [{-j, --affinity} CPU affinity of the write/read thread");
        System.err.println("   Sets the CPU affinity of the thread performing the read/write (default=false)");
        System.err.println("--------------------------------------------------------------------------------------------------------------------");
        System.err.println(" [{-h, --help} print this help string]");
    }

    public static final void main(String[] args) throws Exception {
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option logModeOption = parser.addStringOption('o', "logMode");
        CmdLineParser.Option initialLogLengthOption = parser.addIntegerOption('i', "initialLogLength");
        CmdLineParser.Option zeroOutInitialOption = parser.addBooleanOption('z', "zeroOutInitial");
        CmdLineParser.Option numPerCommitOption = parser.addIntegerOption('n', "numPerCommit");
        CmdLineParser.Option flushUsingMappedMemoryOption = parser.addBooleanOption('m', "flushUsingMappedMemory");
        CmdLineParser.Option flushOnCommitOption = parser.addBooleanOption('f', "flushOnCommit");
        CmdLineParser.Option syncOnCommitOption = parser.addBooleanOption('y', "syncOnCommit");
        CmdLineParser.Option detachedOption = parser.addBooleanOption('d', "detached");
        CmdLineParser.Option queueDepthOption = parser.addIntegerOption('q', "queueDepth");
        CmdLineParser.Option publisherClaimStrategyOption = parser.addStringOption('l', "publisherClaimStrategy");
        CmdLineParser.Option writerWaitStrategyOption = parser.addStringOption('w', "writerWaitStrategy");
        CmdLineParser.Option writerAffinityOption = parser.addStringOption('x', "writerAffinity");
        CmdLineParser.Option pageSizeOption = parser.addIntegerOption('p', "pageSize");
        CmdLineParser.Option lazyDeserializeOption = parser.addBooleanOption('k', "lazyDeserialize");
        CmdLineParser.Option countOption = parser.addIntegerOption('c', "count");
        CmdLineParser.Option warmupTimeOption = parser.addIntegerOption('t', "warmupTime");
        CmdLineParser.Option rateOption = parser.addIntegerOption('r', "rate");
        CmdLineParser.Option noLatencyWritesOption = parser.addBooleanOption('a', "noLatencyWrites");
        CmdLineParser.Option printIntervalStatsOption = parser.addBooleanOption('b', "printIntervalStats");
        CmdLineParser.Option affinityOption = parser.addStringOption('j', "affinity");
        CmdLineParser.Option helpOption = parser.addBooleanOption('h', "help");
        try {
            parser.parse(args);
            if (!((Boolean)parser.getOptionValue(helpOption, (Object)false)).booleanValue()) {
                String affinityStr = (String)parser.getOptionValue(affinityOption, null);
                if (affinityStr != null) {
                    System.setProperty("nv.enablecpuaffinitymasks", "true");
                    UtlThread.setCPUAffinityMask((long)UtlThread.parseAffinityMask((String)affinityStr));
                }
                Properties props = new Properties();
                props.setProperty("logMode", (String)parser.getOptionValue(logModeOption, (Object)"rw"));
                props.setProperty("initialLogLength", String.valueOf(parser.getOptionValue(initialLogLengthOption, (Object)1)));
                props.setProperty("zeroOutInitial", (Boolean)parser.getOptionValue(zeroOutInitialOption, (Object)false) != false ? "true" : "false");
                props.setProperty("flushUsingMappedMemory", (Boolean)parser.getOptionValue(flushUsingMappedMemoryOption, (Object)false) != false ? "true" : "false");
                props.setProperty("flushOnCommit", (Boolean)parser.getOptionValue(flushOnCommitOption, (Object)false) != false ? "true" : "false");
                props.setProperty("detachedPersist", (Boolean)parser.getOptionValue(detachedOption, (Object)false) != false ? "true" : "false");
                props.setProperty("queueDepth", String.valueOf(parser.getOptionValue(queueDepthOption, (Object)1024)));
                props.setProperty("queueOfferStrategy", (String)parser.getOptionValue(publisherClaimStrategyOption, (Object)"SingleThreaded"));
                props.setProperty("queueWaitStrategy", (String)parser.getOptionValue(writerWaitStrategyOption, (Object)"Yielding"));
                props.setProperty("queueDrainerCpuAffinityMask", (String)parser.getOptionValue(writerAffinityOption, (Object)"[0]"));
                props.setProperty("pageSize", String.valueOf(parser.getOptionValue(pageSizeOption, (Object)4096)));
                System.out.println("");
                System.out.println("***** Parameters");
                System.out.println("***** ...logMode=" + props.getProperty("logMode"));
                System.out.println("***** ...initialLogLength=" + props.getProperty("initialLogLength"));
                System.out.println("***** ...zeroOutInitial=" + props.getProperty("zeroOutInitial"));
                System.out.println("*****");
                int numPerCommit = (Integer)parser.getOptionValue(numPerCommitOption, (Object)1);
                System.out.println("***** ...numPerCommit=" + numPerCommit);
                System.out.println("***** ...flushUsingMappedMemory=" + props.getProperty("flushUsingMappedMemory"));
                System.out.println("***** ...flushOnCommit=" + props.getProperty("flushOnCommit"));
                boolean syncOnCommit = (Boolean)parser.getOptionValue(syncOnCommitOption, (Object)false);
                System.out.println("***** ...syncOnCommit=" + syncOnCommit);
                System.out.println("*****");
                System.out.println("***** ...detached=" + props.getProperty("detachedPersist"));
                System.out.println("***** ......queueDepth=" + props.getProperty("queueDepth"));
                System.out.println("***** ......publisherClaimStrategy=" + props.getProperty("queueOfferStrategy"));
                System.out.println("***** ......writerWaitStrategy=" + props.getProperty("queueWaitStrategy"));
                System.out.println("***** ......writerAffinity=" + props.getProperty("queueDrainerCpuAffinityMask"));
                System.out.println("*****");
                System.out.println("***** ...pageSize=" + props.getProperty("pageSize"));
                boolean lazyDeserialize = (Boolean)parser.getOptionValue(lazyDeserializeOption, (Object)true);
                System.out.println("***** ...lazyDeserialize=" + lazyDeserialize);
                System.out.println("*****");
                int count = (Integer)parser.getOptionValue(countOption, (Object)15000000);
                System.out.println("***** ...count=" + count);
                int warmupTime = (Integer)parser.getOptionValue(warmupTimeOption, (Object)2);
                System.out.println("***** ...warmupTime=" + warmupTime);
                int rate = (Integer)parser.getOptionValue(rateOption, (Object)500000);
                System.out.println("***** ...rate=" + rate);
                System.out.println("*****");
                boolean noLatencyWrites = (Boolean)parser.getOptionValue(noLatencyWritesOption, (Object)false);
                System.out.println("***** ...noLatencyWrites=" + noLatencyWrites);
                boolean printIntervalStats = (Boolean)parser.getOptionValue(printIntervalStatsOption, (Object)false);
                System.out.println("***** ...printIntervalStats=" + printIntervalStats);
                System.out.println("*****");
                System.out.println("***** ...affinity=" + affinityStr);
                System.out.println("");
                new StoreLogger(props).run(count, warmupTime, rate, lazyDeserialize, numPerCommit, syncOnCommit, noLatencyWrites, printIntervalStats);
            } else {
                StoreLogger.printUsage();
            }
        }
        catch (CmdLineParser.OptionException e) {
            System.err.println(e.getMessage());
            StoreLogger.printUsage();
        }
    }
}

