/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto.test.unit;

import com.neeve.sto.StoField;
import com.neeve.sto.StoStringField;
import com.neeve.test.UnitTest;
import java.nio.ByteBuffer;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class StoStringFieldTest
extends UnitTest {
    private static Random random = new Random(System.currentTimeMillis());

    static final String createString() {
        return String.format("%04d", random.nextInt(9999));
    }

    private final void validate(StoStringField field, String name, ByteBuffer buffer, String val) {
        if (name == null) {
            Assert.assertNull((Object)field.getName());
        } else {
            Assert.assertEquals((Object)field.getName(), (Object)name);
        }
        if (buffer == null) {
            Assert.assertNull((Object)field.getBackingBuffer());
        } else {
            Assert.assertSame((Object)field.getBackingBuffer(), (Object)buffer);
        }
        Assert.assertEquals((Object)((Object)StoField.Type.STRING), (Object)((Object)field.getType()));
        if (val == null) {
            Assert.assertNull(field.getValue());
        } else {
            Assert.assertEquals(field.getValue(), (Object)val);
        }
    }

    private final void cloneAndValidate(StoStringField field, String name, String val) {
        StoStringField clone = (StoStringField)field.clone();
        Assert.assertNotSame((Object)clone, (Object)field);
        this.validate(clone, name, null, val);
        Assert.assertTrue((boolean)field.contentsEquals(clone));
    }

    private final void validate(ByteBuffer buffer, int pos, int limit, int capacity) {
        Assert.assertEquals((long)buffer.position(), (long)pos);
        Assert.assertEquals((long)buffer.limit(), (long)limit);
        Assert.assertEquals((long)buffer.capacity(), (long)capacity);
    }

    @Test
    public void testStaticMethods() throws Exception {
        Assert.assertEquals((long)StoStringField.getSerializedLength(null), (long)2L);
        Assert.assertEquals((long)StoStringField.getSerializedLength(""), (long)2L);
        Assert.assertEquals((long)StoStringField.getSerializedLength("hello"), (long)7L);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        Assert.assertEquals((long)StoStringField.put(buffer, 5, null), (long)2L);
        this.validate(buffer, 0, 100, 100);
        Assert.assertEquals((long)StoStringField.getSerializedLength(buffer, 5), (long)2L);
        Assert.assertEquals((long)StoStringField.put(buffer, 5, ""), (long)2L);
        this.validate(buffer, 0, 100, 100);
        Assert.assertEquals((long)StoStringField.getSerializedLength(buffer, 5), (long)2L);
        Assert.assertEquals((long)StoStringField.put(buffer, 5, "string1"), (long)9L);
        this.validate(buffer, 0, 100, 100);
        Assert.assertEquals((long)StoStringField.getSerializedLength(buffer, 5), (long)9L);
        this.validate(buffer, 0, 100, 100);
        Assert.assertEquals((Object)StoStringField.get(buffer, 5), (Object)"string1");
        this.validate(buffer, 0, 100, 100);
        StoStringField.put(buffer, 5, "string2");
        this.validate(buffer, 0, 100, 100);
        Assert.assertEquals((Object)StoStringField.get(buffer, 5), (Object)"string2");
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullName() throws Exception {
        StoStringField field = StoStringField.create(null);
        this.validate(field, null, null, null);
        this.cloneAndValidate(field, null, null);
    }

    @Test
    public void testCreateWithNonNullName() throws Exception {
        StoStringField field = StoStringField.create("name");
        this.validate(field, "name", null, null);
        this.cloneAndValidate(field, "name", null);
    }

    @Test
    public void testIsVariableLength() throws Exception {
        Assert.assertTrue((boolean)StoStringField.create(null).isVariableLength());
    }

    @Test
    public void testCreateWithNullNameSetValue() throws Exception {
        StoStringField field = StoStringField.create(null);
        field.setValue("string1");
        this.validate(field, null, null, "string1");
        this.cloneAndValidate(field, null, "string1");
    }

    @Test
    public void testCreateWithNonNullNameSetValue() throws Exception {
        StoStringField field = StoStringField.create("name");
        field.setValue("string1");
        this.validate(field, "name", null, "string1");
        this.cloneAndValidate(field, "name", "string1");
    }

    @Test
    public void testCreateWithNullNameBackByBuffer() throws Exception {
        StoStringField field = StoStringField.create(null);
        this.validate(field, null, null, null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 5);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, buffer, null);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, null);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameBackByBuffer() throws Exception {
        StoStringField field = StoStringField.create("name");
        this.validate(field, "name", null, null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 9);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", buffer, null);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", null);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueBackByBuffer() throws Exception {
        StoStringField field = StoStringField.create(null);
        this.validate(field, null, null, null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue("string1");
        field.setBackingBuffer(buffer, 10);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, buffer, "string1");
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, "string1");
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueBackByBuffer() throws Exception {
        StoStringField field = StoStringField.create("name");
        this.validate(field, "name", null, null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue("string1");
        field.setBackingBuffer(buffer, 12);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", buffer, "string1");
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", "string1");
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueBackByThenClearBuffer() throws Exception {
        StoStringField field = StoStringField.create(null);
        this.validate(field, null, null, null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue("string1");
        field.setBackingBuffer(buffer, 10);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field.getBackingBuffer());
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, null, "string1");
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, "string1");
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueBackByThenClearBuffer() throws Exception {
        StoStringField field = StoStringField.create("name");
        this.validate(field, "name", null, null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue("string1");
        field.setBackingBuffer(buffer, 12);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field.getBackingBuffer());
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", null, "string1");
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", "string1");
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameBackByBufferSetValue() throws Exception {
        StoStringField field = StoStringField.create(null);
        this.validate(field, null, null, null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 22);
        this.validate(buffer, 0, 100, 100);
        field.setValue("string1");
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, buffer, "string1");
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, "string1");
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameBackByBufferSetValue() throws Exception {
        StoStringField field = StoStringField.create("name");
        this.validate(field, "name", null, null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 31);
        this.validate(buffer, 0, 100, 100);
        field.setValue("string1");
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", buffer, "string1");
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", "string1");
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameBackByBufferSetValueClearBuffer() throws Exception {
        StoStringField field = StoStringField.create(null);
        this.validate(field, null, null, null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 22);
        this.validate(buffer, 0, 100, 100);
        field.setValue("string1");
        this.validate(buffer, 0, 100, 100);
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, null, "string1");
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, "string1");
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameBackByBufferSetValueClearBuffer() throws Exception {
        StoStringField field = StoStringField.create("name");
        this.validate(field, "name", null, null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 31);
        this.validate(buffer, 0, 100, 100);
        field.setValue("string1");
        this.validate(buffer, 0, 100, 100);
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", null, "string1");
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", "string1");
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueSync() throws Exception {
        StoStringField field = StoStringField.create(null);
        this.validate(field, null, null, null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue("string1");
        field.sync(buffer, 45);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, null, "string1");
        this.validate(buffer, 0, 100, 100);
        Assert.assertEquals((Object)StoStringField.get(buffer, field.shiftForHeader(45)), (Object)"string1");
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, "string1");
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueSync() throws Exception {
        StoStringField field = StoStringField.create("name");
        this.validate(field, "name", null, null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue("string1");
        field.sync(buffer, 52);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", null, "string1");
        this.validate(buffer, 0, 100, 100);
        Assert.assertEquals((Object)StoStringField.get(buffer, field.shiftForHeader(52)), (Object)"string1");
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", "string1");
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserialize() throws Exception {
        StoStringField field1 = StoStringField.create(null);
        this.validate(field1, null, null, null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue("string1");
        field1.setBackingBuffer(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        StoStringField field2 = (StoStringField)StoField.create(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, "string1");
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserialize() throws Exception {
        StoStringField field1 = StoStringField.create("name");
        this.validate(field1, "name", null, null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue("string1");
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoStringField field2 = (StoStringField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, "name", "string1");
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameDeserialize() throws Exception {
        StoStringField field1 = StoStringField.create(null);
        this.validate(field1, null, null, null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        StoStringField field2 = (StoStringField)StoField.create(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        this.validate(field2, null, buffer, null);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, null);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameDeserialize() throws Exception {
        StoStringField field1 = StoStringField.create("name");
        this.validate(field1, "name", null, null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoStringField field2 = (StoStringField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        this.validate(field2, "name", buffer, null);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, "name", null);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserializeClearBuffer() throws Exception {
        StoStringField field1 = StoStringField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue("string1");
        field1.setBackingBuffer(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        StoStringField field2 = (StoStringField)StoField.create(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        field2.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        Assert.assertNull((Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, "string1");
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserializeClearBuffer() throws Exception {
        StoStringField field1 = StoStringField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue("string1");
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoStringField field2 = (StoStringField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        field2.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        Assert.assertNull((Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, "name", "string1");
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserializeSetBuffer() throws Exception {
        StoStringField field1 = StoStringField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setValue("string1");
        field1.setBackingBuffer(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        StoStringField field2 = (StoStringField)StoField.create(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.setBackingBuffer(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        StoStringField field3 = (StoStringField)StoField.create(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        this.validate(field3, null, buffer2, "string1");
        Assert.assertSame((Object)buffer2, (Object)field3.getBackingBuffer());
        Assert.assertTrue((boolean)field3.contentsEquals(field2));
        this.validate(buffer2, 0, 100, 100);
        this.cloneAndValidate(field3, null, "string1");
        this.validate(buffer2, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserializeSetBuffer() throws Exception {
        StoStringField field1 = StoStringField.create("name");
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setValue("string1");
        field1.setBackingBuffer(buffer1, 31);
        this.validate(buffer1, 0, 100, 100);
        StoStringField field2 = (StoStringField)StoField.create(buffer1, 31);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.setBackingBuffer(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        StoStringField field3 = (StoStringField)StoField.create(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        this.validate(field3, "name", buffer2, "string1");
        Assert.assertSame((Object)buffer2, (Object)field3.getBackingBuffer());
        Assert.assertTrue((boolean)field2.contentsEquals(field3));
        this.validate(buffer2, 0, 100, 100);
        this.cloneAndValidate(field3, "name", "string1");
        this.validate(buffer2, 0, 100, 100);
    }

    @Test
    public void testCreateSetNullValueDeserialize() throws Exception {
        StoStringField field1 = StoStringField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue(null);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoStringField field2 = (StoStringField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, null);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateSetEmptyValueDeserialize() throws Exception {
        StoStringField field1 = StoStringField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue("");
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoStringField field2 = (StoStringField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, "");
        this.validate(buffer, 0, 100, 100);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateSetBackingBufferSync() throws Exception {
        StoStringField field1 = StoStringField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer1, 31);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field1.sync(buffer2, 65);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateDeserializeSync() throws Exception {
        StoStringField field1 = StoStringField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer1, 31);
        this.validate(buffer1, 0, 100, 100);
        StoStringField field2 = (StoStringField)StoField.create(buffer1, 31);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.sync(buffer2, 25);
    }

    @Test
    public void testContentsEqualsWithDifferentNamesFirstNonNull() throws Exception {
        Assert.assertFalse((boolean)StoStringField.create("name").contentsEquals(StoStringField.create(null)));
    }

    @Test
    public void testContentsEqualsWithDifferentNamesSecondNonNull() throws Exception {
        Assert.assertFalse((boolean)StoStringField.create(null).contentsEquals(StoStringField.create("name")));
    }

    @Test
    public void testContentsEqualsWithDifferentNamesBothNonNull() throws Exception {
        Assert.assertFalse((boolean)StoStringField.create("name1").contentsEquals(StoStringField.create("name2")));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesFirstNonNull() throws Exception {
        StoStringField field1 = StoStringField.create(null);
        StoStringField field2 = StoStringField.create(null);
        field1.setValue("string");
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesSecondNonNull() throws Exception {
        StoStringField field1 = StoStringField.create(null);
        StoStringField field2 = StoStringField.create(null);
        field2.setValue("string");
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesBothNonNullDiffContent() throws Exception {
        StoStringField field1 = StoStringField.create(null);
        StoStringField field2 = StoStringField.create(null);
        field1.setValue("string1");
        field2.setValue("string2");
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNullValuesDefault() throws Exception {
        StoStringField field1 = StoStringField.create(null);
        StoStringField field2 = StoStringField.create(null);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNonNullValuesDefault() throws Exception {
        StoStringField field1 = StoStringField.create("name");
        StoStringField field2 = StoStringField.create("name");
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNullValuesNonDefault() throws Exception {
        StoStringField field1 = StoStringField.create(null);
        StoStringField field2 = StoStringField.create(null);
        field1.setValue("string42");
        field2.setValue("string42");
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNonNullValuesNonDefault() throws Exception {
        StoStringField field1 = StoStringField.create("name");
        StoStringField field2 = StoStringField.create("name");
        field1.setValue("string66");
        field2.setValue("string66");
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }
}

