/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto.test.unit;

import com.neeve.sto.StoField;
import com.neeve.sto.StoFloatField;
import com.neeve.test.UnitTest;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;

public final class StoFloatFieldTest
extends UnitTest {
    private final void validate(StoFloatField field, String name, ByteBuffer buffer, float val) {
        if (name == null) {
            Assert.assertNull((Object)field.getName());
        } else {
            Assert.assertEquals((Object)field.getName(), (Object)name);
        }
        if (buffer == null) {
            Assert.assertNull((Object)field.getBackingBuffer());
        } else {
            Assert.assertSame((Object)field.getBackingBuffer(), (Object)buffer);
        }
        Assert.assertEquals((Object)((Object)StoField.Type.FLOAT), (Object)((Object)field.getType()));
        Assert.assertEquals((float)field.getValue(), (float)val, (float)0.0f);
    }

    private final void cloneAndValidate(StoFloatField field, String name, float val) {
        StoFloatField clone = (StoFloatField)field.clone();
        Assert.assertNotSame((Object)clone, (Object)field);
        this.validate(clone, name, null, val);
        Assert.assertTrue((boolean)field.contentsEquals(clone));
    }

    private final void validate(ByteBuffer buffer, int pos, int limit, int capacity) {
        Assert.assertEquals((long)buffer.position(), (long)pos);
        Assert.assertEquals((long)buffer.limit(), (long)limit);
        Assert.assertEquals((long)buffer.capacity(), (long)capacity);
    }

    @Test
    public void testStaticMethods() throws Exception {
        Assert.assertEquals((long)StoFloatField.getSerializedLength(null, 0), (long)4L);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        StoFloatField.put(buffer, 5, 43.6752f);
        this.validate(buffer, 0, 100, 100);
        Assert.assertEquals((float)StoFloatField.get(buffer, 5), (float)43.6752f, (float)0.0f);
        this.validate(buffer, 0, 100, 100);
        StoFloatField.put(buffer, 5, 87.5261f);
        this.validate(buffer, 0, 100, 100);
        Assert.assertEquals((float)StoFloatField.get(buffer, 5), (float)87.5261f, (float)0.0f);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullName() throws Exception {
        StoFloatField field = StoFloatField.create(null);
        this.validate(field, null, null, 0.0f);
        this.cloneAndValidate(field, null, 0.0f);
    }

    @Test
    public void testCreateWithNonNullName() throws Exception {
        StoFloatField field = StoFloatField.create("name");
        this.validate(field, "name", null, 0.0f);
        this.cloneAndValidate(field, "name", 0.0f);
    }

    @Test
    public void testIsVariableLength() throws Exception {
        Assert.assertFalse((boolean)StoFloatField.create(null).isVariableLength());
    }

    @Test
    public void testCreateWithNullNameSetValue() throws Exception {
        StoFloatField field = StoFloatField.create(null);
        field.setValue(43.6752f);
        this.validate(field, null, null, 43.6752f);
        this.cloneAndValidate(field, null, 43.6752f);
    }

    @Test
    public void testCreateWithNonNullNameSetValue() throws Exception {
        StoFloatField field = StoFloatField.create("name");
        field.setValue(43.6752f);
        this.validate(field, "name", null, 43.6752f);
        this.cloneAndValidate(field, "name", 43.6752f);
    }

    @Test
    public void testCreateWithNullNameBackByBuffer() throws Exception {
        StoFloatField field = StoFloatField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 5);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, buffer, 0.0f);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, 0.0f);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameBackByBuffer() throws Exception {
        StoFloatField field = StoFloatField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 9);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", buffer, 0.0f);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", 0.0f);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueBackByBuffer() throws Exception {
        StoFloatField field = StoFloatField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue(43.6752f);
        field.setBackingBuffer(buffer, 10);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, buffer, 43.6752f);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, 43.6752f);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueBackByBuffer() throws Exception {
        StoFloatField field = StoFloatField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue(43.6752f);
        field.setBackingBuffer(buffer, 12);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", buffer, 43.6752f);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", 43.6752f);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueBackByThenClearBuffer() throws Exception {
        StoFloatField field = StoFloatField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue(43.6752f);
        field.setBackingBuffer(buffer, 10);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field.getBackingBuffer());
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, null, 43.6752f);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, 43.6752f);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueBackByThenClearBuffer() throws Exception {
        StoFloatField field = StoFloatField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue(43.6752f);
        field.setBackingBuffer(buffer, 12);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field.getBackingBuffer());
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", null, 43.6752f);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", 43.6752f);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameBackByBufferSetValue() throws Exception {
        StoFloatField field = StoFloatField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 22);
        this.validate(buffer, 0, 100, 100);
        field.setValue(43.6752f);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, buffer, 43.6752f);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, 43.6752f);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameBackByBufferSetValue() throws Exception {
        StoFloatField field = StoFloatField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 31);
        this.validate(buffer, 0, 100, 100);
        field.setValue(43.6752f);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", buffer, 43.6752f);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", 43.6752f);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameBackByBufferSetValueClearBuffer() throws Exception {
        StoFloatField field = StoFloatField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 22);
        this.validate(buffer, 0, 100, 100);
        field.setValue(43.6752f);
        this.validate(buffer, 0, 100, 100);
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, null, 43.6752f);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, 43.6752f);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameBackByBufferSetValueClearBuffer() throws Exception {
        StoFloatField field = StoFloatField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 31);
        this.validate(buffer, 0, 100, 100);
        field.setValue(43.6752f);
        this.validate(buffer, 0, 100, 100);
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", null, 43.6752f);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", 43.6752f);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueSync() throws Exception {
        StoFloatField field = StoFloatField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue(43.6752f);
        field.sync(buffer, 45);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, null, 43.6752f);
        this.validate(buffer, 0, 100, 100);
        Assert.assertEquals((float)StoFloatField.get(buffer, field.shiftForHeader(45)), (float)43.6752f, (float)0.0f);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, 43.6752f);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueSync() throws Exception {
        StoFloatField field = StoFloatField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue(43.6752f);
        field.sync(buffer, 52);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", null, 43.6752f);
        this.validate(buffer, 0, 100, 100);
        Assert.assertEquals((float)StoFloatField.get(buffer, field.shiftForHeader(52)), (float)43.6752f, (float)0.0f);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", 43.6752f);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserialize() throws Exception {
        StoFloatField field1 = StoFloatField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue(43.6752f);
        field1.setBackingBuffer(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        StoFloatField field2 = (StoFloatField)StoField.create(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, 43.6752f);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserialize() throws Exception {
        StoFloatField field1 = StoFloatField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue(43.6752f);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoFloatField field2 = (StoFloatField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, "name", 43.6752f);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserializeClearBuffer() throws Exception {
        StoFloatField field1 = StoFloatField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue(43.6752f);
        field1.setBackingBuffer(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        StoFloatField field2 = (StoFloatField)StoField.create(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        field2.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        Assert.assertNull((Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, 43.6752f);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserializeClearBuffer() throws Exception {
        StoFloatField field1 = StoFloatField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue(43.6752f);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoFloatField field2 = (StoFloatField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        field2.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        Assert.assertNull((Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, "name", 43.6752f);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserializeSetBuffer() throws Exception {
        StoFloatField field1 = StoFloatField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setValue(34.9804f);
        field1.setBackingBuffer(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        StoFloatField field2 = (StoFloatField)StoField.create(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.setBackingBuffer(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        StoFloatField field3 = (StoFloatField)StoField.create(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        this.validate(field3, null, buffer2, 34.9804f);
        Assert.assertSame((Object)buffer2, (Object)field3.getBackingBuffer());
        Assert.assertTrue((boolean)field3.contentsEquals(field2));
        this.validate(buffer2, 0, 100, 100);
        this.cloneAndValidate(field3, null, 34.9804f);
        this.validate(buffer2, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserializeSetBuffer() throws Exception {
        StoFloatField field1 = StoFloatField.create("name");
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setValue(32.7682f);
        field1.setBackingBuffer(buffer1, 34);
        this.validate(buffer1, 0, 100, 100);
        StoFloatField field2 = (StoFloatField)StoField.create(buffer1, 34);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.setBackingBuffer(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        StoFloatField field3 = (StoFloatField)StoField.create(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        this.validate(field3, "name", buffer2, 32.7682f);
        Assert.assertSame((Object)buffer2, (Object)field3.getBackingBuffer());
        Assert.assertTrue((boolean)field2.contentsEquals(field3));
        this.validate(buffer2, 0, 100, 100);
        this.cloneAndValidate(field3, "name", 32.7682f);
        this.validate(buffer2, 0, 100, 100);
    }

    @Test
    public void testCreateDeserialize() throws Exception {
        StoFloatField field1 = StoFloatField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoFloatField field2 = (StoFloatField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, 0.0f);
        this.validate(buffer, 0, 100, 100);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateSetBackingBufferSync() throws Exception {
        StoFloatField field1 = StoFloatField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer1, 31);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field1.sync(buffer2, 65);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateDeserializeSync() throws Exception {
        StoFloatField field1 = StoFloatField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer1, 31);
        this.validate(buffer1, 0, 100, 100);
        StoFloatField field2 = (StoFloatField)StoField.create(buffer1, 31);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.sync(buffer2, 25);
    }

    @Test
    public void testContentsEqualsWithDifferentNamesFirstNonNull() throws Exception {
        Assert.assertFalse((boolean)StoFloatField.create("name").contentsEquals(StoFloatField.create(null)));
    }

    @Test
    public void testContentsEqualsWithDifferentNamesSecondNonNull() throws Exception {
        Assert.assertFalse((boolean)StoFloatField.create(null).contentsEquals(StoFloatField.create("name")));
    }

    @Test
    public void testContentsEqualsWithDifferentNamesBothNonNull() throws Exception {
        Assert.assertFalse((boolean)StoFloatField.create("name1").contentsEquals(StoFloatField.create("name2")));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesFirstNonNull() throws Exception {
        StoFloatField field1 = StoFloatField.create(null);
        StoFloatField field2 = StoFloatField.create(null);
        field1.setValue(100.03f);
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesSecondNonNull() throws Exception {
        StoFloatField field1 = StoFloatField.create(null);
        StoFloatField field2 = StoFloatField.create(null);
        field2.setValue(100.67f);
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesBothNonNullDiffContent() throws Exception {
        StoFloatField field1 = StoFloatField.create(null);
        StoFloatField field2 = StoFloatField.create(null);
        field1.setValue(67.56f);
        field2.setValue(178.43f);
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNullValuesDefault() throws Exception {
        StoFloatField field1 = StoFloatField.create(null);
        StoFloatField field2 = StoFloatField.create(null);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNonNullValuesDefault() throws Exception {
        StoFloatField field1 = StoFloatField.create("name");
        StoFloatField field2 = StoFloatField.create("name");
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNullValuesNonDefault() throws Exception {
        StoFloatField field1 = StoFloatField.create(null);
        StoFloatField field2 = StoFloatField.create(null);
        field1.setValue(42.42f);
        field2.setValue(42.42f);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNonNullValuesNonDefault() throws Exception {
        StoFloatField field1 = StoFloatField.create("name");
        StoFloatField field2 = StoFloatField.create("name");
        field1.setValue(66.66f);
        field2.setValue(66.66f);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }
}

