/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto.test.unit;

import com.neeve.sto.StoDoubleField;
import com.neeve.sto.StoField;
import com.neeve.test.UnitTest;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;

public final class StoDoubleFieldTest
extends UnitTest {
    private final void validate(StoDoubleField field, String name, ByteBuffer buffer, double val) {
        if (name == null) {
            Assert.assertNull((Object)field.getName());
        } else {
            Assert.assertEquals((Object)field.getName(), (Object)name);
        }
        if (buffer == null) {
            Assert.assertNull((Object)field.getBackingBuffer());
        } else {
            Assert.assertSame((Object)field.getBackingBuffer(), (Object)buffer);
        }
        Assert.assertEquals((Object)((Object)StoField.Type.DOUBLE), (Object)((Object)field.getType()));
        Assert.assertEquals((double)field.getValue(), (double)val, (double)0.0);
    }

    private final void cloneAndValidate(StoDoubleField field, String name, double val) {
        StoDoubleField clone = (StoDoubleField)field.clone();
        Assert.assertNotSame((Object)clone, (Object)field);
        this.validate(clone, name, null, val);
        Assert.assertTrue((boolean)field.contentsEquals(clone));
    }

    private final void validate(ByteBuffer buffer, int pos, int limit, int capacity) {
        Assert.assertEquals((long)buffer.position(), (long)pos);
        Assert.assertEquals((long)buffer.limit(), (long)limit);
        Assert.assertEquals((long)buffer.capacity(), (long)capacity);
    }

    @Test
    public void testStaticMethods() throws Exception {
        Assert.assertEquals((long)StoDoubleField.getSerializedLength(null, 0), (long)8L);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        StoDoubleField.put(buffer, 5, 45.8954);
        this.validate(buffer, 0, 100, 100);
        Assert.assertEquals((double)StoDoubleField.get(buffer, 5), (double)45.8954, (double)0.0);
        this.validate(buffer, 0, 100, 100);
        StoDoubleField.put(buffer, 5, 56.8762);
        this.validate(buffer, 0, 100, 100);
        Assert.assertEquals((double)StoDoubleField.get(buffer, 5), (double)56.8762, (double)0.0);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullName() throws Exception {
        StoDoubleField field = StoDoubleField.create(null);
        this.validate(field, null, null, 0.0);
        this.cloneAndValidate(field, null, 0.0);
    }

    @Test
    public void testCreateWithNonNullName() throws Exception {
        StoDoubleField field = StoDoubleField.create("name");
        this.validate(field, "name", null, 0.0);
        this.cloneAndValidate(field, "name", 0.0);
    }

    @Test
    public void testIsVariableLength() throws Exception {
        Assert.assertFalse((boolean)StoDoubleField.create(null).isVariableLength());
    }

    @Test
    public void testCreateWithNullNameSetValue() throws Exception {
        StoDoubleField field = StoDoubleField.create(null);
        field.setValue(45.8954);
        this.validate(field, null, null, 45.8954);
        this.cloneAndValidate(field, null, 45.8954);
    }

    @Test
    public void testCreateWithNonNullNameSetValue() throws Exception {
        StoDoubleField field = StoDoubleField.create("name");
        field.setValue(45.8954);
        this.validate(field, "name", null, 45.8954);
        this.cloneAndValidate(field, "name", 45.8954);
    }

    @Test
    public void testCreateWithNullNameBackByBuffer() throws Exception {
        StoDoubleField field = StoDoubleField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 5);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, buffer, 0.0);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, 0.0);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameBackByBuffer() throws Exception {
        StoDoubleField field = StoDoubleField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 9);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", buffer, 0.0);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", 0.0);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueBackByBuffer() throws Exception {
        StoDoubleField field = StoDoubleField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue(45.8954);
        field.setBackingBuffer(buffer, 10);
        field.setBackingBuffer(buffer, 10);
        this.validate(field, null, buffer, 45.8954);
        field.setBackingBuffer(buffer, 10);
        this.cloneAndValidate(field, null, 45.8954);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueBackByBuffer() throws Exception {
        StoDoubleField field = StoDoubleField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue(45.8954);
        field.setBackingBuffer(buffer, 12);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", buffer, 45.8954);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", 45.8954);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueBackByThenClearBuffer() throws Exception {
        StoDoubleField field = StoDoubleField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue(45.8954);
        field.setBackingBuffer(buffer, 10);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field.getBackingBuffer());
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, null, 45.8954);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, 45.8954);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueBackByThenClearBuffer() throws Exception {
        StoDoubleField field = StoDoubleField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue(45.8954);
        field.setBackingBuffer(buffer, 12);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field.getBackingBuffer());
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", null, 45.8954);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", 45.8954);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameBackByBufferSetValue() throws Exception {
        StoDoubleField field = StoDoubleField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 22);
        this.validate(buffer, 0, 100, 100);
        field.setValue(45.8954);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, buffer, 45.8954);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, 45.8954);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameBackByBufferSetValue() throws Exception {
        StoDoubleField field = StoDoubleField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 31);
        this.validate(buffer, 0, 100, 100);
        field.setValue(45.8954);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", buffer, 45.8954);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", 45.8954);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameBackByBufferSetValueClearBuffer() throws Exception {
        StoDoubleField field = StoDoubleField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 22);
        this.validate(buffer, 0, 100, 100);
        field.setValue(45.8954);
        this.validate(buffer, 0, 100, 100);
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, null, 45.8954);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, 45.8954);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameBackByBufferSetValueClearBuffer() throws Exception {
        StoDoubleField field = StoDoubleField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 31);
        this.validate(buffer, 0, 100, 100);
        field.setValue(45.8954);
        this.validate(buffer, 0, 100, 100);
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", null, 45.8954);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", 45.8954);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueSync() throws Exception {
        StoDoubleField field = StoDoubleField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue(45.8954);
        field.sync(buffer, 45);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, null, 45.8954);
        this.validate(buffer, 0, 100, 100);
        Assert.assertEquals((double)StoDoubleField.get(buffer, field.shiftForHeader(45)), (double)45.8954, (double)0.0);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, 45.8954);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueSync() throws Exception {
        StoDoubleField field = StoDoubleField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue(45.8954);
        field.sync(buffer, 52);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", null, 45.8954);
        this.validate(buffer, 0, 100, 100);
        Assert.assertEquals((double)StoDoubleField.get(buffer, field.shiftForHeader(52)), (double)45.8954, (double)0.0);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", 45.8954);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserialize() throws Exception {
        StoDoubleField field1 = StoDoubleField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue(45.8954);
        field1.setBackingBuffer(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        StoDoubleField field2 = (StoDoubleField)StoField.create(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, 45.8954);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserialize() throws Exception {
        StoDoubleField field1 = StoDoubleField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue(45.8954);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoDoubleField field2 = (StoDoubleField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, "name", 45.8954);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserializeClearBuffer() throws Exception {
        StoDoubleField field1 = StoDoubleField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue(45.8954);
        field1.setBackingBuffer(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        StoDoubleField field2 = (StoDoubleField)StoField.create(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        field2.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        Assert.assertNull((Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, 45.8954);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserializeClearBuffer() throws Exception {
        StoDoubleField field1 = StoDoubleField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue(45.8954);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoDoubleField field2 = (StoDoubleField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        field2.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        Assert.assertNull((Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, "name", 45.8954);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserializeSetBuffer() throws Exception {
        StoDoubleField field1 = StoDoubleField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setValue(78.19804);
        field1.setBackingBuffer(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        StoDoubleField field2 = (StoDoubleField)StoField.create(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.setBackingBuffer(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        StoDoubleField field3 = (StoDoubleField)StoField.create(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        this.validate(field3, null, buffer2, 78.19804);
        Assert.assertSame((Object)buffer2, (Object)field3.getBackingBuffer());
        Assert.assertTrue((boolean)field3.contentsEquals(field2));
        this.validate(buffer2, 0, 100, 100);
        this.cloneAndValidate(field3, null, 78.19804);
        this.validate(buffer2, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserializeSetBuffer() throws Exception {
        StoDoubleField field1 = StoDoubleField.create("name");
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setValue(56.7682);
        field1.setBackingBuffer(buffer1, 62);
        this.validate(buffer1, 0, 100, 100);
        StoDoubleField field2 = (StoDoubleField)StoField.create(buffer1, 62);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.setBackingBuffer(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        StoDoubleField field3 = (StoDoubleField)StoField.create(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        this.validate(field3, "name", buffer2, 56.7682);
        Assert.assertSame((Object)buffer2, (Object)field3.getBackingBuffer());
        Assert.assertTrue((boolean)field2.contentsEquals(field3));
        this.validate(buffer2, 0, 100, 100);
        this.cloneAndValidate(field3, "name", 56.7682);
        this.validate(buffer2, 0, 100, 100);
    }

    @Test
    public void testCreateDeserialize() throws Exception {
        StoDoubleField field1 = StoDoubleField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoDoubleField field2 = (StoDoubleField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, 0.0);
        this.validate(buffer, 0, 100, 100);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateSetBackingBufferSync() throws Exception {
        StoDoubleField field1 = StoDoubleField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer1, 31);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field1.sync(buffer2, 65);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateDeserializeSync() throws Exception {
        StoDoubleField field1 = StoDoubleField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer1, 31);
        this.validate(buffer1, 0, 100, 100);
        StoDoubleField field2 = (StoDoubleField)StoField.create(buffer1, 31);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.sync(buffer2, 25);
    }

    @Test
    public void testContentsEqualsWithDifferentNamesFirstNonNull() throws Exception {
        Assert.assertFalse((boolean)StoDoubleField.create("name").contentsEquals(StoDoubleField.create(null)));
    }

    @Test
    public void testContentsEqualsWithDifferentNamesSecondNonNull() throws Exception {
        Assert.assertFalse((boolean)StoDoubleField.create(null).contentsEquals(StoDoubleField.create("name")));
    }

    @Test
    public void testContentsEqualsWithDifferentNamesBothNonNull() throws Exception {
        Assert.assertFalse((boolean)StoDoubleField.create("name1").contentsEquals(StoDoubleField.create("name2")));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesFirstNonNull() throws Exception {
        StoDoubleField field1 = StoDoubleField.create(null);
        StoDoubleField field2 = StoDoubleField.create(null);
        field1.setValue(100.03);
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesSecondNonNull() throws Exception {
        StoDoubleField field1 = StoDoubleField.create(null);
        StoDoubleField field2 = StoDoubleField.create(null);
        field2.setValue(100.67);
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesBothNonNullDiffContent() throws Exception {
        StoDoubleField field1 = StoDoubleField.create(null);
        StoDoubleField field2 = StoDoubleField.create(null);
        field1.setValue(67.56);
        field2.setValue(178.43);
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNullValuesDefault() throws Exception {
        StoDoubleField field1 = StoDoubleField.create(null);
        StoDoubleField field2 = StoDoubleField.create(null);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNonNullValuesDefault() throws Exception {
        StoDoubleField field1 = StoDoubleField.create("name");
        StoDoubleField field2 = StoDoubleField.create("name");
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNullValuesNonDefault() throws Exception {
        StoDoubleField field1 = StoDoubleField.create(null);
        StoDoubleField field2 = StoDoubleField.create(null);
        field1.setValue(42.42);
        field2.setValue(42.42);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNonNullValuesNonDefault() throws Exception {
        StoDoubleField field1 = StoDoubleField.create("name");
        StoDoubleField field2 = StoDoubleField.create("name");
        field1.setValue(66.66);
        field2.setValue(66.66);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }
}

