/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.pkt;

import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XFactory;
import com.neeve.lang.XString;
import com.neeve.pkt.PktBody;
import com.neeve.pkt.PktBuffer;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSubheaderVariable;
import com.neeve.quark.QuarkBuffer;
import java.nio.ByteBuffer;
import java.util.Properties;

public final class PktSubheaderSMA
extends PktSubheaderVariable {
    private static final byte V1 = 1;
    private static final byte VERSION = 1;
    private static final int VERSION_POS = 1;
    private static final int ENCODING_POS = VERSION_POS + 1;
    private static final int VFID_POS = ENCODING_POS + 1;
    private static final int VTYPE_POS = VFID_POS + 2;
    private static final int SENDER_POS = VTYPE_POS + 2;
    private static final int SNO_POS = SENDER_POS + 4;
    private static final int CHID_POS = SNO_POS + 8;
    private static final int CHNAMELEN_POS = CHID_POS + 2;
    private static final int CHNAME_POS = CHNAMELEN_POS + 2;
    private short chnameLen = 0;
    private final XString chname = XFactory.createXString((int)255, (boolean)true, (boolean)true);

    private PktSubheaderSMA(Properties props) {
        super(5, true);
    }

    public static PktBody create(Properties props) {
        return new PktSubheaderSMA(props);
    }

    public static PktBody create() {
        return PktSubheaderSMA.create(null);
    }

    public static void prepare(PktPacket packet, byte encodingType, short vfid, short vtype, int sender, long sno, short chid, XString chname) {
        PktSubheaderSMA subheaderSMA = packet.getHeader().activateSMASubheader(false);
        PktBuffer buffer = subheaderSMA.getBuffer();
        PktSubheaderSMA.setMessageEncodingType(buffer, encodingType);
        PktSubheaderSMA.setMessageViewFactoryId(buffer, vfid);
        PktSubheaderSMA.setMessageViewType(buffer, vtype);
        PktSubheaderSMA.setSender(buffer, sender);
        PktSubheaderSMA.setSno(buffer, sno);
        PktSubheaderSMA.setChannelId(buffer, chid);
        subheaderSMA.setChannelName(chname);
    }

    private final void updateFieldOffsets() {
    }

    private final void initChnameFromBuffer(PktBuffer buffer, boolean onlyOffset) {
        if (!this.chname.isInitialized()) {
            this.chnameLen = buffer.getShort(CHNAMELEN_POS);
            if (!onlyOffset && this.chnameLen != 0) {
                this.chname.setValue((IOElasticBuffer)buffer, CHNAME_POS, (int)this.chnameLen);
            }
        }
    }

    private static final void setSubheaderVersion(PktBuffer buffer, short version) {
        buffer.put(VERSION_POS, (byte)version);
    }

    private static final short getSubheaderVersion(PktBuffer buffer) {
        return (short)(0xFF & buffer.get(VERSION_POS));
    }

    private static final void setMessageEncodingType(PktBuffer buffer, byte type) {
        buffer.put(ENCODING_POS, type);
    }

    private static final byte getMessageEncodingType(PktBuffer buffer) {
        return buffer.get(ENCODING_POS);
    }

    private static final void setMessageViewFactoryId(PktBuffer buffer, short vfid) {
        buffer.putShort(VFID_POS, vfid);
    }

    private static final short getMessageViewFactoryId(PktBuffer buffer) {
        return buffer.getShort(VFID_POS);
    }

    private static final void setMessageViewType(PktBuffer buffer, short vtype) {
        buffer.putShort(VTYPE_POS, vtype);
    }

    private static final short getMessageViewType(PktBuffer buffer) {
        return buffer.getShort(VTYPE_POS);
    }

    private static final void setSender(PktBuffer buffer, int sender) {
        buffer.putInt(SENDER_POS, sender);
    }

    private static final int getSender(PktBuffer buffer) {
        return buffer.getInt(SENDER_POS);
    }

    private static final void setSno(PktBuffer buffer, long sno) {
        buffer.putLong(SNO_POS, sno);
    }

    private static final long getSno(PktBuffer buffer) {
        return buffer.getLong(SNO_POS);
    }

    private static final void setChannelId(PktBuffer buffer, short chid) {
        buffer.putShort(CHID_POS, chid);
    }

    private static final short getChannelId(PktBuffer buffer) {
        return buffer.getShort(CHID_POS);
    }

    private final PktBuffer syncChannelName(PktBuffer buffer) {
        this.chnameLen = (short)this.chname.getSerializedLength();
        this.updateFieldOffsets();
        buffer.putShort(CHNAMELEN_POS, this.chnameLen);
        if (this.chnameLen > 0) {
            if (buffer.getLength() < CHNAME_POS + this.chnameLen) {
                buffer.setLength(CHNAME_POS + this.chnameLen);
            }
            this.chname.copyInto((IOElasticBuffer)buffer, CHNAME_POS);
        }
        return buffer;
    }

    private final XString getChannelName(PktBuffer buffer) {
        if (!this.chname.isInitialized()) {
            this.initChnameFromBuffer(buffer, false);
        }
        return this.chname;
    }

    @Override
    public final void initialize() {
        this.updateFieldOffsets();
    }

    public static final int getSerializedLength(long addr, int offset) {
        return 21 + (2 + QuarkBuffer.getShort((long)addr, (int)(offset + CHNAMELEN_POS)));
    }

    @Override
    public final int doGetSerializedLength() {
        return 21 + (2 + this.chnameLen);
    }

    @Override
    public final int getSerializedLength(ByteBuffer buffer, int offset) {
        return 21 + (2 + buffer.getShort(offset + CHNAMELEN_POS));
    }

    @Override
    protected final void postDeserialize(int len) {
        this.initChnameFromBuffer(this.buffer, true);
    }

    @Override
    protected final boolean isResettable() {
        return true;
    }

    @Override
    protected final void doReset() {
        this.chnameLen = 0;
        this.chname.clear();
        super.doReset();
    }

    public static final short getLatestSubheaderVersion() {
        return 1;
    }

    private final void setSubheaderVersion(short version) {
        PktSubheaderSMA.setSubheaderVersion(this.buffer, (byte)version);
    }

    public final short getSubheaderVersion() {
        return PktSubheaderSMA.getSubheaderVersion(this.buffer);
    }

    public final void setMessageEncodingType(byte type) {
        PktSubheaderSMA.setMessageEncodingType(this.buffer, type);
    }

    public final byte getMessageEncodingType() {
        return PktSubheaderSMA.getMessageEncodingType(this.buffer);
    }

    public final void setMessageViewFactoryId(short vfid) {
        PktSubheaderSMA.setMessageViewFactoryId(this.buffer, vfid);
    }

    public final short getMessageViewFactoryId() {
        return PktSubheaderSMA.getMessageViewFactoryId(this.buffer);
    }

    public final void setMessageViewType(short type) {
        PktSubheaderSMA.setMessageViewType(this.buffer, type);
    }

    public final short getMessageViewType() {
        return PktSubheaderSMA.getMessageViewType(this.buffer);
    }

    public final void setSender(int sender) {
        PktSubheaderSMA.setSender(this.buffer, sender);
    }

    public final int getSender() {
        return PktSubheaderSMA.getSender(this.buffer);
    }

    public final void setSno(long sno) {
        PktSubheaderSMA.setSno(this.buffer, sno);
    }

    public final long getSno() {
        return PktSubheaderSMA.getSno(this.buffer);
    }

    public final void setChannelId(short chid) {
        PktSubheaderSMA.setChannelId(this.buffer, chid);
    }

    public final short getChannelId() {
        return PktSubheaderSMA.getChannelId(this.buffer);
    }

    public final void setChannelName(String chname) {
        this.chname.setValue(chname);
        this.syncChannelName(this.buffer);
    }

    public final void setChannelName(XString chname) {
        this.chname.setValue(chname);
        this.syncChannelName(this.buffer);
    }

    public final String getChannelName() {
        return this.getChannelName(this.buffer).getValue();
    }

    public final XString getChannelNameAsRaw() {
        return this.getChannelName(this.buffer);
    }

    @Override
    public final void initializeBuffer() {
        if (!this.inDeserialize) {
            this.setSubheaderVersion((short)1);
        }
    }

    public final String toString() {
        return "sma{" + this.getSubheaderVersion() + " " + this.getMessageEncodingType() + " " + this.getMessageViewFactoryId() + " " + this.getMessageViewType() + " " + this.getSender() + " " + this.getSno() + " " + this.getChannelId() + " " + this.getChannelName() + "}";
    }
}

