/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.solxf.impl.jni;

import com.neeve.NativeKernel;
import com.neeve.root.RootConfig;
import com.neeve.sma.SmaException;
import com.neeve.solxf.ISolDynamicTopic;
import com.neeve.solxf.ISolQueue;
import com.neeve.solxf.ISolSession;
import com.neeve.solxf.ISolStaticTopic;
import com.neeve.solxf.SolConfig;
import com.neeve.solxf.impl.jni.SolJniDynamicTopic;
import com.neeve.solxf.impl.jni.SolJniQueue;
import com.neeve.solxf.impl.jni.SolJniSession;
import com.neeve.solxf.impl.jni.SolJniStaticTopic;
import com.neeve.trace.Tracer;
import java.util.Properties;

public final class SolJniFactory {
    private static final Tracer _ccsmpTracer;
    private static final SolJniFactory _instance;

    private SolJniFactory() {
    }

    private static final native void initialize(String var0);

    private static final native void updateLogLevel(String var0);

    private static final String xTraceLevelToCcsmpLogLevel(Tracer.Level level) {
        switch (level) {
            case OFF: 
            case SEVERE: {
                return "error";
            }
            case WARNING: {
                return "warn";
            }
            case INFO: 
            case CONFIG: {
                return "notice";
            }
            case FINE: 
            case DIAGNOSE: 
            case FINER: 
            case VERBOSE: {
                return "info";
            }
            case FINEST: 
            case DEBUG: 
            case ALL: {
                return "debug";
            }
        }
        throw new InternalError("unknown X trace level '" + level + "'");
    }

    static final String toCcsmpTraceCategoryStr(int category) {
        switch (category) {
            case 1: {
                return "SDK";
            }
            case 2: {
                return "APP";
            }
        }
        return "UNK";
    }

    static final String toCcsmpTraceLevelStr(int level) {
        switch (level) {
            case 2: {
                return "CRITICAL";
            }
            case 3: {
                return "ERROR";
            }
            case 4: {
                return "WARNING";
            }
            case 5: {
                return "NOTICE";
            }
            case 6: {
                return "INFO";
            }
            case 7: {
                return "DEBUG";
            }
        }
        return "UNKNOWN";
    }

    static final Tracer.Level ccsmpToXTraceLevel(int ccsmpLevel) {
        switch (ccsmpLevel) {
            case 2: 
            case 3: {
                return Tracer.Level.SEVERE;
            }
            case 4: {
                return Tracer.Level.WARNING;
            }
            case 5: {
                return Tracer.Level.INFO;
            }
            case 6: {
                return Tracer.Level.FINE;
            }
            case 7: {
                return Tracer.Level.FINEST;
            }
        }
        return Tracer.Level.SEVERE;
    }

    static final Tracer ccsmpTracer() {
        return _ccsmpTracer;
    }

    public static final SolJniFactory onlyInstance() {
        return _instance;
    }

    public final ISolSession createSession(String host, String user, Properties props, Properties solxfProperties) throws SmaException {
        return new SolJniSession(host, user, props, solxfProperties);
    }

    public final ISolQueue createQueue(String name) {
        return new SolJniQueue(name);
    }

    public final ISolStaticTopic createStaticTopic(String name) {
        return new SolJniStaticTopic(name);
    }

    public final ISolDynamicTopic createDynamicTopic() {
        return new SolJniDynamicTopic();
    }

    static {
        _instance = new SolJniFactory();
        _ccsmpTracer = RootConfig.ObjectConfig.createTracer((RootConfig.ObjectConfig)SolConfig.getConfig());
        _ccsmpTracer.setLevelChangeCallback((Tracer.LevelChangeCallback)new TraceLevelChangeListener());
        String logLevel = SolJniFactory.xTraceLevelToCcsmpLogLevel(_ccsmpTracer.getLevel());
        try {
            NativeKernel.initialize();
            System.loadLibrary("nvxsoljni");
            SolJniFactory.initialize(logLevel);
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new RuntimeException(e);
        }
    }

    private static final class TraceLevelChangeListener
    implements Tracer.LevelChangeCallback {
        private TraceLevelChangeListener() {
        }

        public final void onLevelChange(Tracer.Level newLevel) {
            SolJniFactory.updateLogLevel(SolJniFactory.xTraceLevelToCcsmpLogLevel(newLevel));
        }
    }
}

