/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.discovery;

import com.neeve.discovery.DiscoveryObject;
import com.neeve.discovery.DiscoveryProviderDescriptor;
import com.neeve.discovery.EDiscoveryException;
import com.neeve.discovery.IDiscoveryProvider;
import com.neeve.trace.Tracer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Properties;

public final class DiscoveryProviderRegistry
extends DiscoveryObject {
    private static final DiscoveryProviderRegistry instance = new DiscoveryProviderRegistry();
    private final HashMap<String, IDiscoveryProvider> providers = new HashMap();

    private DiscoveryProviderRegistry() {
    }

    public static final DiscoveryProviderRegistry getInstance() {
        return instance;
    }

    private final IDiscoveryProvider createProvider(String className, String name, Properties props) throws EDiscoveryException {
        Class<?> providerClass = null;
        try {
            providerClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new EDiscoveryException("Discovery provider class [" + className + "] could not be found");
        }
        catch (UnsupportedClassVersionError e) {
            throw new EDiscoveryException("Discovery provider class [" + className + "] is not supported by this VM <version=" + System.getProperty("java.vm.version") + ">");
        }
        Method providerCreateMethod = null;
        try {
            Class[] parameterTypes = new Class[]{Class.forName("java.lang.String"), Class.forName("java.util.Properties")};
            providerCreateMethod = providerClass.getMethod("create", parameterTypes);
        }
        catch (ClassNotFoundException e) {
            throw new InternalError("Failed to load java.util.Properties during instantiation of discovery provider class [" + className + "]");
        }
        catch (SecurityException e) {
            throw new EDiscoveryException("Access to instantiation method in discovery provider class [" + className + "] is denied");
        }
        catch (NoSuchMethodException e) {
            throw new EDiscoveryException("Instantiation method in discovery provider class [" + className + "] could not be found");
        }
        IDiscoveryProvider provider = null;
        try {
            try {
                Object[] parameters = new Object[]{name, props};
                provider = (IDiscoveryProvider)providerCreateMethod.invoke(null, parameters);
                if (provider == null) {
                    throw new EDiscoveryException("Instantiation method in discovery provider class [" + className + "] returned a null object");
                }
            }
            catch (ClassCastException e) {
                throw new EDiscoveryException("Instantiation method in discovery provider class [" + className + "] returned object of incorrect type");
            }
        }
        catch (IllegalAccessException e) {
            throw new EDiscoveryException("Access to instantiation method in discovery provider class [" + className + "] is denied");
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof EDiscoveryException) {
                throw (EDiscoveryException)((Object)e.getCause());
            }
            throw new EDiscoveryException(e.getCause());
        }
        return provider;
    }

    private final IDiscoveryProvider createProvider(String name) throws EDiscoveryException {
        if (DiscoveryProviderDescriptor.exists(name)) {
            try {
                DiscoveryProviderDescriptor descriptor = DiscoveryProviderDescriptor.load(name);
                return this.createProvider(descriptor.getClassName(), descriptor.getName(), descriptor.getProperties());
            }
            catch (EDiscoveryException e) {
                throw new EDiscoveryException("Failed to load provider descriptor from configuration repository [" + e.toString() + "]");
            }
        }
        throw new EDiscoveryException("invalid provider '" + name + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerProvider(IDiscoveryProvider provider) throws EDiscoveryException {
        if (provider == null) {
            throw new IllegalArgumentException("provider cannot be null");
        }
        HashMap<String, IDiscoveryProvider> hashMap = this.providers;
        synchronized (hashMap) {
            if (this.tracer.debug) {
                this.tracer.log("[DiscoveryProviderRegistry] Registering provider '" + provider.getName() + "'...", Tracer.Level.DEBUG);
            }
            this.providers.put(provider.getName(), provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IDiscoveryProvider getProvider(String name) throws EDiscoveryException {
        HashMap<String, IDiscoveryProvider> hashMap = this.providers;
        synchronized (hashMap) {
            IDiscoveryProvider provider;
            if (this.tracer.debug) {
                this.tracer.log("[DiscoveryProviderRegistry] Getting provider '" + name + "'...", Tracer.Level.DEBUG);
            }
            if ((provider = this.providers.get(name)) == null) {
                if (this.tracer.debug) {
                    this.tracer.log("[DiscoveryProviderRegistry] Discovery provider not created. Creating...", Tracer.Level.DEBUG);
                }
                provider = this.createProvider(name);
                this.providers.put(name, provider);
            } else if (this.tracer.debug) {
                this.tracer.log("[DiscoveryProviderRegistry] Discovery provider already created. Returning...", Tracer.Level.DEBUG);
            }
            return provider;
        }
    }
}

