/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf.test.unit;

import com.neeve.pkt.PktBuffer;
import com.neeve.test.UnitTest;
import com.neeve.xbuf.XbufDoubleField;
import com.neeve.xbuf.XbufDoubleListField;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufFieldContainer;
import com.neeve.xbuf.XbufSchema;
import com.neeve.xbuf.test.unit.XbufStringFieldTest;
import java.nio.ByteOrder;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class XbufDoubleListFieldTest
extends UnitTest {
    private static Random random = new Random(System.currentTimeMillis());

    public static final double[] randomArray(int len) {
        double[] array = new double[len];
        for (int i = 0; i < array.length; ++i) {
            array[i] = random.nextDouble();
        }
        return array;
    }

    public static final void assertEqual(double[] array1, double[] array2, boolean array1EmptyIsArray2Null) {
        if (array1 == null) {
            Assert.assertNull((Object)array2);
        } else if (array1.length == 0) {
            if (array1EmptyIsArray2Null) {
                Assert.assertNull((Object)array2);
            } else {
                Assert.assertNotNull((Object)array2);
                Assert.assertTrue((array2.length == 0 ? 1 : 0) != 0);
            }
        } else {
            Assert.assertNotNull((Object)array2);
            Assert.assertEquals((long)array1.length, (long)array2.length);
            for (int i = 0; i < array1.length; ++i) {
                Assert.assertEquals((double)array1[i], (double)array2[i], (double)0.0);
            }
        }
    }

    public static final void assertEqual(double[] array1, double[] array2) {
        XbufDoubleListFieldTest.assertEqual(array1, array2, false);
    }

    private final XbufDoubleField field(XbufDoubleListField listField, double val) {
        XbufDoubleField field = XbufDoubleField.create(listField.id(), listField.name(), false);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field).build());
        field.setValue(val);
        return field;
    }

    private final XbufDoubleListField testSetClearSyncDesync(XbufDoubleListField field1) {
        double[] values = XbufDoubleListFieldTest.randomArray(0);
        field1.setValues(values);
        Assert.assertEquals((long)0L, (long)field1.getValues().size());
        XbufDoubleListFieldTest.assertEqual(values, field1.getValuesAsArray());
        Assert.assertEquals((long)0L, (long)field1.length());
        double value1 = random.nextDouble();
        field1.addValue(value1);
        values = new double[]{value1};
        Assert.assertEquals((long)1L, (long)field1.getValues().size());
        XbufDoubleListFieldTest.assertEqual(values, field1.getValuesAsArray());
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + 8), (long)field1.length());
        double value2 = random.nextDouble();
        field1.addValue(value2);
        values = new double[]{value1, value2};
        Assert.assertEquals((long)2L, (long)field1.getValues().size());
        XbufDoubleListFieldTest.assertEqual(values, field1.getValuesAsArray());
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + 8 + 8), (long)field1.length());
        double value3 = random.nextDouble();
        field1.getValuesOrNullIfNotSet().add(value3);
        values = new double[]{value1, value2, value3};
        Assert.assertEquals((long)3L, (long)field1.getValues().size());
        XbufDoubleListFieldTest.assertEqual(values, field1.getValuesAsArray());
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + this.field(field1, value3).headerLength() + 8 + 8 + 8), (long)field1.length());
        values = XbufDoubleListFieldTest.randomArray(1 + random.nextInt(20));
        field1.setValues(values);
        Assert.assertEquals((long)values.length, (long)field1.getValues().size());
        XbufDoubleListFieldTest.assertEqual(values, field1.getValuesAsArray());
        int len = 0;
        for (double i : values) {
            len += this.field(field1, i).headerLength() + 8;
        }
        Assert.assertEquals((long)len, (long)field1.length());
        values = XbufDoubleListFieldTest.randomArray(1 + random.nextInt(20));
        field1.setValues(values);
        Assert.assertTrue((boolean)field1.clearValue());
        Assert.assertFalse((boolean)field1.clearValue());
        Assert.assertEquals((long)0L, (long)field1.getValues().size());
        Assert.assertEquals((long)0L, (long)field1.getValuesAsArray().length);
        Assert.assertEquals((long)0L, (long)field1.length());
        PktBuffer buffer1 = PktBuffer.create(null, (int)256, (boolean)false);
        buffer1.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        field1.clearValue();
        Assert.assertEquals((long)0L, (long)field1.sync(buffer1, 23));
        values = XbufDoubleListFieldTest.randomArray(0);
        field1.setValues(values);
        Assert.assertEquals((long)0L, (long)field1.sync(buffer1, 23));
        value1 = random.nextDouble();
        field1.addValue(value1);
        values = new double[]{value1};
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + 8), (long)field1.sync(buffer1, 23));
        XbufDoubleListField field2 = XbufDoubleListField.create(field1.id(), field1.name());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + 8), (long)field2.desync(buffer1, 23));
        Assert.assertEquals((long)1L, (long)field2.getValues().size());
        XbufDoubleListFieldTest.assertEqual(values, field2.getValuesAsArray());
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + 8), (long)field2.length());
        value2 = random.nextDouble();
        field1.addValue(value2);
        values = new double[]{value1, value2};
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + 8 + 8), (long)field1.sync(buffer1, 23));
        field2 = XbufDoubleListField.create(field1.id(), field1.name());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        len = field2.desync(buffer1, 23);
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + 8), (long)len);
        len += field2.desync(buffer1, 23 + len);
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + 8 + 8), (long)len);
        Assert.assertEquals((long)2L, (long)field2.getValues().size());
        XbufDoubleListFieldTest.assertEqual(values, field2.getValuesAsArray());
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + 8 + 8), (long)field2.length());
        value3 = random.nextDouble();
        field1.getValuesOrNullIfNotSet().add(value3);
        values = new double[]{value1, value2, value3};
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + this.field(field1, value3).headerLength() + 8 + 8 + 8), (long)field1.sync(buffer1, 23));
        field2 = XbufDoubleListField.create(field1.id(), field1.name());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        len = field2.desync(buffer1, 23);
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + 8), (long)len);
        len += field2.desync(buffer1, 23 + len);
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + 8 + 8), (long)len);
        len += field2.desync(buffer1, 23 + len);
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + this.field(field1, value3).headerLength() + 8 + 8 + 8), (long)len);
        Assert.assertEquals((long)3L, (long)field2.getValues().size());
        XbufDoubleListFieldTest.assertEqual(values, field2.getValuesAsArray());
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + this.field(field1, value3).headerLength() + 8 + 8 + 8), (long)field2.length());
        values = XbufDoubleListFieldTest.randomArray(1 + random.nextInt(20));
        double[] doubleValues = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            doubleValues[i] = values[i];
        }
        field1.setValues(doubleValues);
        int expectedLen = 0;
        for (double i : values) {
            expectedLen += this.field(field1, i).headerLength() + 8;
        }
        Assert.assertEquals((long)expectedLen, (long)field1.sync(buffer1, 23));
        field2 = XbufDoubleListField.create(field1.id(), field1.name());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        len = 0;
        for (int i = 0; i < values.length; ++i) {
            len += field2.desync(buffer1, 23 + len);
        }
        Assert.assertEquals((long)expectedLen, (long)len);
        Assert.assertEquals((long)values.length, (long)field2.getValues().size());
        XbufDoubleListFieldTest.assertEqual(values, field2.getValuesAsArray());
        Assert.assertEquals((long)expectedLen, (long)field2.length());
        return field2;
    }

    @Test(expected=IllegalStateException.class)
    public final void testHasValue() {
        XbufDoubleListField field1 = XbufDoubleListField.create((short)1, null);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        field1.hasValue();
    }

    @Test
    public final void testInitialState() {
        short id = (short)random.nextInt(Short.MAX_VALUE);
        String name = XbufStringFieldTest.randomString();
        XbufDoubleListField field1 = XbufDoubleListField.create(id, name);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        Assert.assertEquals((Object)((Object)XbufField.Type.DOUBLE_LIST), (Object)((Object)field1.type()));
        Assert.assertEquals((long)id, (long)field1.id());
        Assert.assertEquals((Object)name, (Object)field1.name());
        Assert.assertFalse((boolean)field1.pinned());
        Assert.assertTrue((boolean)field1.repeating());
        Assert.assertFalse((boolean)field1.variableLength());
        Assert.assertEquals((long)0L, (long)field1.getValues().size());
        Assert.assertEquals((long)0L, (long)field1.getValuesAsArray().length);
        Assert.assertEquals((long)0L, (long)field1.length());
        Assert.assertEquals((Object)false, (Object)field1.getValueIterator().hasNext());
        field1 = XbufDoubleListField.create(id, null);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        Assert.assertEquals((Object)((Object)XbufField.Type.DOUBLE_LIST), (Object)((Object)field1.type()));
        Assert.assertEquals((long)id, (long)field1.id());
        Assert.assertNull((Object)field1.name());
        Assert.assertFalse((boolean)field1.pinned());
        Assert.assertTrue((boolean)field1.repeating());
        Assert.assertFalse((boolean)field1.variableLength());
        Assert.assertEquals((long)0L, (long)field1.getValues().size());
        Assert.assertEquals((long)0L, (long)field1.getValuesAsArray().length);
        Assert.assertEquals((long)0L, (long)field1.length());
        Assert.assertEquals((Object)false, (Object)field1.getValueIterator().hasNext());
    }

    @Test
    public final void testInitSetClearSyncDesync_Heap() throws Exception {
        XbufDoubleListField field1 = XbufDoubleListField.create((short)random.nextInt(Short.MAX_VALUE), null);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        this.testSetClearSyncDesync(this.testSetClearSyncDesync(field1));
    }

    @Test
    public final void testInitSetClearSyncDesync_Native() throws Exception {
        XbufDoubleListField field1 = XbufDoubleListField.create((short)random.nextInt(Short.MAX_VALUE), null);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)true)).setSchema(XbufSchema.builder().add(field1).build());
        this.testSetClearSyncDesync(this.testSetClearSyncDesync(field1));
    }

    @Test
    public final void testModificationAfterSync() throws Exception {
        XbufDoubleListField field1 = XbufDoubleListField.create((short)random.nextInt(Short.MAX_VALUE), null);
        XbufFieldContainer container1 = XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        field1.addValue(XbufDoubleListFieldTest.randomValue());
        container1.sync();
        int origLength = container1.getSerializedLength();
        for (int i = 0; i < 1024; ++i) {
            field1.addValue(XbufDoubleListFieldTest.randomValue());
        }
        int newLength = container1.getSerializedLength();
        Assert.assertTrue((String)("Field container serialized length should have increased orig: " + origLength + " now: " + newLength), (origLength < newLength ? 1 : 0) != 0);
    }

    private static final double randomValue() {
        return random.nextDouble();
    }
}

