/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf;

import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XShortIterator;
import com.neeve.pkt.PktBuffer;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufRepeatedShortFieldBuffer;

public final class XbufVariableShortListField
extends XbufField {
    private final Values values;
    private static final short[] EMPTY = new short[0];

    private XbufVariableShortListField(short id, String name) {
        super(XbufField.Type.VARSHORT_LIST, id, name, false, true);
        this.values = new Values(id);
    }

    public static XbufVariableShortListField create(short id, String name) {
        return new XbufVariableShortListField(id, name);
    }

    public static XbufRepeatedShortFieldBuffer createFieldBuffer(short id, int initialLength, boolean isNative) {
        return new XbufRepeatedShortFieldBuffer(id, initialLength, isNative);
    }

    private final Values getValues(boolean forWrite) {
        if (this.container == null) {
            throw new IllegalStateException("cannot get value for a field not in a container");
        }
        if (forWrite && this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        Values v = (Values)this.container.fieldValues[this.index];
        if (v == null) {
            this.values.reset();
            if (forWrite) {
                v = this.values;
                this.container.setValue(this, v, true);
            }
            return this.values;
        }
        if (forWrite) {
            this.container.markDirty(this, v);
        }
        return v;
    }

    @Override
    protected final int contentSync(PktBuffer buffer, int offset) {
        int totalLen = 0;
        Values v = this.getValuesOrNullIfNotSet();
        if (v != null && v.size() > 0) {
            buffer.putFrom(offset, (IOElasticBuffer)v.val, 0, v.length);
            return v.length;
        }
        return totalLen;
    }

    @Override
    protected final int contentDesync(PktBuffer buffer, int offset, int length) {
        int desyncLength = this.getValues(false).desyncAndAddValue(buffer, offset, length);
        this.container.setValue(this, this.values);
        return desyncLength;
    }

    @Override
    protected final int contentLength() {
        Values v = this.getValuesOrNullIfNotSet();
        if (v != null) {
            return v.serializedLength();
        }
        return 0;
    }

    @Override
    protected final String contentAsString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        Values v = this.getValuesOrNullIfNotSet();
        v.toString(sb);
        sb.append("]");
        return sb.toString();
    }

    @Override
    protected final boolean contentClear() {
        return this.container.clearValue(this);
    }

    public final void setValuesFrom(XbufVariableShortListField field) {
        if (field == null) {
            throw new IllegalArgumentException("field cannot be null");
        }
        if (field == this) {
            field.values.toFirst();
            return;
        }
        Values v = this.getValues(true);
        v.setValuesFrom(field.getValues());
    }

    public final void setValuesFrom(XShortIterator val) {
        if (val == null) {
            throw new IllegalArgumentException("cannot set a list field to null");
        }
        Values v = this.getValues(true);
        if (v == val) {
            val.toFirst();
            return;
        }
        v.setValuesFrom(val);
    }

    public final void setValues(short[] val) {
        if (val == null) {
            throw new IllegalArgumentException("cannot set a list field to null");
        }
        Values v = this.getValues(true);
        v.reset();
        for (int i = 0; i < val.length; ++i) {
            v.add(val[i]);
        }
    }

    public final void addValue(short val) {
        this.getValues(true).add(val);
    }

    public final Values getValues() {
        return this.getValues(false);
    }

    public final Values getValuesOrNullIfNotSet() {
        if (this.container == null) {
            throw new IllegalStateException("cannot get value for a field not in a container");
        }
        return (Values)this.container.fieldValues[this.index];
    }

    public final short[] getValuesAsArray() {
        Values v = this.getValuesOrNullIfNotSet();
        if (v == null || v.size() == 0) {
            return EMPTY;
        }
        short[] ret = new short[v.size()];
        int current = v.current;
        v.toFirst();
        int i = 0;
        while (v.hasNext()) {
            ret[i++] = v.next();
        }
        v.current = current;
        return ret;
    }

    public final Values getValueIterator() {
        return (Values)this.getValues(false).toFirst();
    }

    public static final class Values
    extends XbufRepeatedShortFieldBuffer {
        Values(short id) {
            super(id, 1, true);
        }

        public final int size() {
            return this.count();
        }
    }
}

