/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf;

import com.google.protobuf.CodedOutputStream;
import com.neeve.pkt.PktBuffer;
import com.neeve.xbuf.XbufField;
import java.util.Date;

public final class XbufVariableDateField
extends XbufField {
    private final Value value = new Value();

    private XbufVariableDateField(short id, String name) {
        super(XbufField.Type.VARDATE, id, name, false);
    }

    public static final XbufVariableDateField create(short id, String name) {
        return new XbufVariableDateField(id, name);
    }

    final int serializedLength(long val) {
        return CodedOutputStream.computeRawVarint64Size((long)val);
    }

    final int serialize(PktBuffer buffer, int offset, long val) {
        return XbufVariableDateField.syncVarint64(val, buffer, offset);
    }

    final long deserialize(PktBuffer buffer, int offset) {
        return XbufVariableDateField.desyncVarint64(buffer, offset, this.varintDesyncLength);
    }

    final String toString(Date val) {
        return val == null ? null : String.valueOf(val);
    }

    @Override
    protected final int contentSync(PktBuffer buffer, int offset) {
        return this.serialize(buffer, offset, this.getValueAsTimestamp());
    }

    @Override
    protected final int contentDesync(PktBuffer buffer, int offset, int length) {
        this.value.val = this.deserialize(buffer, offset);
        this.container.setValue(this, this.value);
        return this.varintDesyncLength.value;
    }

    @Override
    protected final int contentLength() {
        return this.serializedLength(this.getValueAsTimestamp());
    }

    @Override
    protected final String contentAsString() {
        return this.toString(this.getValue());
    }

    @Override
    protected final boolean contentClear() {
        this.value.val = -1L;
        return this.container.clearValue(this);
    }

    public final void setValue(Date val) {
        long valAsTimestamp;
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        this.value.val = valAsTimestamp = val == null ? -1L : val.getTime();
        this.container.setValue(this, this.value);
    }

    public final void setValueAsTimestamp(long val) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        this.value.val = val;
        this.container.setValue(this, this.value);
    }

    public final void setValueFrom(XbufVariableDateField field) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        if (field == null) {
            throw new IllegalArgumentException("field cannot be null");
        }
        throw new UnsupportedOperationException();
    }

    public final Date getValue() {
        long valAsTimestamp = this.getValueAsTimestamp();
        return valAsTimestamp >= 0L ? new Date(valAsTimestamp) : null;
    }

    public final long getValueAsTimestamp() {
        if (this.container == null) {
            throw new IllegalStateException("cannot get value for a field not in a container");
        }
        if (this.container.framed[this.index]) {
            return this.deserialize(this.buffer, this.contentOffset);
        }
        Value value = (Value)this.container.fieldValues[this.index];
        return value != null ? value.val : -1L;
    }

    static final int serializeField(PktBuffer buffer, int offset, short id, Date v) {
        long timestamp = v == null ? -1L : v.getTime();
        int headerLength = XbufVariableDateField.syncHeader(buffer, offset, id, XbufField.Type.VARDATE, CodedOutputStream.computeRawVarint64Size((long)timestamp));
        int valLength = XbufVariableDateField.syncVarint64(timestamp, buffer, offset + headerLength);
        return headerLength + valLength;
    }

    static final int serializeFieldAsTimestamp(PktBuffer buffer, int offset, short id, long timestamp) {
        int headerLength = XbufVariableDateField.syncHeader(buffer, offset, id, XbufField.Type.VARDATE, CodedOutputStream.computeRawVarint64Size((long)timestamp));
        int valLength = XbufVariableDateField.syncVarint64(timestamp, buffer, offset + headerLength);
        return headerLength + valLength;
    }

    public static int serializedFieldLength(short id, Date v) {
        long timestamp = v == null ? -1L : v.getTime();
        int len = CodedOutputStream.computeRawVarint64Size((long)timestamp);
        return len + XbufVariableDateField.headerLength(id, XbufField.Type.VARDATE, len);
    }

    static final Date deserializeValue(PktBuffer buffer, int offset, XbufField.VarintDesyncLength varintDesyncLength) {
        long timestamp = XbufVariableDateField.desyncVarint64(buffer, offset, varintDesyncLength);
        if (timestamp == -1L) {
            return null;
        }
        return new Date(timestamp);
    }

    static final Date deserializeField(PktBuffer buffer, int offset, short id, XbufField.VarintDesyncLength varintDesyncLength) {
        int tag = XbufVariableDateField.desyncVarint32(buffer, offset, varintDesyncLength);
        int tagLength = varintDesyncLength.value;
        if (id != XbufVariableDateField.fieldId(tag)) {
            throw new IllegalArgumentException("attempt to desync a field using a different field on the wire!");
        }
        Date value = XbufVariableDateField.deserializeValue(buffer, offset + tagLength, varintDesyncLength);
        varintDesyncLength.value += tagLength;
        return value;
    }

    static final long deserializeValueAsTimestamp(PktBuffer buffer, int offset, XbufField.VarintDesyncLength varintDesyncLength) {
        return XbufVariableDateField.desyncVarint64(buffer, offset, varintDesyncLength);
    }

    static final long deserializeFieldAsTimestamp(PktBuffer buffer, int offset, short id, XbufField.VarintDesyncLength varintDesyncLength) {
        int tag = XbufVariableDateField.desyncVarint32(buffer, offset, varintDesyncLength);
        int tagLength = varintDesyncLength.value;
        if (id != XbufVariableDateField.fieldId(tag)) {
            throw new IllegalArgumentException("attempt to desync a field using a different field on the wire!");
        }
        long value = XbufVariableDateField.deserializeValueAsTimestamp(buffer, offset + tagLength, varintDesyncLength);
        varintDesyncLength.value += tagLength;
        return value;
    }

    private final class Value {
        long val;

        private Value() {
        }
    }
}

