/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf;

import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XDoubleIterator;
import com.neeve.pkt.PktBuffer;
import com.neeve.xbuf.XbufDoubleField;
import com.neeve.xbuf.XbufField;
import java.nio.ByteOrder;
import java.util.NoSuchElementException;

public class XbufRepeatedDoubleFieldBuffer
implements XDoubleIterator {
    static final double[] EMPTY_ARRAY = new double[0];
    final PktBuffer val;
    final XbufField.VarintDesyncLength desyncLength = new XbufField.VarintDesyncLength();
    final short id;
    int current;
    int length;
    int count;

    XbufRepeatedDoubleFieldBuffer(short id, int initialLength, boolean isNative) {
        this.id = id;
        this.val = PktBuffer.create((IOElasticBuffer.Sizer)null, (int)initialLength, (boolean)isNative);
        this.val.setByteOrder(ByteOrder.LITTLE_ENDIAN);
    }

    public final short getFieldId() {
        return this.id;
    }

    public final void clear() throws IllegalStateException {
        this.reset();
    }

    final XbufRepeatedDoubleFieldBuffer reset() {
        if (this.count > 0) {
            this.val.setLength(0);
            this.count = 0;
            this.current = 0;
            this.length = 0;
        }
        return this;
    }

    final int desyncAndAddValue(PktBuffer buffer, int offset, int length) {
        this.add(XbufDoubleField.deserializeValue(buffer, offset, this.desyncLength));
        return this.desyncLength.value;
    }

    final int copyInto(IOElasticBuffer buffer, int offset) {
        if (this.length == 0) {
            return 0;
        }
        buffer.putFrom(offset, (IOElasticBuffer)this.val, 0, this.length);
        return this.length;
    }

    final int serializedLength() {
        return this.length;
    }

    final int count() {
        return this.count;
    }

    public final void add(double v) {
        this.length += XbufDoubleField.serializeField(this.val, this.length, this.id, v);
        ++this.count;
    }

    public final void setValuesFrom(XbufRepeatedDoubleFieldBuffer values) {
        this.reset();
        if (this.isBufferCopyPossibleFrom(values)) {
            this.val.putFrom(0, (IOElasticBuffer)values.val, 0, values.length);
            this.length = values.length;
            this.count = values.count;
        } else {
            values.toFirst();
            while (values.hasNext()) {
                this.add(values.next());
            }
            values.toFirst();
        }
    }

    public final void setValuesFrom(XDoubleIterator values) {
        if (values instanceof XbufRepeatedDoubleFieldBuffer) {
            this.setValuesFrom((XbufRepeatedDoubleFieldBuffer)values);
        } else {
            this.reset();
            values.toFirst();
            while (values.hasNext()) {
                this.add(values.next());
            }
            values.toFirst();
        }
    }

    public final boolean hasNext() {
        return this.current < this.length;
    }

    public final double next() {
        if (this.hasNext()) {
            double v = XbufDoubleField.deserializeField(this.val, this.current, this.id, this.desyncLength);
            this.current += this.desyncLength.value;
            return v;
        }
        throw new NoSuchElementException("no more elements");
    }

    public final void remove() {
        throw new UnsupportedOperationException("remove is not supported for xbuf field iterators.");
    }

    public final XbufRepeatedDoubleFieldBuffer toFirst() {
        this.current = 0;
        return this;
    }

    private final boolean isBufferCopyPossibleFrom(XbufRepeatedDoubleFieldBuffer source) {
        return source.getFieldId() == this.getFieldId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final double[] toArray() {
        if (this.count == 0) {
            return EMPTY_ARRAY;
        }
        double[] ret = new double[this.count];
        int c = this.current;
        try {
            this.toFirst();
            int i = 0;
            while (this.hasNext()) {
                ret[i++] = this.next();
            }
        }
        finally {
            this.current = c;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final Appendable toString(Appendable to) {
        int c = this.current;
        try {
            this.toFirst();
            while (this.hasNext()) {
                try {
                    to.append(String.valueOf(this.next()));
                    if (!this.hasNext()) continue;
                    to.append(",");
                }
                catch (Throwable t) {
                    throw new RuntimeException(t.getMessage(), t);
                    return to;
                }
            }
        }
        finally {
            this.current = c;
        }
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }
}

