/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf;

import com.neeve.lang.XFloatArrayIterator;
import com.neeve.lang.XFloatIterator;
import com.neeve.pkt.PktBuffer;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufVariableLengthField;
import java.util.Arrays;
import java.util.NoSuchElementException;

public final class XbufFloatArrayField
extends XbufVariableLengthField<float[]> {
    private final Iterator iterator = new Iterator();

    private XbufFloatArrayField(short id, String name) {
        super(XbufField.Type.FLOAT_ARRAY, id, name);
    }

    public static XbufFloatArrayField create(short id, String name) {
        return new XbufFloatArrayField(id, name);
    }

    @Override
    protected final int serializedLength(float[] val) {
        return val == null ? 0 : val.length * 4;
    }

    @Override
    protected final int serialize(PktBuffer buffer, int offset, float[] val) {
        buffer.putFrom(offset, val, 0, val.length);
        return val.length * 4;
    }

    @Override
    protected final float[] deserialize(PktBuffer buffer, int offset, int length) {
        float[] val = new float[length / 4];
        if (length > 0) {
            buffer.getTo(offset, val, 0, val.length);
        }
        return val;
    }

    public final void setValues(float[] values) {
        super.setValue(values);
    }

    public final float[] getValuesAsArray() {
        return (float[])super.getValue();
    }

    public final float[] getValuesOrNullIfNotSet() {
        return (float[])super.getValue();
    }

    public final void setValuesFrom(XFloatIterator val) {
        float[] v;
        if (val instanceof Iterator) {
            v = ((Iterator)val).array();
        } else if (val instanceof XFloatArrayIterator) {
            XFloatArrayIterator a = (XFloatArrayIterator)val;
            v = a.array();
            if (v.length != a.length()) {
                v = new float[a.length()];
                System.arraycopy(a.array(), a.offset(), v, 0, a.length());
            }
        } else {
            int size = 0;
            val.toFirst();
            while (val.hasNext()) {
                ++size;
                val.next();
            }
            v = new float[size];
            val.toFirst();
            for (int i = 0; i < v.length; ++i) {
                v[i] = val.next();
            }
        }
        this.setValue(v);
        val.toFirst();
    }

    public final void addValue(float val) {
        float[] vArray;
        float[] existing = (float[])this.getValue();
        if (this.getValue() == null) {
            vArray = new float[1];
        } else {
            vArray = new float[existing.length + 1];
            System.arraycopy(existing, 0, vArray, 0, existing.length);
            vArray[vArray.length - 1] = val;
        }
        this.setValue(vArray);
    }

    public final Iterator getValueIterator() {
        return this.iterator.toFirst();
    }

    @Override
    protected final String toString(float[] val) {
        return Arrays.toString(val);
    }

    public final class Iterator
    implements XFloatIterator {
        int current = 0;

        public float[] array() {
            return (float[])XbufFloatArrayField.this.getValue();
        }

        public final boolean hasNext() {
            float[] value = (float[])XbufFloatArrayField.this.getValue();
            return value != null && this.current < value.length;
        }

        public float next() {
            float[] val = (float[])XbufFloatArrayField.this.getValue();
            if (val == null) {
                throw new NoSuchElementException();
            }
            return ((float[])XbufFloatArrayField.this.getValue())[this.current++];
        }

        public final void remove() {
            throw new UnsupportedOperationException("remove is not supported for xbuf field iterators.");
        }

        public final Iterator toFirst() {
            this.current = 0;
            return this;
        }
    }
}

