/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma.impl;

import com.neeve.ci.XRuntime;
import com.neeve.lang.XCollection;
import com.neeve.lang.XIndexedList;
import com.neeve.lang.XLinkedHashMap;
import com.neeve.lang.XString;
import com.neeve.sma.impl.BuiltInChannelKeyFunctions;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlThrowable;
import java.lang.reflect.Method;

public class MessageChannelKeyFunctionRegistry {
    private static final Tracer sTracer = Tracer.get((String)"nv.sma");
    public static final String PROP_CHANNEL_KEY_FUNCTION_CONTAINERS = "nv.sma.channelkeyfunctioncontainers";
    public static final XLinkedHashMap<String, XIndexedList<Method>> keyFunctions = new XLinkedHashMap();

    private static final void registerKeyFunctions(Class<?> functionContainer) {
        Method[] availableFunctions = functionContainer.getDeclaredMethods();
        block0: for (int i = 0; i < availableFunctions.length; ++i) {
            Method candidate = availableFunctions[i];
            if ((candidate.getModifiers() & 8) == 0) {
                if (!MessageChannelKeyFunctionRegistry.sTracer.debug) continue;
                sTracer.log("Ignoring non static key function " + candidate.toGenericString(), Tracer.Level.DEBUG);
                continue;
            }
            if (candidate.getReturnType() != Void.TYPE) {
                if (!MessageChannelKeyFunctionRegistry.sTracer.debug) continue;
                sTracer.log("Ignoring key function with non null return type " + candidate.toGenericString(), Tracer.Level.DEBUG);
                continue;
            }
            if (candidate.getParameterTypes() == null || candidate.getParameterTypes().length < 1) {
                if (!MessageChannelKeyFunctionRegistry.sTracer.debug) continue;
                sTracer.log("Ignoring key function with too few arguments " + candidate.toGenericString(), Tracer.Level.DEBUG);
                continue;
            }
            for (int m = 0; m < candidate.getParameterTypes().length; ++m) {
                if (candidate.getParameterTypes()[0].isAssignableFrom(XString.class)) continue;
                if (!MessageChannelKeyFunctionRegistry.sTracer.debug) continue block0;
                sTracer.log("Ignoring key function with non XString parameter " + candidate.toGenericString(), Tracer.Level.DEBUG);
                continue block0;
            }
            XIndexedList methods = (XIndexedList)keyFunctions.get((Object)candidate.getName());
            if (methods == null) {
                methods = new XIndexedList(10);
                keyFunctions.put((Object)candidate.getName(), (Object)methods);
            }
            methods.add(0, (Object)candidate);
            sTracer.log("ADDED " + candidate.toGenericString() + " to available channel key functions,", Tracer.Level.CONFIG);
        }
    }

    static final Method lookup(String functionName, int argCount) {
        XCollection methods = (XCollection)keyFunctions.get((Object)functionName);
        if (methods == null) {
            throw new IllegalArgumentException("No function found matching '" + functionName + "'");
        }
        for (Method method : methods) {
            if (method.getParameterTypes().length != argCount + 1) continue;
            return method;
        }
        return null;
    }

    static {
        MessageChannelKeyFunctionRegistry.registerKeyFunctions(BuiltInChannelKeyFunctions.class);
        String customKeyFunctions = XRuntime.getValue((String)PROP_CHANNEL_KEY_FUNCTION_CONTAINERS, null);
        if (customKeyFunctions != null) {
            for (String keyClassName : customKeyFunctions.split(",")) {
                try {
                    Class<?> keyClass = Class.forName(keyClassName);
                    MessageChannelKeyFunctionRegistry.registerKeyFunctions(keyClass);
                }
                catch (Throwable t) {
                    sTracer.log("Error loading channel key function container: " + UtlThrowable.prepareStackTrace((Throwable)t), Tracer.Level.SEVERE);
                }
            }
        }
    }
}

