/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.perf.aep.engine;

import com.neeve.aep.AepEngine;
import com.neeve.aep.AepMessageSender;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.perf.aep.engine.messages.FinalMessage;
import com.neeve.server.app.annotations.AppInjectionPoint;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

class Processor {
    private File _bookFile;
    private XSSFWorkbook _book;
    private XSSFCell[] _cells;
    private boolean _outputThroughput;
    protected AepEngine _engine;
    protected AepMessageSender _messageSender;

    Processor() throws IOException {
        String outputFilename = System.getProperty("OUTPUT_FILE");
        if (outputFilename != null) {
            int cellNum;
            int rowNum;
            XSSFSheet sheet;
            this._bookFile = new File(outputFilename);
            if (!this._bookFile.exists()) {
                throw new IllegalArgumentException("specified output file '" + outputFilename + "' does not exist");
            }
            if (!this._bookFile.isFile()) {
                throw new IllegalArgumentException("specified output file '" + outputFilename + "' is a directory");
            }
            this._book = new XSSFWorkbook((InputStream)new FileInputStream(this._bookFile));
            try {
                sheet = this._book.getSheetAt(0);
                System.out.println("Output sheet is '" + sheet.getSheetName() + "'");
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("specified output file '" + outputFilename + "' does not have a sheet");
            }
            this._outputThroughput = Boolean.valueOf(System.getProperty("OUTPUT_THROUGHPUT"));
            String cellSpec = System.getProperty("OUTPUT_CELL");
            if (cellSpec == null) {
                throw new IllegalArgumentException("output cell needs to be specified");
            }
            String[] splitCellSpec = cellSpec.split("-");
            if (splitCellSpec.length != 2) {
                throw new IllegalArgumentException("cell needs to be in <ROW>-<COLUMN> format");
            }
            try {
                rowNum = Integer.parseInt(splitCellSpec[0]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("invalid row '" + splitCellSpec[0] + " in specified cell '" + cellSpec + "'");
            }
            XSSFRow row = sheet.getRow(rowNum);
            if (row == null) {
                throw new IllegalArgumentException("row '" + splitCellSpec[0] + " is not in the sheet");
            }
            try {
                cellNum = Integer.parseInt(splitCellSpec[1]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("invalid cell '" + splitCellSpec[1] + " in specified cell '" + cellSpec + "'");
            }
            this._cells = new XSSFCell[3];
            this._cells[0] = row.getCell(cellNum, Row.MissingCellPolicy.RETURN_NULL_AND_BLANK);
            if (this._cells[0] == null) {
                throw new IllegalArgumentException("cell '" + cellNum + " is not in the sheet");
            }
            if (!this._outputThroughput) {
                this._cells[1] = row.getCell(++cellNum, Row.MissingCellPolicy.RETURN_NULL_AND_BLANK);
                if (this._cells[1] == null) {
                    throw new IllegalArgumentException("cell '" + cellNum + " is not in the sheet");
                }
                this._cells[2] = row.getCell(++cellNum, Row.MissingCellPolicy.RETURN_NULL_AND_BLANK);
                if (this._cells[2] == null) {
                    throw new IllegalArgumentException("cell '" + cellNum + " is not in the sheet");
                }
            }
        }
    }

    @AppInjectionPoint
    public final void setEngine(AepEngine engine) {
        this._engine = engine;
    }

    @AppInjectionPoint
    public final void setMessageSender(AepMessageSender messageSender) {
        this._messageSender = messageSender;
    }

    @EventHandler
    public final void onMessage(FinalMessage finalMessage) throws Exception {
        if (this._book != null) {
            int throughput = finalMessage.getThroughput().getPostWarmup();
            double w2wMean = finalMessage.getLatencies().getW2w().getMean() / 1000.0;
            double w2wMedian = (double)finalMessage.getLatencies().getW2w().getPct50() / 1000.0;
            double w2w99th = (double)finalMessage.getLatencies().getW2w().getPct99() / 1000.0;
            if (this._outputThroughput) {
                this._cells[0].setCellValue((double)throughput);
            } else {
                this._cells[0].setCellValue(w2wMean);
                this._cells[1].setCellValue(w2wMedian);
                this._cells[2].setCellValue(w2w99th);
            }
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(this._bookFile));
            this._book.write((OutputStream)bos);
            bos.close();
            this._book.close();
        }
        this._engine.setAsLastTransaction(null, true, true);
    }
}

