/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods.impl;

import com.neeve.ods.IStoreSender;
import com.neeve.ods.IStoreSenderStats;
import com.neeve.ods.OdsException;
import com.neeve.ods.StoreInterClusterReplicatorDescriptor;
import com.neeve.ods.impl.StoreSenderReceiver;
import com.neeve.ods.impl.StoreSenderStats;
import com.neeve.pkt.PktBuffer;
import com.neeve.pkt.PktPacket;
import com.neeve.sma.MessageView;
import com.neeve.sma.RawMessageViewFactory;
import com.neeve.sma.SmaException;
import com.neeve.sma.event.MessageEvent;
import com.neeve.trace.Tracer;
import java.util.concurrent.atomic.AtomicInteger;

public final class StoreSender
extends StoreSenderReceiver
implements IStoreSender {
    private static final AtomicInteger counter = new AtomicInteger();
    private final RawMessageViewFactory rawMessageViewFactory = RawMessageViewFactory.create(null);
    private final StoreSenderStats stats;

    private StoreSender(String storeName, StoreInterClusterReplicatorDescriptor descriptor) throws OdsException {
        super("ICR-Sender-" + storeName + "-" + counter.incrementAndGet(), storeName, descriptor);
        this.stats = new StoreSenderStats(this, storeName, "nv.ods.sender." + storeName + ".stats.interval");
        super.setStats(this.stats);
    }

    public static final StoreSender create(String storeName, StoreInterClusterReplicatorDescriptor descriptor) throws OdsException {
        if (storeName == null) {
            throw new IllegalArgumentException("store name cannot be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("descriptor cannot be null");
        }
        descriptor.setProperty("shared", "true");
        return new StoreSender(storeName, descriptor);
    }

    @Override
    protected final void doWritePersisterMetadata(PktBuffer metadata) throws Exception {
    }

    @Override
    protected final void doWrite(PktPacket packet) throws Exception {
        if (this.failure == null) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix() + "Sending packet " + packet + "...", Tracer.Level.DEBUG);
            }
            try {
                MessageView view = this.rawMessageViewFactory.wrap((short)0, 1, (Object)packet);
                this.channel.sendMessage(view, null, 30);
                view.dispose();
            }
            catch (SmaException e) {
                e.printStackTrace();
                throw new OdsException(e);
            }
        }
    }

    @Override
    protected final void doFlush(boolean sync) throws Exception {
        if (this.failure == null) {
            try {
                this.binding.flush(null);
            }
            catch (SmaException e) {
                throw new OdsException(e);
            }
        }
    }

    @Override
    protected final void onMessageEvent(MessageEvent event) {
        throw new InternalError("onMessageEvent() called for an ICR sender");
    }

    @Override
    public final IStoreSenderStats getStats() {
        return this.stats;
    }
}

