/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods.impl;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Sets;
import com.neeve.adm.AdmGenerator;
import com.neeve.ods.IStoreField;
import com.neeve.ods.IStoreObject;
import com.neeve.ods.impl.StoreQueryFieldImpl;
import com.neeve.ods.impl.StoreQueryFieldWrapper;
import com.neeve.query.QueryException;
import com.neeve.query.impl.QueryDefaultFieldResolver;
import com.neeve.query.impl.util.UtlQueryReflection;
import com.neeve.query.index.IdxFieldResolver;
import com.neeve.trace.Tracer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class StoreQueryFieldResolverImpl
extends QueryDefaultFieldResolver<IStoreObject>
implements IdxFieldResolver<IStoreObject> {
    private LinkedHashMultimap<String, Class<?>> unqualifiedTypes = LinkedHashMultimap.create();
    public final IStoreField<String> REPOSITORY_NAME_FIELD;
    public final IStoreField<Object> SELECT_ALL_FIELD = new StoreQueryFieldWrapper<Object>(super.getSelectAllField());

    public StoreQueryFieldResolverImpl(Class<IStoreObject> concreteBaseType) {
        super(concreteBaseType);
        this.REPOSITORY_NAME_FIELD = new StoreQueryFieldWrapper<String>(super.getRepositoryNameField());
    }

    private void validateFieldPath(Class<?> objectType, Class<?>[] pathTypes, String fieldPath) {
        if (objectType != Object.class && !IStoreObject.class.isAssignableFrom(objectType)) {
            throw new QueryException("Invalid field, field type must be an entity: " + objectType);
        }
        for (int i = 0; i < pathTypes.length; ++i) {
            Class<?> type = pathTypes[i];
            if (type == Object.class || !IStoreObject.class.isAssignableFrom(type)) continue;
            throw new QueryException("Invalid fieldPath, nested field paths only supported for types declared asEmbedded: " + this + ", " + StoreQueryFieldResolverImpl.reconstructFieldPath(fieldPath.split("\\."), i) + ".");
        }
    }

    private final void registerDiscoveredType(Class<?> returnType) {
        boolean added = this.unqualifiedTypes.put((Object)returnType.getSimpleName(), returnType);
        if (added) {
            if (this.tracer.debug) {
                this.tracer.log("Registering type: " + returnType.getName(), Tracer.Level.DEBUG);
            }
            if (!returnType.isInterface()) {
                try {
                    Method getFields = returnType.getMethod("getFields", new Class[0]);
                    if (getFields != null && (getFields.getModifiers() & 8) != 0) {
                        List fields = (List)getFields.invoke(returnType, new Object[0]);
                        for (IStoreField field : fields) {
                            if (!this.tracer.debug) continue;
                            this.tracer.log("Discovered field: " + field, Tracer.Level.DEBUG);
                        }
                    }
                }
                catch (SecurityException e) {
                    if (this.tracer.debug) {
                        this.tracer.log("Registered type has inaccessible getFields method: " + returnType.getName(), Tracer.Level.DEBUG);
                    }
                }
                catch (NoSuchMethodException e) {
                    if (this.tracer.debug) {
                        this.tracer.log("Registered type has not getFields method: " + returnType.getName(), Tracer.Level.DEBUG);
                    }
                }
                catch (InvocationTargetException e) {
                    this.tracer.log("Error getting declared fields for : " + returnType.getName() + ": " + e.getTargetException().getMessage(), Tracer.Level.WARNING);
                }
                catch (IllegalAccessException e) {
                    this.tracer.log("Error getting declared fields for : " + returnType.getName() + ": " + e.getMessage(), Tracer.Level.WARNING);
                }
                catch (Throwable thrown) {
                    this.tracer.log("Error getting declared fields for : " + returnType.getName() + ": " + thrown.getMessage(), Tracer.Level.WARNING);
                }
            }
        }
    }

    protected final void checkForPossibleNestedEntities(Class<?> objectType, String fieldPath, Class<?> fieldType) {
        if (IStoreObject.class.isAssignableFrom(fieldType) && fieldPath != null && fieldPath.length() > 0) {
            throw new QueryException("Invalid fieldPath, nested field paths only supported for types declared asEmbedded: " + objectType.getSimpleName() + ", " + fieldPath + ".");
        }
        if (objectType == Object.class) {
            for (Class<?> type : this.getTypes()) {
                Class<?>[] pathTypes;
                if (!objectType.isAssignableFrom(type) || (pathTypes = UtlQueryReflection.getBeanPathTypes(type, fieldPath)) == null || !fieldType.isAssignableFrom(pathTypes[pathTypes.length - 1])) continue;
                this.validateFieldPath(objectType, pathTypes, fieldPath);
            }
        } else {
            this.validateFieldPath(objectType, UtlQueryReflection.getBeanPathTypes(objectType, fieldPath), fieldPath);
        }
    }

    @Override
    protected final Class<?> resolveFieldType(Class<?> objectType, String fieldPath) {
        Class returnType = super.resolveFieldType(objectType, fieldPath);
        if (returnType == null) {
            String exampleType = null;
            HashSet returnTypes = Sets.newHashSet();
            String typePath = fieldPath;
            if (fieldPath.length() > 7 && fieldPath.startsWith("object.")) {
                fieldPath = fieldPath.substring(7);
            }
            for (Class<?> type : this.getTypes()) {
                Class<?> rt;
                if (!objectType.isAssignableFrom(type) || (rt = super.resolveFieldType(type, typePath)) == null) continue;
                returnTypes.add(rt);
                if (exampleType != null) continue;
                exampleType = type.getSimpleName();
            }
            if (returnTypes.isEmpty()) {
                throw new QueryException("The path [" + objectType.getSimpleName() + "." + fieldPath + "] could not be resolved");
            }
            if (returnTypes.size() > 1) {
                throw new QueryException("The path [" + objectType.getSimpleName() + "." + fieldPath + "] is ambiguous. Please specify a concrete path such as [" + exampleType + "." + fieldPath + "]");
            }
            returnType = (Class)returnTypes.iterator().next();
            if (returnType != null) {
                this.cacheReturnType(objectType, fieldPath, returnType);
            }
        }
        return returnType;
    }

    protected static final String reconstructFieldPath(String[] paths, int index) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i <= index; ++i) {
            if (i > 0) {
                sb.append(".");
            }
            sb.append(paths[i]);
        }
        return sb.toString();
    }

    public void addFactory(Class<?> factoryClass) {
        for (Method method : factoryClass.getMethods()) {
            Class<?> returnType;
            if ((method.getModifiers() & 8) == 0 || (method.getModifiers() & 1) == 0 || (returnType = method.getReturnType()) == null || method.getParameterTypes().length > 0 && (method.getParameterTypes().length != 1 || method.getParameterTypes()[0] != Integer.TYPE || !IStoreObject.class.isAssignableFrom(returnType))) continue;
            this.registerDiscoveredType(returnType);
            try {
                Class<?> intfType = Class.forName(returnType.getPackage().getName() + '.' + AdmGenerator.interfaceName((String)returnType.getSimpleName()));
                this.registerDiscoveredType(intfType);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public Collection<Class<?>> getTypes() {
        return this.unqualifiedTypes.values();
    }

    public final <T> IStoreField<T> getField(String recordTypeName, String fieldPath) {
        return (IStoreField)super.getField(recordTypeName, fieldPath);
    }

    public final <T> IStoreField<T> getField(Class<?> objectType, String fieldPath) {
        return (IStoreField)super.getField(objectType, fieldPath);
    }

    public <T> IStoreField<T> getField(Class<?> recordType, String fieldPath, Class<T> fieldType, Class<?> ... pathTypes) {
        String fieldName = fieldPath;
        fieldName = recordType != Object.class ? recordType.getSimpleName() + "." + fieldPath : fieldPath;
        this.checkForPossibleNestedEntities(recordType, fieldPath, fieldType);
        return new StoreQueryFieldImpl<T>(fieldName, recordType, fieldPath, fieldType, pathTypes);
    }

    @Override
    public Class<?> resolveType(String className) {
        Set classes;
        Class<?> resolvedType = super.resolveType(className);
        if (resolvedType == null && (classes = this.unqualifiedTypes.get((Object)className)) != null && !classes.isEmpty()) {
            if (classes.size() == 1) {
                return (Class)classes.iterator().next();
            }
            throw new QueryException("Type '" + className + "' is ambiguous. Found " + classes.size() + " potential matches, need a qualified class name");
        }
        return resolvedType;
    }

    public final IStoreField<Object> getSelectAllField() {
        return this.SELECT_ALL_FIELD;
    }

    public final IStoreField<String> getRepositoryNameField() {
        return this.REPOSITORY_NAME_FIELD;
    }
}

