/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods;

import com.neeve.io.IOElasticBuffer;
import com.neeve.ods.IStoreObjectMetadata;
import com.neeve.ods.OdsUnsupportedEncodingException;
import com.neeve.pkt.PktBuffer;
import com.neeve.pkt.PktPacket;
import com.neeve.util.UtlReferenceTracker;

public interface IStoreObject
extends UtlReferenceTracker.HasReferenceTracker,
IStoreObjectMetadata {
    public IStoreObjectMetadata getStoreMetadata();

    public boolean getIsReadOnly();

    public IStoreObject setFieldValue(long var1, Object var3);

    public EncodingType getContentEncodingType();

    public int getSerializedMetadataLength();

    public int serializeMetadata(IOElasticBuffer var1, int var2);

    public PktPacket serialize();

    public IStoreObject deserializeMetadata(PktBuffer var1);

    public IStoreObject deserializeMetadata(PktBuffer var1, boolean var2);

    public IStoreObject deserialize(PktPacket var1);

    public void acquire();

    public int getOwnershipCount();

    public int dispose();

    public void saveMemory();

    public static enum EncodingType {
        Custom(1),
        Quark(6),
        Xbuf(3),
        Xbuf2(7),
        Protobuf(4),
        Json(5);

        final int messageViewEncoding;

        private EncodingType(int messageViewEncoding) {
            this.messageViewEncoding = messageViewEncoding;
        }

        public final int toMessageViewEncoding() {
            return this.messageViewEncoding;
        }

        public static final EncodingType fromMessageViewEncoding(int messageViewEncoding) {
            switch (messageViewEncoding) {
                case 0: {
                    return null;
                }
                case 1: {
                    return Custom;
                }
                case 6: {
                    return Quark;
                }
                case 3: {
                    return Xbuf;
                }
                case 7: {
                    return Xbuf2;
                }
                case 4: {
                    return Protobuf;
                }
                case 5: {
                    return Json;
                }
            }
            throw new OdsUnsupportedEncodingException("Unknown message view encoding: " + messageViewEncoding);
        }
    }
}

