/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util;

import com.lmax.disruptor.BatchEventProcessor;
import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.BusySpinWaitStrategy;
import com.lmax.disruptor.ClaimStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.MultiThreadedClaimStrategy;
import com.lmax.disruptor.MultiThreadedLowContentionClaimStrategy;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.SingleThreadedClaimStrategy;
import com.lmax.disruptor.SleepingWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.YieldingWaitStrategy;
import com.neeve.util.UtlEnv;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlThread;

final class UtlPoolWasher {
    private static final boolean detachedWash = UtlEnv.getValue("nv.pool.detachedwash", UtlEnv.getValue("nv.poolwasher.detachedwash", false));
    private final long washerCpuAffinityMask = UtlThread.parseAffinityMask(UtlEnv.getValue("nv.pool.detachedwash.cpuaffinitymask", "0"));
    private final RingBuffer<CarrierEvent> ringBuffer;
    private final Thread washerThread;
    private static final UtlPoolWasher instance = new UtlPoolWasher();

    private UtlPoolWasher() {
        if (detachedWash) {
            BlockingWaitStrategy waitStrategy;
            SingleThreadedClaimStrategy claimStrategy;
            int queueDepth = UtlEnv.getValue("nv.pool.detachedwash.queueDepth", 1024);
            String claimStrategyStr = UtlEnv.getValue("nv.pool.detachedwash.claimstrategy", "MultiThreadedSufficientCores");
            if (claimStrategyStr.equalsIgnoreCase("SingleThreaded")) {
                claimStrategy = new SingleThreadedClaimStrategy(queueDepth);
            } else if (claimStrategyStr.equalsIgnoreCase("MultiThreaded")) {
                claimStrategy = new MultiThreadedClaimStrategy(queueDepth);
            } else if (claimStrategyStr.equalsIgnoreCase("MultiThreadedSufficientCores")) {
                claimStrategy = new MultiThreadedLowContentionClaimStrategy(queueDepth);
            } else {
                throw new IllegalArgumentException("invalid poolwasher publisher claim strategy '" + claimStrategyStr + "'");
            }
            String waitStrategyStr = UtlEnv.getValue("nv.pool.detachedwash.waitstrategy", UtlEnv.getValue("nv.conservecpu", false) ? "Blocking" : "BusySpin");
            if (waitStrategyStr.equalsIgnoreCase("Blocking")) {
                waitStrategy = new BlockingWaitStrategy();
            } else if (waitStrategyStr.equalsIgnoreCase("Sleeping")) {
                waitStrategy = new SleepingWaitStrategy();
            } else if (waitStrategyStr.equalsIgnoreCase("Yielding")) {
                waitStrategy = new YieldingWaitStrategy();
            } else if (waitStrategyStr.equalsIgnoreCase("BusySpin")) {
                waitStrategy = new BusySpinWaitStrategy();
            } else {
                throw new IllegalArgumentException("invalid poolwasher wait strategy '" + waitStrategyStr + "'");
            }
            CarrierEventProcessor processor = new CarrierEventProcessor();
            this.ringBuffer = new RingBuffer((EventFactory)new EventFactory<CarrierEvent>(){

                public CarrierEvent newInstance() {
                    return new CarrierEvent();
                }
            }, (ClaimStrategy)claimStrategy, (WaitStrategy)waitStrategy);
            SequenceBarrier sequenceBarrier = UtlThread.asIntrumentedSequenceBarrier(this.ringBuffer.newBarrier(new Sequence[0]));
            BatchEventProcessor batchProcessor = new BatchEventProcessor(this.ringBuffer, sequenceBarrier, (EventHandler)processor);
            this.ringBuffer.setGatingSequences(new Sequence[]{batchProcessor.getSequence()});
            this.washerThread = new WasherThread("X-Pool-Washer", (BatchEventProcessor<CarrierEvent>)batchProcessor);
            this.washerThread.start();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.ringBuffer = null;
            this.washerThread = null;
        }
    }

    static final UtlPoolWasher getInstance() {
        return instance;
    }

    static final boolean isDetached() {
        return detachedWash;
    }

    private final void washAndPut(UtlPool.Item<?> item, boolean fromDetached) {
        item.init();
        item.getPool().postWash(item, fromDetached);
    }

    final void wash(UtlPool.Item<?> item, boolean forceAttached) {
        if (detachedWash && !forceAttached && Thread.currentThread() != this.washerThread) {
            long sequence = this.ringBuffer.next();
            CarrierEvent carrierEvent = (CarrierEvent)this.ringBuffer.get(sequence);
            carrierEvent.item = item;
            this.ringBuffer.publish(sequence);
        } else {
            this.washAndPut(item, false);
        }
    }

    private final class WasherThread
    extends Thread {
        WasherThread(String name, BatchEventProcessor<CarrierEvent> batchProcessor) {
            super((Runnable)batchProcessor);
            this.setDaemon(true);
            this.setName(name);
        }

        @Override
        public final void run() {
            if (UtlPoolWasher.this.washerCpuAffinityMask != 0L) {
                UtlThread.setCPUAffinityMask(UtlPoolWasher.this.washerCpuAffinityMask);
            } else {
                UtlThread.setDefaultCPUAffinityMask();
            }
            super.run();
        }
    }

    private final class CarrierEventProcessor
    implements EventHandler<CarrierEvent> {
        private CarrierEventProcessor() {
        }

        public final void onEvent(CarrierEvent event, long sequence, boolean endOfBatch) throws Exception {
            UtlPoolWasher.this.washAndPut(event.item, true);
        }
    }

    private final class CarrierEvent {
        UtlPool.Item<?> item;

        private CarrierEvent() {
        }
    }
}

