/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.config;

import com.neeve.ci.ManifestProductInfo;
import com.neeve.config.ConfigObject;
import com.neeve.config.ConfigRepositoryFactory;
import com.neeve.config.EConfigException;
import com.neeve.config.IConfigComplexEntity;
import com.neeve.config.IConfigComplexEntityContainer;
import com.neeve.config.IConfigRepository;
import com.neeve.config.IConfigSimpleEntity;
import com.neeve.config.IConfigSimpleEntityContainer;
import com.neeve.config.IConfigTraversalCallback;
import com.neeve.tools.interactive.InteractiveTool;
import com.neeve.tools.interactive.commands.Command;
import com.neeve.trace.Tracer;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;

public class ConfigTool
extends ConfigObject {
    private final InteractiveTool interactiveTool;
    private final IConfigRepository repo;

    private final void init(InteractiveTool interactiveTool, Tracer.Level traceLevel) {
        this.tracer.setLevel(traceLevel);
        interactiveTool.registerCommand(new CreateSimpleEntityContainer());
        interactiveTool.registerCommand(new CreateComplexEntityContainer());
        interactiveTool.registerCommand(new CreateSimpleEntity());
        interactiveTool.registerCommand(new CreateComplexEntity());
        interactiveTool.registerCommand(new SetSimpleEntityProperty());
        interactiveTool.registerCommand(new SetComplexEntityProperty());
        interactiveTool.registerCommand(new DeleteSimpleEntity());
        interactiveTool.registerCommand(new DeleteComplexEntity());
        interactiveTool.registerCommand(new DeleteSimpleEntityContainer());
        interactiveTool.registerCommand(new DeleteComplexEntityContainer());
        interactiveTool.registerCommand(new DumpSimpleEntityContainer());
        interactiveTool.registerCommand(new DumpComplexEntityContainer());
        interactiveTool.registerCommand(new DumpSimpleEntity());
        interactiveTool.registerCommand(new DumpComplexEntity());
        interactiveTool.registerCommand(new Commit());
        interactiveTool.registerCommand(new Dump());
        interactiveTool.registerCommand(new Scriptify());
        interactiveTool.registerCommand(new Trace());
    }

    protected ConfigTool(String configDescriptor, boolean createRepo, Tracer.Level traceLevel) throws Exception {
        IConfigRepository localRepo;
        boolean useDefaultRepo;
        this.interactiveTool = new InteractiveTool("Config Tool", null, ManifestProductInfo.loadProductInfo("nvx-hummingbird"));
        this.init(this.interactiveTool, traceLevel);
        boolean bl = useDefaultRepo = configDescriptor != null && configDescriptor.equalsIgnoreCase("default");
        if (createRepo && useDefaultRepo) {
            throw new IllegalArgumentException("cannot specify 'create repo' with 'use default repo'");
        }
        ConfigRepositoryFactory repoFactory = ConfigRepositoryFactory.getInstance();
        IConfigRepository iConfigRepository = localRepo = repoFactory.repositoryExists(ConfigRepositoryFactory.LOCAL_CONFIG_DESCRIPTOR) ? repoFactory.getLocalRepository() : null;
        if (configDescriptor == null) {
            this.tracer.log("Repository not specified. Using local runtime repository", Tracer.Level.INFO);
        }
        IConfigRepository iConfigRepository2 = configDescriptor == null ? localRepo : (createRepo ? repoFactory.createRepository(configDescriptor) : (this.repo = useDefaultRepo ? repoFactory.getDefaultRepository() : repoFactory.openRepository(configDescriptor)));
        if (this.repo == null) {
            throw new Exception("No repository to work with (no repository specified and durable local repository does not exist)");
        }
        if (localRepo != null) {
            IConfigSimpleEntityContainer container = localRepo.getSimpleEntityContainer("/configtool/plugins");
            if (container != null) {
                for (IConfigSimpleEntity entity : container) {
                    this.tracer.log("\n**** " + entity.getName() + " ****", Tracer.Level.INFO);
                    String classname = entity.getProperty("Class", null);
                    if (classname != null) {
                        Class<?> pluginClass = null;
                        try {
                            pluginClass = Class.forName(classname);
                        }
                        catch (ClassNotFoundException e) {
                            this.tracer.log("Plugin class [" + classname + "] could not be found.", Tracer.Level.INFO);
                        }
                        catch (UnsupportedClassVersionError e) {
                            this.tracer.log("Plugin class [" + classname + "] is not supported by this VM <version=" + System.getProperty("java.vm.version") + ">.", Tracer.Level.INFO);
                        }
                        Method createMethod = null;
                        if (pluginClass != null) {
                            try {
                                Class[] parameterTypes = new Class[]{Class.forName("com.neeve.tools.interactive.InteractiveTool"), Class.forName("com.neeve.config.IConfigRepository"), Class.forName("com.neeve.trace.Tracer")};
                                createMethod = pluginClass.getMethod("create", parameterTypes);
                            }
                            catch (ClassNotFoundException e) {
                                this.tracer.log("Failed to load com.neeve.tools.interactive.InteractiveTool or com.neeve.config.IConfigRepository during instantiation of plugin class [" + classname + "].", Tracer.Level.INFO);
                            }
                            catch (SecurityException e) {
                                this.tracer.log("Access to instantiation method in plugin class [" + classname + "] is denied.", Tracer.Level.INFO);
                            }
                            catch (NoSuchMethodException e) {
                                this.tracer.log("Instantiation method in plugin class [" + classname + "] could not be found.", Tracer.Level.INFO);
                            }
                        }
                        if (createMethod == null) continue;
                        try {
                            Object[] parameters = new Object[]{this.interactiveTool, this.repo, this.tracer};
                            createMethod.invoke(null, parameters);
                        }
                        catch (IllegalAccessException e) {
                            this.tracer.log("Access to instantiation method in plugin class [" + classname + "] is denied.", Tracer.Level.INFO);
                        }
                        catch (InvocationTargetException e) {
                            this.tracer.log("Instantiation method in plugin class [" + classname + "] returned with an exception [" + e.getCause() + "].", Tracer.Level.INFO);
                        }
                        continue;
                    }
                    this.tracer.log("Plugin '" + entity.getName() + "' is corrupt [Missing 'Class' property].", Tracer.Level.INFO);
                }
            } else {
                this.tracer.log("No plugins configured.", Tracer.Level.INFO);
            }
        } else {
            this.tracer.log("No plugins configured (no local repository).", Tracer.Level.INFO);
        }
    }

    public ConfigTool(IConfigRepository repo, Tracer.Level traceLevel) throws Exception {
        this.interactiveTool = new InteractiveTool("Config Tool", null, ManifestProductInfo.loadProductInfo("nvx-rumi-core"));
        this.init(this.interactiveTool, traceLevel);
        if (repo == null) {
            throw new IllegalArgumentException("repository cannot be null");
        }
        this.repo = repo;
    }

    public ConfigTool(String configDescriptor, boolean createRepo) throws Exception {
        this(configDescriptor, createRepo, Tracer.Level.INFO);
    }

    public final InteractiveTool getInteractiveTool() {
        return this.interactiveTool;
    }

    public final IConfigRepository getConfigRepository() {
        return this.repo;
    }

    public final void run(InputStream in) throws Exception {
        if (in == null) {
            throw new IllegalArgumentException("input stream cannot be null (use run(File file) with file=null for the tool)");
        }
        this.interactiveTool.run(in);
    }

    public final void run(File scriptFile) throws Exception {
        Thread.currentThread().setName("ConfigTool Main");
        if (scriptFile == null) {
            this.interactiveTool.run();
        } else {
            this.interactiveTool.run(scriptFile);
        }
    }

    public final class Trace
    extends Command {
        public final void doSetLevel(String level) {
            ConfigTool.this.tracer.log("Setting trace level to '" + level + "'...", Tracer.Level.INFO);
            try {
                ConfigTool.this.tracer.setLevel(Tracer.getLevel((String)level));
                ConfigTool.this.tracer.log("Success.", Tracer.Level.INFO);
            }
            catch (Exception e) {
                ConfigTool.this.tracer.log("Failed [" + e.toString() + "]", Tracer.Level.INFO);
            }
        }

        @Override
        public final void run(String[] args) {
            if (args.length != 1) {
                ConfigTool.this.tracer.log("Syntax error: trace <level>", Tracer.Level.SEVERE);
                ConfigTool.this.tracer.log("   level=[off|severe|warn|info] ", Tracer.Level.SEVERE);
            } else {
                this.doSetLevel(args[0]);
            }
        }

        @Override
        public final void help() {
            System.out.println("trace");
            System.out.println("  Set the tool trace level.");
        }

        @Override
        public final String[] keywords() {
            return new String[]{"trace"};
        }
    }

    public final class Scriptify
    extends Command {
        public final void doScriptify(String filename) {
            try {
                File file = new File(filename.endsWith(".xcs") ? filename : filename + ".xcs");
                ConfigTool.this.tracer.log("Scriptifying repository to '" + file.getAbsolutePath() + "'...", Tracer.Level.INFO);
                if (file.exists()) {
                    throw new IllegalArgumentException("script file already exists");
                }
                if (file.isDirectory()) {
                    throw new IllegalArgumentException("script file is a directory");
                }
                file.getParentFile().mkdirs();
                final PrintStream out = new PrintStream(file);
                out.println("// *****************************************************************");
                out.println("// ***** THIS FILE IS GENERATED BY THE X PLATFORM CONFIGURATION TOOL");
                out.println("// ******** Generated on   : " + new Date().toString());
                out.println("// ******** Generated from : " + ConfigTool.this.repo.getDescriptor());
                out.println("// *****************************************************************");
                ConfigTool.this.repo.traverse("...", new IConfigTraversalCallback(){

                    public final void onSimpleEntityContainer(IConfigSimpleEntityContainer container) {
                        out.println("repo_create_simple_entity_container " + container.getAddress());
                    }

                    public final void onComplexEntityContainer(IConfigComplexEntityContainer container) {
                        out.println("repo_create_complex_entity_container " + container.getAddress());
                    }

                    public final void onSimpleEntity(IConfigSimpleEntity entity) {
                        out.println("repo_create_simple_entity " + entity.getContainer().getAddress() + " " + entity.getName());
                        Properties props = entity.getProperties();
                        for (String propname : props.stringPropertyNames()) {
                            out.println("repo_set_simple_entity_property " + entity.getContainer().getAddress() + " " + entity.getName() + " " + propname + " " + props.getProperty(propname));
                        }
                    }

                    public final void onComplexEntity(IConfigComplexEntity entity) {
                        out.println("repo_create_complex_entity " + entity.getContainer().getAddress() + " " + entity.getName());
                        Iterator iterator = entity.names();
                        while (iterator.hasNext()) {
                            String setname = (String)iterator.next();
                            Properties props = entity.getProperties(setname);
                            for (String propname : props.stringPropertyNames()) {
                                out.println("repo_set_complex_entity_property " + entity.getContainer().getAddress() + " " + entity.getName() + " " + setname + " " + propname + " " + props.getProperty(propname));
                            }
                        }
                    }
                });
                out.println("repo_commit");
                out.flush();
                out.close();
            }
            catch (Exception e) {
                ConfigTool.this.tracer.log("Failed [" + e.toString() + "]", Tracer.Level.INFO);
            }
        }

        @Override
        public final void run(String[] args) {
            if (args.length != 1) {
                ConfigTool.this.tracer.log("Syntax error: repo_scriptify <filename>", Tracer.Level.SEVERE);
            } else {
                this.doScriptify(args[0]);
            }
        }

        @Override
        public final void help() {
            System.out.println("repo_scriptify");
            System.out.println("  Reverse engineer a config repository into a configuration script.");
        }

        @Override
        public final String[] keywords() {
            return new String[]{"repo_scriptify"};
        }
    }

    public final class Dump
    extends Command {
        public final void doDump() {
            try {
                System.out.println("\n" + ConfigTool.this.repo.toString());
            }
            catch (Exception e) {
                ConfigTool.this.tracer.log("Failed [" + e.toString() + "]", Tracer.Level.INFO);
            }
        }

        @Override
        public final void run(String[] args) {
            if (args.length != 0) {
                ConfigTool.this.tracer.log("Syntax error: repo_dump", Tracer.Level.SEVERE);
            } else {
                this.doDump();
            }
        }

        @Override
        public final void help() {
            System.out.println("repo_dump");
            System.out.println("  Dumps the contents of the repository to stdout.");
        }

        @Override
        public final String[] keywords() {
            return new String[]{"repo_dump"};
        }
    }

    public final class Commit
    extends Command {
        public final void doCommit() {
            ConfigTool.this.tracer.log("Committing changes to repository...", Tracer.Level.INFO);
            try {
                ConfigTool.this.repo.commit();
                ConfigTool.this.tracer.log("Success.", Tracer.Level.INFO);
            }
            catch (Exception e) {
                ConfigTool.this.tracer.log("Failed [" + e.toString() + "]", Tracer.Level.INFO);
            }
        }

        @Override
        public final void run(String[] args) {
            if (args.length != 0) {
                ConfigTool.this.tracer.log("Syntax error: repo_commit", Tracer.Level.SEVERE);
            } else {
                this.doCommit();
            }
        }

        @Override
        public final void help() {
            System.out.println("repo_commit");
            System.out.println("  Commits the repository to its durable storage.");
        }

        @Override
        public final String[] keywords() {
            return new String[]{"repo_commit"};
        }
    }

    public final class DumpComplexEntity
    extends Command {
        public final void doDump(String addr, String name) {
            block5: {
                System.out.println("Complex entity '" + name + "' in container at '" + addr + "'...");
                try {
                    IConfigComplexEntityContainer container = ConfigTool.this.repo.getComplexEntityContainer(addr);
                    if (container != null) {
                        IConfigComplexEntity entity = (IConfigComplexEntity)container.getEntity(name);
                        if (entity != null) {
                            System.out.println("..." + entity);
                            System.out.println(".....Property Sets:");
                            Iterator iterator = entity.names();
                            while (iterator.hasNext()) {
                                String setname = (String)iterator.next();
                                Properties props = entity.getProperties(setname);
                                System.out.println(".......<" + setname + "> " + props);
                            }
                            break block5;
                        }
                        throw new EConfigException("No entity of name '" + name + "' in complex entity container at '" + addr + "'");
                    }
                    throw new EConfigException("Node at '" + addr + "' is not a complex entity container");
                }
                catch (Exception e) {
                    ConfigTool.this.tracer.log("Failed [" + e.toString() + "]", Tracer.Level.INFO);
                }
            }
        }

        @Override
        public final void run(String[] args) {
            if (args.length != 2) {
                ConfigTool.this.tracer.log("Syntax error: repo_dump_complex_entity <containeraddr> <entityname>", Tracer.Level.SEVERE);
            } else {
                this.doDump(args[0], args[1]);
            }
        }

        @Override
        public final void help() {
            System.out.println("repo_dump_complex_entity");
            System.out.println("  Dumps a new complex entity in the repository");
        }

        @Override
        public final String[] keywords() {
            return new String[]{"repo_dump_complex_entity"};
        }
    }

    public final class DumpSimpleEntity
    extends Command {
        public final void doDump(String addr, String name) {
            System.out.println("Simple entity '" + name + "' in container at '" + addr + "'...");
            try {
                IConfigSimpleEntity entity;
                IConfigSimpleEntityContainer container = ConfigTool.this.repo.getSimpleEntityContainer(addr);
                if (container != null) {
                    entity = (IConfigSimpleEntity)container.getEntity(name);
                    if (entity == null) {
                        throw new EConfigException("No entity of name '" + name + "' in simple entity container at '" + addr + "'");
                    }
                } else {
                    throw new EConfigException("Node at '" + addr + "' is not a simple entity container");
                }
                System.out.println("..." + entity);
                System.out.println(".....Property Set=" + entity.getProperties());
            }
            catch (Exception e) {
                ConfigTool.this.tracer.log("Failed [" + e.toString() + "]", Tracer.Level.INFO);
            }
        }

        @Override
        public final void run(String[] args) {
            if (args.length != 2) {
                ConfigTool.this.tracer.log("Syntax error: repo_dump_simple_entity <containeraddr> <entityname>", Tracer.Level.SEVERE);
            } else {
                this.doDump(args[0], args[1]);
            }
        }

        @Override
        public final void help() {
            System.out.println("repo_dump_simple_entity");
            System.out.println("  Dumps a new simple entity in the repository");
        }

        @Override
        public final String[] keywords() {
            return new String[]{"repo_dump_simple_entity"};
        }
    }

    public final class DumpComplexEntityContainer
    extends Command {
        public final void doDump(String addr) {
            System.out.println("Complex entity container at '" + addr + "'...");
            try {
                IConfigComplexEntityContainer container = ConfigTool.this.repo.getComplexEntityContainer(addr);
                if (container != null) {
                    System.out.println("..." + container);
                    System.out.println(".....Entities");
                    System.out.println(".....{");
                    Iterator iterator = container.iterator();
                    while (iterator.hasNext()) {
                        System.out.println("........" + ((IConfigComplexEntity)iterator.next()).getName());
                    }
                } else {
                    throw new EConfigException("Node at '" + addr + "' is not a complex entity container");
                }
                System.out.println(".....}");
            }
            catch (Exception e) {
                ConfigTool.this.tracer.log("Failed [" + e.toString() + "]", Tracer.Level.INFO);
            }
        }

        @Override
        public final void run(String[] args) {
            if (args.length != 1) {
                ConfigTool.this.tracer.log("Syntax error: repo_dump_complex_entity_container <containeraddr>", Tracer.Level.SEVERE);
            } else {
                this.doDump(args[0]);
            }
        }

        @Override
        public final void help() {
            System.out.println("repo_dump_complex_entity_container");
            System.out.println("  Dumps a complex entity container in the repository");
        }

        @Override
        public final String[] keywords() {
            return new String[]{"repo_dump_complex_entity_container"};
        }
    }

    public final class DumpSimpleEntityContainer
    extends Command {
        public final void doDump(String addr) {
            System.out.println("Simple entity container at '" + addr + "'...");
            try {
                IConfigSimpleEntityContainer container = ConfigTool.this.repo.getSimpleEntityContainer(addr);
                if (container != null) {
                    System.out.println("..." + container);
                    System.out.println(".....Entities");
                    System.out.println(".....{");
                    Iterator iterator = container.iterator();
                    while (iterator.hasNext()) {
                        System.out.println("........" + ((IConfigSimpleEntity)iterator.next()).getName());
                    }
                } else {
                    throw new EConfigException("Node at '" + addr + "' is not a simple entity container");
                }
                System.out.println(".....}");
            }
            catch (Exception e) {
                ConfigTool.this.tracer.log("Failed [" + e.toString() + "]", Tracer.Level.INFO);
            }
        }

        @Override
        public final void run(String[] args) {
            if (args.length != 1) {
                ConfigTool.this.tracer.log("Syntax error: repo_dump_simple_entity_container <containeraddr>", Tracer.Level.SEVERE);
            } else {
                this.doDump(args[0]);
            }
        }

        @Override
        public final void help() {
            System.out.println("repo_dump_simple_entity_container");
            System.out.println("  Dumps a simple entity container in the repository");
        }

        @Override
        public final String[] keywords() {
            return new String[]{"repo_dump_simple_entity_container"};
        }
    }

    public final class DeleteComplexEntityContainer
    extends Command {
        public final void doDelete(String addr) {
            ConfigTool.this.tracer.log("Deleting complex entity container at '" + addr + "'...", Tracer.Level.INFO);
            try {
                if (ConfigTool.this.repo.removeComplexEntityContainer(addr) == null) {
                    throw new EConfigException("Node at '" + addr + "' is not a complex entity container");
                }
                ConfigTool.this.tracer.log("Success. Execute 'repo_commit' to commit to durable storage.", Tracer.Level.INFO);
            }
            catch (Exception e) {
                ConfigTool.this.tracer.log("Failed [" + e.toString() + "]", Tracer.Level.INFO);
            }
        }

        @Override
        public final void run(String[] args) {
            if (args.length != 1) {
                ConfigTool.this.tracer.log("Syntax error: repo_delete_complex_entity_container <addr>", Tracer.Level.SEVERE);
            } else {
                this.doDelete(args[0]);
            }
        }

        @Override
        public final void help() {
            System.out.println("repo_delete_complex_entity_container");
            System.out.println("  Deletes a complex entity container from the repository");
        }

        @Override
        public final String[] keywords() {
            return new String[]{"repo_delete_complex_entity_container"};
        }
    }

    public final class DeleteSimpleEntityContainer
    extends Command {
        public final void doDelete(String addr) {
            ConfigTool.this.tracer.log("Deleting simple entity container at '" + addr + "'...", Tracer.Level.INFO);
            try {
                if (ConfigTool.this.repo.removeSimpleEntityContainer(addr) == null) {
                    throw new EConfigException("Node at '" + addr + "' is not a simple entity container");
                }
                ConfigTool.this.tracer.log("Success. Execute 'repo_commit' to commit to durable storage.", Tracer.Level.INFO);
            }
            catch (Exception e) {
                ConfigTool.this.tracer.log("Failed [" + e.toString() + "]", Tracer.Level.INFO);
            }
        }

        @Override
        public final void run(String[] args) {
            if (args.length != 1) {
                ConfigTool.this.tracer.log("Syntax error: repo_delete_simple_entity_container <addr>", Tracer.Level.SEVERE);
            } else {
                this.doDelete(args[0]);
            }
        }

        @Override
        public final void help() {
            System.out.println("repo_delete_simple_entity_container");
            System.out.println("  Deletes a simple entity container from the repository");
        }

        @Override
        public final String[] keywords() {
            return new String[]{"repo_delete_simple_entity_container"};
        }
    }

    public final class DeleteComplexEntity
    extends Command {
        public final void doDelete(String addr, String name) {
            ConfigTool.this.tracer.log("Deleting complex entity '" + name + "' from container at '" + addr + "'...", Tracer.Level.INFO);
            try {
                IConfigComplexEntityContainer container = ConfigTool.this.repo.getComplexEntityContainer(addr);
                if (container != null) {
                    if (container.removeEntity(name) == null) {
                        throw new EConfigException("Entity of name '" + name + "' does not exist in specified container");
                    }
                } else {
                    throw new EConfigException("Node at '" + addr + "' is not a complex entity container");
                }
                ConfigTool.this.tracer.log("Success. Execute 'repo_commit' to commit to durable storage.", Tracer.Level.INFO);
            }
            catch (Exception e) {
                ConfigTool.this.tracer.log("Failed [" + e.toString() + "]", Tracer.Level.INFO);
            }
        }

        @Override
        public final void run(String[] args) {
            if (args.length != 2) {
                ConfigTool.this.tracer.log("Syntax error: repo_delete_complex_entity <containeraddr> <entityname>", Tracer.Level.SEVERE);
            } else {
                this.doDelete(args[0], args[1]);
            }
        }

        @Override
        public final void help() {
            System.out.println("repo_delete_complex_entity");
            System.out.println("  Deletes a new complex entity in the repository");
        }

        @Override
        public final String[] keywords() {
            return new String[]{"repo_delete_complex_entity"};
        }
    }

    public final class DeleteSimpleEntity
    extends Command {
        public final void doDelete(String addr, String name) {
            ConfigTool.this.tracer.log("Deleting simple entity '" + name + "' from container at '" + addr + "'...", Tracer.Level.INFO);
            try {
                IConfigSimpleEntityContainer container = ConfigTool.this.repo.getSimpleEntityContainer(addr);
                if (container != null) {
                    if (container.removeEntity(name) == null) {
                        throw new EConfigException("Entity of name '" + name + "' does not exist in specified container");
                    }
                } else {
                    throw new EConfigException("Node at '" + addr + "' is not a simple entity container");
                }
                ConfigTool.this.tracer.log("Success. Execute 'repo_commit' to commit to durable storage.", Tracer.Level.INFO);
            }
            catch (Exception e) {
                ConfigTool.this.tracer.log("Failed [" + e.toString() + "]", Tracer.Level.INFO);
            }
        }

        @Override
        public final void run(String[] args) {
            if (args.length != 2) {
                ConfigTool.this.tracer.log("Syntax error: repo_delete_simple_entity <containeraddr> <entityname>", Tracer.Level.SEVERE);
            } else {
                this.doDelete(args[0], args[1]);
            }
        }

        @Override
        public final void help() {
            System.out.println("repo_delete_simple_entity");
            System.out.println("  Deletes a new simple entity in the repository");
        }

        @Override
        public final String[] keywords() {
            return new String[]{"repo_delete_simple_entity"};
        }
    }

    public final class SetComplexEntityProperty
    extends Command {
        public final void doSet(String addr, String name, String setname, String propname, String propval) {
            ConfigTool.this.tracer.log("Setting " + propname + "=" + propval + "@" + setname + " in complex entity '" + name + "' at '" + addr + "'...", Tracer.Level.INFO);
            try {
                IConfigComplexEntity entity;
                IConfigComplexEntityContainer container = ConfigTool.this.repo.getComplexEntityContainer(addr);
                if (container != null) {
                    entity = (IConfigComplexEntity)container.getEntity(name);
                    if (entity == null) {
                        throw new EConfigException("No entity of name '" + name + "' in complex entity container at '" + addr + "'");
                    }
                } else {
                    throw new EConfigException("Node at '" + addr + "' is not a complex entity container");
                }
                entity.setProperty(setname, propname, propval);
                ConfigTool.this.tracer.log("Success. Execute 'repo_commit' to commit to durable storage.", Tracer.Level.INFO);
            }
            catch (Exception e) {
                ConfigTool.this.tracer.log("Failed [" + e.toString() + "]", Tracer.Level.INFO);
            }
        }

        @Override
        public final void run(String[] args) {
            if (args.length != 4 && args.length != 5) {
                ConfigTool.this.tracer.log("Syntax error: repo_set_complex_entity_property <containeraddr> <entityname> <setname> <propname> <propval>", Tracer.Level.SEVERE);
            } else {
                this.doSet(args[0], args[1], args[2], args[3], args.length == 4 ? null : args[4]);
            }
        }

        @Override
        public final void help() {
            System.out.println("repo_set_complex_entity_property");
            System.out.println("  Set a property value in a complex entity in the repository");
        }

        @Override
        public final String[] keywords() {
            return new String[]{"repo_set_complex_entity_property"};
        }
    }

    public final class SetSimpleEntityProperty
    extends Command {
        public final void doSet(String addr, String name, String propname, String propval) {
            ConfigTool.this.tracer.log("Setting " + propname + "=" + propval + " in simple entity '" + name + "' at '" + addr + "'...", Tracer.Level.INFO);
            try {
                IConfigSimpleEntity entity;
                IConfigSimpleEntityContainer container = ConfigTool.this.repo.getSimpleEntityContainer(addr);
                if (container != null) {
                    entity = (IConfigSimpleEntity)container.getEntity(name);
                    if (entity == null) {
                        throw new EConfigException("No entity of name '" + name + "' in simple entity container at '" + addr + "'");
                    }
                } else {
                    throw new EConfigException("Node at '" + addr + "' is not a simple entity container");
                }
                entity.setProperty(propname, propval);
                ConfigTool.this.tracer.log("Success. Execute 'repo_commit' to commit to durable storage.", Tracer.Level.INFO);
            }
            catch (Exception e) {
                ConfigTool.this.tracer.log("Failed [" + e.toString() + "]", Tracer.Level.INFO);
            }
        }

        @Override
        public final void run(String[] args) {
            if (args.length != 3 && args.length != 4) {
                ConfigTool.this.tracer.log("Syntax error: repo_set_simple_entity_property <containeraddr> <entityname> <propname> [propval]", Tracer.Level.SEVERE);
            } else {
                this.doSet(args[0], args[1], args[2], args.length == 3 ? null : args[3]);
            }
        }

        @Override
        public final void help() {
            System.out.println("repo_set_simple_entity_property");
            System.out.println("  Set a property value in a simple entity in the repository");
        }

        @Override
        public final String[] keywords() {
            return new String[]{"repo_set_simple_entity_property"};
        }
    }

    public final class CreateComplexEntity
    extends Command {
        public final void doCreate(String addr, String name) {
            ConfigTool.this.tracer.log("Creating new complex entity '" + name + "' in container at '" + addr + "'...", Tracer.Level.INFO);
            try {
                IConfigComplexEntityContainer container = ConfigTool.this.repo.getComplexEntityContainer(addr);
                if (container == null) {
                    throw new EConfigException("Node at '" + addr + "' is not a complex entity container");
                }
                container.createEntity(name);
                ConfigTool.this.tracer.log("Success. Execute 'repo_commit' to commit to durable storage.", Tracer.Level.INFO);
            }
            catch (Exception e) {
                ConfigTool.this.tracer.log("Failed [" + e.toString() + "]", Tracer.Level.INFO);
            }
        }

        @Override
        public final void run(String[] args) {
            if (args.length != 2) {
                ConfigTool.this.tracer.log("Syntax error: repo_create_complex_entity <containeraddr> <entityname>", Tracer.Level.SEVERE);
            } else {
                this.doCreate(args[0], args[1]);
            }
        }

        @Override
        public final void help() {
            System.out.println("repo_create_complex_entity");
            System.out.println("  Creates a new complex entity in the repository");
        }

        @Override
        public final String[] keywords() {
            return new String[]{"repo_create_complex_entity"};
        }
    }

    public final class CreateSimpleEntity
    extends Command {
        public final void doCreate(String addr, String name) {
            ConfigTool.this.tracer.log("Creating new simple entity '" + name + "' in container at '" + addr + "'...", Tracer.Level.INFO);
            try {
                IConfigSimpleEntityContainer container = ConfigTool.this.repo.getSimpleEntityContainer(addr);
                if (container == null) {
                    throw new EConfigException("Node at '" + addr + "' is not a simple entity container");
                }
                container.createEntity(name);
                ConfigTool.this.tracer.log("Success. Execute 'repo_commit' to commit to durable storage.", Tracer.Level.INFO);
            }
            catch (Exception e) {
                ConfigTool.this.tracer.log("Failed [" + e.toString() + "]", Tracer.Level.INFO);
            }
        }

        @Override
        public final void run(String[] args) {
            if (args.length != 2) {
                ConfigTool.this.tracer.log("Syntax error: repo_create_simple_entity <containeraddr> <entityname>", Tracer.Level.SEVERE);
            } else {
                this.doCreate(args[0], args[1]);
            }
        }

        @Override
        public final void help() {
            System.out.println("repo_create_simple_entity");
            System.out.println("  Creates a new simple entity in the repository");
        }

        @Override
        public final String[] keywords() {
            return new String[]{"repo_create_simple_entity"};
        }
    }

    public final class CreateComplexEntityContainer
    extends Command {
        public final void doCreate(String addr) {
            ConfigTool.this.tracer.log("Creating new complex entity container at '" + addr + "'...", Tracer.Level.INFO);
            try {
                ConfigTool.this.repo.createComplexEntityContainer(addr);
                ConfigTool.this.tracer.log("Success. Execute 'repo_commit' to commit to durable storage.", Tracer.Level.INFO);
            }
            catch (Exception e) {
                ConfigTool.this.tracer.log("Failed [" + e.toString() + "]", Tracer.Level.INFO);
            }
        }

        @Override
        public final void run(String[] args) {
            if (args.length != 1) {
                ConfigTool.this.tracer.log("Syntax error: repo_create_complex_entity_container <addr>", Tracer.Level.SEVERE);
            } else {
                this.doCreate(args[0]);
            }
        }

        @Override
        public final void help() {
            System.out.println("repo_create_complex_entity_container");
            System.out.println("  Creates a new complex entity container in the repository");
        }

        @Override
        public final String[] keywords() {
            return new String[]{"repo_create_complex_entity_container"};
        }
    }

    public final class CreateSimpleEntityContainer
    extends Command {
        public final void doCreate(String addr) {
            ConfigTool.this.tracer.log("Creating new simple entity container at '" + addr + "'...", Tracer.Level.INFO);
            try {
                ConfigTool.this.repo.createSimpleEntityContainer(addr);
                ConfigTool.this.tracer.log("Success. Execute 'repo_commit' to commit to durable storage.", Tracer.Level.INFO);
            }
            catch (Exception e) {
                ConfigTool.this.tracer.log("Failed [" + e.toString() + "]", Tracer.Level.INFO);
            }
        }

        @Override
        public final void run(String[] args) {
            if (args.length != 1) {
                ConfigTool.this.tracer.log("Syntax error: repo_create_simple_entity_container <addr>", Tracer.Level.SEVERE);
            } else {
                this.doCreate(args[0]);
            }
        }

        @Override
        public final void help() {
            System.out.println("repo_create_simple_entity_container");
            System.out.println("  Creates a new simple entity container in the repository");
        }

        @Override
        public final String[] keywords() {
            return new String[]{"repo_create_simple_entity_container"};
        }
    }
}

