/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.perf.aep.engine;

import com.neeve.perf.common.LatencyWriter;
import com.neeve.util.UtlTime;

public final class LatencyRecorder {
    private static final long _utlTimeOverhead;
    private static boolean _noWrite;
    private static boolean _printIntervalStats;
    private static LatencyWriter _lw_w2w;

    public static final void noWrite(boolean val) {
        _noWrite = val;
    }

    public static final void printIntervalStats(boolean val) {
        _printIntervalStats = val;
    }

    public static final void start(int rate, int count) throws Exception {
        _lw_w2w = new LatencyWriter("w2w", _noWrite ? null : "latencies.w2w.bin", _printIntervalStats);
        _lw_w2w.start(rate, count);
    }

    public static final void recordW2w(long val) throws Exception {
        _lw_w2w.write((int)(val - _utlTimeOverhead));
    }

    public static final void stop(int warmupCount, LatencyWriter.Stats stats) throws Exception {
        _lw_w2w.close(warmupCount, stats);
    }

    static {
        try {
            long start = UtlTime.now();
            int i = 0;
            while ((long)i < 100000000L) {
                UtlTime.now();
                ++i;
            }
            _utlTimeOverhead = (UtlTime.now() - start) / 100000000L;
            System.out.println("UtlTime overhead=" + _utlTimeOverhead + "ns");
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

