/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.toa.service;

import com.neeve.toa.service.ToaService;
import java.util.Properties;

public class ToaServiceChannel {
    private final ToaService service;
    private String busName;
    private final String name;
    private String key;
    private Properties initialKRT;
    private String resolvedKey;

    public ToaServiceChannel(ToaService service, String busName, String name, String key) {
        if (service == null) {
            throw new IllegalArgumentException("ToaService cannot be null");
        }
        this.service = service;
        this.busName = busName;
        this.name = name;
        this.key = key;
    }

    public void setBusName(String busName) {
        this.busName = busName;
    }

    public final String getBusName() {
        return this.busName;
    }

    public ToaService getService() {
        return this.service;
    }

    public final String getSimpleName() {
        return this.name;
    }

    public final String getName() {
        if (this.service.isPrefixChannelNames()) {
            return this.service.getSimpleName().toLowerCase() + "-" + this.name;
        }
        return this.name;
    }

    public final String getKey() {
        return this.key;
    }

    public final void setKey(String key) {
        this.key = key;
    }

    public final void setInitialKRT(Properties initialKRT) {
        this.initialKRT = initialKRT;
    }

    public final Properties getInitialKRT() {
        return this.initialKRT;
    }

    public void setInitiallyResolvedKey(String resolvedKey) {
        this.resolvedKey = resolvedKey;
    }

    public String getInitiallyResolvedKey() {
        return this.resolvedKey;
    }

    public String toString() {
        return "ToaServiceChannel [name=" + this.getName() + ", bus=" + this.getBusName() + ", key=" + this.getKey() + ", service=" + (this.service != null ? this.service : "null") + "]";
    }
}

