/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.toa;

import com.neeve.config.Config;
import com.neeve.toa.spi.AbstractServiceDefinitionLocator;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlResource;
import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;

public final class DefaultServiceDefinitionLocator
extends AbstractServiceDefinitionLocator {
    public static final String PROP_STRICT_SERVICE_VALIDATION = "nv.toa.strictservicelocatorvalidation";
    @Deprecated
    private static final String PROP_STRICT_SERVICE_VALIDATION_DEPRECATED = "nv.toa.strictServiceLocatorValidation";
    public static final boolean PROP_STRICT_SERVICE_VALIDATION_DEFAULT = false;
    public static final String PROP_SCAN_FOR_CLASSPATH_SERVICES = "nv.toa.scanforclasspathservices";
    public static final boolean PROP_SCAN_FOR_CLASSPATH_SERVICES_DEFAULT = true;
    private final boolean strictValidation = Config.getValue((String)"nv.toa.strictservicelocatorvalidation", (boolean)Config.getValue((String)"nv.toa.strictServiceLocatorValidation", (boolean)false));
    private final boolean scanForClassPathServices = Config.getValue((String)"nv.toa.scanforclasspathservices", (boolean)true);
    private final UtlResource.URLFilter SERVICE_FILTER = new UtlResource.URLFilter(){

        public boolean filter(URL url) {
            if (DefaultServiceDefinitionLocator.this.strictValidation) {
                if (url.getPath().endsWith(".xml")) {
                    AbstractServiceDefinitionLocator.validateServiceDefinitionFile(url);
                    return false;
                }
                if (tracer.debug) {
                    tracer.log("Ignoring service definition candidate, no xml suffix: " + url, Tracer.Level.DEBUG);
                }
                return true;
            }
            return !AbstractServiceDefinitionLocator.isServiceDefinitionFile(url);
        }
    };

    @Override
    public final void locateServices(Set<URL> urls) throws Exception {
        this.findFileSystemServices(new File(Config.getRootDirectory().toString() + File.separator + "conf" + File.separator + "services"), urls);
        this.findFileSystemServices(new File(Config.getRootDirectory().toString() + File.separator + "resources" + File.separator + "services"), urls);
        String appName = Config.getValue((String)"application.name", null);
        if (appName != null) {
            this.findFileSystemServices(new File(Config.getRootDirectory().toString() + File.separator + "conf" + File.separator + appName + File.separator + "services"), urls);
            this.findFileSystemServices(new File(Config.getRootDirectory().toString() + File.separator + "resources" + File.separator + appName + File.separator + "services"), urls);
        }
        if (this.scanForClassPathServices) {
            UtlResource.findClasspathResourcesIn((String)"services", urls, (UtlResource.URLFilter)this.SERVICE_FILTER);
        }
    }

    private final void findFileSystemServices(File directory, Set<URL> urls) throws MalformedURLException {
        File[] files;
        if (DefaultServiceDefinitionLocator.tracer.debug) {
            tracer.log("Looking for service definitions in " + directory, Tracer.Level.DEBUG);
        }
        if (!directory.exists() || !directory.isDirectory()) {
            return;
        }
        for (File file : files = directory.listFiles(new FilenameFilter(){

            @Override
            public final boolean accept(File dir, String name) {
                return !new File(name).isDirectory() && name.endsWith(".xml");
            }
        })) {
            URL url = file.toURI().toURL();
            if (this.strictValidation) {
                DefaultServiceDefinitionLocator.validateServiceDefinitionFile(url);
                urls.add(url);
                continue;
            }
            if (!DefaultServiceDefinitionLocator.isServiceDefinitionFile(url)) continue;
            urls.add(url);
        }
    }
}

