/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.toa.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.rog.IRogMessage;
import com.neeve.server.app.SrvAppLoader;
import com.neeve.toa.TopicOrientedApplication;
import com.neeve.toa.spi.AbstractServiceDefinitionLocator;
import com.neeve.toa.spi.ServiceDefinitionLocator;
import com.neeve.toa.test.unit.IForwarderMessage1;
import com.neeve.toa.test.unit.IForwarderMessage2;
import com.neeve.toa.test.unit.IReceiverMessage1;
import com.neeve.toa.test.unit.IReceiverMessage2;
import com.neeve.util.UtlObjectGraph;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.junit.Assert;

public class AbstractToaTestApp
extends TopicOrientedApplication {
    volatile boolean holdMessages = true;
    volatile int receivedMessageCount = 0;
    volatile List<IRogMessage> received = new ArrayList<IRogMessage>();
    volatile int sentMessageCount = 0;
    volatile List<IRogMessage> sent = new ArrayList<IRogMessage>();
    private SrvAppLoader appLoader;

    public ServiceDefinitionLocator getServiceDefinitionLocator() {
        return new ToaTestServiceDefinitionLocator();
    }

    protected void onAppLoaderInjected(SrvAppLoader appLoader) {
        this.appLoader = appLoader;
    }

    public SrvAppLoader getAppLoader() {
        return this.appLoader;
    }

    public AepEngine getAepEngine() {
        return super.getEngine();
    }

    protected IRogMessage recordReceipt(IRogMessage message) {
        if (this.holdMessages) {
            message.acquire();
            this.received.add(message);
        }
        ++this.receivedMessageCount;
        return message;
    }

    protected IRogMessage recordSend(IRogMessage message) {
        if (this.holdMessages) {
            message.acquire();
            this.sent.add(message);
        }
        ++this.sentMessageCount;
        return message;
    }

    public IRogMessage populateMessage(IRogMessage message) {
        try {
            UtlObjectGraph.populateObject((Object)message, (Class[])new Class[]{IForwarderMessage1.class, IForwarderMessage2.class, IReceiverMessage1.class, IReceiverMessage2.class});
        }
        catch (Exception e) {
            throw new RuntimeException("Error populating message", e);
        }
        return message;
    }

    public void setHoldMessages(boolean value) {
        this.holdMessages = value;
    }

    public boolean waitForTransactionStability(int seconds, long minTransactions) throws InterruptedException {
        boolean waiting = true;
        long timeout = System.currentTimeMillis() + (long)(seconds * 1000);
        while ((waiting = this.getEngine().getStats().getNumCommitsCompleted() < minTransactions) && System.currentTimeMillis() < timeout) {
            Thread.sleep(100L);
        }
        return !waiting;
    }

    public boolean waitForTransactionStability(int seconds) throws InterruptedException {
        return this.waitForTransactionStability(seconds, this.getEngine().getStats().getNumCommitsStarted());
    }

    public boolean waitForSends(int seconds, int minMessages) throws InterruptedException {
        boolean waiting = true;
        long timeout = System.currentTimeMillis() + (long)(seconds * 1000);
        while ((waiting = this.sentMessageCount < minMessages) && System.currentTimeMillis() < timeout) {
            Thread.sleep(100L);
        }
        return !waiting;
    }

    public void assertExpectedSends(int seconds, int expectedSends) throws InterruptedException {
        this.waitForSends(seconds, expectedSends);
        Assert.assertEquals((String)(this.getAepEngine().getName() + " has unexpected number of sent messages"), (long)expectedSends, (long)this.sentMessageCount);
    }

    public boolean waitForMessages(int seconds, int minMessages) throws InterruptedException {
        boolean waiting = true;
        long timeout = System.currentTimeMillis() + (long)(seconds * 1000);
        while ((waiting = this.receivedMessageCount < minMessages) && System.currentTimeMillis() < timeout) {
            Thread.sleep(100L);
        }
        return !waiting;
    }

    public void assertExpectedReceipt(int seconds, int expectedReceipt) throws InterruptedException {
        this.waitForMessages(seconds, expectedReceipt);
        Assert.assertEquals((String)(this.getAepEngine().getName() + " has unexpected number of received messages"), (long)expectedReceipt, (long)this.receivedMessageCount);
    }

    public void clearReceivedMessages() {
        if (this.holdMessages) {
            for (IRogMessage message : this.received) {
                message.dispose();
            }
            this.received.clear();
        }
        this.receivedMessageCount = 0;
    }

    public void cleanup() {
        this.clearReceivedMessages();
    }

    private class ToaTestServiceDefinitionLocator
    extends AbstractServiceDefinitionLocator {
        private ToaTestServiceDefinitionLocator() {
        }

        public void locateServices(Set<URL> urls) throws Exception {
            urls.add(((Object)((Object)this)).getClass().getResource("/services/forwarderService.xml"));
            urls.add(((Object)((Object)this)).getClass().getResource("/services/receiverService.xml"));
        }
    }
}

