/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.toa.test.unit;

import com.neeve.config.Config;
import com.neeve.ods.IStoreObject;
import com.neeve.rog.IRogMessage;
import com.neeve.rog.IRogMetadata;
import com.neeve.rog.IRogNode;
import com.neeve.rog.log.RogLogUtil;
import com.neeve.server.embedded.EmbeddedXVM;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.test.UnitTest;
import com.neeve.toa.TopicOrientedApplication;
import com.neeve.toa.test.unit.AbstractToaTestApp;
import com.neeve.toa.test.unit.SingleAppToaServer;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;

public abstract class AbstractToaTest
extends UnitTest {
    private static final HashSet<String> DIVERGENT_PRIMARY_BACKUP_FIELD_EXCEPTIONS = new HashSet();
    private static final HashSet<String> DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS = new HashSet();
    private static final RogLogUtil.FieldFilter PRIMARY_BACKUP_FILTER;
    private static final RogLogUtil.FieldFilter SENDER_RECEIVER_FILTER;
    protected final HashSet<EmbeddedXVM> servers = new HashSet();
    private Properties systemProperties;

    @BeforeClass
    public static void setup() {
        System.setProperty("nv.toa.usebusconfigtoresolvechannelbus", "false");
    }

    @Before
    public void saveSystemProperties() throws Exception {
        this.systemProperties = (Properties)System.getProperties().clone();
    }

    @After
    public void cleanup() throws Throwable {
        Throwable error = null;
        for (EmbeddedXVM server : this.servers) {
            try {
                Object app;
                server.shutdown();
                if (server.getStartupError() != null || !(server instanceof SingleAppToaServer) || !((app = ((SingleAppToaServer)server).getApplication()) instanceof AbstractToaTestApp)) continue;
                ((AbstractToaTestApp)((Object)app)).cleanup();
            }
            catch (Throwable thrown) {
                if (error != null) {
                    error = thrown;
                }
                thrown.printStackTrace();
            }
        }
        Config.reset((Properties)this.systemProperties);
        if (error != null) {
            throw error;
        }
        for (MessageBusDescriptor busDescriptor : MessageBusDescriptor.loadAll(null)) {
            busDescriptor.delete();
        }
    }

    protected <T extends TopicOrientedApplication> SingleAppToaServer<T> createServer(String appName, Class<T> applicationClass) {
        SingleAppToaServer<T> server = SingleAppToaServer.create(appName, null, applicationClass, null);
        this.servers.add(server);
        return server;
    }

    protected <T extends TopicOrientedApplication> SingleAppToaServer<T> createServer(String appName, String instanceId, Class<T> applicationClass) {
        SingleAppToaServer<T> server = SingleAppToaServer.create(appName, instanceId, applicationClass, null);
        this.servers.add(server);
        return server;
    }

    protected <T extends TopicOrientedApplication> SingleAppToaServer<T> createServer(String appName, String instanceId, Class<T> applicationClass, Map<String, String> configOverrides) {
        SingleAppToaServer<T> server = SingleAppToaServer.create(appName, instanceId, applicationClass, configOverrides);
        this.servers.add(server);
        return server;
    }

    protected <T extends TopicOrientedApplication> T createApp(String appName, String instanceId, Class<T> applicationClass) throws Throwable {
        SingleAppToaServer<T> server = this.createServer(appName, instanceId, applicationClass);
        server.start();
        if (server.getApplication().getEngine().isPrimary()) {
            server.getApplication().getEngine().waitForMessagingToStart();
        }
        return server.getApplication();
    }

    protected <T extends TopicOrientedApplication> T createApp(String appName, String instanceId, Class<T> applicationClass, Map<String, String> configOverrides) throws Throwable {
        SingleAppToaServer<T> server = this.createServer(appName, instanceId, applicationClass, configOverrides);
        server.start();
        if (server.getApplication().getEngine().isPrimary()) {
            server.getApplication().getEngine().waitForMessagingToStart();
        }
        return server.getApplication();
    }

    protected final void assertPrimaryAndBackupMessageEqual(AbstractToaTestApp primary, AbstractToaTestApp backup) throws Exception {
        Assert.assertEquals((String)"Backup has different number of messages than primary.", (long)primary.receivedMessageCount, (long)backup.receivedMessageCount);
        StringBuffer diffBuffer = new StringBuffer();
        for (int i = 1; i <= primary.received.size(); ++i) {
            if (RogLogUtil.compareRogNodes((IRogNode)((IRogNode)primary.received.get(i - 1)), (IRogNode)((IRogNode)backup.received.get(i - 1)), (RogLogUtil.FieldFilter)PRIMARY_BACKUP_FILTER, (StringBuffer)diffBuffer)) continue;
            throw new Exception("Primary (source) and backup (target) messages diverge at message #" + i + ": " + diffBuffer);
        }
    }

    protected final void assertSentAndReceivedMessageEqual(AbstractToaTestApp sender, AbstractToaTestApp receiver) throws Exception {
        if (!sender.holdMessages || !receiver.holdMessages) {
            Assert.assertEquals((String)"Backup has different number of messages than primary.", (long)sender.receivedMessageCount, (long)receiver.receivedMessageCount);
            return;
        }
        for (int i = 1; i <= sender.sent.size(); ++i) {
            if (receiver.received.size() < i) {
                IRogMessage sent = sender.sent.get(i - 1);
                StringWriter writer = new StringWriter();
                RogLogUtil.dumpObjectAsJson((IRogMetadata)sent.getMetadata(), (IStoreObject)sent, (boolean)true, (boolean)true, (boolean)true, (RogLogUtil.JsonPrettyPrintStyle)RogLogUtil.JsonPrettyPrintStyle.Default, (Writer)writer);
                throw new Exception("Receiver didn't receive message #" + i + ":\n " + writer.toString());
            }
            this.assertSentAndReceivedMessagesEqual("Sender (source) and receiver (target) messages diverge at message #" + i + ": ", sender.sent.get(i - 1), receiver.received.get(i - 1));
        }
        if (receiver.received.size() > sender.sent.size()) {
            IRogMessage received = receiver.received.get(sender.sent.size());
            StringWriter writer = new StringWriter();
            RogLogUtil.dumpObjectAsJson((IRogMetadata)received.getMetadata(), (IStoreObject)received, (boolean)true, (boolean)true, (boolean)true, (RogLogUtil.JsonPrettyPrintStyle)RogLogUtil.JsonPrettyPrintStyle.Default, (Writer)writer);
            throw new Exception("Receiver received " + (receiver.received.size() - sender.sent.size()) + " additional messages. First message:\n " + writer.toString());
        }
    }

    protected final void assertSentAndReceivedMessagesEqual(String text, IRogMessage sentMessage, IRogMessage receivedMessage) throws Exception {
        StringBuffer diffBuffer = new StringBuffer();
        if (!RogLogUtil.compareRogNodes((IRogNode)sentMessage, (IRogNode)receivedMessage, (RogLogUtil.FieldFilter)SENDER_RECEIVER_FILTER, (StringBuffer)diffBuffer)) {
            throw new Exception(text + ":" + diffBuffer);
        }
    }

    static {
        DIVERGENT_PRIMARY_BACKUP_FIELD_EXCEPTIONS.add("ownershipCount");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("messageBus");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("messageChannel");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("messageKey");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("messageBusAsRaw");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("messageChannelAsRaw");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("messageKeyAsRaw");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("transactionInSequenceNumber");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("transactionOutSequenceNumber");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("inMsgsInTransaction");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("outMsgsInTransaction");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("ownershipCount");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("outTs");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("transactionInSequenceNumber");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("isInboundMessage");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("serializedMetadataLength");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("isOutboundMessage");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("transactionId");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("preProcessingTs");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("postProcessingTs");
        PRIMARY_BACKUP_FILTER = new RogLogUtil.FieldFilter(){
            RogLogUtil.FieldFilter defaultFilter;

            public final boolean filter(Class<?> type, String path) {
                if (this.defaultFilter == null) {
                    try {
                        this.defaultFilter = RogLogUtil.loadComparisonFilter();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error loading comparison filter", e);
                    }
                }
                return this.defaultFilter.filter(type, path) || DIVERGENT_PRIMARY_BACKUP_FIELD_EXCEPTIONS.contains(path);
            }
        };
        SENDER_RECEIVER_FILTER = new RogLogUtil.FieldFilter(){
            RogLogUtil.FieldFilter defaultFilter;

            public final boolean filter(Class<?> type, String path) {
                if (this.defaultFilter == null) {
                    try {
                        this.defaultFilter = RogLogUtil.loadComparisonFilter();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error loading comparison filter", e);
                    }
                }
                return this.defaultFilter.filter(type, path) || DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.contains(path);
            }
        };
    }
}

