/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.toa.test.unit;

import com.neeve.ci.XRuntime;
import com.neeve.config.VMConfigurer;
import com.neeve.server.Configurer;
import com.neeve.server.Main;
import com.neeve.server.app.SrvAppLoader;
import com.neeve.server.config.SrvConfigDescriptor;
import com.neeve.server.embedded.EmbeddedXVM;
import com.neeve.toa.TopicOrientedApplication;
import com.neeve.util.UtlStr;
import com.neeve.util.UtlTailoring;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class SingleAppToaServer<T extends TopicOrientedApplication>
extends EmbeddedXVM {
    public static final String PROP_NAME_STORE_ENABLED = "store.enabled";
    public static final String PROP_NAME_STORE_CLUSTERING_ENABLED = "store.clustering.enabled";
    private final Class<T> applicationClass;
    private final String appName;
    private final String instanceId;
    private final String serverName;
    private T application;

    private SingleAppToaServer(ToaSingleAppServerConfigurer<T> configurer, SrvConfigDescriptor descriptor) {
        super(configurer, descriptor);
        this.appName = configurer.getAppName();
        this.instanceId = configurer.getInstanceId();
        this.serverName = configurer.getServerName();
        this.applicationClass = configurer.getApplicationClass();
    }

    public static final <T extends TopicOrientedApplication> SingleAppToaServer<T> create(String appName, String instanceId, Class<T> applicationClass, Map<String, String> configOverrides) {
        ToaSingleAppServerConfigurer<T> configurer = new ToaSingleAppServerConfigurer<T>(appName, instanceId, applicationClass, configOverrides);
        try {
            SrvConfigDescriptor descriptor = Main.seedServerConfig(configurer, (String[])new String[0]);
            return new SingleAppToaServer<T>(configurer, descriptor);
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading toa server", e);
        }
    }

    public void onStartEnd(Throwable error) throws Exception {
        SrvAppLoader loader;
        if (error == null && (loader = this.getServerController().getAppManager().getAppLoader(this.appName)) != null) {
            Object main = loader.getAppMain();
            if (this.applicationClass == main.getClass()) {
                this.application = (TopicOrientedApplication)main;
            } else {
                throw new Exception("Application '" + this.appName + "' main class was expected to be type '" + this.applicationClass.getCanonicalName() + "' but loaded class was '" + main.getClass().getCanonicalName() + ".");
            }
        }
    }

    public String getAppName() {
        return this.appName;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getServerName() {
        return this.serverName;
    }

    public T getApplication() {
        if (this.application != null) {
            return this.application;
        }
        if (this.getState() != EmbeddedXVM.State.Started) {
            throw new IllegalStateException("Application not available until server started");
        }
        throw new IllegalStateException("Application not loaded.");
    }

    public String toString() {
        return "ToaTestServer " + this.getServerName() + " (" + this.applicationClass.getSimpleName() + ")";
    }

    private static class ToaSingleAppServerConfigurer<T extends TopicOrientedApplication>
    implements Configurer,
    UtlTailoring.PropertySource {
        private final String appName;
        private final String instanceId;
        private final String serverName;
        private final Class<T> applicationClass;
        private final UtlTailoring.PropertySource envResolver = new UtlStr.SubstResolverFromEnv();
        final Map<String, String> overrides = new HashMap<String, String>();

        ToaSingleAppServerConfigurer(String appName, String instanceId, Class<T> applicationClass, Map<String, String> configOverrides) {
            this.appName = appName;
            this.instanceId = instanceId;
            this.serverName = appName + "-" + instanceId;
            this.applicationClass = applicationClass;
            XRuntime.getProps().setProperty("nv.server.autostop.onlastappstop", "false");
            this.overrides.put("application.name", appName);
            this.overrides.put("application.server.name", appName + "-" + instanceId);
            this.overrides.put("application.main.class", applicationClass.getName());
            this.overrides.put("transport.descriptor", "loopback://.");
            this.overrides.put("store.discovery.descriptor", "loopback://clusterdiscovery&initWaitTime=2");
            this.overrides.put("server.discoveryDescriptor", "local://serverdiscovery&initWaitTime=0");
            if (configOverrides != null) {
                this.overrides.putAll(configOverrides);
                XRuntime.getProps().putAll(this.overrides);
            }
        }

        public String[] configure(String[] args) throws Exception {
            URL overlayUrl = SingleAppToaServer.class.getResource("/conf/platform.xml");
            File overlayConfig = new File(overlayUrl.toURI());
            VMConfigurer.configure((File)overlayConfig, (UtlTailoring.PropertySource)this);
            return new String[]{"--name", this.serverName};
        }

        public String getValue(String key, String defaultValue) {
            String override = this.overrides.get(key);
            if (override != null) {
                return override;
            }
            return this.envResolver.getValue(key, defaultValue);
        }

        public final String getAppName() {
            return this.appName;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final String getServerName() {
            return this.serverName;
        }

        public final Class<T> getApplicationClass() {
            return this.applicationClass;
        }
    }
}

