/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.managed.hk2;

import com.neeve.ci.XRuntime;
import com.neeve.managed.ManagedObjectLocator;
import com.neeve.managed.hk2.ManagedImpl;
import com.neeve.managed.hk2.PlatformModules;
import com.neeve.toa.TopicOrientedApplication;
import com.neeve.trace.Tracer;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;

public class HK2ManagedObjectLocator
implements ManagedObjectLocator {
    public static final String PROP_ENABLE_HK2_IMMEDIATE_SCOPE = "nv.toa.hk2.enableimmediatescope";
    public static final boolean PROP_ENABLE_HK2_IMMEDIATE_SCOPE_DEFAULT = false;
    protected final Tracer tracer = Tracer.get((String)"nv.toa");
    private final TopicOrientedApplication application;
    private final List<Binder> applicationModules;
    private final String applicationName;
    private ServiceLocator applicationServiceLocator;

    public HK2ManagedObjectLocator(TopicOrientedApplication application, String applicationName, List<Binder> applicationModules) {
        this.application = application;
        this.applicationName = applicationName;
        this.applicationModules = applicationModules;
        this.applicationServiceLocator = this.initializeApplicationServiceLocator();
    }

    public void locateManagedObjects(Set<Object> managedObjects) throws Exception {
        List<Object> applicationManagedObjects = this.findManagedObjects();
        if (applicationManagedObjects.isEmpty()) {
            this.tracer.log("No Managed Objects found", Tracer.Level.WARNING);
        }
        if (this.tracer.debug) {
            for (Object object : applicationManagedObjects) {
                this.tracer.log(this + " found ManagedObject=" + object, Tracer.Level.DEBUG);
            }
        }
        for (Object object : applicationManagedObjects) {
            this.applicationServiceLocator.inject(object);
        }
        managedObjects.addAll(applicationManagedObjects);
    }

    private List<Object> findManagedObjects() {
        List serviceHandles = this.applicationServiceLocator.getAllServiceHandles((Annotation)((Object)new ManagedImpl()), new Annotation[0]);
        ArrayList<Object> managedObjects = new ArrayList<Object>();
        for (ServiceHandle serviceHandle : serviceHandles) {
            managedObjects.add(serviceHandle.getService());
        }
        return managedObjects;
    }

    private ServiceLocator initializeApplicationServiceLocator() {
        ServiceLocator serviceLocator = this.createServiceLocator(this.applicationName);
        if (XRuntime.getValue((String)PROP_ENABLE_HK2_IMMEDIATE_SCOPE, (boolean)false)) {
            ServiceLocatorUtilities.enableImmediateScope((ServiceLocator)serviceLocator);
        }
        ArrayList<Binder> modules = new ArrayList<Binder>(this.createPlatformModules());
        modules.addAll(this.applicationModules);
        ServiceLocatorUtilities.bind((ServiceLocator)serviceLocator, (Binder[])modules.toArray(new Binder[modules.size()]));
        return serviceLocator;
    }

    protected List<Binder> createPlatformModules() {
        ArrayList<Binder> binders = new ArrayList<Binder>();
        binders.add((Binder)new PlatformModules(this.application));
        return binders;
    }

    protected ServiceLocator createServiceLocator(String applicationName) {
        return ServiceLocatorFactory.getInstance().create(applicationName, null, null, ServiceLocatorFactory.CreatePolicy.ERROR);
    }

    public void destroy() {
        this.applicationServiceLocator.shutdown();
    }

    public ServiceLocator getApplicationServiceLocator() {
        return this.applicationServiceLocator;
    }
}

