/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.webservice;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.name.Named;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.GuiceServletContextListener;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlThrowable;
import com.sun.jersey.api.core.PackagesResourceConfig;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.ws.rs.core.Application;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;

public final class HttpServer {
    private final Server _server;
    private final Tracer _tracer;
    private State _state;

    @Inject
    public HttpServer(Tracer tracer, @Named(value="nv.webservice.http.port") Integer port) {
        this._tracer = tracer;
        this._tracer.log("Using port: " + port, Tracer.Level.INFO);
        this._server = new Server(port.intValue());
        this._state = State.Init;
    }

    private File copyResourcesToTempDir(String webappDir) {
        String tempDirectory = System.getProperty("java.io.tmpdir");
        File baseDirectory = null;
        try {
            URL url = Server.class.getClassLoader().getResource(webappDir);
            if (url != null) {
                if (url.getPath().contains(".jar!/" + webappDir)) {
                    baseDirectory = new File(tempDirectory, UUID.randomUUID().toString());
                    baseDirectory.mkdir();
                    baseDirectory.deleteOnExit();
                    String path = url.getPath().substring(5, url.getPath().length() - (webappDir.length() + 2));
                    JarFile jar = new JarFile(new File(path));
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry jarEntry = entries.nextElement();
                        if (!jarEntry.getName().startsWith(webappDir)) continue;
                        File file = new File(baseDirectory, jarEntry.getName().substring(webappDir.length()));
                        this.copyContent(file, jar, jarEntry);
                    }
                } else {
                    baseDirectory = new File(url.toURI());
                }
            } else {
                this._tracer.log("No resources in class path for " + webappDir, Tracer.Level.WARNING);
            }
        }
        catch (Exception ioe) {
            this._tracer.log(UtlThrowable.prepareStackTrace((Throwable)ioe), Tracer.Level.SEVERE);
        }
        return baseDirectory;
    }

    private void copyContent(File file, JarFile jar, JarEntry jarEntry) throws IOException {
        file.deleteOnExit();
        if (!jarEntry.isDirectory()) {
            int oneChar;
            file.createNewFile();
            InputStream in = jar.getInputStream(jarEntry);
            FileOutputStream out = new FileOutputStream(file);
            while ((oneChar = in.read()) != -1) {
                ((OutputStream)out).write(oneChar);
            }
            ((OutputStream)out).close();
            in.close();
        } else {
            file.mkdirs();
        }
    }

    public final String getServerUrl() {
        String host = this._server.getConnectors()[0].getHost();
        if (host == null) {
            try {
                host = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return "http://" + host + ":" + this._server.getConnectors()[0].getPort();
    }

    public final void start(final Injector injector, String webappDir, String webserviceResourcesPackage) throws URISyntaxException {
        if (this._state == State.Init) {
            File tempDir = this.copyResourcesToTempDir(webappDir);
            this._tracer.log("Resource directory='" + tempDir.getAbsolutePath() + "'", Tracer.Level.INFO);
            ResourceHandler staticHandler = new ResourceHandler();
            staticHandler.setResourceBase(tempDir.getPath());
            ServletContextHandler dynamicHandler = new ServletContextHandler(1);
            dynamicHandler.setContextPath("/");
            dynamicHandler.addServlet(new ServletHolder((Servlet)new ServletContainer((Application)new PackagesResourceConfig(new String[]{"com.neeve.webservice.resources", "io.swagger.jaxrs.listing", webserviceResourcesPackage}))), "/*");
            dynamicHandler.addEventListener((EventListener)new GuiceServletContextListener(){

                protected final Injector getInjector() {
                    return injector;
                }
            });
            FilterHolder cors = dynamicHandler.addFilter(CrossOriginFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
            cors.setInitParameter("allowedOrigins", "*");
            cors.setInitParameter("Access-Control-Allow-Origin", "*");
            cors.setInitParameter("allowedMethods", "GET,POST,HEAD");
            cors.setInitParameter("allowedHeaders", "X-Requested-With,Content-Type,Accept,Origin");
            ServletContextHandler swaggerHandler = new ServletContextHandler(1);
            ResourceHandler rh = new ResourceHandler();
            rh.setResourceBase(this.getClass().getClassLoader().getResource("META-INF/resources/webjars/swagger-ui/2.1.4").toURI().toString());
            swaggerHandler.setContextPath("/doc");
            swaggerHandler.setHandler((Handler)rh);
            swaggerHandler.addFilter(GuiceFilter.class, "/*", null);
            swaggerHandler.addServlet(DefaultServlet.class, "/");
            HandlerList handlers = new HandlerList();
            handlers.setHandlers(new Handler[]{staticHandler, swaggerHandler, dynamicHandler});
            this._server.setHandler((Handler)handlers);
            try {
                this._server.start();
                this._tracer.log("Started HTTP server", Tracer.Level.INFO);
                this._state = State.Started;
            }
            catch (Exception e) {
                this._tracer.log(UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.SEVERE);
                this._state = State.Failed;
                this._tracer.log("Failed to start HTTP server [" + e.toString() + "]", Tracer.Level.SEVERE);
                this.stop();
            }
        } else {
            throw new IllegalStateException("invalid state '" + (Object)((Object)this._state) + "'");
        }
    }

    public final void stop() {
        switch (this._state) {
            case Init: {
                break;
            }
            case Started: 
            case Failed: {
                try {
                    this._server.stop();
                    this._tracer.log("Stopped HTTP server", Tracer.Level.INFO);
                    break;
                }
                catch (Exception e) {
                    this._tracer.log("Failed to stop HTTP server [" + e.toString() + "]", Tracer.Level.SEVERE);
                    break;
                }
                finally {
                    this._state = State.Stopped;
                }
            }
            case Stopped: {
                break;
            }
            default: {
                throw new IllegalStateException("unknown state '" + (Object)((Object)this._state) + "'");
            }
        }
    }

    private static enum State {
        Init,
        Started,
        Failed,
        Stopped;

    }
}

