/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.service;

import com.neeve.service.entities.ErrorCode;
import com.neeve.service.entities.ErrorType;

public class EServiceException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private ErrorType type;
    private ErrorCode code;
    private String description;
    private String extInfo;
    private int extCode;

    public EServiceException(Throwable cause) {
        super(cause);
    }

    public EServiceException(Throwable cause, ErrorCode code) {
        super(cause);
        this.type = ErrorType.System;
        this.code = code;
        this.description = cause.getMessage();
        this.extInfo = null;
    }

    public EServiceException(ErrorType type, ErrorCode code, String description, int extCode, String extInfo) {
        super(code.toString() + "{" + description + "<" + extCode + ": " + extInfo + ">}");
        this.type = type;
        this.code = code == null ? ErrorCode.UnknownError : code;
        this.description = description;
        this.extCode = extCode;
        this.extInfo = extInfo;
    }

    public EServiceException(ErrorType type, ErrorCode code, String description, String extInfo) {
        this(type, code, description, -1, extInfo);
    }

    public final ErrorType getErrorType() {
        return this.type;
    }

    public final ErrorCode getErrorCode() {
        return this.code;
    }

    public final String getErrorDescription() {
        return this.description == null ? super.getMessage() : this.description;
    }

    public final String getErrorExtInfo() {
        return this.extInfo;
    }

    public final int getErrorExtCode() {
        return this.extCode;
    }

    @Override
    public final String getMessage() {
        if (this.description == null) {
            return super.getMessage();
        }
        if (this.description != null && this.extInfo == null) {
            return "<" + (Object)((Object)this.code) + ">[" + this.description + "<" + this.extCode + ">]";
        }
        return "<" + (Object)((Object)this.code) + ">[" + this.description + "<" + this.extCode + ": " + this.extInfo + ">]";
    }
}

