/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.service;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.neeve.blog.Blogger;
import com.neeve.ci.XRuntime;
import com.neeve.rog.IRogNode;
import com.neeve.service.IAlertTracer;
import com.neeve.service.IdentityInformationProvider;
import com.neeve.service.messages.AgentInfo;
import com.neeve.service.messages.Alert;
import com.neeve.service.messages.AlertRequest;
import com.neeve.service.messages.AlertSeverity;
import com.neeve.service.messages.MessageHeader;
import com.neeve.service.messages.NullMessage;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlThrowable;
import java.util.Date;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

@Singleton
public final class Alerter {
    private final IdentityInformationProvider _identityInfoProvider;
    private final String _logName;
    private final Blogger _blogger;
    private final ScheduledThreadPoolExecutor _lastAlertStabilizationExecutor;
    private final Tracer _tracer;
    private final Date _startTime;
    private volatile Callout _callout;
    private volatile boolean _loggingEnabled;
    private AtomicBoolean _alertStabilizationPending;

    @Inject
    public Alerter(@Named(value="nv.service.alert.logging.enabled") Boolean loggingEnabled, @Named(value="nv.service.alert.logging.location") String loggingLocation, IdentityInformationProvider identityInfoProvider, IAlertTracer tracer) {
        this._loggingEnabled = loggingEnabled;
        this._identityInfoProvider = identityInfoProvider;
        this._logName = this._identityInfoProvider.getAgentName() + "-alerts";
        this._blogger = Blogger.create((String)this._logName).setLocation(loggingLocation);
        this._lastAlertStabilizationExecutor = new ScheduledThreadPoolExecutor(1, new LastAlertStabilizationExecutorThreadFactory());
        this._lastAlertStabilizationExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this._alertStabilizationPending = new AtomicBoolean();
        this._tracer = tracer.getTracer();
        this._startTime = new Date();
    }

    private final void log(String headline, String str, Throwable e, Severity severity, String classifier) {
        if (this._loggingEnabled) {
            try {
                this._blogger.log((IRogNode)this.createAlert(new Date(), headline, str, e, severity, classifier));
                this._alertStabilizationPending.set(true);
            }
            catch (Throwable e1) {
                StringBuilder sb = new StringBuilder();
                sb.append("Failed to log alert [" + e1.toString() + "]").append("\n");
                sb.append("Stack trace:").append("\n");
                sb.append(UtlThrowable.prepareStackTrace((Throwable)e1));
                this._tracer.log(sb.toString(), Tracer.Level.WARNING);
            }
        }
    }

    private final AlertSeverity toAlertSeverity(Severity severity) {
        if (severity != null) {
            switch (severity) {
                case Info: {
                    return AlertSeverity.Info;
                }
                case Warning: {
                    return AlertSeverity.Warning;
                }
                case Severe: {
                    return AlertSeverity.Severe;
                }
            }
            return AlertSeverity.Unknown;
        }
        return AlertSeverity.Unknown;
    }

    private final void setAgentInfo(Alert alert) {
        AgentInfo agentInfo = AgentInfo.create();
        agentInfo.setApplicationName(this._identityInfoProvider.getName());
        agentInfo.setApplicationPartition(this._identityInfoProvider.getPartition());
        agentInfo.setPid(XRuntime.getPid());
        agentInfo.setStartTime(this._startTime);
        alert.setAgentInfo(agentInfo);
    }

    final Alert populateAlert(Alert alert, AgentInfo agentInfo, Date timestamp, String headline, String desc, String stackTrace, AlertSeverity severity, String classifier) {
        try {
            if (agentInfo != null) {
                alert.setAgentInfo(agentInfo);
            } else {
                this.setAgentInfo(alert);
            }
            alert.setTimestamp(timestamp);
            alert.setHeadline(headline);
            alert.setClassifier(classifier);
            alert.setDesc(desc);
            alert.setStackTrace(stackTrace);
            alert.setSeverity(severity);
        }
        catch (Throwable e) {
            this._tracer.log(UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.SEVERE);
        }
        return alert;
    }

    final Alert populateAlert(Alert alert, AlertRequest request) {
        return this.populateAlert(Alert.create(), request.getAgentInfo() != null ? (AgentInfo)request.getAgentInfo().clone() : null, request.getTimestamp(), request.getHeadline(), request.getDesc(), request.getStackTrace(), request.getSeverity(), request.getClassifier());
    }

    final Alert createAlert(Date timestamp, String headline, String desc, String stackTrace, AlertSeverity severity, String classifier) {
        return this.populateAlert(Alert.create(), null, timestamp, headline, desc, stackTrace, severity, classifier);
    }

    final Alert createAlert(Date timestamp, String headline, String desc, String stackTrace, Severity severity, String classifier) {
        return this.createAlert(timestamp, headline, desc, stackTrace, this.toAlertSeverity(severity), classifier);
    }

    final Alert createAlert(Date timestamp, String headline, String desc, Throwable e, Severity severity, String classifier) {
        return this.createAlert(timestamp, headline, desc, e != null ? UtlThrowable.prepareStackTrace((Throwable)e) : null, severity, classifier);
    }

    final AlertRequest createAlertRequest(Date timestamp, String headline, String desc, Throwable e, Severity severity, String classifier) {
        AlertRequest request = AlertRequest.create();
        request.setHeader(MessageHeader.create());
        request.setTimestamp(timestamp);
        request.setHeadline(headline);
        request.setClassifier(classifier);
        request.setDesc(desc);
        request.setStackTrace(e != null ? UtlThrowable.prepareStackTrace((Throwable)e) : null);
        request.setSeverity(this.toAlertSeverity(severity));
        return request;
    }

    public final String getLogName() {
        return this._logName;
    }

    public final void open(Callout callout) throws Exception {
        this._blogger.open();
        if (this._lastAlertStabilizationExecutor != null) {
            this._lastAlertStabilizationExecutor.scheduleWithFixedDelay(new LastAlertStabilizationExecutor(), 1L, 1L, TimeUnit.SECONDS);
        }
        this._callout = callout;
    }

    public final Alerter enableLogging(boolean val) {
        this._loggingEnabled = val;
        return this;
    }

    public final boolean isLoggingEnabled() {
        return this._loggingEnabled;
    }

    public final void setLogCompactionThreshold(int val) throws Exception {
        this._blogger.setLogCompactionThreshold(val);
    }

    public final void scheduleLogCompactionOnNextWrite() throws Exception {
        this._blogger.scheduleLogCompactionOnNextWrite();
    }

    public final void alert(String headline, String str, Throwable e, Severity severity, String classifier) {
        try {
            Tracer.Level level;
            StringBuilder sb = new StringBuilder();
            sb.append(str).append("\n");
            if (e != null) {
                sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
            }
            switch (severity) {
                case Info: {
                    level = Tracer.Level.INFO;
                    break;
                }
                case Warning: {
                    level = Tracer.Level.WARNING;
                    break;
                }
                case Severe: {
                    level = Tracer.Level.SEVERE;
                    break;
                }
                default: {
                    level = Tracer.Level.WARNING;
                }
            }
            this._tracer.log(sb.toString(), level);
            this.log(headline, str, e, severity, classifier);
            if (this._callout != null) {
                this._callout.onAlert(headline, str, e, severity, classifier);
            }
        }
        catch (Throwable e1) {
            this._tracer.log(UtlThrowable.prepareStackTrace((Throwable)e1), Tracer.Level.SEVERE);
        }
    }

    public final void alert(String str, Throwable e, Severity severity, String classifier) {
        this.alert(null, str, e, severity, classifier);
    }

    public final void alert(String str, Throwable e, Severity severity) {
        this.alert(str, e, severity, null);
    }

    public final void close() {
        if (this._lastAlertStabilizationExecutor != null) {
            this._lastAlertStabilizationExecutor.shutdown();
        }
        if (this._blogger.isOpen()) {
            this._blogger.close();
        }
    }

    public static interface Callout {
        public void onAlert(String var1, String var2, Throwable var3, Severity var4, String var5);
    }

    public static enum Severity {
        Info,
        Warning,
        Severe;

    }

    private final class LastAlertStabilizationExecutor
    implements Runnable {
        private LastAlertStabilizationExecutor() {
        }

        @Override
        public final void run() {
            if (Alerter.this._alertStabilizationPending.getAndSet(false)) {
                try {
                    Alerter.this._blogger.log((IRogNode)NullMessage.create());
                }
                catch (Throwable e) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Failed to log alert stabilizer [" + e.toString() + "]").append("\n");
                    sb.append("Stack trace:").append("\n");
                    sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                    Alerter.this._tracer.log(sb.toString(), Tracer.Level.WARNING);
                }
            }
        }
    }

    private final class LastAlertStabilizationExecutorThreadFactory
    implements ThreadFactory {
        private int num;

        private LastAlertStabilizationExecutorThreadFactory() {
        }

        @Override
        public final Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("X-Eagle-" + Alerter.this._identityInfoProvider.getAgentName() + "-LastAlertStabilizer-" + ++this.num);
            return thread;
        }
    }
}

