/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.asm;

import com.neeve.adm.AdmMessage;
import com.neeve.adm.AdmModel;
import com.neeve.asm.AsmModelElement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class AsmStreamingPeer
extends AsmModelElement {
    private final AdmModel messagesModel;
    private final List<Message> messages;
    private final Map<String, Channel> channels;

    public AsmStreamingPeer(AdmModel messagesModel) {
        if (messagesModel == null) {
            throw new IllegalArgumentException("messages model cannot be null");
        }
        this.messagesModel = messagesModel;
        this.messages = new ArrayList<Message>();
        this.channels = new LinkedHashMap<String, Channel>();
    }

    public final AdmModel getMessagesModel() {
        return this.messagesModel;
    }

    public final Map<String, Channel> getChannels() {
        return this.channels;
    }

    public final Channel getChannel(String name) {
        return this.channels.get(name);
    }

    public final List<Message> getMessages() {
        return this.messages;
    }

    public final Channel addChannel(String name, String key, String filter) {
        Channel channel = new Channel(name, key, filter);
        this.channels.put(name, channel);
        return channel;
    }

    public final void addMessage(AdmMessage message, String name, Channel channel) {
        this.messages.add(new Message(message, name, channel));
    }

    public final String toString() {
        return "[name=" + this.messagesModel.getName() + ", messages=" + (this.messages != null ? this.messages.size() : 0) + "]";
    }

    final class Message {
        private final String name;
        private final Channel channel;
        private final AdmMessage message;
        private final String handlerName;

        Message(AdmMessage message, String name, Channel channel) {
            this.name = name;
            this.channel = channel;
            this.message = message;
            this.handlerName = message.getNamespace().replace('.', '_') + "_" + message.getName() + "Handler";
        }

        public final String getName() {
            return this.name;
        }

        public final Channel getChannel() {
            return this.channel;
        }

        public final AdmMessage getMessage() {
            return this.message;
        }

        public final String getHandlerName() {
            return this.handlerName;
        }
    }

    final class Channel {
        private final String name;
        private final String key;
        private final String filter;

        Channel(String name, String key, String filter) {
            this.name = name;
            this.key = key;
            this.filter = filter;
        }

        public final String getName() {
            return this.name;
        }

        public final String getKey() {
            return this.key;
        }

        public final String getFilter() {
            return this.filter;
        }
    }
}

