/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.service.db.mps;

import com.neeve.service.cdc.DbEntityPersister;
import com.neeve.service.cdc.DbPersister;
import com.neeve.service.entities.MessageProcessingTime;
import com.neeve.service.entities.MessageProcessingTimeLogElement;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlThrowable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.HdrHistogram.IntCountsHistogram;
import org.influxdb.dto.Point;

public final class MessageProcessingTimePersister
extends DbEntityPersister {
    private static final String MPTS_TABLE_NAME = "MESSAGE_PROCESSING_TIME";
    private static final String MPTS_TIMESTAMP_FIELD_NAME = "TIMESTAMP";
    private static final String MPTS_TRANSACTION_FIELD_NAME = "TRANSACTION";
    private static final String MPTS_AGENT_FIELD_NAME = "AGENT";
    private static final String MPTS_LEG_FIELD_NAME = "LEG";
    private static final String MPTS_QUEUETIME_FIELD_NAME = "QUEUETIME";
    private static final String MPTS_PROCTIME_FIELD_NAME = "PROCTIME";
    private PreparedStatement _insertMessageProcessingTime;
    private PreparedStatement _pruneMessageProcessingTime;
    private final Map<String, HistogramComputer> _histogramComputers = new ConcurrentHashMap<String, HistogramComputer>();
    private final ScheduledThreadPoolExecutor _influxDbWriterExecutor = new ScheduledThreadPoolExecutor(1, new InfluxDbWriterExecutorThreadFactory());

    public MessageProcessingTimePersister(DbPersister persister) {
        super(persister);
        this._influxDbWriterExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
    }

    private final HistogramComputer getHistogramComputer(String agentName, String legName) {
        String key = agentName + legName;
        HistogramComputer computer = this._histogramComputers.get(key);
        if (computer == null) {
            computer = new HistogramComputer(agentName, legName);
            this._histogramComputers.put(key, computer);
        }
        return computer;
    }

    private final String createMessageProcessingTimesTableStatement() {
        return String.format("CREATE TABLE %s(%s %s, %s %s, %s %s, %s %s, %s %s, %s %s)", MPTS_TABLE_NAME, MPTS_TIMESTAMP_FIELD_NAME, MPTS_TIMESTAMP_FIELD_NAME, MPTS_TRANSACTION_FIELD_NAME, "VARCHAR(512)", MPTS_AGENT_FIELD_NAME, "VARCHAR(64)", MPTS_LEG_FIELD_NAME, "VARCHAR(255)", MPTS_QUEUETIME_FIELD_NAME, "NUMERIC(38,0)", MPTS_PROCTIME_FIELD_NAME, "NUMERIC(38,0)");
    }

    private final boolean createMessageProcessingTimesTable(StringBuilder sb) throws Exception {
        sb.append(MPTS_TABLE_NAME);
        if (!this.tableExists(MPTS_TABLE_NAME)) {
            this._rdbmsConnection.createStatement().execute(this.createMessageProcessingTimesTableStatement());
            return true;
        }
        return false;
    }

    private final String truncateMessageProcessingTimesTableStatement() {
        return String.format("TRUNCATE TABLE %s", MPTS_TABLE_NAME);
    }

    private final void truncateMessageProcessingTimesTable() throws Exception {
        if (this.tableExists(MPTS_TABLE_NAME)) {
            this._rdbmsConnection.createStatement().execute(this.truncateMessageProcessingTimesTableStatement());
        }
    }

    private final String dropMessageProcessingTimesTableStatement() {
        return String.format("DROP TABLE %s", MPTS_TABLE_NAME);
    }

    private final void dropMessageProcessingTimesTable() throws Exception {
        if (this.tableExists(MPTS_TABLE_NAME)) {
            this._rdbmsConnection.createStatement().execute(this.dropMessageProcessingTimesTableStatement());
        }
    }

    private final String createMessageProcessingTimeInsertStatement() {
        return String.format("INSERT INTO %s (%s, %s, %s, %s, %s, %s) VALUES (?, ?, ?, ?, ?, ?)", MPTS_TABLE_NAME, MPTS_TIMESTAMP_FIELD_NAME, MPTS_TRANSACTION_FIELD_NAME, MPTS_AGENT_FIELD_NAME, MPTS_LEG_FIELD_NAME, MPTS_QUEUETIME_FIELD_NAME, MPTS_PROCTIME_FIELD_NAME);
    }

    private final void createMessageProcessingTimeInsertPreparedStatement() throws Exception {
        this._insertMessageProcessingTime = this._rdbmsConnection.prepareStatement(this.createMessageProcessingTimeInsertStatement());
    }

    private final String createMessageProcessingTimePruneStatement() {
        return String.format("DELETE FROM %s WHERE %s < ?", MPTS_TABLE_NAME, MPTS_TIMESTAMP_FIELD_NAME);
    }

    private final void createMessageProcessingTimePrunePreparedStatement() throws Exception {
        this._pruneMessageProcessingTime = this._rdbmsConnection.prepareStatement(this.createMessageProcessingTimePruneStatement());
    }

    private final void insertMessageProcessingTime(MessageProcessingTime mpt) throws Exception {
        if (mpt != null) {
            try {
                this.getHistogramComputer(mpt.getAgentName(), mpt.getLegName()).add(mpt.getProcTime(), mpt.getQueueTime(), mpt.getTimestamp());
            }
            catch (Throwable e) {
                this.tracer().log(this.tracePrefix() + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.WARNING);
            }
            if (this._insertMessageProcessingTime != null) {
                this._insertMessageProcessingTime.setTimestamp(1, new Timestamp(mpt.getTimestamp()));
                this._insertMessageProcessingTime.setString(2, mpt.getTxnId());
                this._insertMessageProcessingTime.setString(3, mpt.getAgentName());
                this._insertMessageProcessingTime.setString(4, mpt.getLegName());
                this._insertMessageProcessingTime.setInt(5, mpt.getQueueTime());
                this._insertMessageProcessingTime.setInt(6, mpt.getProcTime());
                this._insertMessageProcessingTime.execute();
            }
        }
    }

    @Override
    protected final void doOpen() throws Exception {
        this._influxDbWriterExecutor.scheduleWithFixedDelay(new InfluxDbWriter(), this._persister.getInlfuxMpstatsInjectFrequency(), this._persister.getInlfuxMpstatsInjectFrequency(), TimeUnit.MILLISECONDS);
    }

    @Override
    protected final void doClose() {
        if (this._influxDbWriterExecutor != null) {
            this._influxDbWriterExecutor.shutdown();
        }
    }

    @Override
    protected final void createTables(boolean createIndexes) throws Exception {
        StringBuilder sb = new StringBuilder("...");
        sb.append(this.createMessageProcessingTimesTable(sb = new StringBuilder("...")) ? "...created" : "...exists");
        this.tracer().log(sb.toString(), Tracer.Level.INFO);
    }

    @Override
    protected final void createPreparedStatements() throws Exception {
        this.createMessageProcessingTimeInsertPreparedStatement();
        this.createMessageProcessingTimePrunePreparedStatement();
    }

    @Override
    protected final void closePreparedStatements() throws SQLException {
        if (this._insertMessageProcessingTime != null) {
            this._insertMessageProcessingTime.close();
        }
        if (this._pruneMessageProcessingTime != null) {
            this._pruneMessageProcessingTime.close();
        }
    }

    public final void dropTables() throws Exception {
        this.dropMessageProcessingTimesTable();
    }

    public final void truncateTables() throws Exception {
        this.truncateMessageProcessingTimesTable();
    }

    public final void insert(MessageProcessingTimeLogElement mptle) throws Exception {
        this.insertMessageProcessingTime(mptle.getTime());
    }

    private final class InfluxDbWriter
    implements Runnable {
        private InfluxDbWriter() {
        }

        @Override
        public final void run() {
            try {
                for (HistogramComputer computer : MessageProcessingTimePersister.this._histogramComputers.values()) {
                    computer.write();
                }
            }
            catch (Throwable e) {
                MessageProcessingTimePersister.this.tracer().log(MessageProcessingTimePersister.this.tracePrefix() + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.WARNING);
            }
        }
    }

    private final class InfluxDbWriterExecutorThreadFactory
    implements ThreadFactory {
        private InfluxDbWriterExecutorThreadFactory() {
        }

        @Override
        public final Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("X-Eagle-" + MessageProcessingTimePersister.this._persister.getAgentName() + "-InfluxDbWriter");
            return thread;
        }
    }

    private final class HistogramComputer {
        final String agentName;
        final String legName;
        int sampleSize = 0;
        long sampleStartTs = 0L;
        long sampleEndTs = 0L;
        long count = 0L;
        final Histogram queueTimeHistogram = new Histogram();
        final Histogram procTimeHistogram = new Histogram();

        HistogramComputer(String agentName, String legName) {
            this.agentName = agentName;
            this.legName = legName;
        }

        final synchronized void add(int procTime, int queueTime, long ts) {
            if (this.sampleStartTs == 0L) {
                this.sampleStartTs = ts;
            }
            this.sampleEndTs = ts;
            ++this.sampleSize;
            ++this.count;
            this.queueTimeHistogram.add(this.sampleSize, queueTime);
            this.procTimeHistogram.add(this.sampleSize, procTime);
        }

        final synchronized void write() {
            if (this.sampleSize == 0) {
                return;
            }
            long ts = (this.sampleStartTs + this.sampleEndTs) / 2L;
            MessageProcessingTimePersister.super.write(Point.measurement((String)"mpt").time(ts, TimeUnit.MILLISECONDS).tag("agent_name", this.agentName).tag("leg_name", this.legName).addField("queue_time_min", (double)this.queueTimeHistogram.min).addField("proc_time_min", (double)this.procTimeHistogram.min).addField("queue_time_50", (double)this.queueTimeHistogram.histogram.getValueAtPercentile(50.0)).addField("proc_time_50", (double)this.procTimeHistogram.histogram.getValueAtPercentile(50.0)).addField("queue_time_90", (double)this.queueTimeHistogram.histogram.getValueAtPercentile(90.0)).addField("proc_time_90", (double)this.procTimeHistogram.histogram.getValueAtPercentile(90.0)).addField("queue_time_99", (double)this.queueTimeHistogram.histogram.getValueAtPercentile(99.0)).addField("proc_time_99", (double)this.procTimeHistogram.histogram.getValueAtPercentile(99.0)).addField("queue_time_mean", (double)this.queueTimeHistogram.mean).addField("proc_time_mean", (double)this.procTimeHistogram.mean).addField("queue_time_max", (double)this.queueTimeHistogram.max).addField("proc_time_max", (double)this.procTimeHistogram.max).addField("sample", (double)this.sampleSize).addField("count", (double)this.count).build());
            this.sampleEndTs = 0L;
            this.sampleStartTs = 0L;
            this.sampleSize = 0;
            this.queueTimeHistogram.reset();
            this.procTimeHistogram.reset();
        }

        private final class Histogram {
            final IntCountsHistogram histogram = new IntCountsHistogram((long)((int)TimeUnit.MINUTES.toMicros(10L)), 3);
            int min = Integer.MAX_VALUE;
            float mean = 0.0f;
            int max = 0;

            private Histogram() {
            }

            final void add(int sampleSize, int value) {
                this.min = Math.min(this.min, value);
                this.max = Math.max(this.max, value);
                this.mean = sampleSize == 1 ? (float)value : this.mean * (float)(sampleSize - 1) / (float)sampleSize + (float)value / (float)sampleSize;
                if ((long)value > this.histogram.getHighestTrackableValue()) {
                    value = (int)this.histogram.getHighestTrackableValue();
                }
                if (value < 0) {
                    value = 0;
                }
                this.histogram.recordValue((long)value);
            }

            final void reset() {
                this.min = Integer.MAX_VALUE;
                this.mean = 0.0f;
                this.max = 0;
                this.histogram.reset();
            }
        }
    }
}

