/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.asm;

import com.neeve.adm.AdmMessage;
import com.neeve.asm.AsmDocumentation;
import com.neeve.asm.AsmModelElement;
import java.util.Set;

public final class AsmOperation
extends AsmModelElement {
    private final String name;
    private final Type type;
    private final AdmMessage inMessage;
    private final AdmMessage outMessage;
    private final Set<AdmMessage> eventMessages;
    private final String restPath;
    private final RestMethod restMethod;
    private String handlerName;
    private final int partition;
    private final AsmDocumentation documentation;

    public AsmOperation(String name, Type type, AdmMessage inMessage, AdmMessage outMessage, Set<AdmMessage> eventMessages, String restPath, RestMethod restMethod, int parition, AsmDocumentation documentation) {
        if (inMessage == null) {
            throw new IllegalArgumentException("in message cannot be null");
        }
        this.name = name;
        this.type = type;
        this.inMessage = inMessage;
        this.outMessage = outMessage;
        this.eventMessages = eventMessages;
        this.restPath = restPath;
        this.restMethod = restMethod;
        this.handlerName = inMessage.getName() + "Handler";
        this.partition = parition;
        this.documentation = documentation;
    }

    public AsmOperation(String name, Type type, AdmMessage inMessage, AdmMessage outMessage, Set<AdmMessage> eventMessages, String restPath, RestMethod restMethod) {
        this(name, type, inMessage, outMessage, eventMessages, restPath, restMethod, 0, null);
    }

    public AsmOperation(String name, Type type, AdmMessage inMessage, AdmMessage outMessage, Set<AdmMessage> eventMessages) {
        this(name, type, inMessage, outMessage, eventMessages, null, null);
    }

    public final String getName() {
        return this.name;
    }

    public final Type getType() {
        return this.type;
    }

    public AsmDocumentation getDocumentation() {
        return this.documentation;
    }

    public final AdmMessage getInMessage() {
        return this.inMessage;
    }

    public final AdmMessage getOutMessage() {
        return this.outMessage;
    }

    public final Set<AdmMessage> getEventMessages() {
        return this.eventMessages;
    }

    public final String getRESTPath() {
        return this.restPath;
    }

    public final RestMethod getRESTMethod() {
        return this.restMethod;
    }

    public final int getPartition() {
        return this.partition;
    }

    final void setHandlerName(String handlerName) {
        this.handlerName = handlerName;
    }

    final String getHandlerName() {
        return this.handlerName;
    }

    public final String toString() {
        return "[name=" + this.name + ", type=" + (Object)((Object)this.type) + ", in=" + this.inMessage.getFullName() + ", out=" + (this.outMessage != null ? this.outMessage.getFullName() : "null") + ", events=" + (this.eventMessages != null ? this.eventMessages.size() : 0) + ", RESTPath=" + this.restPath + ", handlerName=" + this.handlerName + "]";
    }

    public static enum RestMethod {
        GET,
        POST;

    }

    public static enum Type {
        local,
        remote;

    }
}

