/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.asm;

import com.neeve.adm.AdmArray;
import com.neeve.adm.AdmCollection;
import com.neeve.adm.AdmDocumentation;
import com.neeve.adm.AdmEntity;
import com.neeve.adm.AdmEntityArray;
import com.neeve.adm.AdmEnumeration;
import com.neeve.adm.AdmEnumerationArray;
import com.neeve.adm.AdmFactory;
import com.neeve.adm.AdmField;
import com.neeve.adm.AdmGenerator;
import com.neeve.adm.AdmMessage;
import com.neeve.adm.AdmModel;
import com.neeve.adm.AdmPrimitive;
import com.neeve.adm.AdmPrimitiveArray;
import com.neeve.adm.AdmType;
import com.neeve.asm.AsmDocumentation;
import com.neeve.asm.AsmModelElement;
import com.neeve.asm.AsmModule;
import com.neeve.asm.AsmOperation;
import com.neeve.asm.AsmStreamingPeer;
import com.neeve.asm.EAsmException;
import com.neeve.service.AbstractApp;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlText;
import io.swagger.models.Info;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import io.swagger.models.properties.UUIDProperty;
import io.swagger.util.Json;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang.StringUtils;

public final class AsmModel
extends AsmModelElement {
    private final String name;
    private final String namespace;
    private final AdmModel messagesModel;
    private final AdmModel stateModel;
    private final AdmEntity stateRoot;
    private final Set<AsmModule> modules;
    private final Set<AsmModel> peers;
    private final Set<AsmStreamingPeer> streamingPeers;
    private final Set<AsmOperation> operations;
    private final AdmModel eagleMessagesModel;
    private AsmDocumentation documentation;

    public AsmModel(String name, String namespace, AdmModel messagesModel, AdmModel stateModel, AdmEntity stateRoot, AdmModel eagleMessagesModel) {
        if (namespace == null) {
            throw new IllegalArgumentException("model namespace cannot be null");
        }
        if (messagesModel == null) {
            throw new IllegalArgumentException("message model cannot be null");
        }
        if (stateModel == null) {
            throw new IllegalArgumentException("state model cannot be null");
        }
        if (stateRoot == null) {
            throw new IllegalArgumentException("state root cannot be null");
        }
        if (eagleMessagesModel == null) {
            throw new IllegalArgumentException("eagle messages mode cannot be null");
        }
        if (this.tracer.debug) {
            this.tracer.log("ASM Model '" + namespace + "': Creating model (name='" + name + "', namespace='" + namespace + "'...", Tracer.Level.DEBUG);
        }
        this.name = name;
        this.namespace = namespace;
        this.messagesModel = messagesModel;
        this.stateModel = stateModel;
        this.modules = new LinkedHashSet<AsmModule>();
        this.peers = new LinkedHashSet<AsmModel>();
        this.streamingPeers = new LinkedHashSet<AsmStreamingPeer>();
        this.operations = new LinkedHashSet<AsmOperation>();
        this.stateRoot = stateRoot;
        this.eagleMessagesModel = eagleMessagesModel;
    }

    private final String forConfigurationProperty(String str) {
        return str.replace("-", ".").replace("_", ".");
    }

    private final AdmMessage getNullMessage() {
        return this.eagleMessagesModel.getMessage("NullMessage");
    }

    private final File resolveAbsoluteClassFile(File baseDir, String namespace, String classname) throws Exception {
        StringBuilder sb = new StringBuilder(baseDir.getCanonicalPath());
        sb.append(File.separator);
        if (namespace != null) {
            StringTokenizer tokenizer = new StringTokenizer(namespace, ".");
            while (tokenizer.hasMoreTokens()) {
                sb.append(tokenizer.nextToken());
                sb.append(File.separator);
            }
        }
        sb.append(classname);
        sb.append(".java");
        return new File(sb.toString());
    }

    private final String messageHandlerVarName(AdmMessage message) {
        String basicName = "_" + AdmGenerator.toFirstLetterLowercase((String)message.getName()) + "Handler";
        return message.getNamespace().equals(this.messagesModel.getNamespace()) ? basicName : "_" + message.getNamespace().replace('.', '_') + basicName;
    }

    private final String messageSenderVarName(AdmMessage message) {
        String basicName = "_" + AdmGenerator.toFirstLetterLowercase((String)message.getName()) + "Sender";
        return message.getNamespace().equals(this.messagesModel.getNamespace()) ? basicName : "_" + message.getNamespace().replace('.', '_') + basicName;
    }

    private final String generateAppMessageResponseSenderProviderMethod(AdmMessage message) {
        StringBuilder sb = new StringBuilder();
        sb.append("    @Provides").append("\n");
        sb.append("    final private MessageSender<" + message.getFullName() + "> provides_" + String.valueOf(message.getNamespace()).replace('.', '_') + "_" + message.getName() + "Sender() {").append("\n");
        sb.append("        return new ResponseSender<" + message.getFullName() + ">();").append("\n");
        sb.append("    }");
        return sb.toString();
    }

    private final String generateAppMessageEventSenderProviderMethod(AdmMessage message) {
        StringBuilder sb = new StringBuilder();
        sb.append("    @Provides").append("\n");
        sb.append("    final private MessageSender<" + message.getFullName() + "> provides_" + String.valueOf(message.getNamespace()).replace('.', '_') + "_" + message.getName() + "Sender() {").append("\n");
        sb.append("        return new EventSender<" + message.getFullName() + ">();").append("\n");
        sb.append("    }");
        return sb.toString();
    }

    private final String generateAppMessageAsyncRequestSenderProviderMethod(AsmModel model, AsmOperation operation) {
        if (operation.getInMessage().getNamespace().equals(model.getMessagesModel().getNamespace())) {
            StringBuilder sb = new StringBuilder();
            sb.append("    @Provides").append("\n");
            sb.append("    final private MessageSender<" + operation.getInMessage().getFullName() + "> provides_" + String.valueOf(operation.getInMessage().getNamespace()).replace('.', '_') + "_" + operation.getInMessage().getName() + "Sender() {").append("\n");
            sb.append("        return new PeerRequestSender<" + operation.getInMessage().getFullName() + ">() {").append("\n");
            sb.append("            @Override").append("\n");
            sb.append("            public void send(final MessageHeader inHeader, final " + operation.getInMessage().getFullName() + " request) {").append("\n");
            sb.append("                " + this.peerAsyncClientVarName(model.getNamespace()) + "." + AdmGenerator.toFirstLetterLowercase((String)operation.getName()) + "Async(request);").append("\n");
            sb.append("            }").append("\n");
            sb.append("        };").append("\n");
            sb.append("    }");
            return sb.toString();
        }
        return null;
    }

    private final String peerClientVarName(String modelNamespace) {
        return "_" + modelNamespace.replace('.', '_') + "_Client";
    }

    private final String peerAsyncClientVarName(String modelNamespace) {
        return this.peerClientVarName(modelNamespace) + "Async";
    }

    private final String generateAppMessageHandlerMethod(String name, AdmMessage inMessage, AdmMessage outMessage, boolean streamingPeer) {
        StringBuilder sb = new StringBuilder();
        sb.append("    @EventHandler").append("\n");
        sb.append("    public void on" + inMessage.getName() + "(final " + inMessage.getFullName() + " request) {").append("\n");
        sb.append("        if (messageTracer().debug) messageTracer().log(\"<-- \" + request.toJsonString(true, null, null) + \".\", Tracer.Level.DEBUG);").append("\n");
        sb.append("        final " + outMessage.getFullName() + " response = " + outMessage.getFullName() + ".create();").append("\n");
        sb.append("        response.setHeader(MessageHeader.create());").append("\n");
        sb.append("        createRequestExecutor(\"" + name + "\",").append("\n");
        sb.append("                              request,").append("\n");
        if (streamingPeer) {
            sb.append("                              (MessageHeader)null,").append("\n");
        } else {
            sb.append("                              request.getHeader(),").append("\n");
        }
        sb.append("                              response,").append("\n");
        sb.append("                              response.getHeader(),").append("\n");
        sb.append("                              " + this.messageHandlerVarName(inMessage) + ",").append("\n");
        sb.append("                              " + (outMessage == this.getNullMessage() ? "null" : this.messageSenderVarName(outMessage)) + ").go();").append("\n");
        sb.append("    }");
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    private final void generateAbstractApp(PrintWriter writer) {
        writer.println("package " + this.getNamespace() + ".service;");
        writer.println("");
        writer.println("import java.util.List;");
        writer.println("import java.util.ArrayList;");
        writer.println("import java.util.Set;");
        writer.println("import java.util.Map;");
        writer.println("import java.util.LinkedHashMap;");
        writer.println("import org.apache.commons.lang.StringUtils;");
        writer.println("");
        writer.println("import com.google.inject.*;");
        writer.println("");
        writer.println("import com.neeve.ci.*;");
        writer.println("import com.neeve.util.*;");
        writer.println("import com.neeve.trace.*;");
        writer.println("import com.neeve.sma.*;");
        writer.println("import com.neeve.aep.*;");
        writer.println("import com.neeve.aep.annotations.*;");
        writer.println("import com.neeve.rog.*;");
        writer.println("import com.neeve.server.app.annotations.*;");
        writer.println("import com.neeve.service.*;");
        writer.println("import com.neeve.service.messages.*;");
        writer.println("");
        writer.println("abstract public class AbstractApp extends com.neeve.service.AbstractApp<" + this.getStateRoot().getFullName() + "> {");
        writer.println("    /*");
        writer.println("     * The application state factory");
        writer.println("     */");
        writer.println("    final private class RepositoryFactory implements IAepApplicationStateFactory {");
        writer.println("        final public IRogNode createState(final MessageView view) {");
        writer.println("            return " + this.getStateRoot().getFullName() + ".create();");
        writer.println("        }");
        writer.println("    }");
        writer.println("");
        writer.println("    // ----- Private scope members");
        writer.println("    private RepositoryFactory _repositoryFactory;");
        for (AsmModel asmModel : this.peers) {
            writer.println("    private " + asmModel.getNamespace() + ".service.Client " + this.peerAsyncClientVarName(asmModel.getNamespace()) + ";");
            writer.println("    private " + asmModel.getNamespace() + ".service.Client " + this.peerClientVarName(asmModel.getNamespace()) + ";");
        }
        writer.println("    // ----- /Private scope members");
        writer.println("");
        writer.println("    // ----- Message Handlers");
        for (AsmOperation asmOperation : this.operations) {
            writer.println("    @Inject private MessageHandler<" + asmOperation.getInMessage().getFullName() + ", " + asmOperation.getOutMessage().getFullName() + ", " + this.stateRoot.getFullName() + "> " + this.messageHandlerVarName(asmOperation.getInMessage()) + ";");
        }
        for (AsmStreamingPeer asmStreamingPeer : this.streamingPeers) {
            for (AsmStreamingPeer.Message message : asmStreamingPeer.getMessages()) {
                writer.println("    @Inject private MessageHandler<" + message.getMessage().getFullName() + ", " + this.getNullMessage().getFullName() + ", " + this.stateRoot.getFullName() + "> " + this.messageHandlerVarName(message.getMessage()) + ";");
            }
        }
        writer.println("    // ----- /Message Handlers");
        writer.println("");
        writer.println("    // ----- Message Senders");
        LinkedHashSet<String> messageSenderStatements = new LinkedHashSet<String>();
        for (AsmOperation asmOperation : this.operations) {
            messageSenderStatements.add("    @Inject private MessageSender<" + asmOperation.getOutMessage().getFullName() + "> " + this.messageSenderVarName(asmOperation.getOutMessage()) + ";");
            if (asmOperation.getEventMessages() == null) continue;
            for (AdmMessage admMessage : asmOperation.getEventMessages()) {
                messageSenderStatements.add("    @Inject private MessageSender<" + admMessage.getFullName() + "> " + this.messageSenderVarName(admMessage) + ";");
            }
        }
        for (String string : messageSenderStatements) {
            writer.println(string);
        }
        writer.println("    // ----- /Message Senders");
        writer.println("");
        writer.println("    // ----- Service identity information");
        writer.println("    final public static String APP_NAME;");
        writer.println("    final public static String APP_NAME_FOR_CONFIG;");
        writer.println("    final public static int APP_PART;");
        writer.println("    final public static String AGENT_NAME;");
        writer.println("    // ----- /Service identity information");
        writer.println("");
        writer.println("    // ----- Environment information");
        writer.println("    final private static String _env;");
        writer.println("    // ----- /Environment information");
        writer.println("");
        writer.println("    // ----- static constructor");
        writer.println("    static {");
        writer.println("        _env = UtlProps.getValue(XRuntime.getProps(), \"" + this.forConfigurationProperty(this.getName()) + ".env\", null);");
        writer.println("        APP_NAME = localizeAppName(_env, \"" + this.getName() + "\");");
        writer.println("        APP_NAME_FOR_CONFIG = \"" + this.forConfigurationProperty(this.getName()) + "\";");
        writer.println("        APP_PART = (int)UtlProps.getValue(XRuntime.getProps(), \"" + this.forConfigurationProperty(this.getName()) + ".partition\", 1);");
        writer.println("        AGENT_NAME = APP_NAME + \"-\" + App.APP_PART;");
        writer.println("    }");
        writer.println("    // ----- /static constructor");
        writer.println("");
        writer.println("    /**");
        writer.println("     * Constructor ");
        writer.println("     */");
        writer.println("    protected AbstractApp(final int majorVersion, final int minorVersion) {");
        writer.println("        // chain");
        writer.println("        super(APP_NAME, APP_NAME_FOR_CONFIG, APP_PART, majorVersion, minorVersion);");
        writer.println("    }");
        writer.println("");
        writer.println("    // ---- Message sender providers");
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (AsmOperation asmOperation : this.operations) {
            linkedHashSet.add(this.generateAppMessageResponseSenderProviderMethod(asmOperation.getOutMessage()));
            if (asmOperation.getEventMessages() == null) continue;
            for (AdmMessage admMessage : asmOperation.getEventMessages()) {
                linkedHashSet.add(this.generateAppMessageEventSenderProviderMethod(admMessage));
            }
        }
        for (AsmModel asmModel : this.peers) {
            for (AsmOperation asmOperation : asmModel.operations) {
                String statement = this.generateAppMessageAsyncRequestSenderProviderMethod(asmModel, asmOperation);
                if (statement == null) continue;
                linkedHashSet.add(statement);
            }
        }
        for (String string : linkedHashSet) {
            writer.println(string);
        }
        writer.println("    // ---- /Message sender providers");
        writer.println("");
        writer.println("    // ---- Peer client providers");
        for (AsmModel asmModel : this.peers) {
            writer.println("    @Provides");
            writer.println("    final private " + asmModel.getNamespace() + ".service.Client provides" + this.peerClientVarName(asmModel.getNamespace()) + "() {");
            writer.println("        return " + this.peerClientVarName(asmModel.getNamespace()) + ";");
            writer.println("    }");
        }
        writer.println("    // ---- /Peer client providers");
        writer.println("");
        writer.println("    // ---- Overriden abstract app methods");
        writer.println("    @Override");
        writer.println("    final protected String doGetMainClassName() {");
        writer.println("        return \"" + this.getNamespace() + ".service.App\";");
        writer.println("    }");
        writer.println("    @Override");
        writer.println("    final protected List<com.neeve.service.AbstractClient> doGetPeerClients() {");
        if (this.peers.size() > 0) {
            writer.println("        final List<com.neeve.service.AbstractClient> peerClients = new ArrayList<com.neeve.service.AbstractClient>();");
            for (AsmModel asmModel : this.peers) {
                writer.println("        peerClients.add((" + this.peerClientVarName(asmModel.getNamespace()) + " = new " + asmModel.getNamespace() + ".service.Client(AGENT_NAME)));");
            }
            writer.println("        return peerClients;");
        } else {
            writer.println("        return null;");
        }
        writer.println("    }");
        writer.println("    @Override");
        writer.println("    final protected Map<String, com.neeve.service.AbstractClient> doGetPeerAsyncClients() {");
        if (this.peers.size() > 0) {
            writer.println("        final Map<String, com.neeve.service.AbstractClient> peerAsyncClients = new LinkedHashMap<String, com.neeve.service.AbstractClient>();");
            for (AsmModel asmModel : this.peers) {
                writer.println("        peerAsyncClients.put(" + asmModel.getNamespace() + ".service.App.APP_NAME, (" + this.peerAsyncClientVarName(asmModel.getNamespace()) + " = new " + asmModel.getNamespace() + ".service.Client(AGENT_NAME + \"-async\")));");
            }
            writer.println("        return peerAsyncClients;");
        } else {
            writer.println("        return null;");
        }
        writer.println("    }");
        writer.println("    @Override");
        writer.println("    protected boolean joinChannel(final String channelName) {");
        if (this.peers.size() > 0) {
            writer.println("        if (channelName.equals(RESPONSE_CHANNEL_NAME) || channelName.equals(EVENT_CHANNEL_NAME) || channelName.equals(HEARTBEAT_CHANNEL_NAME)) {");
            writer.println("            return true;");
            writer.println("        }");
        }
        for (AsmStreamingPeer asmStreamingPeer : this.streamingPeers) {
            for (String string : asmStreamingPeer.getChannels().keySet()) {
                writer.println("        if (channelName.equals(\"" + string + "\")) {");
                writer.println("            return true;");
                writer.println("        }");
            }
        }
        writer.println("        return false;");
        writer.println("    }");
        if (this.streamingPeers.size() > 0) {
            writer.println("    @Override");
            writer.println("    protected void doAddChannelDescriptorsForStreamingPeers(final MessageBusDescriptor busDescriptor) {");
            writer.println("        MessageChannelDescriptor channelDescriptor;");
            boolean bl = false;
            for (AsmStreamingPeer asmStreamingPeer : this.streamingPeers) {
                for (AsmStreamingPeer.Channel channel : asmStreamingPeer.getChannels().values()) {
                    void var4_26;
                    if (!AbstractApp._coreAppChannels.contains(channel.getName())) {
                        writer.println("        channelDescriptor = busDescriptor.getChannel(\"" + channel.getName() + "\");");
                        writer.println("        if (channelDescriptor == null) {");
                        writer.println("            channelDescriptor = MessageChannelDescriptor.create(\"" + channel.getName() + "\", busDescriptor);");
                        if (!StringUtils.isEmpty((String)channel.getKey())) {
                            writer.println("            channelDescriptor.setChannelKey(\"${" + channel.getKey() + "}\");");
                        }
                        writer.println("            busDescriptor.addChannel(channelDescriptor);");
                        writer.println("        }");
                        if (StringUtils.isEmpty((String)channel.getFilter())) continue;
                        writer.println("        channelDescriptor.setChannelFilter(\"" + channel.getFilter() + "\")");
                        continue;
                    }
                    if (StringUtils.isEmpty((String)channel.getFilter())) continue;
                    writer.println("        channelDescriptor = busDescriptor.getChannel(\"" + channel.getName() + "\");");
                    writer.println("        " + (++var4_26 == false ? "String " : "") + "filter = channelDescriptor.getChannelFilter();");
                    writer.println("        if (!StringUtils.isEmpty(filter)) {");
                    writer.println("            channelDescriptor.setChannelFilter(\"\" + filter + \";" + channel.getFilter() + "\");");
                    writer.println("        }");
                    writer.println("        else {");
                    writer.println("            channelDescriptor.setChannelFilter(\"" + channel.getFilter() + "\");");
                    writer.println("        }");
                }
            }
            writer.println("    }");
            writer.println("    @Override");
            writer.println("    protected void doAddChannelsForStreamingPeers(final AepEngineDescriptor engineDescriptor) throws Exception {");
            for (AsmStreamingPeer asmStreamingPeer : this.streamingPeers) {
                for (AsmStreamingPeer.Channel channel : asmStreamingPeer.getChannels().values()) {
                    if (AbstractApp._coreAppChannels.contains(channel.getName())) continue;
                    writer.println("        engineDescriptor.addChannel(APP_NAME, \"" + channel.getName() + "\", AepEngineDescriptor.ChannelConfig.from(\"join=true\"));");
                }
            }
            writer.println("    }");
        }
        writer.println("    @Override");
        writer.println("    protected void doAddGuiceModules(final Set<AbstractModule> modules) {");
        writer.println("        modules.add(new " + this.getNamespace() + ".service.domain.Module());");
        for (AsmModule asmModule : this.modules) {
            writer.println("        addAppGuiceModule(\"" + asmModule.getClassName() + "\", modules);");
        }
        writer.println("    }");
        writer.println("    @Override");
        writer.println("    protected void doRegisterFactories() {");
        for (AdmFactory admFactory : this.messagesModel.getFactories()) {
            writer.println("        _engine.registerFactory(new " + admFactory.getFullName() + "());");
        }
        for (AdmFactory admFactory : this.stateModel.getFactories()) {
            writer.println("        _engine.registerFactory(new " + admFactory.getFullName() + "());");
        }
        for (AsmModel asmModel : this.peers) {
            for (AdmFactory admFactory : asmModel.getMessagesModel().getFactories()) {
                writer.println("        _engine.registerFactory(new " + admFactory.getFullName() + "());");
            }
        }
        for (AsmStreamingPeer asmStreamingPeer : this.streamingPeers) {
            for (AdmFactory admFactory : asmStreamingPeer.getMessagesModel().getFactories()) {
                writer.println("        _engine.registerFactory(new " + admFactory.getFullName() + "());");
            }
        }
        writer.println("        _engine.registerFactory(new com.neeve.server.mon.SrvMonFactory());");
        writer.println("    }");
        writer.println("    // ---- /Overriden abstract app methods");
        writer.println("");
        writer.println("    /**");
        writer.println("     * Get the state (repository factory)");
        writer.println("     */");
        writer.println("    @AppStateFactoryAccessor");
        writer.println("    final public IAepApplicationStateFactory getRepositoryFactory() {");
        writer.println("        if (_repositoryFactory == null) {");
        writer.println("            _repositoryFactory = new RepositoryFactory();");
        writer.println("        }");
        writer.println("        return _repositoryFactory;");
        writer.println("    }");
        writer.println("");
        writer.println("    // ---- Message handlers");
        for (AsmOperation asmOperation : this.operations) {
            writer.println(this.generateAppMessageHandlerMethod(asmOperation.getName(), asmOperation.getInMessage(), asmOperation.getOutMessage(), false));
        }
        for (AsmStreamingPeer asmStreamingPeer : this.streamingPeers) {
            for (AsmStreamingPeer.Message message : asmStreamingPeer.getMessages()) {
                writer.println(this.generateAppMessageHandlerMethod(message.getName(), message.getMessage(), this.getNullMessage(), true));
            }
        }
        writer.println("    // ---- /Message handlers");
        writer.println("}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generateAbstractApp(File outdir, boolean absolute) throws Exception {
        File file = this.resolveAbsoluteClassFile(outdir, absolute ? null : this.getNamespace() + ".service", "AbstractApp");
        System.out.println("...'" + file.getAbsolutePath() + "'...");
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(file);
            try {
                this.generateAbstractApp(writer);
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            throw new EAsmException("Failed to create application main file '" + file.getPath() + "' [" + e.toString() + "]");
        }
    }

    private final void generateAbstractClient(PrintWriter writer) {
        writer.println("package " + this.getNamespace() + ".service;");
        writer.println("");
        writer.println("import com.neeve.sma.*;");
        writer.println("import com.neeve.aep.*;");
        writer.println("import com.neeve.rog.*;");
        writer.println("import com.neeve.service.*;");
        writer.println("import com.neeve.service.messages.*;");
        writer.println("import com.neeve.service.entities.*;");
        writer.println("");
        writer.println("abstract public class AbstractClient extends com.neeve.service.AbstractClient {");
        writer.println("    // ---- Private scope members");
        writer.println("    private AbstractApp _app;");
        writer.println("    // ---- Private scope members");
        writer.println("");
        writer.println("    // ---- Constructors");
        writer.println("    protected AbstractClient(final String name, final int majorVersion, final int minorVersion, final Object handlers, final Credentials credentials) {");
        writer.println("        super(name, AbstractApp.APP_NAME, AbstractApp.APP_NAME_FOR_CONFIG, majorVersion, minorVersion, handlers, credentials);");
        writer.println("    }");
        writer.println("    protected AbstractClient(final String name, final int majorVersion, final int minorVersion, final Object handlers) {");
        writer.println("        this(name, majorVersion, minorVersion, handlers, null);");
        writer.println("    }");
        writer.println("    // ---- Constructors");
        writer.println("");
        writer.println("");
        writer.println("    // ---- Partition resolver methods");
        for (AsmOperation operation : this.operations) {
            if (!operation.getInMessage().getNamespace().equals(this.messagesModel.getNamespace())) continue;
            writer.println("    public int resolvePartitionFor" + AdmGenerator.toFirstLetterUppercase((String)operation.getName()) + "(final " + operation.getInMessage().getFullName() + " request) {");
            writer.println("        return " + operation.getPartition() + ";");
            writer.println("    }");
        }
        writer.println("    // ---- Partition resolver methods");
        writer.println("");
        writer.println("    // ---- Abstract client methods to be implemented by concrete client");
        writer.println("    abstract protected AbstractApp createApp();");
        writer.println("    // ---- Abstract client methods to be implemented by concrete client");
        writer.println("");
        writer.println("    // ---- Overriden abstract client methods");
        writer.println("    @Override");
        writer.println("    final protected IRogMessage doSetRequestHeader(IRogMessage request, MessageHeader header) {");
        writer.println("        switch(request.getVfid()) {");
        for (AdmFactory factory : this.messagesModel.getFactories()) {
            writer.println("            case " + factory.getFullName() + ".VFID:");
            writer.println("                switch(request.getType()) {");
            for (AsmOperation operation : this.operations) {
                if (operation.getInMessage().getFactory() != factory || !operation.getInMessage().getNamespace().equals(this.messagesModel.getNamespace())) continue;
                writer.println("                    case " + operation.getInMessage().getFactory().getFullName() + ".ID_" + operation.getInMessage().getName() + ":");
                writer.println("                        ((" + operation.getInMessage().getFullName() + ")request).setHeader(header);");
                writer.println("                        break;");
            }
            writer.println("                }");
            writer.println("                break;");
        }
        writer.println("        }");
        writer.println("        return request;");
        writer.println("    }");
        writer.println("    @Override");
        writer.println("    final protected MessageHeader doGetResponseHeader(MessageView message) {");
        writer.println("        switch(message.getVfid()) {");
        HashSet<String> generatedLabels = new HashSet<String>();
        for (AdmFactory factory : this.messagesModel.getFactories()) {
            writer.println("            case " + factory.getFullName() + ".VFID:");
            writer.println("                switch(message.getType()) {");
            for (AsmOperation operation : this.operations) {
                if (operation.getOutMessage().getFactory() != factory || !operation.getOutMessage().getNamespace().equals(this.messagesModel.getNamespace()) || generatedLabels.contains(operation.getOutMessage().getName())) continue;
                writer.println("                    case " + operation.getOutMessage().getFactory().getFullName() + ".ID_" + operation.getOutMessage().getName() + ":");
                writer.println("                        return ((" + operation.getOutMessage().getFullName() + ")message).getHeader();");
                generatedLabels.add(operation.getOutMessage().getName());
            }
            writer.println("                }");
            writer.println("                break;");
        }
        writer.println("        }");
        writer.println("        return null;");
        writer.println("    }");
        writer.println("    @Override");
        writer.println("    final protected void doRegisterFactories(final AepEngine engine) {");
        for (AdmFactory factory : this.messagesModel.getFactories()) {
            writer.println("        engine.registerFactory(new " + factory.getFullName() + "());");
        }
        writer.println("    }");
        writer.println("    @Override");
        writer.println("    final protected EmbeddedServerController doGetEmbeddedServerController() {");
        writer.println("        if (_app == null) {");
        writer.println("            _app = createApp();");
        writer.println("        }");
        writer.println("        return _app;");
        writer.println("    }");
        writer.println("    // ---- Overriden abstract client methods");
        writer.println("");
        writer.println("    // ---- Interface methods");
        for (AsmOperation operation : this.operations) {
            if (!operation.getInMessage().getNamespace().equals(this.messagesModel.getNamespace())) continue;
            writer.println("    public " + operation.getOutMessage().getFullName() + " " + AdmGenerator.toFirstLetterLowercase((String)operation.getName()) + "(final " + operation.getInMessage().getFullName() + " request, Integer... timeout) throws EServiceException {");
            writer.println("        validateRequest(request);");
            writer.println("        return sendRequestAndWaitForReply(request.getHeader(), request, _serverLaunched ? 1 : resolvePartitionFor" + AdmGenerator.toFirstLetterUppercase((String)operation.getName()) + "(request), timeout);");
            writer.println("    }");
            writer.println("    public void " + AdmGenerator.toFirstLetterLowercase((String)operation.getName()) + "Async(final " + operation.getInMessage().getFullName() + " request) throws EServiceException {");
            writer.println("        validateRequest(request);");
            writer.println("        sendRequest(request.getHeader(), request, _serverLaunched ? 1 : resolvePartitionFor" + AdmGenerator.toFirstLetterUppercase((String)operation.getName()) + "(request));");
            writer.println("    }");
        }
        writer.println("    // ---- Interface methods");
        writer.println("}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generateAbstractClient(File outdir, boolean absolute) throws Exception {
        File file = this.resolveAbsoluteClassFile(outdir, absolute ? null : this.getNamespace() + ".service", "AbstractClient");
        System.out.println("...'" + file.getAbsolutePath() + "'...");
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(file);
            try {
                this.generateAbstractClient(writer);
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            throw new EAsmException("Failed to create application client file '" + file.getPath() + "' [" + e.toString() + "]");
        }
    }

    private final void generateDomainGuiceModule(PrintWriter writer) {
        writer.println("package " + this.getNamespace() + ".service.domain;");
        writer.println("");
        writer.println("import com.google.inject.*;");
        writer.println("");
        writer.println("import com.neeve.service.MessageHandler;");
        writer.println("");
        writer.println("import " + this.getNamespace() + ".service.domain.handlers.*;");
        writer.println("");
        writer.println("final public class Module extends AbstractModule {");
        writer.println("    public Module() {");
        writer.println("    }");
        writer.println("");
        writer.println("    @Override");
        writer.println("    protected void configure() {");
        writer.println("        bind(new TypeLiteral<MessageHandler<com.neeve.service.messages.PingRequest, com.neeve.service.messages.PingResponse, " + this.stateRoot.getFullName() + ">>() {}).to(PingRequestHandler.class);");
        writer.println("        bind(new TypeLiteral<MessageHandler<com.neeve.service.messages.FirstRequest, com.neeve.service.messages.AgentStartedEvent, " + this.stateRoot.getFullName() + ">>() {}).to(FirstMessageRequestHandler.class);");
        for (AsmOperation operation : this.operations) {
            writer.println("        bind(new TypeLiteral<MessageHandler<" + operation.getInMessage().getFullName() + ", " + operation.getOutMessage().getFullName() + ", " + this.stateRoot.getFullName() + ">>() {}).to(" + operation.getHandlerName() + ".class);");
        }
        for (AsmStreamingPeer streamingPeer : this.streamingPeers) {
            for (AsmStreamingPeer.Message message : streamingPeer.getMessages()) {
                writer.println("        bind(new TypeLiteral<MessageHandler<" + message.getMessage().getFullName() + ", " + this.getNullMessage().getFullName() + ", " + this.stateRoot.getFullName() + ">>() {}).to(" + message.getHandlerName() + ".class);");
            }
        }
        writer.println("    }");
        writer.println("}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generateDomainGuiceModule(File outdir, boolean absolute) throws Exception {
        File file = this.resolveAbsoluteClassFile(outdir, absolute ? null : this.getNamespace() + ".service.domain", "Module");
        System.out.println("...'" + file.getAbsolutePath() + "'...");
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(file);
            try {
                this.generateDomainGuiceModule(writer);
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            throw new EAsmException("Failed to create application domain guice module file '" + file.getPath() + "' [" + e.toString() + "]");
        }
    }

    private final void generateWebApp(PrintWriter writer) {
        writer.println("package " + this.getNamespace() + ".webservice;");
        writer.println("");
        writer.println("import java.util.Set;");
        writer.println("");
        writer.println("import com.google.inject.AbstractModule;");
        writer.println("");
        writer.println("import com.neeve.server.config.SrvConfigAppDescriptor;");
        writer.println("import com.neeve.server.config.SrvConfigDescriptor;");
        writer.println("import com.neeve.server.controller.SrvController;");
        writer.println("");
        writer.println("import com.neeve.webservice.AbstractApp;");
        writer.println("");
        writer.println("final public class App extends AbstractApp {");
        writer.println("    public App() {");
        writer.println("        super(\"" + this.getName() + "\"," + this.getNamespace() + ".service.App.APP_NAME, " + this.getNamespace() + ".service.App.APP_NAME_FOR_CONFIG, " + this.getNamespace() + ".service.App.APP_PART);");
        writer.println("    }");
        writer.println("");
        writer.println("    @Override");
        writer.println("    final protected void doAddGuiceModules(final Set<AbstractModule> modules) {");
        writer.println("    }");
        writer.println("");
        writer.println("    /**");
        writer.println("      * main method to run the webservice and service in the same JVM connected using loopback");
        writer.println("      */");
        writer.println("    public static void main(String[] args) throws Exception {");
        writer.println("        final SrvConfigDescriptor serverDescriptor = SrvConfigDescriptor.create(" + this.getNamespace() + ".service.App.APP_NAME + \"-web-server-\" + " + this.getNamespace() + ".service.App.APP_PART);");
        writer.println("        final SrvConfigAppDescriptor serviceAppDescriptor = SrvConfigAppDescriptor.create(" + this.getNamespace() + ".service.App.APP_NAME + \"-web-\" + " + this.getNamespace() + ".service.App.APP_PART);");
        writer.println("        serviceAppDescriptor.setMainClass(\"" + this.getNamespace() + ".webservice.App\");");
        writer.println("        serverDescriptor.addApp(serviceAppDescriptor);");
        writer.println("        serverDescriptor.save();");
        writer.println("        serviceAppDescriptor.save(serverDescriptor.getName());");
        writer.println("        final SrvController serverController = SrvController.getInstance(serverDescriptor);");
        writer.println("        serverController.start();");
        writer.println("    }");
        writer.println("}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generateWebApp(File outdir, boolean absolute) throws Exception {
        File file = this.resolveAbsoluteClassFile(outdir, absolute ? null : this.getNamespace() + ".webservice", "App");
        System.out.println("...'" + file.getAbsolutePath() + "'...");
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(file);
            try {
                this.generateWebApp(writer);
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            throw new EAsmException("Failed to create application main file '" + file.getPath() + "' [" + e.toString() + "]");
        }
    }

    private final String getRestParamType(AdmType fieldType) {
        if (fieldType instanceof AdmPrimitive) {
            AdmPrimitive primitiveType = (AdmPrimitive)fieldType;
            switch (primitiveType.getType()) {
                case Byte: 
                case Short: 
                case Integer: 
                case Long: 
                case Float: 
                case Double: 
                case Boolean: 
                case String: 
                case Char: {
                    return primitiveType.getPrimitiveTypeName();
                }
                case Date: {
                    return "java.util.Date";
                }
                case Currency: 
                case UUID: {
                    return "String";
                }
            }
            throw new IllegalArgumentException("Unknown or unsupported primitive type '" + primitiveType.getPrimitiveTypeName() + "'");
        }
        throw new IllegalArgumentException("Unsupported parameter type '" + fieldType.getName() + "'. Please use POST method for this request.");
    }

    private final String restParamToRequestArg(AdmType fieldType, String name) {
        if (fieldType instanceof AdmPrimitive) {
            AdmPrimitive primitiveType = (AdmPrimitive)fieldType;
            switch (primitiveType.getType()) {
                case UUID: {
                    return name + " != null ? java.util.UUID.fromString(" + name + ") : null";
                }
                case Currency: {
                    return name + " != null ? java.util.Currency.getInstance(" + name + ") : null";
                }
            }
            return name;
        }
        throw new IllegalArgumentException("Unsupported parameter type '" + fieldType.getName() + "'. Please use POST method for this request.");
    }

    private final String getBriefDoc(AsmDocumentation documentation) {
        if (documentation != null && documentation.getBrief() != null) {
            return UtlText.removeLineBreaks((String)documentation.getBrief());
        }
        return "";
    }

    private final String getFullDoc(String full) {
        BufferedReader reader = new BufferedReader(new StringReader(full.trim()));
        StringBuilder sb = new StringBuilder();
        String line = null;
        boolean first = true;
        try {
            while ((line = reader.readLine()) != null) {
                if (!first) {
                    sb.append("<br>");
                }
                sb.append(line.trim());
                first = false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    private final String getFullDoc(AsmDocumentation documentation) {
        if (documentation != null && documentation.getFull() != null) {
            return this.getFullDoc(documentation.getFull());
        }
        return "";
    }

    private final String getDoc(AsmDocumentation documentation) {
        if (documentation != null) {
            if (documentation.getFull() != null) {
                return this.getFullDoc(documentation.getFull());
            }
            if (documentation.getBrief() != null) {
                return UtlText.removeLineBreaks((String)documentation.getBrief());
            }
        }
        return "";
    }

    private final String getBriefDoc(AdmDocumentation documentation) {
        if (documentation != null && documentation.getBrief() != null) {
            return UtlText.removeLineBreaks((String)documentation.getBrief());
        }
        return "";
    }

    private final String getFullDoc(AdmDocumentation documentation) {
        if (documentation != null && documentation.getFull() != null) {
            return this.getFullDoc(documentation.getFull());
        }
        return "";
    }

    private final String getDoc(AdmDocumentation documentation) {
        if (documentation != null) {
            if (documentation.getFull() != null) {
                return this.getFullDoc(documentation.getFull());
            }
            if (documentation.getBrief() != null) {
                return UtlText.removeLineBreaks((String)documentation.getBrief());
            }
        }
        return "";
    }

    private final String getDocNoLineBreaks(AdmDocumentation documentation) {
        if (documentation != null) {
            if (documentation.getFull() != null) {
                return UtlText.removeLineBreaks((String)documentation.getFull());
            }
            if (documentation.getBrief() != null) {
                return UtlText.removeLineBreaks((String)documentation.getBrief());
            }
        }
        return "";
    }

    private final void generateAbstractWebAppResource(PrintWriter writer) {
        writer.println("package " + this.getNamespace() + ".webservice.resources;");
        writer.println("");
        writer.println("import java.io.IOException;");
        writer.println("");
        writer.println("import javax.ws.rs.*;");
        writer.println("import javax.ws.rs.core.MediaType;");
        writer.println("");
        writer.println("import com.neeve.service.messages.*;");
        writer.println("import " + this.getNamespace() + ".service.*;");
        writer.println("");
        writer.println("abstract public class AbstractWebApp extends com.neeve.webservice.resources.AbstractWebApp {");
        writer.println("    protected Client _client;");
        writer.println("");
        writer.println("    public AbstractWebApp(final int port) {");
        writer.println("        super(port);");
        writer.println("    }");
        writer.println("");
        writer.println("    final protected AbstractClient doCreateClient() {");
        writer.println("        return _client = new Client(" + this.getNamespace() + ".service.App.APP_NAME + \"web\");");
        writer.println("    }");
        writer.println("");
        if (this.operations.size() > 0) {
            for (AsmOperation operation : this.operations) {
                if (operation.getRESTPath() == null || !operation.getInMessage().getNamespace().equals(this.messagesModel.getNamespace())) continue;
                AdmMessage inMessage = operation.getInMessage();
                writer.println("    @" + (Object)((Object)operation.getRESTMethod()));
                writer.println("    @Path(\"/" + operation.getRESTPath() + "\")");
                boolean hasReturnValue = operation.getOutMessage() != null;
                switch (operation.getRESTMethod()) {
                    case POST: {
                        writer.println("    @Consumes(MediaType.APPLICATION_JSON)");
                        if (hasReturnValue) {
                            writer.println("    @Produces(MediaType.APPLICATION_JSON)");
                        }
                        writer.println("    public " + (hasReturnValue ? "String " : "void ") + AdmGenerator.toFirstLetterLowercase((String)operation.getName()) + "(final String request) throws IOException {");
                        writer.println("        " + (hasReturnValue ? "return " : "") + "_mapper.writeValueAsString(_client." + AdmGenerator.toFirstLetterLowercase((String)operation.getName()) + "(" + operation.getInMessage().getFullName() + ".create().deserializeFromRawJson(request)));");
                        writer.println("    }");
                        break;
                    }
                    case GET: {
                        writer.println("    @Produces(MediaType.APPLICATION_JSON)");
                        writer.print("    public " + (hasReturnValue ? "String " : "void ") + AdmGenerator.toFirstLetterLowercase((String)operation.getName()) + "(");
                        boolean first = true;
                        for (AdmField field : inMessage.fields().values()) {
                            if (field.getName().equals("header")) continue;
                            if (!first) {
                                writer.print(", ");
                            } else {
                                first = false;
                            }
                            writer.print("final @QueryParam(\"" + field.getName() + "\") " + this.getRestParamType(field.getType()) + " " + field.getName());
                        }
                        writer.println(") throws IOException {");
                        writer.println("        final " + operation.getInMessage().getFullName() + " request = " + operation.getInMessage().getFullName() + ".create();");
                        for (AdmField field : inMessage.fields().values()) {
                            if (field.getName().equals("header")) continue;
                            writer.println("        request.set" + AdmGenerator.toFirstLetterUppercase((String)field.getName()) + "(" + this.restParamToRequestArg(field.getType(), field.getName()) + ");");
                        }
                        writer.println("        " + (hasReturnValue ? "return " : "") + "_mapper.writeValueAsString(_client." + AdmGenerator.toFirstLetterLowercase((String)operation.getName()) + "(request));");
                        writer.println("    }");
                    }
                }
            }
        }
        writer.println("}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generateAbstractWebAppResource(File outdir, boolean absolute) throws Exception {
        File file = this.resolveAbsoluteClassFile(outdir, absolute ? null : this.getNamespace() + ".webservice.resources", "AbstractWebApp");
        System.out.println("...'" + file.getAbsolutePath() + "'...");
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(file);
            try {
                this.generateAbstractWebAppResource(writer);
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            throw new EAsmException("Failed to create application main file '" + file.getPath() + "' [" + e.toString() + "]");
        }
    }

    private final void generateWebAppResource(PrintWriter writer) {
        writer.println("package " + this.getNamespace() + ".webservice.resources;");
        writer.println("");
        writer.println("import javax.ws.rs.Path;");
        writer.println("");
        writer.println("import com.sun.jersey.spi.resource.Singleton;");
        writer.println("");
        writer.println("import com.neeve.ci.XRuntime;");
        writer.println("import com.neeve.util.UtlProps;");
        writer.println("");
        writer.println("import " + this.getNamespace() + ".webservice.resources.AbstractWebApp;");
        writer.println("");
        writer.println("@Singleton");
        writer.println("@Path(\"/" + this.getName() + "\")");
        writer.println("final public class WebApp extends AbstractWebApp {");
        writer.println("");
        writer.println("    public WebApp() {");
        writer.println("        super((int)UtlProps.getValue(XRuntime.getProps(), \"" + this.forConfigurationProperty(this.getName()) + ".webservice.port\", com.neeve.webservice.AbstractApp.DEFAULT_PORT));");
        writer.println("    }");
        writer.println("");
        writer.println("}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generateWebAppResource(File outdir, boolean absolute) throws Exception {
        block7: {
            File file = this.resolveAbsoluteClassFile(outdir, absolute ? null : this.getNamespace() + ".webservice.resources", "WebApp");
            if (!file.exists()) {
                System.out.println("...'" + file.getAbsolutePath() + "'...");
                File dir = file.getParentFile();
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                PrintWriter writer = null;
                try {
                    writer = new PrintWriter(file);
                    try {
                        this.generateWebAppResource(writer);
                        break block7;
                    }
                    finally {
                        writer.close();
                    }
                }
                catch (IOException e) {
                    throw new EAsmException("Failed to create application main file '" + file.getPath() + "' [" + e.toString() + "]");
                }
            }
            System.out.println("...'" + file.getAbsolutePath() + "'...X [already exists].");
        }
    }

    private final void generateWebserviceResourceModule(PrintWriter writer) {
        writer.println("package " + this.getNamespace() + ".webservice.resources;");
        writer.println("");
        writer.println("import com.google.inject.Singleton;");
        writer.println("import com.sun.jersey.guice.JerseyServletModule;");
        writer.println("import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;");
        writer.println("/**");
        writer.println(" * Module providing guice servlet bindings");
        writer.println("*/");
        writer.println("");
        writer.println("public class Module extends JerseyServletModule {");
        writer.println("    public Module() {");
        writer.println("    }");
        writer.println("");
        writer.println("    @Override");
        writer.println("    final protected void configureServlets() {");
        writer.println("        bind(WebApp.class).in(Singleton.class);");
        writer.println("        serve(\"/*\").with(GuiceContainer.class);");
        writer.println("        bind(AbstractWebApp.ServiceExceptionMapper.class).in(Singleton.class);");
        writer.println("        bind(AbstractWebApp.RuntimeExceptionMapper.class).in(Singleton.class);");
        writer.println("    }");
        writer.println("}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generateWebserviceResourceModule(File outdir, boolean absolute) throws Exception {
        block7: {
            File file = this.resolveAbsoluteClassFile(outdir, absolute ? null : this.getNamespace() + ".webservice.resources", "Module");
            if (!file.exists()) {
                System.out.println("...'" + file.getAbsolutePath() + "'...");
                File dir = file.getParentFile();
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                PrintWriter writer = null;
                try {
                    writer = new PrintWriter(file);
                    try {
                        this.generateWebserviceResourceModule(writer);
                        break block7;
                    }
                    finally {
                        writer.close();
                    }
                }
                catch (IOException e) {
                    throw new EAsmException("Failed to create application main file '" + file.getPath() + "' [" + e.toString() + "]");
                }
            }
            System.out.println("...'" + file.getAbsolutePath() + "'...X [already exists].");
        }
    }

    private final void setSwaggerQueryParamType(QueryParameter param, AdmType fieldType) {
        if (fieldType instanceof AdmPrimitive) {
            AdmPrimitive primitiveType = (AdmPrimitive)fieldType;
            switch (primitiveType.getType()) {
                case Byte: 
                case Short: 
                case Integer: 
                case Char: {
                    ((QueryParameter)param.type("integer")).format("int32");
                    break;
                }
                case Long: {
                    ((QueryParameter)param.type("integer")).format("int64");
                    break;
                }
                case Float: {
                    ((QueryParameter)param.type("number")).format("float");
                    break;
                }
                case Double: {
                    ((QueryParameter)param.type("number")).format("double");
                    break;
                }
                case Boolean: {
                    param.type("boolean");
                    break;
                }
                case String: {
                    param.type("string");
                    break;
                }
                case Date: {
                    ((QueryParameter)param.type("string")).format("date");
                    break;
                }
                case Currency: {
                    ((QueryParameter)param.type("string")).format("currency");
                    break;
                }
                case UUID: {
                    ((QueryParameter)param.type("string")).format("uuid");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown or unsupported primitive type '" + primitiveType.getPrimitiveTypeName() + "'");
                }
            }
            return;
        }
        throw new IllegalArgumentException("Unsupported parameter type '" + fieldType.getName() + "'. Please use POST method for this request.");
    }

    private final Property getPrimitiveProperty(AdmPrimitive.Type primitiveType) {
        switch (primitiveType) {
            case Byte: 
            case Short: 
            case Integer: 
            case Char: {
                return new IntegerProperty();
            }
            case Long: {
                return new LongProperty();
            }
            case Float: {
                return new FloatProperty();
            }
            case Double: {
                return new DoubleProperty();
            }
            case Boolean: {
                return new BooleanProperty();
            }
            case String: {
                return new StringProperty();
            }
            case Date: {
                return new DateProperty();
            }
            case Currency: {
                return new StringProperty();
            }
            case UUID: {
                return new UUIDProperty();
            }
        }
        throw new IllegalArgumentException("Unknown or unsupported primitive type '" + primitiveType.getPrimitiveTypeName() + "'");
    }

    private final Property getEnumProperty(AdmEnumeration enumeration) {
        StringProperty prop = new StringProperty();
        Iterator iterator = enumeration.constIterator();
        while (iterator.hasNext()) {
            AdmEnumeration.ConstEntry entry = (AdmEnumeration.ConstEntry)iterator.next();
            prop._enum(entry.name);
        }
        return prop;
    }

    private final Property getEntityProperty(AdmEntity entityType) {
        return new ObjectProperty().properties(this.getProperties(entityType.fields().values()));
    }

    private final Map<String, Property> getProperties(Collection<AdmField> fields) {
        LinkedHashMap<String, Property> properties = new LinkedHashMap<String, Property>();
        for (AdmField field : fields) {
            if (field.getName().equals("header")) continue;
            AdmType fieldType = field.getType();
            if (fieldType instanceof AdmPrimitive) {
                properties.put(field.getName(), this.getPrimitiveProperty(((AdmPrimitive)field.getType()).getType()).description(this.getDocNoLineBreaks(field.getDocumentation())));
                continue;
            }
            if (fieldType instanceof AdmArray) {
                if (fieldType instanceof AdmPrimitiveArray) {
                    properties.put(field.getName(), (Property)new ArrayProperty().items(this.getPrimitiveProperty(((AdmPrimitiveArray)fieldType).getType())));
                    continue;
                }
                if (fieldType instanceof AdmEntityArray) {
                    properties.put(field.getName(), (Property)new ArrayProperty().items(this.getEntityProperty(((AdmEntityArray)fieldType).getType())));
                    continue;
                }
                if (!(fieldType instanceof AdmEnumerationArray)) continue;
                properties.put(field.getName(), (Property)new ArrayProperty().items(this.getEnumProperty(((AdmEnumerationArray)fieldType).getType())));
                continue;
            }
            if (fieldType instanceof AdmEnumeration) {
                properties.put(field.getName(), this.getEnumProperty((AdmEnumeration)fieldType));
                continue;
            }
            if (fieldType instanceof AdmEntity) {
                properties.put(field.getName(), this.getEntityProperty((AdmEntity)fieldType).description(field.getQualifiedName() + ": " + this.getDocNoLineBreaks(field.getDocumentation())));
                continue;
            }
            if (fieldType instanceof AdmCollection) continue;
            throw new IllegalArgumentException("unknown field type '" + fieldType.getTemplatedJavaTypeName() + "' (class=" + fieldType.getClass().getName() + ")");
        }
        return properties;
    }

    private final Model getSchema(AdmEntity entity) {
        ModelImpl model = new ModelImpl();
        model.description(entity.getFullName() + ": " + this.getDoc(entity.getDocumentation())).name(entity.getName()).type("object");
        model.setProperties(this.getProperties(entity.fields().values()));
        return model;
    }

    private final void generateSwaggerDoc(PrintWriter writer) throws IOException {
        Swagger swagger = new Swagger();
        swagger.setSwagger("2.0");
        swagger.info(new Info().title(this.getBriefDoc(this.documentation)).version("1.0").description(this.getFullDoc(this.documentation))).host(null).basePath("/" + this.getName()).tag(new Tag().name(this.getName())).scheme(Scheme.HTTP).scheme(Scheme.HTTPS);
        if (this.operations.size() > 0) {
            for (AsmOperation operation : this.operations) {
                if (operation.getRESTPath() == null || !operation.getInMessage().getNamespace().equals(this.messagesModel.getNamespace())) continue;
                Path path = new Path();
                swagger.path("/" + operation.getRESTPath(), path);
                AdmMessage inMessage = operation.getInMessage();
                AdmMessage outMessage = operation.getOutMessage();
                boolean hasReturnValue = outMessage != null;
                Operation swagOperation = new Operation();
                swagOperation.summary(this.getBriefDoc(operation.getDocumentation())).description(this.getFullDoc(operation.getDocumentation())).operationId(AdmGenerator.toFirstLetterLowercase((String)operation.getName())).tag(this.getName());
                swagOperation.response(200, new Response().schema(this.getEntityProperty((AdmEntity)outMessage)).description(this.getDoc(outMessage.getDocumentation())));
                switch (operation.getRESTMethod()) {
                    case POST: {
                        swagOperation.consumes("application/json");
                        if (hasReturnValue) {
                            swagOperation.produces("application/json");
                        }
                        BodyParameter param = new BodyParameter().name("request").description(this.getDoc(inMessage.getDocumentation()));
                        param.schema(this.getSchema((AdmEntity)inMessage));
                        swagOperation.parameter((Parameter)param);
                        path.post(swagOperation);
                        break;
                    }
                    case GET: {
                        swagOperation.produces("application/json");
                        for (AdmField field : inMessage.fields().values()) {
                            if (field.getName().equals("header")) continue;
                            QueryParameter qparam = (QueryParameter)((QueryParameter)new QueryParameter().name(field.getName())).description(this.getDocNoLineBreaks(field.getDocumentation()));
                            this.setSwaggerQueryParamType(qparam, field.getType());
                            swagOperation.parameter((Parameter)qparam);
                        }
                        path.get(swagOperation);
                    }
                }
            }
        }
        Path path = new Path();
        swagger.path("/ping", path);
        Operation swagOperation = new Operation();
        swagOperation.summary("send a ping request").description("Sends a ping request to the service").operationId("ping").tag(this.getName()).produces("application/json");
        swagOperation.response(200, new Response().schema(this.getEntityProperty((AdmEntity)this.eagleMessagesModel.getMessage("PingResponse")).description("returns PingResponse object as json string.<p>")));
        path.get(swagOperation);
        Json.pretty().writeValue((Writer)writer, (Object)swagger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generateSwaggerDoc(File targetDir) throws Exception {
        File file = new File(targetDir, "swagger.json");
        if (file.exists()) {
            file.delete();
        }
        System.out.println("...'" + file.getAbsolutePath() + "'...");
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(file);
            try {
                this.generateSwaggerDoc(writer);
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            throw new EAsmException("Failed to create HTML service test page '" + file.getPath() + "' [" + e.toString() + "]");
        }
    }

    private final void generateHTMLTestPage(PrintWriter writer) {
        writer.println("<!DOCTYPE HTML>");
        writer.println("<html lang=\"en\">");
        writer.println("    <head>");
        writer.println("        <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />");
        writer.println("        <title>" + this.getName() + " Service Test Page</title>");
        writer.println("        <link rel=\"stylesheet\" href=\"http://maxcdn.bootstrapcdn.com/bootstrap/3.3.5/css/bootstrap.min.css\">");
        writer.println("        <meta content=\"text/html\" charset=\"utf-8\" http-equiv=\"Content-Type\">");
        writer.println("        <meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">");
        writer.println("    </head>");
        writer.println("");
        writer.println("    <body link=\"#e14900\" bgcolor=\"#f8f8f8\">");
        writer.println("        <script src=\"https://ajax.googleapis.com/ajax/libs/jquery/1.11.3/jquery.min.js\"></script>");
        writer.println("        <script src=\"http://maxcdn.bootstrapcdn.com/bootstrap/3.3.5/js/bootstrap.min.js\"></script>");
        writer.println("        <script src=\"scripts/jquery-3.1.0.min.js\" type=\"text/javascript\" charset=\"utf-8\"> </script>");
        writer.println("        <script src=\"scripts/jquery-ui.min.js\" type=\"text/javascript\" charset=\"utf-8\"> </script>");
        writer.println("");
        writer.println("        <script type=\"text/javascript\">");
        writer.println("            $(document).ready(function(){");
        writer.println("                enableDisable();");
        writer.println("                $('#submit').click(function(evt) {");
        writer.println("                    evt.preventDefault();");
        writer.println("                    send();");
        writer.println("                });");
        writer.println("                $('#clear').click(function(evt) {");
        writer.println("                    evt.preventDefault();");
        writer.println("                    clear();");
        writer.println("                });");
        writer.println("                $('#method').change(function(evt) {");
        writer.println("                    enableDisable();");
        writer.println("                });");
        writer.println("                $('#method').focusout(function(evt) {");
        writer.println("                    enableDisable();");
        writer.println("                });");
        writer.println("            });");
        writer.println("");
        writer.println("            function enableDisable() {");
        writer.println("                var method = $('#method').val();");
        writer.println("                switch (method) {");
        writer.println("                    case \"ping\":");
        for (AsmOperation operation : this.operations) {
            if (operation.getRESTPath() == null || !operation.getInMessage().getNamespace().equals(this.messagesModel.getNamespace()) || operation.getRESTMethod() != AsmOperation.RestMethod.GET) continue;
            writer.println("                    case \"" + AdmGenerator.toFirstLetterLowercase((String)operation.getName()) + "\":");
        }
        writer.println("                        $('#params').show();");
        writer.println("                        $('#reqdto').hide()");
        writer.println("                        break;");
        boolean hasCase = false;
        for (AsmOperation operation : this.operations) {
            if (operation.getRESTPath() == null || !operation.getInMessage().getNamespace().equals(this.messagesModel.getNamespace()) || operation.getRESTMethod() != AsmOperation.RestMethod.POST) continue;
            writer.println("                    case \"" + AdmGenerator.toFirstLetterLowercase((String)operation.getName()) + "\":");
            hasCase = true;
        }
        if (hasCase) {
            writer.println("                        $('#params').show();");
            writer.println("                        $('#reqdto').show()");
            writer.println("                        break;");
        }
        writer.println("                }");
        writer.println("            }");
        writer.println("            function getUrl(method) {");
        writer.println("                switch (method) {");
        writer.println("                    case \"ping\":");
        writer.println("                        return \"/ping\";");
        for (AsmOperation operation : this.operations) {
            if (operation.getRESTPath() == null || !operation.getInMessage().getNamespace().equals(this.messagesModel.getNamespace())) continue;
            writer.println("                    case \"" + AdmGenerator.toFirstLetterLowercase((String)operation.getName()) + "\":");
            writer.println("                        return \"/" + operation.getRESTPath() + "\";");
        }
        writer.println("            }");
        writer.println("                return \"\";");
        writer.println("            }");
        writer.println("            function getMethodType(method) {");
        writer.println("                switch (method) {");
        writer.println("                    case \"ping\":");
        writer.println("                        return \"GET\";");
        for (AsmOperation operation : this.operations) {
            if (operation.getRESTPath() == null || !operation.getInMessage().getNamespace().equals(this.messagesModel.getNamespace())) continue;
            writer.println("                    case \"" + AdmGenerator.toFirstLetterLowercase((String)operation.getName()) + "\":");
            writer.println("                        return \"" + (Object)((Object)operation.getRESTMethod()) + "\";");
        }
        writer.println("                }");
        writer.println("                return \"\";");
        writer.println("            }");
        writer.println("            function send() {");
        writer.println("                var method = $('#method').val();");
        writer.println("                var url = \"http://\" + location.host + \"/\" + \"" + this.getName() + "\" + getUrl(method);");
        writer.println("                var methodType = getMethodType(method);");
        writer.println("                switch (methodType) {");
        writer.println("                    case \"GET\":");
        writer.println("                        url = url + \"?\" + $('#params').val();");
        writer.println("                        $('#url').val(\"GET \" + url);");
        writer.println("                        $('#reqdto').val(\"<empty>\");");
        writer.println("                        $.ajax({url: url,");
        writer.println("                            type: \"GET\",");
        writer.println("                            dataType: \"json\",");
        writer.println("                            cache: \"false\",");
        writer.println("                            contentType: \"text/plain\",");
        writer.println("                            success: function(data, status, jqXHR) {");
        writer.println("                                if (data == null) {");
        writer.println("                                    $('#respdto').val(\"<empty>\");");
        writer.println("                                }");
        writer.println("                                else {");
        writer.println("                                    $('#respdto').val(JSON.stringify(data));");
        writer.println("                                }");
        writer.println("                            },");
        writer.println("                            error: function(jqXHR, status, thrown) {");
        writer.println("                                $('#respdto').val(jqXHR.responseText);");
        writer.println("                            }});");
        writer.println("                        break;");
        writer.println("                    case \"POST\":");
        writer.println("                        $('#url').val(\"POST \" + url);");
        writer.println("                        $.ajax({url: url,");
        writer.println("                            type: \"POST\",");
        writer.println("                            dataType: \"json\",");
        writer.println("                            cache: \"false\",");
        writer.println("                            contentType: \"application/json\",");
        writer.println("                            data: $('#reqdto').val(),");
        writer.println("                            success: function(data, status, jqXHR) {");
        writer.println("                                if (data == null) {");
        writer.println("                                    $('#respdto').val(\"<empty>\");");
        writer.println("                                }");
        writer.println("                                else {");
        writer.println("                                    $('#respdto').val(JSON.stringify(data));");
        writer.println("                                }");
        writer.println("                            },");
        writer.println("                            error: function(jqXHR, status, thrown) {");
        writer.println("                                $('#respdto').val(jqXHR.responseText);");
        writer.println("                            }});");
        writer.println("                        break;");
        writer.println("                }");
        writer.println("            }");
        writer.println("            function clear() {");
        writer.println("                $('#url').val(\"\");");
        writer.println("                $('#reqdto').val(\"\");");
        writer.println("                $('#respdto').val(\"\");");
        writer.println("            }");
        writer.println("        </script>");
        writer.println("");
        writer.println("        <div class=\"container\">");
        writer.println("            <div class=\"row\">");
        writer.println("                <div class=\"col-md-12\">");
        writer.println("                    <h2 align=\"right\"><img style=\"WIDTH: 247px; HEIGHT: 36px\" border=\"0\" hspace=\"2\" src=\"images/logo.gif\"></h2>");
        writer.println("                </div>");
        writer.println("            </div>");
        writer.println("            <div class=\"row\">");
        writer.println("                <div class=\"col-md-12\">");
        writer.println("                    <hr>");
        writer.println("                    <h1 align=\"left\" style=\"color: #b99701\">" + this.getName() + " Service Test Page</h1>");
        writer.println("                    <p style=\"FONT-SIZE: 14px;color: #444f51\" align=\"left\">");
        writer.println("                        This is the " + this.getName() + " service test page. To test a method, select the method you wish to test, supply the appropriate parameters ");
        writer.println("                        and click Send. Clicking the Clear button will reset the page in preparation for a new request.");
        writer.println("                    </p>");
        writer.println("                    <p style=\"FONT-SIZE: 14px;color: #444f51\" align=\"left\">");
        writer.println("                        <i><b>Note</b>: that the \"Request Body\" section will only be enabled when a POST method is selected.</i>");
        writer.println("                    </p>");
        writer.println("                    <hr>");
        writer.println("                    <h4 align=\"left\" style=\"color: #320555\">Method</h4>");
        writer.println("                    <p style=\"FONT-SIZE: 16px;color: #320555\">");
        writer.println("                        <select id=\"method\">");
        writer.println("                            <option value=\"ping\">ping</option>");
        for (AsmOperation operation : this.operations) {
            if (operation.getRESTPath() == null || !operation.getInMessage().getNamespace().equals(this.messagesModel.getNamespace())) continue;
            writer.println("                            <option value=\"" + AdmGenerator.toFirstLetterLowercase((String)operation.getName()) + "\">" + AdmGenerator.toFirstLetterLowercase((String)operation.getName()) + "</option>");
        }
        writer.println("                        </select>");
        writer.println("                    </p>");
        writer.println("                    <h5 align=\"left\" style=\"color: #320555\">URL Parameters</h5>");
        writer.println("                    <input type=\"text\" id=\"params\" size=\"120\" name=\"params\">");
        writer.println("                    <h5 align=\"left\" style=\"color: #320555\">Request Body (Json DTO)</h5>");
        writer.println("                    <textarea id=\"reqdto\" cols=\"120\" rows=\"12\"></textarea>");
        writer.println("                    <br>");
        writer.println("                    <button type=\"button\" id=\"submit\">Send</button>");
        writer.println("                    <button type=\"button\" id=\"clear\">Clear</button>");
        writer.println("                    <input style=\"border:none;background-color: transparent;FONT-SIZE: 14px;color: red\" type=\"text\" id=\"error\" size=\"100\" name=\"error\" readonly=\"true\">");
        writer.println("                    <br>");
        writer.println("                    <hr/>");
        writer.println("                    <h5 align=\"left\" style=\"color: #320555\">Request URL</h5>");
        writer.println("                    <input type=\"text\" id=\"url\" size=\"120\" name=\"url\" readonly=\"true\">");
        writer.println("                    <h5 align=\"left\" style=\"color: #320555\">Response Body (JSON DTO)</h5>");
        writer.println("                    <textarea id=\"respdto\" cols=\"120\" rows=\"12\"></textarea>");
        writer.println("                </div>");
        writer.println("            </div>");
        writer.println("            <div class=\"row\">");
        writer.println("                <div class=\"col-md-12\">");
        writer.println("                    <p style=\"FONT-SIZE: 12px\" align=\"center\">");
        writer.println("                    </br>");
        writer.println("                    Copyright (c) 2016 Neeve Research, LLC");
        writer.println("                    </p>");
        writer.println("                </div>");
        writer.println("            </div>");
        writer.println("            <div class=\"modal\"><!-- Place at bottom of page --></div>");
        writer.println("        </div>");
        writer.println("    </body>");
        writer.println("</html>");
    }

    private final File ensureTargetDir(File dir) throws Exception {
        if (!dir.exists()) {
            System.out.println("......'" + dir.getAbsolutePath() + "'...");
            dir.mkdirs();
        } else {
            System.out.println("......'" + dir.getAbsolutePath() + "'...X [already exists].");
        }
        return dir;
    }

    private final File ensureTargetWebappDir(File resourcesdir) throws Exception {
        String WEBAPP_DIR = "webapp/";
        File webAppDir = new File(resourcesdir, this.getName() + File.separator + "webapp/");
        return this.ensureTargetDir(webAppDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generateHTMLTestPage(File targetDir) throws Exception {
        File file = new File(targetDir, "testService.html");
        if (file.exists()) {
            file.delete();
        }
        System.out.println("...'" + file.getAbsolutePath() + "'...");
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(file);
            try {
                this.generateHTMLTestPage(writer);
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            throw new EAsmException("Failed to create HTML service test page '" + file.getPath() + "' [" + e.toString() + "]");
        }
    }

    private void copyContent(File outFile, JarFile jar, JarEntry jarEntry) throws IOException {
        if (!jarEntry.isDirectory()) {
            int oneChar;
            outFile.createNewFile();
            InputStream in = jar.getInputStream(jarEntry);
            FileOutputStream out = new FileOutputStream(outFile);
            while ((oneChar = in.read()) != -1) {
                ((OutputStream)out).write(oneChar);
            }
            ((OutputStream)out).close();
            in.close();
        } else {
            outFile.mkdirs();
        }
    }

    private final void copyHTMLTestPageResources(File targetDir, File apiDocFile) throws Exception {
        String SOURCE_WEBAPP_DIR = "webapp/";
        System.out.println("...Copying html test page resource files...");
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("webapp/");
        System.out.println("Found webapp dir at: " + url);
        if (url != null) {
            if (url.getPath().contains(".jar!/webapp/")) {
                String path = url.getPath().substring(5, url.getPath().length() - ("webapp/".length() + 2));
                JarFile jar = new JarFile(new File(path));
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    File outFile;
                    JarEntry jarEntry = entries.nextElement();
                    if (!jarEntry.getName().startsWith("webapp/") || (outFile = jarEntry.getName().endsWith("apidoc.html") ? apiDocFile : new File(targetDir, jarEntry.getName().substring("webapp/".length()))).equals(targetDir)) continue;
                    outFile.delete();
                    System.out.println("......'" + outFile.getAbsolutePath() + "'...");
                    this.copyContent(outFile, jar, jarEntry);
                }
            } else {
                this.copyRecursive(new File(url.getFile()), targetDir);
            }
        } else {
            throw new EAsmException("Failed to copy html test page resource files. resources/webapp not found in jar");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void copyRecursive(File srcDir, File targetDir) throws EAsmException {
        File[] files = srcDir.listFiles();
        if (files == null) {
            throw new EAsmException("Not a directory: " + srcDir);
        }
        block8: for (File f : files) {
            if (f.isDirectory()) {
                File nextTargetDir = new File(targetDir, f.getName());
                if (!nextTargetDir.isDirectory() && !nextTargetDir.mkdir()) {
                    throw new EAsmException("Failed to copy html test page resource files. Unable to create output directory: " + nextTargetDir);
                }
                this.copyRecursive(new File(srcDir, f.getName()), nextTargetDir);
                continue;
            }
            File destFile = new File(targetDir, f.getName());
            if (destFile.isFile() && !destFile.delete()) {
                throw new EAsmException("Failed to delete old file: " + destFile);
            }
            try (FileOutputStream out = new FileOutputStream(destFile);
                 FileInputStream in = new FileInputStream(f);){
                byte[] buf = new byte[16384];
                while (true) {
                    int numRead;
                    if ((numRead = in.read(buf)) < 0) {
                        continue block8;
                    }
                    out.write(buf, 0, numRead);
                }
            }
            catch (IOException e) {
                throw new EAsmException(e);
            }
        }
    }

    private final void generateApp(PrintWriter writer) {
        writer.println("package " + this.getNamespace() + ".service;");
        writer.println("");
        writer.println("@com.neeve.server.app.annotations.AppVersion(1)");
        writer.println("public class App extends AbstractApp {");
        writer.println("    // --- App version");
        writer.println("    final public static int APP_MAJOR_VERSION = 1;");
        writer.println("    final public static int APP_MINOR_VERSION = 0;");
        writer.println("    // --- App version");
        writer.println("");
        writer.println("    /**");
        writer.println("     * Constructor ");
        writer.println("     */");
        writer.println("    public App() {");
        writer.println("        super(APP_MAJOR_VERSION, APP_MINOR_VERSION);");
        writer.println("    }");
        writer.println("}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generateApp(File outdir, boolean absolute) throws Exception {
        block7: {
            File file = this.resolveAbsoluteClassFile(outdir, absolute ? null : this.getNamespace() + ".service", "App");
            if (!file.exists()) {
                System.out.println("...'" + file.getAbsolutePath() + "'...");
                File dir = file.getParentFile();
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                PrintWriter writer = null;
                try {
                    writer = new PrintWriter(file);
                    try {
                        this.generateApp(writer);
                        break block7;
                    }
                    finally {
                        writer.close();
                    }
                }
                catch (IOException e) {
                    throw new EAsmException("Failed to create application main file '" + file.getPath() + "' [" + e.toString() + "]");
                }
            }
            System.out.println("...'" + file.getAbsolutePath() + "'...X [already exists].");
        }
    }

    private final void generateClient(PrintWriter writer) {
        writer.println("package " + this.getNamespace() + ".service;");
        writer.println("");
        writer.println("import com.neeve.service.messages.*;");
        writer.println("");
        writer.println("final public class Client extends AbstractClient {");
        writer.println("    // ---- Constructors");
        writer.println("    public Client() {");
        writer.println("        this(null);");
        writer.println("    }");
        writer.println("    public Client(final String name) {");
        writer.println("        this(name, null, null);");
        writer.println("    }");
        writer.println("    public Client(final String name, final Credentials credentials) {");
        writer.println("        this(name, null, credentials);");
        writer.println("    }");
        writer.println("    public Client(final String name, final Object handlers) {");
        writer.println("        this(name, handlers, null);");
        writer.println("    }");
        writer.println("    public Client(final String name, final Object handlers, final Credentials credentials) {");
        writer.println("        super(name, App.APP_MAJOR_VERSION, App.APP_MINOR_VERSION, handlers, credentials);");
        writer.println("    }");
        writer.println("    // ---- Constructors");
        writer.println("");
        writer.println("    // ---- Overriden implementation of {@link AbstractClient#createApp}");
        writer.println("    @Override");
        writer.println("    final protected " + this.getNamespace() + ".service.AbstractApp createApp() {");
        writer.println("        return new App();");
        writer.println("    }");
        writer.println("}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generateClient(File outdir, boolean absolute) throws Exception {
        block7: {
            File file = this.resolveAbsoluteClassFile(outdir, absolute ? null : this.getNamespace() + ".service", "Client");
            if (!file.exists()) {
                System.out.println("...'" + file.getAbsolutePath() + "'...");
                File dir = file.getParentFile();
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                PrintWriter writer = null;
                try {
                    writer = new PrintWriter(file);
                    try {
                        this.generateClient(writer);
                        break block7;
                    }
                    finally {
                        writer.close();
                    }
                }
                catch (IOException e) {
                    throw new EAsmException("Failed to create application client file '" + file.getPath() + "' [" + e.toString() + "]");
                }
            }
            System.out.println("...'" + file.getAbsolutePath() + "'...X [already exists].");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generateFirstMessageHandler(File outdir, boolean absolute) throws Exception {
        block7: {
            File file = this.resolveAbsoluteClassFile(outdir, absolute ? null : this.getNamespace() + ".service.domain.handlers", "FirstMessageRequestHandler");
            if (!file.exists()) {
                System.out.println("...'" + file.getAbsolutePath() + "'...");
                File dir = file.getParentFile();
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                PrintWriter writer = null;
                try {
                    writer = new PrintWriter(file);
                    try {
                        writer.println("package " + this.getNamespace() + ".service.domain.handlers;");
                        writer.println("");
                        writer.println("import java.util.Date;");
                        writer.println("");
                        writer.println("import com.google.inject.*;");
                        writer.println("");
                        writer.println("import com.neeve.ci.XRuntime;");
                        writer.println("import com.neeve.sma.MessageView;");
                        writer.println("import com.neeve.service.MessageHandler;");
                        writer.println("import com.neeve.service.IdentityInformationProvider;");
                        writer.println("import com.neeve.service.messages.FirstRequest;");
                        writer.println("import com.neeve.service.messages.AgentInfo;");
                        writer.println("import com.neeve.service.messages.AgentStartedEvent;");
                        writer.println("");
                        writer.println("final public class FirstMessageRequestHandler implements MessageHandler<FirstRequest, AgentStartedEvent, " + this.stateRoot.getFullName() + "> {");
                        writer.println("    @Inject private IdentityInformationProvider identityInfoProvider;");
                        writer.println("");
                        writer.println("    /**");
                        writer.println("     * Implementation of {@link MessageHandler#getType}");
                        writer.println("     */");
                        writer.println("    final public Type getType() {");
                        writer.println("        return Type.Local;");
                        writer.println("    }");
                        writer.println("");
                        writer.println("    /**");
                        writer.println("     * Implementation of {@link MessageHandler#handle}");
                        writer.println("     */");
                        writer.println("    final public MessageView handle(final String origin,");
                        writer.println("                                    final FirstRequest request, ");
                        writer.println("                                    final AgentStartedEvent event, ");
                        writer.println("                                    final " + this.stateRoot.getFullName() + " repository) throws Exception {");
                        writer.println("        // dispatch the agent started event");
                        writer.println("        final AgentInfo agentInfo = AgentInfo.create();");
                        writer.println("        agentInfo.setApplicationName(identityInfoProvider.getName());");
                        writer.println("        agentInfo.setApplicationPartition(identityInfoProvider.getPartition());");
                        writer.println("        agentInfo.setPid(XRuntime.getPid());");
                        writer.println("        agentInfo.setStartTime(new Date());");
                        writer.println("        event.setAgentInfo(agentInfo);");
                        writer.println("        return null;");
                        writer.println("    }");
                        writer.println("}");
                        break block7;
                    }
                    finally {
                        writer.close();
                    }
                }
                catch (IOException e) {
                    throw new EAsmException("Failed to create application handler file '" + file.getPath() + "' [" + e.toString() + "]");
                }
            }
            System.out.println("...'" + file.getAbsolutePath() + "'...X [already exists].");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generatePingHandler(File outdir, boolean absolute) throws Exception {
        block7: {
            File file = this.resolveAbsoluteClassFile(outdir, absolute ? null : this.getNamespace() + ".service.domain.handlers", "PingRequestHandler");
            if (!file.exists()) {
                System.out.println("...'" + file.getAbsolutePath() + "'...");
                File dir = file.getParentFile();
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                PrintWriter writer = null;
                try {
                    writer = new PrintWriter(file);
                    try {
                        writer.println("package " + this.getNamespace() + ".service.domain.handlers;");
                        writer.println("");
                        writer.println("import java.util.Date;");
                        writer.println("");
                        writer.println("import com.google.inject.*;");
                        writer.println("");
                        writer.println("import com.neeve.ci.XRuntime;");
                        writer.println("import com.neeve.sma.MessageView;");
                        writer.println("import com.neeve.service.MessageHandler;");
                        writer.println("import com.neeve.service.IdentityInformationProvider;");
                        writer.println("import com.neeve.service.messages.PingRequest;");
                        writer.println("import com.neeve.service.messages.PingResponse;");
                        writer.println("import com.neeve.service.messages.AgentInfo;");
                        writer.println("");
                        writer.println("final public class PingRequestHandler implements MessageHandler<PingRequest, PingResponse, " + this.stateRoot.getFullName() + "> {");
                        writer.println("    @Inject private IdentityInformationProvider identityInfoProvider;");
                        writer.println("");
                        writer.println("    /**");
                        writer.println("     * Implementation of {@link MessageHandler#getType}");
                        writer.println("     */");
                        writer.println("    final public Type getType() {");
                        writer.println("        return Type.Local;");
                        writer.println("    }");
                        writer.println("");
                        writer.println("    /**");
                        writer.println("     * Implementation of {@link MessageHandler#handle}");
                        writer.println("     */");
                        writer.println("    final public MessageView handle(final String origin,");
                        writer.println("                                    final PingRequest request, ");
                        writer.println("                                    final PingResponse response, ");
                        writer.println("                                    final " + this.stateRoot.getFullName() + " repository) throws Exception {");
                        writer.println("        // dispatch the agent started event");
                        writer.println("        final AgentInfo agentInfo = AgentInfo.create();");
                        writer.println("        agentInfo.setApplicationName(identityInfoProvider.getName());");
                        writer.println("        agentInfo.setApplicationPartition(identityInfoProvider.getPartition());");
                        writer.println("        agentInfo.setPid(XRuntime.getPid());");
                        writer.println("        agentInfo.setStartTime(new Date());");
                        writer.println("        response.setStatus(agentInfo.toString());");
                        writer.println("        return null;");
                        writer.println("    }");
                        writer.println("}");
                        break block7;
                    }
                    finally {
                        writer.close();
                    }
                }
                catch (IOException e) {
                    throw new EAsmException("Failed to create ping handler file '" + file.getPath() + "' [" + e.toString() + "]");
                }
            }
            System.out.println("...'" + file.getAbsolutePath() + "'...X [already exists].");
        }
    }

    private final void generateHandler(String handlerName, AsmOperation.Type type, AdmMessage inMessage, AdmMessage outMessage, Set<AdmMessage> eventMessages, PrintWriter writer) {
        writer.println("package " + this.getNamespace() + ".service.domain.handlers;");
        writer.println("");
        writer.println("import com.google.inject.*;");
        writer.println("");
        writer.println("import com.neeve.sma.MessageView;");
        writer.println("import com.neeve.service.MessageHandler;");
        writer.println("import com.neeve.service.MessageSender;");
        writer.println("");
        writer.println("import " + inMessage.getFullName() + ";");
        writer.println("import " + outMessage.getFullName() + ";");
        writer.println("import " + this.stateRoot.getFullName() + ";");
        writer.println("");
        writer.println("final public class " + handlerName + " implements MessageHandler<" + inMessage.getJavaTypeName() + ", " + outMessage.getJavaTypeName() + ", " + this.stateRoot.getJavaTypeName() + "> {");
        if (eventMessages != null && eventMessages.size() > 0) {
            for (AdmMessage message : eventMessages) {
                writer.println("    @Inject private MessageSender<" + message.getFullName() + "> " + this.messageSenderVarName(message) + ";");
            }
            writer.println("");
        }
        writer.println("    /**");
        writer.println("     * Implementation of {@link MessageHandler#getType}");
        writer.println("     */");
        writer.println("    final public Type getType() {");
        writer.println("        return " + (type == AsmOperation.Type.local ? "Type.Local" : "Type.Remote") + ";");
        writer.println("    }");
        writer.println("");
        writer.println("    /**");
        writer.println("     * Implementation of {@link MessageHandler#handle}");
        writer.println("     */");
        writer.println("    final public MessageView handle(final String origin,");
        writer.println("                                    final " + inMessage.getJavaTypeName() + " request, ");
        writer.println("                                    final " + outMessage.getJavaTypeName() + " response, ");
        writer.println("                                    final " + this.stateRoot.getJavaTypeName() + " repository) throws Exception {");
        writer.println("        return null;");
        writer.println("    }");
        writer.println("}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generateHandler(String handlerName, AsmOperation.Type type, AdmMessage inMessage, AdmMessage outMessage, Set<AdmMessage> eventMessages, File outdir, boolean absolute) throws Exception {
        block7: {
            File file = this.resolveAbsoluteClassFile(outdir, absolute ? null : this.getNamespace() + ".service.domain.handlers", handlerName);
            if (!file.exists()) {
                System.out.println("...'" + file.getAbsolutePath() + "'...");
                File dir = file.getParentFile();
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                PrintWriter writer = null;
                try {
                    writer = new PrintWriter(file);
                    try {
                        this.generateHandler(handlerName, type, inMessage, outMessage, eventMessages, writer);
                        break block7;
                    }
                    finally {
                        writer.close();
                    }
                }
                catch (IOException e) {
                    throw new EAsmException("Failed to create application handler file '" + file.getPath() + "' [" + e.toString() + "]");
                }
            }
            System.out.println("...'" + file.getAbsolutePath() + "'...X [already exists].");
        }
    }

    private final void generateHandlers(File outdir, boolean absolute) throws Exception {
        this.generateFirstMessageHandler(outdir, absolute);
        this.generatePingHandler(outdir, absolute);
        for (AsmOperation operation : this.operations) {
            this.generateHandler(operation.getHandlerName(), operation.getType(), operation.getInMessage(), operation.getOutMessage(), operation.getEventMessages(), outdir, absolute);
        }
        for (AsmStreamingPeer streamingPeer : this.streamingPeers) {
            for (AsmStreamingPeer.Message message : streamingPeer.getMessages()) {
                this.generateHandler(message.getHandlerName(), AsmOperation.Type.local, message.getMessage(), this.getNullMessage(), null, outdir, absolute);
            }
        }
    }

    public final void generateClasses(File unmodresourcesdir, File resourcesdir, File unmodoutdir, File modoutdir, boolean absolute) throws Exception {
        if (unmodoutdir == null) {
            throw new IllegalArgumentException("output directory for unmodifiable generated files cannot be null");
        }
        if (modoutdir == null) {
            throw new IllegalArgumentException("output directory for modifiable generated files cannot be null");
        }
        if (unmodresourcesdir == null) {
            throw new IllegalArgumentException("unmodifiable resources directory cannot be null");
        }
        if (resourcesdir == null) {
            throw new IllegalArgumentException("resources directory for unmodifiable generated resource files cannot be null");
        }
        System.out.println("Generating unmodifiable class files to '" + unmodoutdir.getAbsolutePath() + "' (absolute=" + absolute + ")...");
        this.generateAbstractApp(unmodoutdir, absolute);
        this.generateAbstractClient(unmodoutdir, absolute);
        this.generateDomainGuiceModule(unmodoutdir, absolute);
        this.generateWebApp(unmodoutdir, absolute);
        this.generateAbstractWebAppResource(unmodoutdir, absolute);
        System.out.println("");
        System.out.println("Generating modifiable class files to '" + modoutdir.getAbsolutePath() + "' (absolute=" + absolute + ")...");
        if (!modoutdir.exists()) {
            modoutdir.mkdirs();
        }
        this.generateApp(modoutdir, absolute);
        this.generateClient(modoutdir, absolute);
        this.generateHandlers(modoutdir, absolute);
        this.generateWebAppResource(modoutdir, absolute);
        File targetWebappDir = this.ensureTargetWebappDir(unmodresourcesdir);
        System.out.println("Generating unmodifiable webservice resources files to '" + targetWebappDir.getAbsolutePath() + "'...");
        File apiDocDir = this.ensureTargetDir(new File(targetWebappDir, "doc"));
        this.generateSwaggerDoc(apiDocDir);
        this.copyHTMLTestPageResources(targetWebappDir, new File(apiDocDir, this.getName() + ".html"));
        System.out.println("");
    }

    public final String getName() {
        return this.name;
    }

    public final String getNamespace() {
        return this.namespace;
    }

    public void setDocumentation(AsmDocumentation doc) {
        this.documentation = doc;
    }

    public AsmDocumentation getDocumentation() {
        return this.documentation;
    }

    public final AdmModel getMessagesModel() {
        return this.messagesModel;
    }

    public final AdmModel getStateModel() {
        return this.stateModel;
    }

    public final AdmEntity getStateRoot() {
        return this.stateRoot;
    }

    public final String nameFromFullName(String fullname) {
        int index = fullname.lastIndexOf(".");
        return index == -1 ? fullname : fullname.substring(index + 1, fullname.length());
    }

    public final String namespaceFromFullName(String fullname) {
        int index = fullname.lastIndexOf(".");
        return index == -1 ? null : fullname.substring(0, index);
    }

    public final void addModule(AsmModule module) throws Exception {
        if (module == null) {
            throw new IllegalArgumentException("service module cannot be null");
        }
        if (this.tracer.debug) {
            this.tracer.log("ASM Model '" + this.namespace + "': Adding module '" + module.getClassName() + "'", Tracer.Level.DEBUG);
        }
        this.modules.add(module);
    }

    public final void addPeer(AsmModel model) throws Exception {
        if (model == null) {
            throw new IllegalArgumentException("peer model cannot be null");
        }
        if (this.tracer.debug) {
            this.tracer.log("ASM Model '" + this.namespace + "': Adding peer '" + model.getNamespace() + "'", Tracer.Level.DEBUG);
        }
        this.peers.add(model);
    }

    public final void addStreamingPeer(AsmStreamingPeer peer) throws Exception {
        if (peer == null) {
            throw new IllegalArgumentException("streaming peer model cannot be null");
        }
        if (this.tracer.debug) {
            this.tracer.log("ASM Model '" + this.namespace + "': Adding streaming peer model '" + peer.getMessagesModel().getNamespace() + "'", Tracer.Level.DEBUG);
        }
        this.streamingPeers.add(peer);
    }

    public final void addOperation(AsmOperation operation) throws Exception {
        if (operation == null) {
            throw new IllegalArgumentException("operation cannot be null");
        }
        if (this.tracer.debug) {
            this.tracer.log("ASM Model '" + this.namespace + "': Adding operation '" + (Object)((Object)operation) + "'", Tracer.Level.DEBUG);
        }
        if (!operation.getInMessage().getNamespace().equals(this.messagesModel.getNamespace())) {
            operation.setHandlerName(operation.getInMessage().getNamespace().replace('.', '_') + "_" + operation.getHandlerName());
        }
        this.operations.add(operation);
    }

    public final List<AdmMessage> resolveMessage(String name) {
        AdmMessage message;
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (this.tracer.debug) {
            this.tracer.log("ASM Model '" + this.namespace + "': Resolving message '" + name + "'...", Tracer.Level.DEBUG);
        }
        ArrayList<AdmMessage> resolvedMessages = new ArrayList<AdmMessage>();
        String namespace = this.namespaceFromFullName(name);
        name = this.nameFromFullName(name);
        if (this.tracer.debug) {
            this.tracer.log("ASM Model '" + this.namespace + "': ...namespace=" + namespace + ", name=" + name, Tracer.Level.DEBUG);
        }
        if ((message = this.messagesModel.getMessage(name)) != null && (namespace == null || namespace.equals(message.getNamespace()))) {
            if (this.tracer.debug) {
                this.tracer.log("ASM Model '" + this.namespace + "': ...found in generating service's message model", Tracer.Level.DEBUG);
            }
            resolvedMessages.add(message);
        }
        for (AsmModel model : this.peers) {
            message = model.getMessagesModel().getMessage(name);
            if (message == null || namespace != null && !namespace.equals(message.getNamespace())) continue;
            if (this.tracer.debug) {
                this.tracer.log("ASM Model '" + this.namespace + "': ...found in peer service '" + model.getNamespace() + "' message model", Tracer.Level.DEBUG);
            }
            resolvedMessages.add(message);
        }
        return resolvedMessages;
    }

    public final void dump() {
        System.out.println(this.getNamespace() + " {");
        System.out.println("   Messages {");
        System.out.println("   ...model [type=" + this.messagesModel.getNamespace() + "]");
        System.out.println("   }");
        System.out.println("");
        System.out.println("   State {");
        System.out.println("   ...model [type=" + this.stateModel.getNamespace() + "]");
        System.out.println("   ...root  [type=" + this.stateRoot.getFullName() + "]");
        System.out.println("   }");
        System.out.println("");
        System.out.println("   Modules {");
        for (AsmModule module : this.modules) {
            System.out.println("   ..." + module.getClassName());
        }
        System.out.println("   }");
        System.out.println("");
        System.out.println("   Peers {");
        for (AsmModel asmModel : this.peers) {
            System.out.println("   ..." + asmModel.getNamespace());
        }
        System.out.println("   }");
        System.out.println("");
        System.out.println("   Streaming Peers {");
        for (AsmStreamingPeer streamingPeer : this.streamingPeers) {
            System.out.println("   ..." + streamingPeer.getMessagesModel().getNamespace());
            System.out.println("   ...Channels {");
            for (AsmStreamingPeer.Channel channel : streamingPeer.getChannels().values()) {
                System.out.println("   ...channel [name=" + channel.getName() + ", key=" + channel.getKey() + ", filter=" + channel.getFilter() + "]");
            }
            System.out.println("   ...}");
            System.out.println("   ...Messages {");
            for (AsmStreamingPeer.Message message : streamingPeer.getMessages()) {
                AsmStreamingPeer.Channel channel = message.getChannel();
                System.out.println("   ...message [name=" + message.getName() + ", channel=" + channel.getName() + ", key=" + channel.getKey() + ", filter=" + channel.getFilter() + "]");
            }
            System.out.println("   ...}");
        }
        System.out.println("   }");
        System.out.println("");
        System.out.println("   Operations {");
        for (AsmOperation operation : this.operations) {
            System.out.println("   ..." + operation.getName() + " {");
            System.out.println("   ......type=" + (Object)((Object)operation.getType()));
            System.out.println("   ......inMessage  [type=" + operation.getInMessage().getFullName() + "]");
            System.out.println("   ......outMessage [type=" + operation.getOutMessage().getFullName() + "]");
            System.out.println("   ......eventMessages {");
            for (AdmMessage eventMessage : operation.getEventMessages()) {
                System.out.println("   .........type=" + eventMessage.getFullName());
            }
            System.out.println("   ......}");
            System.out.println("   ......handler=" + operation.getHandlerName());
            System.out.println("   ...}");
        }
        System.out.println("   }");
        System.out.println("");
        System.out.println("}");
        System.out.println("");
    }
}

