/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.webservice.resources;

import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.neeve.service.AbstractClient;
import com.neeve.service.EServiceException;
import com.neeve.service.messages.Credentials;
import com.neeve.service.messages.PingRequest;
import com.sun.jersey.spi.resource.Singleton;
import io.swagger.jaxrs.config.BeanConfig;
import java.io.IOException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

public abstract class AbstractWebApp
extends Application {
    protected final ObjectMapper _mapper = new ObjectMapper();
    protected final AbstractClient _client;

    public AbstractWebApp(int port) {
        this._mapper.configure(MapperFeature.USE_ANNOTATIONS, true).configure(MapperFeature.AUTO_DETECT_GETTERS, false).configure(MapperFeature.AUTO_DETECT_IS_GETTERS, false).configure(MapperFeature.AUTO_DETECT_FIELDS, false).configure(MapperFeature.AUTO_DETECT_SETTERS, false).configure(MapperFeature.AUTO_DETECT_CREATORS, false).configure(MapperFeature.USE_GETTERS_AS_SETTERS, true).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        Credentials credentials = Credentials.create();
        credentials.setUsername("anything");
        credentials.setPassword("doesntmatterfornow");
        this._client = this.doCreateClient();
        this._client.open(credentials);
        BeanConfig beanConfig = new BeanConfig();
        beanConfig.setVersion("1.0.2");
        beanConfig.setSchemes(new String[]{"http"});
        beanConfig.setBasePath("/");
        beanConfig.setResourcePackage(((Object)((Object)this)).getClass().getPackage().getName());
        beanConfig.setScan(true);
    }

    protected abstract AbstractClient doCreateClient();

    @GET
    @Path(value="/ping")
    @Produces(value={"application/json"})
    public String ping() throws IOException {
        return this._mapper.writeValueAsString((Object)this._client.ping(PingRequest.create()));
    }

    @Provider
    @Singleton
    public static final class RuntimeExceptionMapper
    implements ExceptionMapper<RuntimeException> {
        public Response toResponse(RuntimeException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).type("text/plain").build();
        }
    }

    @Provider
    @Singleton
    public static final class ServiceExceptionMapper
    implements ExceptionMapper<EServiceException> {
        public Response toResponse(EServiceException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).type("text/plain").build();
        }
    }
}

