/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.webservice;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import com.neeve.aep.AepEngine;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.event.AepEngineStartedEvent;
import com.neeve.aep.event.AepEngineStoppedEvent;
import com.neeve.aep.event.AepMessagingPrestartEvent;
import com.neeve.ci.XRuntime;
import com.neeve.root.RootConfig;
import com.neeve.server.app.SrvAppLoader;
import com.neeve.server.app.annotations.AppInjectionPoint;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlThrowable;
import com.neeve.webservice.HttpServer;
import java.lang.annotation.Annotation;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class AbstractApp
extends AbstractModule {
    private final String _coreAppName;
    private final String _appName;
    private final String _appNameForConfig;
    private final int _appPart;
    private final String _webAppName;
    private final String _agentName;
    @Inject
    protected Tracer _tracer;
    @Inject
    protected HttpServer _httpServer;
    protected final Tracer TRACER;
    protected AepEngine _engine;
    protected Injector _injector;
    private final int _port;
    public static final int DEFAULT_PORT = 7778;

    protected AbstractApp(String coreAppName, String appName, String appNameForConfig, int appPart) {
        this._coreAppName = coreAppName;
        this._appName = appName;
        this._appNameForConfig = appNameForConfig;
        this._appPart = appPart;
        this._webAppName = this._appName + "web";
        this._agentName = this._webAppName + "-" + this._appPart;
        this._port = XRuntime.getValue((String)this.toConfigParam("http.port"), (int)7778);
        this.TRACER = RootConfig.ObjectConfig.createTracer((RootConfig.ObjectConfig)RootConfig.ObjectConfig.get((String)(this._appNameForConfig + ".webservice")));
    }

    private final String toConfigParam(String str) {
        return this._appNameForConfig + "." + str;
    }

    @Provides
    private final Tracer providesTracer() {
        return this.TRACER;
    }

    protected abstract void doAddGuiceModules(Set<AbstractModule> var1);

    protected final void addAppGuiceModule(String moduleClassName, Set<AbstractModule> modules) {
        try {
            modules.add((AbstractModule)Class.forName(moduleClassName).newInstance());
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    @AppInjectionPoint
    public final void setAppEngine(AepEngine engine) throws Exception {
        this._engine = engine;
    }

    @EventHandler
    public final void onEngineStarted(AepEngineStartedEvent event) {
        this._tracer.log("The " + this._agentName + " web service has started.", Tracer.Level.INFO);
    }

    @EventHandler
    public final void onMessagingPrestart(AepMessagingPrestartEvent event) {
        this._tracer.log("The " + this._agentName + " web service has activated.", Tracer.Level.INFO);
        try {
            this._httpServer.start(this._injector, this._coreAppName + "/webapp/", ((Object)((Object)this)).getClass().getPackage().getName());
            this._tracer.log("The service doc and endpoints can be accessed at - " + this._httpServer.getServerUrl() + "/doc/" + this._coreAppName + ".html", Tracer.Level.INFO);
        }
        catch (Exception e) {
            this._tracer.log(UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.SEVERE);
            this._engine.stop(e);
        }
    }

    @EventHandler
    public final void onEngineStopped(AepEngineStoppedEvent event) {
        this._httpServer.stop();
        this._tracer.log("The " + this._agentName + " web service has stopped (cause=" + event.getCause() + ").", Tracer.Level.INFO);
    }

    protected void configure() {
        this.bind(Integer.class).annotatedWith((Annotation)Names.named((String)"nv.webservice.http.port")).toInstance((Object)this._port);
    }

    @AppInjectionPoint
    public final void setAppLoader(SrvAppLoader loader) throws Exception {
        LinkedHashSet<AbstractModule> modules = new LinkedHashSet<AbstractModule>();
        modules.add(this);
        this.doAddGuiceModules(modules);
        this._injector = Guice.createInjector(modules);
        this._injector.injectMembers((Object)this);
    }
}

