/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.service.db.alert;

import com.neeve.service.cdc.DbEntityPersister;
import com.neeve.service.cdc.DbPersister;
import com.neeve.service.messages.Alert;
import com.neeve.service.messages.AlertSeverity;
import java.util.concurrent.TimeUnit;
import org.influxdb.dto.Point;

public final class AlertPersister
extends DbEntityPersister {
    public AlertPersister(DbPersister persister) {
        super(persister);
    }

    private final int alertImpact(AlertSeverity severity) {
        switch (severity) {
            case Info: 
            case Warning: 
            case Severe: {
                return severity.val;
            }
        }
        return AlertSeverity.Severe.val + 1;
    }

    private final int alertImpact(Alert alert) {
        return this.alertImpact(alert.getSeverity());
    }

    public final void insert(Alert alert) throws Exception {
        if (alert != null) {
            this.write(Point.measurement((String)"alert").time(alert.getTimestamp().getTime(), TimeUnit.MILLISECONDS).tag("agent_name", this._persister.getAgentName()).tag("vm_name", this._persister.getServerName()).tag("severity", alert.getSeverity().toString()).addField("classifier", this.quote(alert.getClassifier())).addField("description", this.quote(alert.getDesc())).addField("stack_trace", this.quote(alert.getStackTrace())).addField("value", (double)(this.alertImpact(alert) * 5)).build());
        }
    }
}

