/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.service;

import com.eaio.uuid.UUID;
import com.neeve.aep.AepEngine;
import com.neeve.aep.AepEngineDescriptor;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.event.AepChannelDownEvent;
import com.neeve.aep.event.AepChannelUpEvent;
import com.neeve.aep.event.AepEngineStoppedEvent;
import com.neeve.aep.event.AepMessagingStartedEvent;
import com.neeve.ci.XRuntime;
import com.neeve.event.Event;
import com.neeve.event.IEventHandler;
import com.neeve.rog.IRogCopyableNode;
import com.neeve.rog.IRogMessage;
import com.neeve.service.AbstractApp;
import com.neeve.service.EServiceException;
import com.neeve.service.EmbeddedServerController;
import com.neeve.service.entities.EntityFactory;
import com.neeve.service.entities.ErrorCode;
import com.neeve.service.entities.ErrorType;
import com.neeve.service.entities.MessageProcessingTime;
import com.neeve.service.messages.AgentInfo;
import com.neeve.service.messages.AgentStartedEvent;
import com.neeve.service.messages.AlertRequest;
import com.neeve.service.messages.AlertSeverity;
import com.neeve.service.messages.Credentials;
import com.neeve.service.messages.ErrorContext;
import com.neeve.service.messages.Heartbeat;
import com.neeve.service.messages.HeartbeatRequest;
import com.neeve.service.messages.LogoutRequest;
import com.neeve.service.messages.LogoutResponse;
import com.neeve.service.messages.MessageFactory;
import com.neeve.service.messages.MessageHeader;
import com.neeve.service.messages.PingRequest;
import com.neeve.service.messages.PingResponse;
import com.neeve.service.messages.PostMessageProcessingTimesRequest;
import com.neeve.service.messages.Version;
import com.neeve.sma.CopyableMessageView;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.MessageView;
import com.neeve.sma.SmaException;
import com.neeve.sma.event.MessageBusBindingFailedEvent;
import com.neeve.sma.event.MessageEvent;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlThrowable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public abstract class AbstractClient {
    private final String _name;
    private final String _appName;
    private final String _appNameForConfig;
    private final int _appVersionMajor;
    private final int _appVersionMinor;
    private final String _sourceId;
    private final HashMap<String, RequestReplyTableEntry> _rrTable;
    private final int _numPartitions;
    private final ThreadLocal<String> _transactionId;
    private final Random _random;
    private final Object _userHandlers;
    private final ScheduledThreadPoolExecutor _mptPostExecutor;
    private final List<MessageProcessingTime> _mptToPost;
    private final Communicator _communicator;
    final IServerMonitor _serverMonitor;
    private final boolean _useHeartbeatsToTrackServers;
    private static final HashMap<String, Object> _embeddedServerLaunchSynchronizer = new HashMap();
    private static final HashMap<String, Integer> _serverLaunchCount = new HashMap();
    private int _responseTimeout;
    private boolean _listenForEvents;
    private boolean _listenForHeartbeats;
    private boolean _listenForAlerts;
    private Credentials _credentials;
    private String _sessionId;
    private volatile MessageChannel _requests;
    private boolean _messagingStarted;
    private Properties _krt;
    protected boolean _serverLaunched;

    protected AbstractClient(String name, String appName, String appNameForConfig, int appVersionMajor, int appVersionMinor, Object handlers, Credentials credentials) {
        this._name = name == null ? new UUID().toString() : name;
        this._appName = appName;
        this._appNameForConfig = appNameForConfig;
        this._appVersionMajor = appVersionMajor;
        this._appVersionMinor = appVersionMinor;
        this._sourceId = this._name + "-" + XRuntime.getValue((String)this.toConfigParam("client.instanceid"), (String)new UUID().toString());
        this._rrTable = new HashMap();
        this._responseTimeout = Math.max(1, XRuntime.getValue((String)this.toConfigParam("client.responsetimeout"), (int)60));
        this._numPartitions = Math.max(1, XRuntime.getValue((String)this.toConfigParam("numpartitions"), (int)1));
        this._transactionId = new ThreadLocal();
        this._random = new Random(System.currentTimeMillis());
        this._userHandlers = handlers;
        boolean enableMptPosts = XRuntime.getValue((String)this.toConfigParam("client.mptsend.enable"), (boolean)true);
        this._mptPostExecutor = enableMptPosts ? new ScheduledThreadPoolExecutor(1, new MptPostExecutorThreadFactory()) : null;
        if (this._mptPostExecutor != null) {
            this._mptPostExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        }
        this._mptToPost = new ArrayList<MessageProcessingTime>();
        this._useHeartbeatsToTrackServers = XRuntime.getValue((String)this.toConfigParam("client.servertracking.enable"), (boolean)true);
        this._serverMonitor = this._useHeartbeatsToTrackServers ? new HeartbeatsServerMonitor() : new NumPartitionsServerMonitor();
        this._listenForEvents = XRuntime.getValue((String)this.toConfigParam("client.listenforevents"), (boolean)true);
        this._listenForHeartbeats = this._useHeartbeatsToTrackServers ? true : UtlProps.getValue((Properties)XRuntime.getProps(), (String)this.toConfigParam("client.listenforheartbeats"), (boolean)false);
        this._listenForAlerts = XRuntime.getValue((String)this.toConfigParam("client.listenforalerts"), (boolean)true);
        this._credentials = credentials;
        this._krt = new Properties();
        this._krt.setProperty("app", this._appName);
        this._communicator = new Communicator();
    }

    private final String toConfigParam(String str) {
        return this._appNameForConfig + "." + str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object getEmbeddedServerLaunchSynchronizer() {
        HashMap<String, Object> hashMap = _embeddedServerLaunchSynchronizer;
        synchronized (hashMap) {
            Object val = _embeddedServerLaunchSynchronizer.get(this.getClass().getName());
            if (val == null) {
                val = new Object();
                _embeddedServerLaunchSynchronizer.put(this.getClass().getName(), val);
            }
            return val;
        }
    }

    private final int getServerLaunchCount() {
        Integer val = _serverLaunchCount.get(this.getClass().getName());
        return val == null ? 0 : val;
    }

    private final int updateServerLaunchCount(int change) {
        int newVal = this.getServerLaunchCount() + change;
        _serverLaunchCount.put(this.getClass().getName(), newVal);
        return newVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doOpen(Credentials credentials, AepEngine engine) throws EServiceException {
        block20: {
            try {
                boolean embeddedLaunch;
                this._credentials = credentials;
                String loopbackUrl = "loopback://eagle";
                String url = XRuntime.getValue((String)this.toConfigParam("url"), (String)"loopback://eagle");
                boolean bl = embeddedLaunch = url.startsWith("loopback://") && XRuntime.getValue((String)this.toConfigParam("client.serverlaunch"), (boolean)true);
                if (embeddedLaunch && !url.equals("loopback://eagle")) {
                    throw new IllegalArgumentException("Illegal loopback bus name (exp=loopback://eagle, actual=" + url + ") for embedded server launch");
                }
                if (engine == null) {
                    this._communicator.open(url);
                    this._communicator.start();
                    Object object = this.getEmbeddedServerLaunchSynchronizer();
                    synchronized (object) {
                        if (embeddedLaunch) {
                            if (this.getServerLaunchCount() == 0) {
                                this.doGetEmbeddedServerController().start();
                                if (!this._communicator.waitForServiceLaunch()) {
                                    this.close();
                                    throw new EServiceException(ErrorType.System, ErrorCode.ServerLaunchTimedOut, "Server launch not complete within configured time", null);
                                }
                            }
                            this.updateServerLaunchCount(1);
                            this._serverLaunched = true;
                        }
                        break block20;
                    }
                }
                this._communicator.open(engine);
            }
            catch (Exception e) {
                if (e instanceof EServiceException) {
                    throw (EServiceException)e;
                }
                throw new EServiceException(e);
            }
        }
        if (this._mptPostExecutor != null) {
            int interval = XRuntime.getValue((String)this.toConfigParam("client.mptpost.interval"), (int)30);
            this._mptPostExecutor.scheduleWithFixedDelay(new MptPostExecutor(), interval, interval, TimeUnit.SECONDS);
        }
        if (this._useHeartbeatsToTrackServers) {
            for (int i = 1; i <= this._numPartitions; ++i) {
                this.solicitHeartbeat(i);
            }
            IServerMonitor iServerMonitor = this._serverMonitor;
            synchronized (iServerMonitor) {
                if (this._serverMonitor.getNumPartitions() <= 0) {
                    try {
                        int waittime = XRuntime.getValue((String)this.toConfigParam("client.firstheartbeat.waittime"), (int)5000);
                        this._serverMonitor.wait(waittime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private final ErrorContext createError(ErrorType type, ErrorCode code, String desc, String ext) {
        ErrorContext error = ErrorContext.create();
        error.setType(type);
        error.setCode(code);
        error.setDescription(desc);
        error.setExtInfo(ext);
        return error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void dispatchReplies(Exception e) {
        HashMap<String, RequestReplyTableEntry> hashMap = this._rrTable;
        synchronized (hashMap) {
            for (RequestReplyTableEntry rrEntry : this._rrTable.values()) {
                rrEntry.replyReceived = true;
                rrEntry.header.setError(this.createError(ErrorType.System, ErrorCode.SystemError, e.toString(), null));
            }
            this._rrTable.clear();
            this._rrTable.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void recordTransactionLegTime(String transactionId, String legName, int procTime) {
        MessageProcessingTime mpt = MessageProcessingTime.create();
        mpt.setTimestamp(System.currentTimeMillis());
        mpt.setTxnId(transactionId);
        mpt.setAgentName(this._communicator.getAgentName());
        mpt.setLegName(legName);
        mpt.setQueueTime(0);
        mpt.setProcTime(procTime);
        List<MessageProcessingTime> list = this._mptToPost;
        synchronized (list) {
            this._mptToPost.add(mpt);
        }
    }

    private final void solicitHeartbeat(int partition) throws EServiceException {
        HeartbeatRequest request = HeartbeatRequest.create();
        MessageHeader header = MessageHeader.create();
        this.prepareMessageHeader(header, true, false);
        request.setHeader(header);
        this._communicator.sendRequest(header, request, partition, false);
    }

    private final void sendAlert(AlertRequest request, boolean relogin) throws EServiceException {
        MessageHeader header = request.getHeader() != null ? request.getHeader() : MessageHeader.create();
        this.prepareMessageHeader(header, relogin, false);
        request.setHeader((MessageHeader)header.clone());
        this._communicator.sendRequest(header, request, 0);
    }

    private final void postMessageProcessingTimes(PostMessageProcessingTimesRequest request) throws EServiceException {
        MessageHeader header = request.getHeader() != null ? request.getHeader() : MessageHeader.create();
        this.prepareMessageHeader(header, false, false);
        request.setHeader((MessageHeader)header.clone());
        this._communicator.sendRequest(header, request, 0);
    }

    private final void logout(int partition) throws EServiceException {
        block2: {
            try {
                this.sendRequest(MessageHeader.create(), (IRogMessage)LogoutRequest.create(), partition, false, new Integer[0]);
            }
            catch (EServiceException e) {
                if (e.getErrorCode() == ErrorCode.InvalidSession) break block2;
                throw e;
            }
        }
    }

    private final void logout() throws EServiceException {
        if (this._sessionId != null) {
            try {
                for (int i = 1; i <= this._numPartitions; ++i) {
                    this.logout(i);
                }
            }
            finally {
                this._sessionId = null;
            }
        }
    }

    private final MessageHeader getResponseHeader(MessageView message) {
        switch (message.getVfid()) {
            case 132: {
                switch (message.getType()) {
                    case 4: {
                        return ((PingResponse)message).getHeader();
                    }
                    case 10: {
                        return ((LogoutResponse)message).getHeader();
                    }
                }
                return null;
            }
        }
        return this.doGetResponseHeader(message);
    }

    private final IRogMessage setRequestHeader(IRogMessage request, MessageHeader header) {
        switch (request.getVfid()) {
            case 132: {
                switch (request.getType()) {
                    case 3: {
                        ((PingRequest)request).setHeader(header);
                        break;
                    }
                    case 9: {
                        ((LogoutRequest)request).setHeader(header);
                    }
                }
                return request;
            }
        }
        return this.doSetRequestHeader(request, header);
    }

    private final void onMessage(MessageView view) {
        if (!(view instanceof CopyableMessageView)) {
            throw new IllegalArgumentException("inbound messages to client must be copyable");
        }
        view = ((CopyableMessageView)view).copy();
        this.onReply(this.getResponseHeader(view), view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RequestReplyTableEntry prepareMessageHeader(MessageHeader header, boolean relogin, boolean requestReply) {
        header.setSourceId(this._sourceId);
        header.setSessionId(this._sessionId);
        if (this._sessionId == null || relogin) {
            header.setCredentials(this._credentials);
        }
        String requestId = new UUID().toString();
        String transactionId = this._transactionId.get();
        header.setTransactionId(transactionId == null ? requestId : transactionId);
        Version version = Version.create();
        version.setMajorVersion(this._appVersionMajor);
        version.setMinorVersion(this._appVersionMinor);
        header.setSenderVersion(version);
        header.setError(null);
        if (requestReply) {
            header.setRequestId(requestId);
            RequestReplyTableEntry rrEntry = new RequestReplyTableEntry(header);
            HashMap<String, RequestReplyTableEntry> hashMap = this._rrTable;
            synchronized (hashMap) {
                this._rrTable.put(requestId, rrEntry);
            }
            return rrEntry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onReply(MessageHeader header, Object reply) {
        if (header != null && header.getSourceId().equals(this._sourceId)) {
            HashMap<String, RequestReplyTableEntry> hashMap = this._rrTable;
            synchronized (hashMap) {
                RequestReplyTableEntry rrEntry = this._rrTable.remove(header.getRequestId());
                if (rrEntry != null) {
                    rrEntry.replyReceived = true;
                    ErrorContext error = header.getError();
                    if (error == null) {
                        rrEntry.sessionId = header.getSessionId();
                        rrEntry.reply = reply;
                    } else {
                        rrEntry.header.setError(this.createError(error.getType(), error.getCode(), error.getDescription(), error.getExtInfo()));
                    }
                    this._rrTable.notifyAll();
                }
            }
        }
    }

    private final <T> T waitForReply(RequestReplyTableEntry rrEntry, Integer ... timeout) {
        HashMap<String, RequestReplyTableEntry> hashMap = this._rrTable;
        synchronized (hashMap) {
            long remainingTime;
            long expiryTime = System.currentTimeMillis() + (long)((timeout.length > 0 ? timeout[0] : this._responseTimeout) * 1000);
            while (!rrEntry.replyReceived && (remainingTime = Math.max(0L, expiryTime - System.currentTimeMillis())) > 0L) {
                try {
                    this._rrTable.wait(remainingTime);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (rrEntry.replyReceived) {
                MessageHeader header = rrEntry.header;
                ErrorContext error = header.getError();
                if (error == null) {
                    this._sessionId = rrEntry.sessionId;
                    return (T)rrEntry.reply;
                }
                throw new EServiceException(error.getType(), error.getCode(), error.getDescription(), error.getExtInfo());
            }
            throw new EServiceException(ErrorType.System, ErrorCode.RequestTimedOut, "Request timed out", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T sendRequest(MessageHeader header, IRogMessage message, int partition, boolean relogin, boolean waitForReply, Integer ... timeout) {
        if (!this._communicator.open()) {
            this.open();
        }
        int procTime = -1;
        try {
            long ts = System.nanoTime();
            RequestReplyTableEntry rrEntry = this.prepareMessageHeader(header, relogin, waitForReply);
            this.setRequestHeader(message, header);
            this._communicator.sendRequest(header, message, partition);
            T response = waitForReply ? (T)this.waitForReply(rrEntry, timeout) : null;
            procTime = (int)((System.nanoTime() - ts) / 1000L);
            T t = response;
            return t;
        }
        finally {
            if (waitForReply) {
                this.recordTransactionLegTime(header.getTransactionId(), message.getClass().getSimpleName(), procTime);
            }
        }
    }

    final Communicator getCommunicator() {
        return this._communicator;
    }

    protected abstract void doRegisterFactories(AepEngine var1);

    protected abstract EmbeddedServerController doGetEmbeddedServerController();

    protected abstract IRogMessage doSetRequestHeader(IRogMessage var1, MessageHeader var2);

    protected abstract MessageHeader doGetResponseHeader(MessageView var1);

    protected void validateRequest(IRogMessage request) {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
    }

    protected final <T> T sendRequest(MessageHeader header, IRogMessage request, int partition, boolean waitForReply, Integer ... timeout) {
        header = header != null ? header : MessageHeader.create();
        try {
            return this.sendRequest(header, request, partition, false, waitForReply, timeout);
        }
        catch (EServiceException e) {
            if (e.getErrorCode() == ErrorCode.InvalidSession) {
                return this.sendRequest((MessageHeader)header.clone(), (IRogMessage)((IRogCopyableNode)request).copy(), partition, true, waitForReply, timeout);
            }
            throw e;
        }
    }

    protected final <T> T sendRequestAndWaitForReply(MessageHeader header, IRogMessage request, int partition, Integer ... timeout) {
        return this.sendRequest(header, request, partition, true, timeout);
    }

    protected final void sendRequest(MessageHeader header, IRogMessage request, int partition) {
        this.sendRequest(header, request, partition, false, new Integer[0]);
    }

    @EventHandler(source="requests@*")
    public final void onRequestsChannelUp(AepChannelUpEvent event) {
        this._requests = event.getMessageChannel();
    }

    @EventHandler(source="requests@*")
    public final void onRequestsChannelDown(AepChannelDownEvent event) {
        this._requests = null;
    }

    @EventHandler
    public final void onBindingFailed(MessageBusBindingFailedEvent event) {
        this.dispatchReplies(event.getCause());
    }

    @EventHandler
    public final void onMessagingStarted(AepMessagingStartedEvent event) {
        if (event.getStatus() == null) {
            this._messagingStarted = true;
        }
    }

    @EventHandler
    public final void onEngineStopped(AepEngineStoppedEvent event) {
        this.dispatchReplies(new Exception("client has closed"));
    }

    @EventHandler
    public final void onHeartbeat(Heartbeat heartbeat) {
        this._serverMonitor.onHeartbeat(heartbeat);
    }

    public final void setResponseTimeout(int timeout) {
        if (timeout <= 0) {
            throw new IllegalArgumentException("timeout must be > 0");
        }
        this._responseTimeout = timeout;
    }

    public final AbstractClient listenForEvents(boolean val) {
        this._listenForEvents = val;
        return this;
    }

    public final AbstractClient listenForHeartbeats(boolean val) {
        if (!this._useHeartbeatsToTrackServers) {
            this._listenForHeartbeats = val;
        } else if (!this._listenForHeartbeats) {
            throw new IllegalArgumentException("cannot turn off listing to heartbeats when server tracking is enabled");
        }
        return this;
    }

    public final AbstractClient listenForAlerts(boolean val) {
        this._listenForAlerts = val;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void open(Credentials credentials, AepEngine engine) throws EServiceException {
        if (credentials == null) {
            throw new IllegalArgumentException("credentials are required to open the client");
        }
        AbstractClient abstractClient = this;
        synchronized (abstractClient) {
            if (!this._communicator.open()) {
                this.doOpen(credentials, engine);
            }
        }
    }

    public final void open(AepEngine engine) throws EServiceException {
        this.open(this._credentials, engine);
    }

    public final void open(Credentials credentials) throws EServiceException {
        this.open(credentials, null);
    }

    public final void open() throws EServiceException {
        this.open(this._credentials);
    }

    public final String getName() {
        return this._name;
    }

    public final String getSourceId() {
        return this._sourceId;
    }

    public final void setTransactionId(String id) {
        this._transactionId.set(id);
    }

    public final String getTransactionId() {
        return this._transactionId.get();
    }

    public final void recordTransactionLegTime(String legName, int procTime) {
        String transactionId = this.getTransactionId();
        if (transactionId == null) {
            transactionId = new UUID().toString();
        }
        this.recordTransactionLegTime(transactionId, legName, procTime);
    }

    public final PingResponse ping(PingRequest request) throws EServiceException {
        this.validateRequest(request);
        return (PingResponse)this.sendRequestAndWaitForReply(request.getHeader(), request, 0, new Integer[0]);
    }

    public final void sendAlert(AlertRequest request) throws EServiceException {
        this.validateRequest(request);
        if (this._communicator.open()) {
            this.sendAlert(request, false);
        }
    }

    public void sendAlert(String headline, String desc, Throwable e, AlertSeverity severity) {
        if (this._communicator.open()) {
            AlertRequest request = MessageFactory.createAlertRequest();
            AgentInfo agentInfo = AgentInfo.create();
            agentInfo.setApplicationName(this._communicator.getAgentName());
            agentInfo.setApplicationPartition(1);
            agentInfo.setPid(XRuntime.getPid());
            agentInfo.setStartTime(new Date());
            request.setAgentInfo(agentInfo);
            request.setHeadline(headline);
            request.setDesc(desc);
            request.setStackTrace(e != null ? UtlThrowable.prepareStackTrace((Throwable)e) : null);
            request.setSeverity(severity);
            this.sendAlert(request);
        }
    }

    public void sendAlert(String desc, Throwable e, AlertSeverity severity) {
        this.sendAlert(null, desc, e, severity);
    }

    public final void close() {
        try {
            if (this._mptPostExecutor != null) {
                this._mptPostExecutor.shutdown();
            }
            this.logout();
            this._communicator.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    protected final class Communicator {
        private final String _agentName;
        private AepEngine _engine;
        private boolean _externalEngine;
        private boolean _serviceAgentStarted;
        private final long SERVICE_LAUNCH_TIMEOUT;

        Communicator() {
            this.SERVICE_LAUNCH_TIMEOUT = XRuntime.getValue((String)AbstractClient.this.toConfigParam("client.serverlaunch.timeout"), (int)30);
            String qualifier = UtlProps.getValue((Properties)XRuntime.getProps(), (String)AbstractClient.this.toConfigParam("client.namequalifier"), null);
            this._agentName = AbstractClient.this._appName + "-client-" + AbstractClient.this._name + (qualifier == null ? "" : "-" + qualifier);
        }

        final boolean open() {
            return this._engine != null;
        }

        final void open(String url) throws Exception {
            if (this.open()) {
                throw new IllegalStateException("already initialized");
            }
            MessageBusDescriptor busDescriptor = AbstractApp.checkAndCreateAbstractBusDescriptor(AbstractClient.this._appName, url);
            MessageChannelDescriptor responsesChannelDescriptor = busDescriptor.getChannel("responses");
            responsesChannelDescriptor.setChannelFilter("app=" + AbstractClient.this._appName + ";source=" + AbstractClient.this._sourceId);
            MessageChannelDescriptor eventsChannelDescriptor = busDescriptor.getChannel("events");
            eventsChannelDescriptor.setChannelFilter("app=" + AbstractClient.this._appName);
            MessageChannelDescriptor heartbeatsChannelDescriptor = busDescriptor.getChannel("heartbeats");
            heartbeatsChannelDescriptor.setChannelFilter("app=" + AbstractClient.this._appName);
            MessageChannelDescriptor alertsChannelDescriptor = busDescriptor.getChannel("alerts");
            alertsChannelDescriptor.setChannelFilter("app=" + AbstractClient.this._appName);
            busDescriptor.save(this._agentName);
            AepEngineDescriptor engineDescriptor = AepEngineDescriptor.create((String)this._agentName);
            engineDescriptor.addChannel(AbstractClient.this._appName, "requests", AepEngineDescriptor.ChannelConfig.from((String)"join=false"));
            engineDescriptor.addChannel(AbstractClient.this._appName, "responses", AepEngineDescriptor.ChannelConfig.from((String)"join=true"));
            engineDescriptor.addChannel(AbstractClient.this._appName, "events", AepEngineDescriptor.ChannelConfig.from((String)("join=" + AbstractClient.this._listenForEvents)));
            engineDescriptor.addChannel(AbstractClient.this._appName, "heartbeats", AepEngineDescriptor.ChannelConfig.from((String)("join=" + AbstractClient.this._listenForHeartbeats)));
            engineDescriptor.addChannel(AbstractClient.this._appName, "alerts", AepEngineDescriptor.ChannelConfig.from((String)("join=" + AbstractClient.this._listenForAlerts)));
            engineDescriptor.setMessagingStartFailPolicy(AepEngine.MessagingStartFailPolicy.FailIfOneBindingFails);
            engineDescriptor.setMessageBusBindingFailPolicy(AepEngine.MessageBusBindingFailPolicy.Reconnect);
            engineDescriptor.setPerformDuplicateChecking(false);
            engineDescriptor.setSetInboundMessagesAsReadOnly(false);
            engineDescriptor.setSetOutboundMessagesAsReadOnly(false);
            HashSet<Object> objects = new HashSet<Object>();
            EventHandlers handlers = new EventHandlers();
            objects.add(handlers);
            objects.add(AbstractClient.this);
            if (AbstractClient.this._userHandlers != null) {
                objects.add(AbstractClient.this._userHandlers);
            }
            this._engine = AepEngine.create((AepEngineDescriptor)engineDescriptor, null, objects, (IEventHandler)handlers, null);
            this._externalEngine = false;
            this._engine.registerFactory((Object)new EntityFactory());
            this._engine.registerFactory((Object)new MessageFactory());
            AbstractClient.this.doRegisterFactories(this._engine);
        }

        final void open(AepEngine engine) {
            if (this.open()) {
                throw new IllegalStateException("already initialized");
            }
            this._engine = engine;
            this._externalEngine = true;
        }

        final String getAgentName() {
            return this._agentName;
        }

        final void start() throws Exception {
            if (!this._externalEngine) {
                this._engine.start();
                this._engine.waitForMessagingToStart();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean waitForServiceLaunch() {
            Communicator communicator = this;
            synchronized (communicator) {
                long start = System.currentTimeMillis();
                while (!this._serviceAgentStarted) {
                    long remaining = this.SERVICE_LAUNCH_TIMEOUT * 1000L - (System.currentTimeMillis() - start);
                    if (remaining > 0L) {
                        try {
                            this.wait(remaining);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    return false;
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void sendRequest(MessageHeader header, IRogMessage message, int partition, boolean validatePartition) throws EServiceException {
            Communicator communicator = this;
            synchronized (communicator) {
                MessageChannel channel = AbstractClient.this._requests;
                if (channel != null && AbstractClient.this._messagingStarted) {
                    try {
                        AbstractClient.this._krt.setProperty("partition", String.valueOf(validatePartition ? AbstractClient.this._serverMonitor.validatePartition(partition) : partition));
                        channel.setKeyResolutionTable(AbstractClient.this._krt);
                        message.setMessageKey(null);
                        this._engine.sendMessage(channel, message);
                        channel.getMessageBusBinding().flush(null);
                    }
                    catch (SmaException e) {
                        header.setError(AbstractClient.this.createError(ErrorType.System, ErrorCode.CommunicationError, e.getMessage(), UtlThrowable.prepareStackTrace((Throwable)e)));
                        AbstractClient.this.onReply(header, null);
                    }
                    catch (EServiceException e) {
                        if (e.getErrorType() == ErrorType.System && e.getErrorCode() == ErrorCode.ServerUnavailable) {
                            header.setError(AbstractClient.this.createError(e.getErrorType(), e.getErrorCode(), e.getMessage(), UtlThrowable.prepareStackTrace((Throwable)e)));
                            AbstractClient.this.onReply(header, null);
                        }
                    }
                } else {
                    header.setError(AbstractClient.this.createError(ErrorType.System, ErrorCode.NotConnected, "not connected", null));
                    AbstractClient.this.onReply(header, null);
                }
            }
        }

        public final void sendRequest(MessageHeader header, IRogMessage message, int partition) throws EServiceException {
            this.sendRequest(header, message, partition, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void close() {
            if (!this._externalEngine) {
                this._engine.stop();
            }
            Object object = AbstractClient.this.getEmbeddedServerLaunchSynchronizer();
            synchronized (object) {
                if (AbstractClient.this._serverLaunched) {
                    AbstractClient.this._serverLaunched = false;
                    if (AbstractClient.this.updateServerLaunchCount(-1) == 0) {
                        AbstractClient.this.doGetEmbeddedServerController().stop();
                    }
                }
            }
        }

        public final class EventHandlers
        implements IEventHandler {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @EventHandler
            public final void onServiceAgentStarted(AgentStartedEvent event) {
                Communicator communicator = Communicator.this;
                synchronized (communicator) {
                    Communicator.this._serviceAgentStarted = true;
                    Communicator.this.notifyAll();
                }
            }

            public final void onEvent(Event event) {
                switch (event.getType()) {
                    case 105: {
                        AbstractClient.this.onMessage(((MessageEvent)event).getMessageView());
                    }
                }
            }
        }
    }

    protected final class RequestReplyTableEntry {
        final MessageHeader header;
        boolean replyReceived;
        String sessionId;
        Object reply;

        RequestReplyTableEntry(MessageHeader header) {
            this.header = header;
        }
    }

    private final class HeartbeatsServerMonitor
    implements IServerMonitor {
        private final ConcurrentHashMap<Integer, Server> servers = new ConcurrentHashMap();
        private final int numMissedHeartbeatsAcceptable;
        private final long minHeartbeatsMissedDuration;
        private volatile int[] partitions = new int[0];

        HeartbeatsServerMonitor() {
            this.numMissedHeartbeatsAcceptable = XRuntime.getValue((String)AbstractClient.this.toConfigParam("client.servertracking.maxheartbeatsmissed"), (int)5);
            this.minHeartbeatsMissedDuration = (long)XRuntime.getValue((String)AbstractClient.this.toConfigParam("client.servertracking.minheartbeatsmissedduration"), (int)60) * 1000L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void onHeartbeat(Heartbeat heartbeat) {
            HeartbeatsServerMonitor heartbeatsServerMonitor = this;
            synchronized (heartbeatsServerMonitor) {
                if (heartbeat.getAgentInfo() != null) {
                    int partition = heartbeat.getAgentInfo().getApplicationPartition();
                    Server server = this.servers.get(partition);
                    if (server == null) {
                        server = new Server();
                        this.servers.put(partition, server);
                        int[] newpartitions = Arrays.copyOf(this.partitions, this.partitions.length + 1);
                        newpartitions[newpartitions.length - 1] = partition;
                        this.partitions = newpartitions;
                    }
                    server.onHeartbeat();
                    this.notifyAll();
                }
            }
        }

        @Override
        public final int getNumPartitions() {
            return this.partitions.length;
        }

        final boolean isAlive(int partition) {
            Server server = this.servers.get(partition);
            return server != null ? server.isAlive() : false;
        }

        final int getRandomAlivePartition() {
            int numPartitions = this.partitions.length;
            if (numPartitions > 0) {
                HashSet<Integer> checked = new HashSet<Integer>(numPartitions);
                do {
                    int partition;
                    if (this.isAlive(partition = this.partitions[AbstractClient.this._random.nextInt(numPartitions)])) {
                        return partition;
                    }
                    checked.add(partition);
                } while (checked.size() < numPartitions);
            }
            return -1;
        }

        @Override
        public final int validatePartition(int partition) {
            int checkedPartition;
            int n = partition == 0 ? this.getRandomAlivePartition() : (checkedPartition = this.isAlive(partition) ? partition : -1);
            if (checkedPartition > 0) {
                return checkedPartition;
            }
            throw new EServiceException(ErrorType.System, ErrorCode.ServerUnavailable, "Server currently unavailable", null);
        }

        private final class Server {
            private final List<Long> rcvdTimes;

            private Server() {
                this.rcvdTimes = new ArrayList<Long>(HeartbeatsServerMonitor.this.numMissedHeartbeatsAcceptable + 1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            final void onHeartbeat() {
                List<Long> list = this.rcvdTimes;
                synchronized (list) {
                    if (this.rcvdTimes.size() > HeartbeatsServerMonitor.this.numMissedHeartbeatsAcceptable) {
                        this.rcvdTimes.remove(0);
                    }
                    this.rcvdTimes.add(System.currentTimeMillis());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            final boolean isAlive() {
                List<Long> list = this.rcvdTimes;
                synchronized (list) {
                    return this.rcvdTimes.size() > HeartbeatsServerMonitor.this.numMissedHeartbeatsAcceptable ? System.currentTimeMillis() - this.rcvdTimes.get(HeartbeatsServerMonitor.this.numMissedHeartbeatsAcceptable) < Math.max(HeartbeatsServerMonitor.this.minHeartbeatsMissedDuration, this.rcvdTimes.get(HeartbeatsServerMonitor.this.numMissedHeartbeatsAcceptable) - this.rcvdTimes.get(0)) : true;
                }
            }
        }
    }

    private final class NumPartitionsServerMonitor
    implements IServerMonitor {
        private NumPartitionsServerMonitor() {
        }

        @Override
        public final void onHeartbeat(Heartbeat heartbeat) {
        }

        @Override
        public final int getNumPartitions() {
            return AbstractClient.this._numPartitions;
        }

        @Override
        public final int validatePartition(int partition) {
            return partition == 0 ? AbstractClient.this._random.nextInt(AbstractClient.this._numPartitions) + 1 : partition;
        }
    }

    private static interface IServerMonitor {
        public void onHeartbeat(Heartbeat var1);

        public int getNumPartitions();

        public int validatePartition(int var1);
    }

    private final class MptPostExecutor
    implements Runnable {
        private MptPostExecutor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            PostMessageProcessingTimesRequest request = null;
            List list = AbstractClient.this._mptToPost;
            synchronized (list) {
                if (AbstractClient.this._mptToPost.size() > 0) {
                    request = PostMessageProcessingTimesRequest.create();
                    request.setTimes(AbstractClient.this._mptToPost.toArray(new MessageProcessingTime[AbstractClient.this._mptToPost.size()]));
                    AbstractClient.this._mptToPost.clear();
                }
            }
            if (request != null) {
                try {
                    AbstractClient.this.postMessageProcessingTimes(request);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private final class MptPostExecutorThreadFactory
    implements ThreadFactory {
        private MptPostExecutorThreadFactory() {
        }

        @Override
        public final Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("X-Eagle-Mpt-Poster");
            return thread;
        }
    }
}

