/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.service;

import com.eaio.uuid.UUID;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Names;
import com.neeve.aep.AepEngine;
import com.neeve.aep.AepEngineDescriptor;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.event.AepChannelDownEvent;
import com.neeve.aep.event.AepChannelUpEvent;
import com.neeve.aep.event.AepEngineStartedEvent;
import com.neeve.aep.event.AepEngineStoppedEvent;
import com.neeve.aep.event.AepMessagingPrestartEvent;
import com.neeve.aep.event.AepMessagingStartedEvent;
import com.neeve.ci.XRuntime;
import com.neeve.rog.IRogCopyableNode;
import com.neeve.rog.IRogJsonizable;
import com.neeve.rog.IRogMessage;
import com.neeve.root.RootConfig;
import com.neeve.server.app.SrvAppLoader;
import com.neeve.server.app.annotations.AppCommandHandler;
import com.neeve.server.app.annotations.AppCommandHandlerContainersAccessor;
import com.neeve.server.app.annotations.AppEventHandlerContainersAccessor;
import com.neeve.server.app.annotations.AppFinalizer;
import com.neeve.server.app.annotations.AppInitializer;
import com.neeve.server.app.annotations.AppInjectionPoint;
import com.neeve.server.app.annotations.AppStat;
import com.neeve.server.app.annotations.AppVersion;
import com.neeve.server.config.ESrvConfigException;
import com.neeve.server.config.SrvConfigAppDescriptor;
import com.neeve.server.config.SrvConfigDescriptor;
import com.neeve.server.controller.SrvController;
import com.neeve.service.AbstractClient;
import com.neeve.service.Alerter;
import com.neeve.service.CompositeSpecializedTracerImpl;
import com.neeve.service.EServiceException;
import com.neeve.service.EmbeddedServerController;
import com.neeve.service.IAlertTracer;
import com.neeve.service.IHeartbeatTracer;
import com.neeve.service.IMessageProcessingStatsTracer;
import com.neeve.service.IMessageScheduler;
import com.neeve.service.IMessageTracer;
import com.neeve.service.IdentityInformationProvider;
import com.neeve.service.MessageHandler;
import com.neeve.service.MessageProcessingStatsCollector;
import com.neeve.service.MessageSender;
import com.neeve.service.SessionManager;
import com.neeve.service.cdc.alert.ICdcTracer;
import com.neeve.service.cdc.main.RunnerController;
import com.neeve.service.cdc.mps.IDbTracer;
import com.neeve.service.cdc.mps.Module;
import com.neeve.service.entities.EntityFactory;
import com.neeve.service.entities.ErrorCode;
import com.neeve.service.entities.ErrorType;
import com.neeve.service.entities.MessageProcessingTime;
import com.neeve.service.messages.AgentInfo;
import com.neeve.service.messages.AgentStartedEvent;
import com.neeve.service.messages.Alert;
import com.neeve.service.messages.AlertRequest;
import com.neeve.service.messages.Credentials;
import com.neeve.service.messages.ErrorContext;
import com.neeve.service.messages.FirstRequest;
import com.neeve.service.messages.Heartbeat;
import com.neeve.service.messages.HeartbeatRequest;
import com.neeve.service.messages.LogoutRequest;
import com.neeve.service.messages.LogoutResponse;
import com.neeve.service.messages.MessageFactory;
import com.neeve.service.messages.MessageHeader;
import com.neeve.service.messages.NullMessage;
import com.neeve.service.messages.PingRequest;
import com.neeve.service.messages.PingResponse;
import com.neeve.service.messages.PostMessageProcessingTimesRequest;
import com.neeve.service.messages.Version;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.MessageView;
import com.neeve.sma.SmaException;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlThrowable;
import com.neeve.util.UtlTime;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

@AppVersion(value=1)
public abstract class AbstractApp<R>
extends AbstractModule
implements EmbeddedServerController {
    private String _serverName;
    private final String _appName;
    private final String _appNameForConfig;
    private final int _appPart;
    private final int _appVersionMajor;
    private final int _appVersionMinor;
    private final String _agentName;
    private final Map<String, AbstractClient> _peerAsyncClients;
    private final List<AbstractClient> _peerClients;
    private SrvController _serverController;
    @Inject
    private SessionManager _sessionManager;
    private final int _threadPoolCapacity;
    private final AtomicInteger _threadPoolUsed;
    @Inject
    private RunnerController _mainCdcRunnerController;
    @Inject
    private com.neeve.service.cdc.mps.RunnerController _mpsCdcRunnerController;
    @Inject
    private com.neeve.service.cdc.alert.RunnerController _alertCdcRunnerController;
    protected AepEngine _engine;
    protected MessageChannel _eventsChannel;
    protected MessageChannel _responsesChannel;
    protected MessageChannel _heartbeatsChannel;
    protected MessageChannel _alertsChannel;
    protected Properties _krt;
    protected ExecutorService _requestExecutor;
    protected ScheduledThreadPoolExecutor _heartbeatExecutor;
    protected Injector _injector;
    @Inject
    protected Tracer _tracer;
    @Inject
    protected IMessageTracer _messageTracer;
    @Inject
    protected IHeartbeatTracer _heartbeatTracer;
    @Inject
    protected Alerter _alerter;
    @Inject
    protected MessageProcessingStatsCollector _messageProcessingStatsCollector;
    @Inject
    private MessageHandler<FirstRequest, AgentStartedEvent, R> _firstRequestHandler;
    @Inject
    private MessageHandler<PingRequest, PingResponse, R> _pingRequestHandler;
    @Inject
    private MessageHandler<HeartbeatRequest, Heartbeat, R> _heartbeatRequestHandler;
    @Inject
    private MessageHandler<AlertRequest, Alert, R> _alertRequestHandler;
    @Inject
    private MessageHandler<PostMessageProcessingTimesRequest, NullMessage, R> _postMessageProcessingTimesRequestHandler;
    @Inject
    private MessageHandler<LogoutRequest, LogoutResponse, R> _logoutRequestHandler;
    @Inject
    private MessageSender<AgentStartedEvent> _agentStartedEventSender;
    @Inject
    private MessageSender<PingResponse> _pingSender;
    @Inject
    private MessageSender<Heartbeat> _heartbeatSender;
    @Inject
    private MessageSender<Alert> _alertSender;
    @Inject
    private MessageSender<LogoutResponse> _logoutResponseSender;
    protected final Tracer TRACER;
    protected final IMessageTracer MESSAGE_TRACER;
    protected final IHeartbeatTracer HEARTBEAT_TRACER;
    protected final IMessageProcessingStatsTracer MSGPROCSTATS_TRACER;
    protected final IAlertTracer ALERT_TRACER;
    protected final com.neeve.service.cdc.main.ICdcTracer MAIN_CDC_TRACER;
    protected final com.neeve.service.cdc.mps.ICdcTracer MPS_CDC_TRACER;
    protected final ICdcTracer ALERT_CDC_TRACER;
    protected final com.neeve.service.cdc.main.IDbTracer MAIN_DB_TRACER;
    protected final IDbTracer MPS_DB_TRACER;
    protected final com.neeve.service.cdc.alert.IDbTracer ALERT_DB_TRACER;
    public static final String REQUEST_CHANNEL_NAME = "requests";
    public static final String RESPONSE_CHANNEL_NAME = "responses";
    public static final String HEARTBEAT_CHANNEL_NAME = "heartbeats";
    public static final String ALERT_CHANNEL_NAME = "alerts";
    public static final String EVENT_CHANNEL_NAME = "events";
    public static final Set<String> _coreAppChannels = new LinkedHashSet<String>();
    public static final String LOOPBACK_URL = "loopback://eagle";

    protected AbstractApp(String appName, String appNameForConfig, int appPart, int appMajorVersion, int appMinorVersion) {
        this._appName = appName;
        this._appNameForConfig = appNameForConfig;
        this._appPart = appPart;
        this._appVersionMajor = appMajorVersion;
        this._appVersionMinor = appMinorVersion;
        this._agentName = this._appName + "-" + this._appPart;
        this.TRACER = RootConfig.ObjectConfig.createTracer((RootConfig.ObjectConfig)RootConfig.ObjectConfig.get((String)this._appNameForConfig));
        this.MESSAGE_TRACER = new CompositeSpecializedTracerImpl(this.toConfigParam("message"));
        this.HEARTBEAT_TRACER = new CompositeSpecializedTracerImpl(this.toConfigParam("heartbeat"));
        this.MSGPROCSTATS_TRACER = new CompositeSpecializedTracerImpl(this.toConfigParam("mps"));
        this.ALERT_TRACER = new CompositeSpecializedTracerImpl(this.toConfigParam("alert"));
        CompositeSpecializedTracerImpl mainCdcDbCompositeSpecializedTracer = new CompositeSpecializedTracerImpl(this.toConfigParam("cdc.main"));
        CompositeSpecializedTracerImpl mpsCdcDbCompositeSpecializedTracer = new CompositeSpecializedTracerImpl(this.toConfigParam("cdc.mps"));
        CompositeSpecializedTracerImpl alertCdcDbCompositeSpecializedTracer = new CompositeSpecializedTracerImpl(this.toConfigParam("cdc.alert"));
        this.MAIN_CDC_TRACER = mainCdcDbCompositeSpecializedTracer;
        this.MAIN_DB_TRACER = mainCdcDbCompositeSpecializedTracer;
        this.MPS_CDC_TRACER = mpsCdcDbCompositeSpecializedTracer;
        this.MPS_DB_TRACER = mpsCdcDbCompositeSpecializedTracer;
        this.ALERT_CDC_TRACER = alertCdcDbCompositeSpecializedTracer;
        this.ALERT_DB_TRACER = alertCdcDbCompositeSpecializedTracer;
        this._peerAsyncClients = this.doGetPeerAsyncClients();
        this._peerClients = this.doGetPeerClients();
        this.checkAndCreateBusDescriptor();
        this._krt = new Properties();
        this._krt.setProperty("app", this._appName);
        this._threadPoolUsed = new AtomicInteger(0);
        this._threadPoolCapacity = Math.max(2, UtlProps.getValue((Properties)XRuntime.getProps(), (String)this.toConfigParam("maxconcurrency"), (int)10));
        this._requestExecutor = this._threadPoolCapacity > 1 ? Executors.newFixedThreadPool(this._threadPoolCapacity, new RequestExecutorThreadFactory()) : null;
        boolean enableHeartbeats = UtlProps.getValue((Properties)XRuntime.getProps(), (String)this.toConfigParam("heartbeat.enabled"), (boolean)true);
        this._heartbeatExecutor = enableHeartbeats ? new ScheduledThreadPoolExecutor(1, new HeartbeatExecutorThreadFactory()) : null;
        if (this._heartbeatExecutor != null) {
            this._heartbeatExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        }
        try {
            SrvConfigDescriptor serverDescriptor = SrvConfigDescriptor.create((String)(this._appName + "-server-" + this._appPart));
            SrvConfigAppDescriptor serviceAppDescriptor = SrvConfigAppDescriptor.create((String)this._agentName);
            serviceAppDescriptor.setMainClass(this.doGetMainClassName());
            serverDescriptor.addApp(serviceAppDescriptor);
            serverDescriptor.save();
            serviceAppDescriptor.save(serverDescriptor.getName());
            this._serverController = SrvController.getInstance((SrvConfigDescriptor)serverDescriptor);
        }
        catch (ESrvConfigException e) {
            throw new RuntimeException(e);
        }
    }

    private final String toConfigParam(String str) {
        return this._appNameForConfig + "." + str;
    }

    static final MessageBusDescriptor checkAndCreateAbstractBusDescriptor(String busName, String providerConfig) throws SmaException {
        if (!MessageBusDescriptor.exists((String)busName)) {
            MessageBusDescriptor busDescriptor = MessageBusDescriptor.create((String)busName);
            MessageChannelDescriptor requestsChannelDescriptor = MessageChannelDescriptor.create((String)REQUEST_CHANNEL_NAME, (MessageBusDescriptor)busDescriptor);
            requestsChannelDescriptor.setChannelKey("${app}/${partition}");
            busDescriptor.addChannel(requestsChannelDescriptor);
            MessageChannelDescriptor responsesChannelDescriptor = MessageChannelDescriptor.create((String)RESPONSE_CHANNEL_NAME, (MessageBusDescriptor)busDescriptor);
            responsesChannelDescriptor.setChannelKey("${app}/${source}");
            busDescriptor.addChannel(responsesChannelDescriptor);
            MessageChannelDescriptor eventsChannelDescriptor = MessageChannelDescriptor.create((String)EVENT_CHANNEL_NAME, (MessageBusDescriptor)busDescriptor);
            eventsChannelDescriptor.setChannelKey("${app}");
            busDescriptor.addChannel(eventsChannelDescriptor);
            MessageChannelDescriptor heartbeatsChannelDescriptor = MessageChannelDescriptor.create((String)HEARTBEAT_CHANNEL_NAME, (MessageBusDescriptor)busDescriptor);
            heartbeatsChannelDescriptor.setChannelKey("${app}");
            busDescriptor.addChannel(heartbeatsChannelDescriptor);
            MessageChannelDescriptor alertsChannelDescriptor = MessageChannelDescriptor.create((String)ALERT_CHANNEL_NAME, (MessageBusDescriptor)busDescriptor);
            alertsChannelDescriptor.setChannelKey("${app}");
            busDescriptor.addChannel(alertsChannelDescriptor);
            busDescriptor.setProviderConfig(providerConfig);
            return busDescriptor;
        }
        return MessageBusDescriptor.load((String)busName, null);
    }

    private final void checkAndCreateBusDescriptor() {
        try {
            MessageBusDescriptor busDescriptor = AbstractApp.checkAndCreateAbstractBusDescriptor(this._appName, UtlProps.getValue((Properties)XRuntime.getProps(), (String)this.toConfigParam("url"), (String)LOOPBACK_URL));
            MessageChannelDescriptor requestsChannelDescriptor = busDescriptor.getChannel(REQUEST_CHANNEL_NAME);
            requestsChannelDescriptor.setChannelFilter("app=" + this._appName + ";partition=" + this._appPart);
            MessageChannelDescriptor responsesChannelDescriptor = busDescriptor.getChannel(RESPONSE_CHANNEL_NAME);
            if (this._peerAsyncClients != null && this._peerAsyncClients.size() > 0) {
                StringBuilder sb1 = new StringBuilder();
                StringBuilder sb2 = new StringBuilder();
                for (Map.Entry entry : this._peerAsyncClients.entrySet()) {
                    sb1.append(sb1.length() > 0 ? "|" : "app=").append((String)entry.getKey());
                    sb2.append(sb2.length() > 0 ? "|" : "source=").append(((AbstractClient)entry.getValue()).getSourceId());
                }
                responsesChannelDescriptor.setChannelFilter(sb1.toString() + ";" + sb2.toString());
            }
            MessageChannelDescriptor eventsChannelDescriptor = busDescriptor.getChannel(EVENT_CHANNEL_NAME);
            if (this._peerAsyncClients != null && this._peerAsyncClients.size() > 0) {
                StringBuilder sb = new StringBuilder();
                for (String string : this._peerAsyncClients.keySet()) {
                    sb.append(sb.length() > 0 ? "|" : "app=").append(string);
                }
                eventsChannelDescriptor.setChannelFilter(sb.toString());
            }
            MessageChannelDescriptor heartbeatsChannelDescriptor = busDescriptor.getChannel(HEARTBEAT_CHANNEL_NAME);
            heartbeatsChannelDescriptor.setChannelFilter(eventsChannelDescriptor.getChannelFilter());
            this.doAddChannelDescriptorsForStreamingPeers(busDescriptor);
            busDescriptor.save(this._agentName);
        }
        catch (SmaException e) {
            throw new RuntimeException(e);
        }
    }

    @Provides
    private final Tracer providesTracer() {
        return this.TRACER;
    }

    @Provides
    private final IMessageTracer providesMessageTracer() {
        return this.MESSAGE_TRACER;
    }

    @Provides
    private final IHeartbeatTracer providesHeartbeatTracer() {
        return this.HEARTBEAT_TRACER;
    }

    @Provides
    private final IMessageProcessingStatsTracer providesMessageProcessingStatsTracer() {
        return this.MSGPROCSTATS_TRACER;
    }

    @Provides
    private final IAlertTracer providesAlertTracer() {
        return this.ALERT_TRACER;
    }

    @Provides
    private final com.neeve.service.cdc.main.ICdcTracer providesMainCdcTracer() {
        return this.MAIN_CDC_TRACER;
    }

    @Provides
    private final com.neeve.service.cdc.mps.ICdcTracer providesMpsCdcTracer() {
        return this.MPS_CDC_TRACER;
    }

    @Provides
    private final ICdcTracer providesAlertCdcTracer() {
        return this.ALERT_CDC_TRACER;
    }

    @Provides
    private final com.neeve.service.cdc.main.IDbTracer providesMainDbTracer() {
        return this.MAIN_DB_TRACER;
    }

    @Provides
    private final IDbTracer providesMpsDbTracer() {
        return this.MPS_DB_TRACER;
    }

    @Provides
    private final com.neeve.service.cdc.alert.IDbTracer providesAlertDbTracer() {
        return this.ALERT_DB_TRACER;
    }

    @Provides
    private final IdentityInformationProvider providesIdentityInformationProvider() {
        return new IdentityInformationProviderImpl();
    }

    @Provides
    private final IMessageScheduler providesMessageScheduler() {
        return new MessageSchedulerImpl();
    }

    @Provides
    private final MessageHandler<HeartbeatRequest, Heartbeat, R> providesHeartbeatRequestHandler() {
        return new HeartbeatRequestHandler((IdentityInformationProvider)this._injector.getInstance(IdentityInformationProvider.class));
    }

    @Provides
    private final MessageHandler<AlertRequest, Alert, R> providesAlertRequestHandler() {
        return new AlertRequestHandler((IdentityInformationProvider)this._injector.getInstance(IdentityInformationProvider.class), (Alerter)this._injector.getInstance(Alerter.class));
    }

    @Provides
    private final MessageHandler<PostMessageProcessingTimesRequest, NullMessage, R> providesPostMessageProcessingTimesRequestHandler() {
        return new PostMessageProcessingTimesRequestHandler((MessageProcessingStatsCollector)this._injector.getInstance(MessageProcessingStatsCollector.class));
    }

    @Provides
    private final MessageHandler<LogoutRequest, LogoutResponse, R> providesLogoutRequestHandler() {
        return new LogoutRequestHandler((SessionManager)this._injector.getInstance(SessionManager.class));
    }

    @Provides
    private final MessageSender<AgentStartedEvent> providesAgentStartedEventSender() {
        return new EventSender<AgentStartedEvent>();
    }

    @Provides
    private final MessageSender<PingResponse> providesPingResponseSender() {
        return new ResponseSender<PingResponse>();
    }

    @Provides
    private final MessageSender<Heartbeat> providesHeartbeatSender() {
        return new HeartbeatSender<Heartbeat>();
    }

    @Provides
    private final MessageSender<Alert> providesAlertSender() {
        return new AlertSender<Alert>();
    }

    @Provides
    private final MessageSender<LogoutResponse> providesLogoutResponseSender() {
        return new ResponseSender<LogoutResponse>();
    }

    protected final Tracer heartbeatTracer() {
        return this._heartbeatTracer.getTracer();
    }

    protected final Tracer messageTracer() {
        return this._messageTracer.getTracer();
    }

    protected static final String localizeAppName(String env, String str) {
        return env != null ? str + "-" + env : str;
    }

    protected final void addAppGuiceModule(String moduleClassName, Set<AbstractModule> modules) {
        try {
            modules.add((AbstractModule)Class.forName(moduleClassName).newInstance());
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    protected abstract String doGetMainClassName();

    protected abstract Map<String, AbstractClient> doGetPeerAsyncClients();

    protected abstract List<AbstractClient> doGetPeerClients();

    protected void doAddChannelDescriptorsForStreamingPeers(MessageBusDescriptor busDescriptor) {
    }

    protected abstract boolean joinChannel(String var1);

    protected void doAddChannelsForStreamingPeers(AepEngineDescriptor engineDescriptor) throws Exception {
    }

    protected abstract void doAddGuiceModules(Set<AbstractModule> var1);

    protected abstract void doRegisterFactories();

    protected void doAddEventHandlerContainers(Set<Object> containers) {
    }

    protected void doAddCommandHandlerContainers(Set<Object> containers) {
    }

    protected void doInitialize() {
    }

    protected void onStarted() {
    }

    protected void onActivated() throws Exception {
    }

    protected void onMessagingStarted() {
    }

    protected void onSubmitForRemoteExecution(MessageView message) {
    }

    protected void onMessageProcessingStart(MessageView message) {
    }

    protected void onMessageProcessingComplete(MessageView message) {
    }

    protected void onMessageSend(MessageView message, boolean response) {
    }

    protected void onMessageSchedule(MessageView message) {
    }

    protected void onStopped(Throwable cause) {
    }

    protected void doFinalize() {
    }

    protected void configure() {
        this.bind(SessionManager.class).in(Singleton.class);
        this.bind(MessageProcessingStatsCollector.class).in(Singleton.class);
        this.bind(Boolean.class).annotatedWith((Annotation)Names.named((String)"nv.service.mps.logging.enabled")).toInstance((Object)UtlProps.getValue((Properties)XRuntime.getProps(), (String)this.toConfigParam("mps.logging.enabled"), (boolean)false));
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"nv.service.mps.logging.location")).toInstance((Object)UtlProps.getValue((Properties)XRuntime.getProps(), (String)this.toConfigParam("mps.logging.location"), (String)XRuntime.getDataDirectory((boolean)false)));
        this.bind(Integer.class).annotatedWith((Annotation)Names.named((String)"nv.service.mps.trace.interval")).toInstance((Object)UtlProps.getValue((Properties)XRuntime.getProps(), (String)this.toConfigParam("mps.trace.interval"), (int)0));
        this.bind(Alerter.class).in(Singleton.class);
        this.bind(Boolean.class).annotatedWith((Annotation)Names.named((String)"nv.service.alert.logging.enabled")).toInstance((Object)UtlProps.getValue((Properties)XRuntime.getProps(), (String)this.toConfigParam("alert.logging.enabled"), (boolean)false));
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"nv.service.alert.logging.location")).toInstance((Object)UtlProps.getValue((Properties)XRuntime.getProps(), (String)this.toConfigParam("alert.logging.location"), (String)XRuntime.getDataDirectory((boolean)false)));
        this.bind(Integer.class).annotatedWith((Annotation)Names.named((String)"nv.service.cdc.restartattempts")).toInstance((Object)UtlProps.getValue((Properties)XRuntime.getProps(), (String)this.toConfigParam("cdc.restartattempts"), (int)1));
        this.bind(Long.class).annotatedWith((Annotation)Names.named((String)"nv.service.cdc.restartfrequency")).toInstance((Object)((long)UtlProps.getValue((Properties)XRuntime.getProps(), (String)this.toConfigParam("cdc.restartfrequency"), (int)5) * 1000L));
        this.bind(Boolean.class).annotatedWith((Annotation)Names.named((String)"nv.service.cdc.main.enabled")).toInstance((Object)UtlProps.getValue((Properties)XRuntime.getProps(), (String)this.toConfigParam("cdc.main.enabled"), (boolean)false));
        this.bind(Boolean.class).annotatedWith((Annotation)Names.named((String)"nv.service.cdc.main.disableonfail")).toInstance((Object)UtlProps.getValue((Properties)XRuntime.getProps(), (String)this.toConfigParam("cdc.main.disableonfail"), (boolean)false));
        this.bind(Integer.class).annotatedWith((Annotation)Names.named((String)"nv.service.cdc.main.pollalertfrequency")).toInstance((Object)UtlProps.getValue((Properties)XRuntime.getProps(), (String)this.toConfigParam("cdc.main.pollalertfrequency"), (int)30));
        this.bind(Boolean.class).annotatedWith((Annotation)Names.named((String)"nv.service.cdc.mps.enabled")).toInstance((Object)UtlProps.getValue((Properties)XRuntime.getProps(), (String)this.toConfigParam("cdc.mps.enabled"), (boolean)false));
        this.bind(Boolean.class).annotatedWith((Annotation)Names.named((String)"nv.service.cdc.mps.disableonfail")).toInstance((Object)UtlProps.getValue((Properties)XRuntime.getProps(), (String)this.toConfigParam("cdc.mps.disableonfail"), (boolean)false));
        this.bind(Integer.class).annotatedWith((Annotation)Names.named((String)"nv.service.cdc.mps.pollalertfrequency")).toInstance((Object)UtlProps.getValue((Properties)XRuntime.getProps(), (String)this.toConfigParam("cdc.mps.pollalertfrequency"), (int)30));
        this.bind(Boolean.class).annotatedWith((Annotation)Names.named((String)"nv.service.cdc.alert.enabled")).toInstance((Object)UtlProps.getValue((Properties)XRuntime.getProps(), (String)this.toConfigParam("cdc.alert.enabled"), (boolean)false));
        this.bind(Boolean.class).annotatedWith((Annotation)Names.named((String)"nv.service.cdc.alert.disableonfail")).toInstance((Object)UtlProps.getValue((Properties)XRuntime.getProps(), (String)this.toConfigParam("cdc.alert.disableonfail"), (boolean)false));
        this.bind(Integer.class).annotatedWith((Annotation)Names.named((String)"nv.service.cdc.alert.pollalertfrequency")).toInstance((Object)UtlProps.getValue((Properties)XRuntime.getProps(), (String)this.toConfigParam("cdc.alert.pollalertfrequency"), (int)30));
        this.bind(Boolean.class).annotatedWith((Annotation)Names.named((String)"nv.service.db.rdbms.enabled")).toInstance((Object)UtlProps.getValue((Properties)XRuntime.getProps(), (String)this.toConfigParam("db.rdbms.enabled"), (boolean)false));
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"nv.service.db.rdbms.driver")).toInstance((Object)UtlProps.getValue((Properties)XRuntime.getProps(), (String)this.toConfigParam("db.rdbms.driver"), (String)"not_configured"));
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"nv.service.db.rdbms.url")).toInstance((Object)UtlProps.getValue((Properties)XRuntime.getProps(), (String)this.toConfigParam("db.rdbms.url"), (String)"not_configured"));
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"nv.service.db.rdbms.username")).toInstance((Object)UtlProps.getValue((Properties)XRuntime.getProps(), (String)this.toConfigParam("db.rdbms.username"), (String)"not_configured"));
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"nv.service.db.rdbms.password")).toInstance((Object)UtlProps.getValue((Properties)XRuntime.getProps(), (String)this.toConfigParam("db.rdbms.password"), (String)"not_configured"));
        this.bind(Boolean.class).annotatedWith((Annotation)Names.named((String)"nv.service.db.rdbms.createtables")).toInstance((Object)UtlProps.getValue((Properties)XRuntime.getProps(), (String)this.toConfigParam("db.rdbms.createtables"), (boolean)false));
        this.bind(Boolean.class).annotatedWith((Annotation)Names.named((String)"nv.service.db.rdbms.createindexes")).toInstance((Object)UtlProps.getValue((Properties)XRuntime.getProps(), (String)this.toConfigParam("db.rdbms.createindexes"), (boolean)false));
        this.bind(Integer.class).annotatedWith((Annotation)Names.named((String)"nv.service.db.rdbms.numreaderthreads")).toInstance((Object)UtlProps.getValue((Properties)XRuntime.getProps(), (String)this.toConfigParam("db.rdbms.numreaderthreads"), (int)25));
        this.bind(Long.class).annotatedWith((Annotation)Names.named((String)"nv.service.db.rdbms.reconnectfrequency")).toInstance((Object)((long)UtlProps.getValue((Properties)XRuntime.getProps(), (String)this.toConfigParam("db.rdbms.reconnectfrequency"), (int)1) * 1000L));
        this.bind(Long.class).annotatedWith((Annotation)Names.named((String)"nv.service.db.rdbms.reconnectattemptduration")).toInstance((Object)((long)UtlProps.getValue((Properties)XRuntime.getProps(), (String)this.toConfigParam("db.rdbms.reconnectattemptduration"), (int)600) * 1000L));
        this.bind(Boolean.class).annotatedWith((Annotation)Names.named((String)"nv.service.db.influx.enabled")).toInstance((Object)UtlProps.getValue((Properties)XRuntime.getProps(), (String)this.toConfigParam("db.influx.enabled"), (boolean)false));
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"nv.service.db.influx.url")).toInstance((Object)UtlProps.getValue((Properties)XRuntime.getProps(), (String)this.toConfigParam("db.influx.url"), (String)"http://localhost:8086"));
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"nv.service.db.influx.username")).toInstance((Object)UtlProps.getValue((Properties)XRuntime.getProps(), (String)this.toConfigParam("db.influx.username"), (String)"root"));
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"nv.service.db.influx.password")).toInstance((Object)UtlProps.getValue((Properties)XRuntime.getProps(), (String)this.toConfigParam("db.influx.password"), (String)"root"));
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"nv.service.db.influx.dbname")).toInstance((Object)UtlProps.getValue((Properties)XRuntime.getProps(), (String)this.toConfigParam("db.influx.dbname"), (String)"eagle"));
        this.bind(Long.class).annotatedWith((Annotation)Names.named((String)"nv.service.db.influx.mpstats.injectfrequency")).toInstance((Object)((long)UtlProps.getValue((Properties)XRuntime.getProps(), (String)this.toConfigParam("db.influx.mpstats.injectfrequency"), (int)1000) * 1L));
    }

    protected final <I extends IRogMessage & IRogCopyableNode, O extends IRogMessage, H extends MessageHandler<I, O, R>, S extends MessageSender<O>> RequestExecutor<I, O, H, S> createRequestExecutor(String method, I request, MessageHeader requestHeader, O response, MessageHeader responseHeader, H handler, S sender) {
        return new RequestExecutor(this, method, request, requestHeader, response, responseHeader, handler, sender);
    }

    @AppStat(name="ThreadPoolCapacity")
    public final int getThreadPoolCapacity() {
        return this._threadPoolCapacity;
    }

    @AppStat(name="ThreadPoolUsed")
    public final int getThreadPoolUsed() {
        return this._threadPoolUsed.get();
    }

    @AppInjectionPoint
    public final void setAppLoader(SrvAppLoader loader) throws Exception {
        this._serverName = loader.getServerDescriptor().getName();
        LinkedHashSet<AbstractModule> modules = new LinkedHashSet<AbstractModule>();
        modules.add(new com.neeve.service.cdc.main.Module());
        modules.add(new com.neeve.service.db.main.Module());
        modules.add(new Module());
        modules.add(new com.neeve.service.db.mps.Module());
        modules.add(new com.neeve.service.cdc.alert.Module());
        modules.add(new com.neeve.service.db.alert.Module());
        modules.add(this);
        this.doAddGuiceModules(modules);
        this._injector = Guice.createInjector(modules);
        this._injector.injectMembers((Object)this);
    }

    @AppCommandHandlerContainersAccessor
    public final void addCommandHandlerContainer(Set<Object> containers) throws Exception {
        containers.add(this._mainCdcRunnerController);
        containers.add(this._mpsCdcRunnerController);
        containers.add(this._alertCdcRunnerController);
        this.doAddCommandHandlerContainers(containers);
    }

    @AppEventHandlerContainersAccessor
    public final void addEventHandlerContainer(Set<Object> containers) throws Exception {
        if (this._peerAsyncClients != null) {
            for (AbstractClient client : this._peerAsyncClients.values()) {
                containers.add(client);
            }
        }
        this.doAddEventHandlerContainers(containers);
    }

    @AppInjectionPoint
    public final void prepEngineDescriptor(AepEngineDescriptor engineDescriptor) throws Exception {
        if (!engineDescriptor.getName().equals(this._agentName)) {
            throw new IllegalArgumentException("engine name must be configured as " + this._agentName);
        }
        engineDescriptor.addChannel(this._appName, REQUEST_CHANNEL_NAME, AepEngineDescriptor.ChannelConfig.from((String)"join=true"));
        engineDescriptor.addChannel(this._appName, RESPONSE_CHANNEL_NAME, AepEngineDescriptor.ChannelConfig.from((String)("join=" + this.joinChannel(RESPONSE_CHANNEL_NAME))));
        engineDescriptor.addChannel(this._appName, EVENT_CHANNEL_NAME, AepEngineDescriptor.ChannelConfig.from((String)("join=" + this.joinChannel(EVENT_CHANNEL_NAME))));
        engineDescriptor.addChannel(this._appName, HEARTBEAT_CHANNEL_NAME, AepEngineDescriptor.ChannelConfig.from((String)("join=" + this.joinChannel(HEARTBEAT_CHANNEL_NAME))));
        engineDescriptor.addChannel(this._appName, ALERT_CHANNEL_NAME, AepEngineDescriptor.ChannelConfig.from((String)"join=false"));
        this.doAddChannelsForStreamingPeers(engineDescriptor);
        engineDescriptor.setPerformDuplicateChecking(false);
        engineDescriptor.setSetInboundMessagesAsReadOnly(false);
        engineDescriptor.setSetOutboundMessagesAsReadOnly(false);
        engineDescriptor.setHAPolicy(AepEngine.HAPolicy.StateReplication);
    }

    @AppInjectionPoint
    public final void setAppEngine(AepEngine engine) throws Exception {
        this._engine = engine;
    }

    @AppInitializer
    public final void initialize() throws Exception {
        this._engine.registerFactory((Object)new EntityFactory());
        this._engine.registerFactory((Object)new MessageFactory());
        this.doRegisterFactories();
        this._alerter.open(new AlertHandler());
        this._messageProcessingStatsCollector.open();
        this.doInitialize();
    }

    @AppCommandHandler(command="startmpslogging")
    public final String startMpsLogging(String command, String[] args) throws Exception {
        this._messageProcessingStatsCollector.enableLogging(true);
        this._tracer.log("Message processing stats logging for '" + this._agentName + "' has started.", Tracer.Level.INFO);
        return "OK ";
    }

    @AppCommandHandler(command="schedulempslogcompaction")
    public final String scheduleMpsLogCompaction(String command, String[] args) throws Exception {
        this._messageProcessingStatsCollector.scheduleLogCompactionOnNextWrite();
        this._tracer.log("Scheduled compaction on next write to message processing stats log for '" + this._agentName + "'.", Tracer.Level.INFO);
        return "OK ";
    }

    @AppCommandHandler(command="setmpslogcompactionthreshold")
    public final String setMpsLogCompactionThreshold(String command, String[] args) throws Exception {
        if (args.length != 1) {
            throw new IllegalArgumentException("usage: setmpslogcompactionthreshold <threshold>");
        }
        int val = Integer.parseInt(args[0]);
        this._messageProcessingStatsCollector.setLogCompactionThreshold(val);
        this._tracer.log("Set compaction threshold on the message processing stats log for '" + this._agentName + "' to " + val + "GB.", Tracer.Level.INFO);
        return "OK ";
    }

    @AppCommandHandler(command="stopmpslogging")
    public final String stopMpsLogging(String command, String[] args) throws Exception {
        this._messageProcessingStatsCollector.enableLogging(false);
        this._tracer.log("Message processing stats logging for '" + this._agentName + "' has stopped.", Tracer.Level.INFO);
        return "OK ";
    }

    @AppCommandHandler(command="msgstats")
    public final String messageStats(String command, String[] args) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (Class<?> type : this._messageProcessingStatsCollector.getTypes()) {
            MessageProcessingStatsCollector.TypeStats stats = this._messageProcessingStatsCollector.getTypeStats(type);
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append("proctimes_").append(type.getSimpleName()).append(".csv").append("^");
            stats.getRawForCsv(sb);
        }
        return sb.toString();
    }

    @AppCommandHandler(command="resetstats")
    public final String resetStats(String command, String[] args) throws Exception {
        this._messageProcessingStatsCollector.reset();
        this._tracer.log("Message processing stats for '" + this._agentName + "' have been reset.", Tracer.Level.INFO);
        return "OK ";
    }

    @AppCommandHandler(command="startalertlogging")
    public final String startAlertLogging(String command, String[] args) throws Exception {
        this._alerter.enableLogging(true);
        this._tracer.log("Alert logging for '" + this._agentName + "' has started.", Tracer.Level.INFO);
        return "OK ";
    }

    @AppCommandHandler(command="schedulealertlogcompaction")
    public final String scheduleAlertLogCompaction(String command, String[] args) throws Exception {
        this._alerter.scheduleLogCompactionOnNextWrite();
        this._tracer.log("Scheduled compaction on next write to alert log for '" + this._agentName + "'.", Tracer.Level.INFO);
        return "OK ";
    }

    @AppCommandHandler(command="setalertlogcompactionthreshold")
    public final String setAlertLogCompactionThreshold(String command, String[] args) throws Exception {
        if (args.length != 1) {
            throw new IllegalArgumentException("usage: setalertlogcompactionthreshold <threshold>");
        }
        int val = Integer.parseInt(args[0]);
        this._alerter.setLogCompactionThreshold(val);
        this._tracer.log("Set compaction threshold on the alert log for '" + this._agentName + "' to " + val + "GB.", Tracer.Level.INFO);
        return "OK ";
    }

    @AppCommandHandler(command="stopalertlogging")
    public final String stopAlertLogging(String command, String[] args) throws Exception {
        this._alerter.enableLogging(false);
        this._tracer.log("Alert logging for '" + this._agentName + "' has stopped.", Tracer.Level.INFO);
        return "OK ";
    }

    @EventHandler
    public final void onEngineStarted(AepEngineStartedEvent event) {
        this._tracer.log("The " + this._agentName + " service has started.", Tracer.Level.INFO);
        this.onStarted();
    }

    @EventHandler
    public final void onMessagingPrestart(AepMessagingPrestartEvent event) {
        this._tracer.log("The " + this._agentName + " service has activated.", Tracer.Level.INFO);
        try {
            this.onActivated();
            FirstRequest request = FirstRequest.create();
            request.setHeader(MessageHeader.create());
            request.getHeader().setOrigin(this._appName);
            request.getHeader().setSourceId(String.valueOf(this._appPart));
            request.getHeader().setTransactionId(new UUID().toString());
            event.setFirstMessage((MessageView)request);
        }
        catch (Exception e) {
            this._tracer.log("Failed app prestart - " + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.SEVERE);
            this._engine.stop(e);
        }
    }

    @EventHandler
    public final void onMessagingStarted(AepMessagingStartedEvent event) {
        if (event.getStatus() == null) {
            Credentials credentials;
            this._tracer.log("The " + this._agentName + " service messaging has started successfully.", Tracer.Level.INFO);
            if (this._peerAsyncClients != null && this._peerAsyncClients.size() > 0) {
                credentials = Credentials.create();
                credentials.setUsername(this._agentName + "-async");
                credentials.setPassword("doesntmatter");
                for (AbstractClient client : this._peerAsyncClients.values()) {
                    client.open(credentials, this._engine);
                }
            }
            if (this._peerClients != null && this._peerClients.size() > 0) {
                credentials = Credentials.create();
                credentials.setUsername(this._agentName);
                credentials.setPassword("doesntmatter");
                for (AbstractClient client : this._peerClients) {
                    client.open(credentials);
                }
            }
            if (this._heartbeatExecutor != null) {
                int interval = UtlProps.getValue((Properties)XRuntime.getProps(), (String)this.toConfigParam("heartbeat.interval"), (int)5);
                this._heartbeatExecutor.scheduleWithFixedDelay(new HeartbeatExecutor(), interval, interval, TimeUnit.SECONDS);
            }
            this.onMessagingStarted();
            String thisHostName = "<unknown>";
            String thisHostAddr = "<unknown>";
            try {
                InetAddress thisHost = InetAddress.getLocalHost();
                try {
                    thisHostName = thisHost.getHostName();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    thisHostAddr = thisHost.getHostAddress();
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable e) {
                this._tracer.log("Failed to get local host name [" + e.toString() + "].", Tracer.Level.WARNING);
                this._tracer.log("...[not a fatal error - name only needed for trace/notificational purposes].", Tracer.Level.WARNING);
            }
            this._alerter.alert(this._agentName + " is active (" + thisHostName + "[" + thisHostAddr + "], pid=" + XRuntime.getPid() + ")", null, Alerter.Severity.Info);
        } else {
            this._tracer.log("The " + this._agentName + " service messaging failed to start [" + event.getStatus().toString() + "].", Tracer.Level.INFO);
        }
    }

    @EventHandler(source="requests@*")
    public final void onRequestsChannelUp(AepChannelUpEvent event) {
        this._tracer.log("The " + this._agentName + " requests channel is up.", Tracer.Level.INFO);
    }

    @EventHandler(source="requests@*")
    public final void onRequestsChannelDown(AepChannelDownEvent event) {
        this._tracer.log("The " + this._agentName + " requests channel is down.", Tracer.Level.INFO);
    }

    @EventHandler(source="responses@*")
    public final void onResponsesChannelUp(AepChannelUpEvent event) {
        this._tracer.log("The " + this._agentName + " responses channel is up.", Tracer.Level.INFO);
        this._responsesChannel = event.getMessageChannel();
        this._responsesChannel.setKeyResolutionTable(this._krt);
    }

    @EventHandler(source="responses@*")
    public final void onResponsesChannelDown(AepChannelDownEvent event) {
        this._tracer.log("The " + this._agentName + " responses channel is down.", Tracer.Level.INFO);
        this._responsesChannel = null;
    }

    @EventHandler(source="events@*")
    public final void onEventsChannelUp(AepChannelUpEvent event) {
        this._tracer.log("The " + this._agentName + " events channel is up.", Tracer.Level.INFO);
        this._eventsChannel = event.getMessageChannel();
        this._eventsChannel.setKeyResolutionTable(this._krt);
    }

    @EventHandler(source="events@*")
    public final void onEventsChannelDown(AepChannelDownEvent event) {
        this._tracer.log("The " + this._agentName + " events channel is down.", Tracer.Level.INFO);
        this._eventsChannel = null;
    }

    @EventHandler(source="heartbeats@*")
    public final void onHeartbeatsChannelUp(AepChannelUpEvent event) {
        this._tracer.log("The " + this._agentName + " heartbeats channel is up.", Tracer.Level.INFO);
        this._heartbeatsChannel = event.getMessageChannel();
        this._heartbeatsChannel.setKeyResolutionTable(this._krt);
    }

    @EventHandler(source="heartbeats@*")
    public final void onHeartbeatsChannelDown(AepChannelDownEvent event) {
        this._tracer.log("The " + this._agentName + " heartbeats channel is down.", Tracer.Level.INFO);
        this._heartbeatsChannel = null;
    }

    @EventHandler(source="alerts@*")
    public final void onAlertsChannelUp(AepChannelUpEvent event) {
        this._tracer.log("The " + this._agentName + " alerts channel is up.", Tracer.Level.INFO);
        this._alertsChannel = event.getMessageChannel();
        this._alertsChannel.setKeyResolutionTable(this._krt);
    }

    @EventHandler(source="alerts@*")
    public final void onAlertsChannelDown(AepChannelDownEvent event) {
        this._tracer.log("The " + this._agentName + " alerts channel is down.", Tracer.Level.INFO);
        this._alertsChannel = null;
    }

    @EventHandler
    public final void onNull(NullMessage message) {
        if (this.messageTracer().debug) {
            this.messageTracer().log("<-- " + message.toJsonString(true, null, null) + ".", Tracer.Level.DEBUG);
        }
    }

    @EventHandler
    public final void onFirstMessage(FirstRequest request) {
        if (this.messageTracer().debug) {
            this.messageTracer().log("<-- " + request.toJsonString(true, null, null) + ".", Tracer.Level.DEBUG);
        }
        AgentStartedEvent response = AgentStartedEvent.create();
        response.setHeader(MessageHeader.create());
        this.createRequestExecutor("First", request, request.getHeader(), response, response.getHeader(), this._firstRequestHandler, this._agentStartedEventSender).go();
    }

    @EventHandler
    public final void onPing(PingRequest request) {
        if (this.messageTracer().debug) {
            this.messageTracer().log("<-- " + request.toJsonString(true, null, null) + ".", Tracer.Level.DEBUG);
        }
        PingResponse response = PingResponse.create();
        response.setHeader(MessageHeader.create());
        this.createRequestExecutor("Ping", request, request.getHeader(), response, response.getHeader(), this._pingRequestHandler, this._pingSender).go();
    }

    @EventHandler
    public final void onHeartbeat(HeartbeatRequest request) {
        if (this.heartbeatTracer().debug) {
            this.heartbeatTracer().log("<-- " + request.toJsonString(true, null, null) + ".", Tracer.Level.DEBUG);
        }
        Heartbeat heartbeat = Heartbeat.create();
        heartbeat.setHeader(MessageHeader.create());
        this.createRequestExecutor("Heartbeat", request, request.getHeader(), heartbeat, heartbeat.getHeader(), this._heartbeatRequestHandler, this._heartbeatSender).go();
    }

    @EventHandler
    public final void onAlert(AlertRequest request) {
        if (this.messageTracer().debug) {
            this.messageTracer().log("<-- " + request.toJsonString(true, null, null) + ".", Tracer.Level.DEBUG);
        }
        Alert alert = Alert.create();
        alert.setHeader(MessageHeader.create());
        this.createRequestExecutor("Alert", request, request.getHeader(), alert, alert.getHeader(), this._alertRequestHandler, this._alertSender).go();
    }

    @EventHandler
    public final void onPostMessageProcessingTimes(PostMessageProcessingTimesRequest request) {
        if (this.messageTracer().debug) {
            this.messageTracer().log("<-- " + request.toJsonString(true, null, null) + ".", Tracer.Level.DEBUG);
        }
        new RequestExecutor(this, "PostMessageProcessingTimes", (IRogMessage)request, request.getHeader(), null, null, this._postMessageProcessingTimesRequestHandler, null).go();
    }

    @EventHandler
    public final void onLogout(LogoutRequest request) {
        if (this.messageTracer().debug) {
            this.messageTracer().log("<-- " + request.toJsonString(true, null, null) + ".", Tracer.Level.DEBUG);
        }
        LogoutResponse response = LogoutResponse.create();
        response.setHeader(MessageHeader.create());
        this.createRequestExecutor("Logout", request, request.getHeader(), response, response.getHeader(), this._logoutRequestHandler, this._logoutResponseSender).go();
    }

    @EventHandler
    public final void onEngineStopped(AepEngineStoppedEvent event) {
        this.onStopped(event.getCause());
        this._tracer.log("The " + this._agentName + " service has stopped (cause=" + event.getCause() + ").", Tracer.Level.INFO);
        if (event.getCause() != null) {
            this._tracer.log(UtlThrowable.prepareStackTrace((Throwable)event.getCause()), Tracer.Level.SEVERE);
        }
    }

    @AppFinalizer
    public void finalize() {
        if (this._requestExecutor != null) {
            this._requestExecutor.shutdown();
        }
        if (this._heartbeatExecutor != null) {
            this._heartbeatExecutor.shutdown();
        }
        if (this._peerAsyncClients != null && this._peerAsyncClients.size() > 0) {
            for (AbstractClient client : this._peerAsyncClients.values()) {
                client.close();
            }
        }
        if (this._peerClients != null && this._peerClients.size() > 0) {
            for (AbstractClient client : this._peerClients) {
                client.close();
            }
        }
        this._messageProcessingStatsCollector.close();
        this._alerter.close();
        this.doFinalize();
    }

    @Override
    public final void start() throws Exception {
        new Thread(){

            @Override
            public final void run() {
                AbstractApp.this._serverController.start();
            }
        }.start();
    }

    @Override
    public final void stop() {
        this._serverController.stop();
    }

    static {
        _coreAppChannels.add(REQUEST_CHANNEL_NAME);
        _coreAppChannels.add(RESPONSE_CHANNEL_NAME);
        _coreAppChannels.add(HEARTBEAT_CHANNEL_NAME);
        _coreAppChannels.add(ALERT_CHANNEL_NAME);
        _coreAppChannels.add(EVENT_CHANNEL_NAME);
    }

    public static final class LogoutRequestHandler<R>
    implements MessageHandler<LogoutRequest, LogoutResponse, R> {
        private final SessionManager _sessionManager;

        @Inject
        LogoutRequestHandler(SessionManager sessionManager) {
            this._sessionManager = sessionManager;
        }

        @Override
        public final MessageHandler.Type getType() {
            return MessageHandler.Type.Local;
        }

        public final IRogMessage handle(String source, LogoutRequest request, LogoutResponse response, R repository) throws Exception {
            this._sessionManager.logout(request.getHeader().getSessionId());
            return null;
        }
    }

    public static final class PostMessageProcessingTimesRequestHandler<R>
    implements MessageHandler<PostMessageProcessingTimesRequest, NullMessage, R> {
        private final MessageProcessingStatsCollector _messageProcessingStatsCollector;

        PostMessageProcessingTimesRequestHandler(MessageProcessingStatsCollector messageProcessingStatsCollector) {
            this._messageProcessingStatsCollector = messageProcessingStatsCollector;
        }

        @Override
        public final MessageHandler.Type getType() {
            return MessageHandler.Type.Remote;
        }

        public final IRogMessage handle(String source, PostMessageProcessingTimesRequest request, NullMessage noop, R repository) throws Exception {
            for (MessageProcessingTime mpt : request.getTimesEmptyIfNull()) {
                this._messageProcessingStatsCollector.log((MessageProcessingTime)mpt.clone());
            }
            return null;
        }
    }

    public static final class AlertRequestHandler<R>
    implements MessageHandler<AlertRequest, Alert, R> {
        private final IdentityInformationProvider _identityInfoProvider;
        private final Alerter _alerter;

        AlertRequestHandler(IdentityInformationProvider identityInfoProvider, Alerter alerter) {
            this._identityInfoProvider = identityInfoProvider;
            this._alerter = alerter;
        }

        @Override
        public final MessageHandler.Type getType() {
            return MessageHandler.Type.Local;
        }

        public final IRogMessage handle(String source, AlertRequest request, Alert alert, R repository) throws Exception {
            this._alerter.populateAlert(alert, request);
            return null;
        }
    }

    public static final class HeartbeatRequestHandler<R>
    implements MessageHandler<HeartbeatRequest, Heartbeat, R> {
        private final IdentityInformationProvider _identityInfoProvider;
        private final Date _startTime = new Date();

        HeartbeatRequestHandler(IdentityInformationProvider identityInfoProvider) {
            this._identityInfoProvider = identityInfoProvider;
        }

        private final void setAgentInfo(Heartbeat heartbeat) {
            AgentInfo agentInfo = AgentInfo.create();
            agentInfo.setApplicationName(this._identityInfoProvider.getName());
            agentInfo.setApplicationPartition(this._identityInfoProvider.getPartition());
            agentInfo.setPid(XRuntime.getPid());
            agentInfo.setStartTime(this._startTime);
            heartbeat.setAgentInfo(agentInfo);
        }

        @Override
        public final MessageHandler.Type getType() {
            return MessageHandler.Type.Remote;
        }

        public final IRogMessage handle(String source, HeartbeatRequest request, Heartbeat heartbeat, R repository) throws Exception {
            this.setAgentInfo(heartbeat);
            return null;
        }
    }

    private final class MessageSchedulerImpl
    implements IMessageScheduler {
        private MessageSchedulerImpl() {
        }

        @Override
        public void send(MessageView message) {
            if (AbstractApp.this._engine != null && AbstractApp.this._engine.getState() == AepEngine.State.Started) {
                AbstractApp.this.onMessageSchedule(message);
                AbstractApp.this._engine.multiplexMessage((IRogMessage)message, true);
            }
        }
    }

    protected final class AlertSender<T extends IRogMessage>
    extends MessageSenderImpl<T> {
        @Override
        protected final MessageChannel getMessageChannel() {
            return AbstractApp.this._alertsChannel;
        }

        @Override
        protected final String getMessageKey(MessageHeader requestHeader) {
            return AbstractApp.this._appName;
        }

        @Override
        public final MessageHeader prepareHeader(MessageHeader requestHeader, MessageHeader alertHeader, Throwable e) {
            alertHeader.setOrigin(AbstractApp.this._appName);
            alertHeader.setSourceId(String.valueOf(AbstractApp.this._appPart));
            alertHeader.setSessionId(null);
            alertHeader.setRequestId(null);
            Version version = Version.create();
            version.setMajorVersion(AbstractApp.this._appVersionMajor);
            version.setMinorVersion(AbstractApp.this._appVersionMinor);
            alertHeader.setSenderVersion(version);
            alertHeader.setError(null);
            return alertHeader;
        }

        @Override
        public void send(MessageHeader requestHeader, T message) {
            if (AbstractApp.this._alertsChannel != null) {
                super.send(requestHeader, message);
            } else {
                AbstractApp.this._tracer.log("Failed to send message. Alerts channel is down.", Tracer.Level.WARNING);
            }
        }
    }

    protected final class HeartbeatSender<T extends IRogMessage>
    extends MessageSenderImpl<T> {
        @Override
        protected final void writeMessageTrace(T message) {
            if (AbstractApp.this.heartbeatTracer().debug) {
                AbstractApp.this.heartbeatTracer().log("--> " + ((IRogJsonizable)message).toJsonString(true, null, null) + ".", Tracer.Level.DEBUG);
            }
        }

        @Override
        protected final MessageChannel getMessageChannel() {
            return AbstractApp.this._heartbeatsChannel;
        }

        @Override
        protected final String getMessageKey(MessageHeader requestHeader) {
            return AbstractApp.this._appName;
        }

        @Override
        public final MessageHeader prepareHeader(MessageHeader requestHeader, MessageHeader heartbeatHeader, Throwable e) {
            heartbeatHeader.setOrigin(AbstractApp.this._appName);
            heartbeatHeader.setSourceId(String.valueOf(AbstractApp.this._appPart));
            heartbeatHeader.setSessionId(null);
            heartbeatHeader.setRequestId(null);
            Version version = Version.create();
            version.setMajorVersion(AbstractApp.this._appVersionMajor);
            version.setMinorVersion(AbstractApp.this._appVersionMinor);
            heartbeatHeader.setSenderVersion(version);
            heartbeatHeader.setError(null);
            return heartbeatHeader;
        }
    }

    protected abstract class PeerRequestSender<T extends IRogMessage>
    implements MessageSender<T> {
        protected PeerRequestSender() {
        }

        @Override
        public final MessageHeader prepareHeader(MessageHeader inRequestHeader, MessageHeader outRequestHeader, Throwable e) {
            outRequestHeader.setOrigin(AbstractApp.this._appName);
            outRequestHeader.setSourceId(String.valueOf(AbstractApp.this._appPart));
            outRequestHeader.setSessionId(null);
            outRequestHeader.setRequestId(new UUID().toString());
            outRequestHeader.setTransactionId(inRequestHeader.getTransactionId());
            Version version = Version.create();
            version.setMajorVersion(AbstractApp.this._appVersionMajor);
            version.setMinorVersion(AbstractApp.this._appVersionMinor);
            outRequestHeader.setSenderVersion(version);
            outRequestHeader.setError(null);
            return outRequestHeader;
        }
    }

    protected final class EventSender<T extends IRogMessage>
    extends MessageSenderImpl<T> {
        @Override
        protected final MessageChannel getMessageChannel() {
            return AbstractApp.this._eventsChannel;
        }

        @Override
        protected final String getMessageKey(MessageHeader requestHeader) {
            return AbstractApp.this._appName;
        }

        @Override
        public final MessageHeader prepareHeader(MessageHeader requestHeader, MessageHeader eventHeader, Throwable e) {
            eventHeader.setOrigin(AbstractApp.this._appName);
            eventHeader.setSourceId(String.valueOf(AbstractApp.this._appPart));
            eventHeader.setSessionId(null);
            eventHeader.setRequestId(null);
            eventHeader.setTransactionId(requestHeader.getTransactionId());
            Version version = Version.create();
            version.setMajorVersion(AbstractApp.this._appVersionMajor);
            version.setMinorVersion(AbstractApp.this._appVersionMinor);
            eventHeader.setSenderVersion(version);
            eventHeader.setError(null);
            return eventHeader;
        }
    }

    protected final class ResponseSender<T extends IRogMessage>
    extends MessageSenderImpl<T> {
        @Override
        protected final MessageChannel getMessageChannel() {
            return AbstractApp.this._responsesChannel;
        }

        @Override
        protected final String getMessageKey(MessageHeader requestHeader) {
            return requestHeader.getSourceId() != null ? AbstractApp.this._appName + "/" + requestHeader.getSourceId() : null;
        }

        @Override
        public final MessageHeader prepareHeader(MessageHeader requestHeader, MessageHeader responseHeader, Throwable e) {
            ErrorContext errorContext;
            ErrorContext errorContext2 = errorContext = e == null ? null : ErrorContext.create();
            if (e != null) {
                if (e instanceof EServiceException) {
                    EServiceException ae = (EServiceException)e;
                    errorContext.setType(ae.getErrorType());
                    errorContext.setCode(ae.getErrorCode());
                    errorContext.setDescription(ae.getErrorDescription());
                    errorContext.setExtInfo(ae.getErrorExtInfo());
                } else {
                    errorContext.setType(ErrorType.System);
                    errorContext.setCode(ErrorCode.SystemError);
                    errorContext.setDescription(e.getMessage() == null ? e.toString() : e.getMessage());
                    errorContext.setExtInfo("See the service logs for additional information");
                }
            }
            responseHeader.setOrigin(AbstractApp.this._appName);
            if (responseHeader.getSourceId() == null) {
                responseHeader.setSourceId(requestHeader.getSourceId());
            }
            if (responseHeader.getSessionId() == null) {
                responseHeader.setSessionId(requestHeader.getSessionId());
            }
            if (responseHeader.getRequestId() == null) {
                responseHeader.setRequestId(requestHeader.getRequestId());
            }
            Version version = Version.create();
            version.setMajorVersion(AbstractApp.this._appVersionMajor);
            version.setMinorVersion(AbstractApp.this._appVersionMinor);
            responseHeader.setSenderVersion(version);
            responseHeader.setError(errorContext);
            return responseHeader;
        }
    }

    protected abstract class MessageSenderImpl<T extends IRogMessage>
    implements MessageSender<T> {
        protected MessageSenderImpl() {
        }

        protected abstract MessageChannel getMessageChannel();

        protected abstract String getMessageKey(MessageHeader var1);

        protected void writeMessageTrace(T message) {
            if (AbstractApp.this.messageTracer().debug) {
                AbstractApp.this.messageTracer().log("--> " + ((IRogJsonizable)message).toJsonString(true, null, null) + ".", Tracer.Level.DEBUG);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send(MessageHeader requestHeader, T message) {
            if (message != null) {
                this.writeMessageTrace(message);
                AepEngine aepEngine = AbstractApp.this._engine;
                synchronized (aepEngine) {
                    try {
                        MessageChannel channel = this.getMessageChannel();
                        if (AbstractApp.this._engine.getState() == AepEngine.State.Started && channel != null) {
                            AbstractApp.this.onMessageSend((MessageView)message, this instanceof ResponseSender);
                            String key = this.getMessageKey(requestHeader);
                            if (key != null) {
                                AbstractApp.this._engine.sendMessage(channel, message, key, null);
                                channel.getMessageBusBinding().flush(null);
                            }
                        } else {
                            AbstractApp.this._alerter.alert("Did not send " + message.getClass().getSimpleName() + (channel != null ? " [application is being shut down]" : " [message channel is down]"), null, Alerter.Severity.Warning);
                        }
                    }
                    catch (Exception e) {
                        AbstractApp.this._alerter.alert("Failed to send message " + message.getClass().getSimpleName() + " [" + e.getMessage() + "].", e, Alerter.Severity.Severe);
                    }
                }
            }
        }
    }

    protected static final class RequestExecutor<I extends IRogMessage & IRogCopyableNode, O extends IRogMessage, H extends MessageHandler<I, O, R>, S extends MessageSender<O>>
    implements Runnable {
        private final String _method;
        private final I _request;
        private final O _response;
        private final H _handler;
        private final S _sender;
        private final MessageHeader _requestHeader;
        private final MessageHeader _responseHeader;
        private final MessageProcessingStatsCollector.TypeStats _typeStats;
        private R _repository;
        private long _startTime;
        final /* synthetic */ AbstractApp this$0;

        public RequestExecutor(String method, I request, MessageHeader requestHeader, O response, MessageHeader responseHeader, H handler, S sender) {
            this.this$0 = this$0;
            this._method = method;
            if (handler.getType() == MessageHandler.Type.Remote) {
                this._request = (IRogMessage)((IRogCopyableNode)request).copy();
            } else {
                this._request = request;
                this._request.acquire();
            }
            this._requestHeader = requestHeader != null && handler.getType() == MessageHandler.Type.Remote ? requestHeader.copy() : requestHeader;
            this._response = response;
            this._responseHeader = responseHeader;
            this._handler = handler;
            this._sender = sender;
            this._startTime = UtlTime.now();
            this._typeStats = this$0._messageProcessingStatsCollector.getTypeStats(request.getClass());
        }

        private final void onHandlerException(String user, String method, Throwable e) {
            this.this$0._alerter.alert("FAIL {" + user + ", " + method + ", " + (e != null ? (e.getMessage() != null ? e.getMessage() : e.toString()) : "null") + "}", e, Alerter.Severity.Severe);
        }

        private final boolean internalRequest() {
            return this._request instanceof HeartbeatRequest || this._request instanceof AlertRequest || this._request instanceof FirstRequest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean execute() {
            boolean sendResponse = this._response != null && !(this._response instanceof NullMessage);
            boolean requestProcessingComplete = true;
            try {
                MessageView view = this._handler.handle(this._requestHeader == null || this.internalRequest() ? null : (this._requestHeader.getOrigin() != null ? this._requestHeader.getOrigin() : this.this$0._sessionManager.validateSession(this._requestHeader).getUser()), this._request, this._response, this._repository);
                if (view != null) {
                    if (!(view instanceof NullMessage)) {
                        this.this$0._engine.multiplexMessage((IRogMessage)view, true);
                    }
                    requestProcessingComplete = false;
                } else if (sendResponse) {
                    this._sender.prepareHeader(this._requestHeader, this._responseHeader, null);
                }
                boolean bl = true;
                return bl;
            }
            catch (Throwable e) {
                this.onHandlerException(this._requestHeader != null ? this.this$0._sessionManager.user(this._requestHeader.getSessionId()) : null, this._method, e);
                if (sendResponse) {
                    this._sender.prepareHeader(this._requestHeader, this._responseHeader, e);
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (requestProcessingComplete && sendResponse) {
                    this._response.setAsPriority();
                    this._sender.send(this._responseHeader, this._response);
                }
            }
        }

        public final void go() {
            if (this.this$0._engine.getState() == AepEngine.State.Started) {
                if (this.this$0._requestExecutor != null && this._handler.getType() == MessageHandler.Type.Remote) {
                    this.this$0.onSubmitForRemoteExecution((MessageView)this._request);
                    this._repository = null;
                    this.this$0._requestExecutor.submit(this);
                    this.this$0._threadPoolUsed.incrementAndGet();
                } else {
                    this._repository = this.this$0._engine.getApplicationState(this._request);
                    this.this$0._threadPoolUsed.incrementAndGet();
                    this.run();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            try {
                this.this$0.onMessageProcessingStart((MessageView)this._request);
                long _requestTime = UtlTime.now();
                int queueTime = (int)(_requestTime - this._startTime);
                try {
                    this._typeStats.onProcessingStart();
                    if (!this.execute()) {
                        this._typeStats.onError();
                    }
                    this._typeStats.onProcessingComplete(this._requestHeader != null ? this._requestHeader.getTransactionId() : new UUID().toString(), queueTime, (int)(UtlTime.now() - _requestTime));
                }
                catch (Throwable throwable) {
                    this._typeStats.onProcessingComplete(this._requestHeader != null ? this._requestHeader.getTransactionId() : new UUID().toString(), queueTime, (int)(UtlTime.now() - _requestTime));
                    this.this$0.onMessageProcessingComplete((MessageView)this._request);
                    this._request.dispose();
                    throw throwable;
                }
                this.this$0.onMessageProcessingComplete((MessageView)this._request);
                this._request.dispose();
            }
            finally {
                this.this$0._threadPoolUsed.decrementAndGet();
            }
        }
    }

    private final class RequestExecutorThreadFactory
    implements ThreadFactory {
        private int num;

        private RequestExecutorThreadFactory() {
        }

        @Override
        public final Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("X-Eagle-" + AbstractApp.this._agentName + "-RequestExecutor-" + ++this.num);
            return thread;
        }
    }

    private final class AlertHandler
    implements Alerter.Callout {
        private AlertHandler() {
        }

        @Override
        public final void onAlert(String headline, String str, Throwable e, Alerter.Severity severity, String classifier) {
            if (AbstractApp.this._engine != null && AbstractApp.this._engine.getState() == AepEngine.State.Started) {
                AbstractApp.this._engine.multiplexMessage((IRogMessage)AbstractApp.this._alerter.createAlertRequest(new Date(), headline, str, e, severity, classifier));
            }
        }
    }

    private final class IdentityInformationProviderImpl
    implements IdentityInformationProvider {
        private IdentityInformationProviderImpl() {
        }

        @Override
        public final String getServerName() {
            return AbstractApp.this._serverName;
        }

        @Override
        public final String getName() {
            return AbstractApp.this._appName;
        }

        @Override
        public final int getMajorVersion() {
            return AbstractApp.this._appVersionMajor;
        }

        @Override
        public final int getMinorVersion() {
            return AbstractApp.this._appVersionMinor;
        }

        @Override
        public final String getAgentName() {
            return AbstractApp.this._agentName;
        }

        @Override
        public final int getPartition() {
            return AbstractApp.this._appPart;
        }
    }

    private final class HeartbeatExecutor
    implements Runnable {
        private HeartbeatExecutor() {
        }

        @Override
        public final void run() {
            if (AbstractApp.this._engine != null && AbstractApp.this._engine.getState() == AepEngine.State.Started) {
                HeartbeatRequest request = HeartbeatRequest.create();
                request.setHeader(MessageHeader.create());
                AbstractApp.this._engine.multiplexMessage((IRogMessage)request);
            }
        }
    }

    private final class HeartbeatExecutorThreadFactory
    implements ThreadFactory {
        private int num;

        private HeartbeatExecutorThreadFactory() {
        }

        @Override
        public final Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("X-Eagle-" + AbstractApp.this._agentName + "-HeartbeatExecutor-" + ++this.num);
            return thread;
        }
    }
}

