/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.service.messages;

import com.eaio.uuid.UUID;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.neeve.adm.runtime.AdmRuntime;
import com.neeve.adm.runtime.annotations.AdmFactoryInfo;
import com.neeve.adm.runtime.annotations.AdmGenerated;
import com.neeve.ci.XRuntime;
import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XString;
import com.neeve.memory.MemoryStats;
import com.neeve.pkt.PktBody;
import com.neeve.pkt.PktBuffer;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.types.PktBodyData;
import com.neeve.quark.QuarkBuffer;
import com.neeve.quark.QuarkHeuristics;
import com.neeve.quark.QuarkString;
import com.neeve.quark.QuarkStringDeserializer;
import com.neeve.service.messages.Credentials;
import com.neeve.service.messages.ErrorContext;
import com.neeve.service.messages.IMessageHeader;
import com.neeve.service.messages.MessageFactory;
import com.neeve.service.messages.Version;
import com.neeve.util.UtlPool;
import com.neeve.xbuf2.XbufUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;

@AdmGenerated(encoding="Xbuf2", compatLevel="4.1.0", admVersion="Unknown Version", date="12/5/25 11:52 AM", buildInfo="nvx-eagle-2.9-SNAPSHOT Xbuf2 Encoding")
@AdmFactoryInfo(factoryClass=MessageFactory.class, vfid=132, ofid=132, typeId=1002)
@JsonPropertyOrder(value={"origin", "sourceId", "channelId", "sessionId", "transactionId", "requestId", "credentials", "senderVersion", "error"})
public final class MessageHeader
implements IMessageHeader,
UtlPool.Item<MessageHeader>,
AdmRuntime.BufferSizer {
    private static final MemoryStats _memoryStats = MemoryStats.getInstance();
    private static final MessageHeaderPoolFactory _messageHeaderFactory = new MessageHeaderPoolFactory();
    private static final MessageHeaderPojoPoolFactory _messageHeaderPojoFactory = new MessageHeaderPojoPoolFactory();
    private static final MessageHeaderSerializerPoolFactory _messageHeaderSerializerFactory = new MessageHeaderSerializerPoolFactory();
    private static final MessageHeaderDeserializerPoolFactory _messageHeaderDeserializerFactory = new MessageHeaderDeserializerPoolFactory();
    static final UtlPool<MessageHeader> _entityPool = UtlPool.create((String)"quark.entity", (String)"MessageHeaderQuarkEntity.-100.1002", (UtlPool.Factory)_messageHeaderFactory, (UtlPool.Params)QuarkHeuristics.configurePoolParams(MessageHeader.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new MessageHeaderPoolEvictedItemReceiver());
    static final UtlPool<Pojo> _entityPojoPool = UtlPool.create((String)"quark.entity.pojo", (String)"MessageHeaderQuarkEntityPojo.-100.1002", (UtlPool.Factory)_messageHeaderPojoFactory, (UtlPool.Params)QuarkHeuristics.configurePoolParams(Pojo.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new MessageHeaderPojoPoolEvictedItemReceiver());
    static final UtlPool<Serializer> _entitySerializerPool = UtlPool.create((String)"quark.entity.serializer", (String)"MessageHeaderQuarkEntitySerializer.-100.1002", (UtlPool.Factory)_messageHeaderSerializerFactory, (UtlPool.Params)QuarkHeuristics.configurePoolParams(Serializer.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new MessageHeaderSerializerPoolEvictedItemReceiver());
    static final UtlPool<Deserializer> _entityDeserializerPool = UtlPool.create((String)"quark.entity.deserializer", (String)"MessageHeaderQuarkEntityDeserializer.-100.1002", (UtlPool.Factory)_messageHeaderDeserializerFactory, (UtlPool.Params)QuarkHeuristics.configurePoolParams(Deserializer.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new MessageHeaderDeserializerPoolEvictedItemReceiver());
    private final AtomicInteger _ownershipCount = new AtomicInteger(1);
    private UtlPool<MessageHeader> _pool;
    private QuarkBuffer _serializedBuffer;
    private int _serializedBufferLength;
    private Serializer _serializer;
    private Deserializer _deserializer;
    private Pojo _pojo;
    private boolean readOnly;
    private boolean created = true;
    public static final MessageHeader[] EMPTY_ARRAY = new MessageHeader[0];

    MessageHeader() {
    }

    public static MessageHeader create() {
        MessageHeader entity = (MessageHeader)_entityPool.get(null);
        _memoryStats.onEntityAllocated(MessageHeader.class, MemoryStats.EntityType.EmbeddedEntity, !entity.created);
        return entity;
    }

    private final QuarkBuffer serializedBuffer(int len) {
        QuarkBuffer oldBuffer = this._serializedBuffer;
        int oldCapacity = oldBuffer != null ? oldBuffer.getCapacity() : 0;
        this._serializedBuffer = QuarkBuffer.ensureCapacity((QuarkBuffer)this._serializedBuffer, (int)len, (boolean)false);
        int newCapacity = this._serializedBuffer.getCapacity();
        if (newCapacity > oldCapacity) {
            if (oldBuffer != null) {
                _memoryStats.onEntityDataDisposed(MessageHeader.class, MemoryStats.EntityType.EmbeddedEntity, oldCapacity, true);
            }
            _memoryStats.onEntityDataAllocated(MessageHeader.class, MemoryStats.EntityType.EmbeddedEntity, newCapacity);
        }
        return this._serializedBuffer;
    }

    public final boolean hasSerializedBuffer() {
        return this._serializedBuffer != null;
    }

    @JsonIgnore
    public final QuarkBuffer getSerializedBuffer() {
        return this._serializedBuffer;
    }

    @Deprecated
    @JsonIgnore
    public final QuarkBuffer getBackingBuffer() {
        return this.getSerializedBuffer();
    }

    final void setSerializedBufferLength(int val) {
        this._serializedBufferLength = val;
    }

    @JsonIgnore
    public final int getSerializedBufferLength() {
        return this._serializedBufferLength;
    }

    @Deprecated
    @JsonIgnore
    public final int getSerializeToNativeLength() {
        return this.getSerializedBufferLength();
    }

    public final Serializer serializer(int length, boolean autoResizeTargetBuffer) {
        if (this._serializer == null) {
            this._serializer = Serializer.create();
        }
        this.serializedBuffer(length);
        if (autoResizeTargetBuffer) {
            this._serializer.setSizer(this);
        }
        return this._serializer.init(this);
    }

    public final Serializer serializer(int minimumLength) {
        return this.serializer(minimumLength, true);
    }

    public final Serializer serializer() {
        return this.serializer(1024, true);
    }

    public final long ensureCapacity(long addr, int capacity) {
        if (capacity <= this._serializedBufferLength) {
            return addr;
        }
        int newLength = capacity <= this._serializedBuffer.getCapacity() ? capacity : Math.max(capacity, this._serializedBuffer.getCapacity() * 2);
        this._serializedBuffer = QuarkBuffer.ensureCapacity((QuarkBuffer)this._serializedBuffer, (int)newLength, (boolean)true);
        return this._serializedBuffer.getNativeAddress();
    }

    public final Deserializer deserializer(boolean createBuffer) {
        if (!this.hasSerializedBuffer() && createBuffer) {
            this.serializedBuffer(0);
        }
        if (!this.hasSerializedBuffer()) {
            throw new IllegalStateException("no backing serialized buffer");
        }
        if (this._deserializer == null) {
            this._deserializer = Deserializer.create();
        }
        return this._deserializer.init(this._serializedBuffer, 0, this._serializedBufferLength);
    }

    public final Deserializer deserializer() {
        return this.deserializer(false);
    }

    public final boolean hasPojo() {
        return this._pojo != null && this._pojo.isInitialized();
    }

    public final boolean hasDirtyPojo() {
        return this.hasPojo() && this._pojo.isDirty();
    }

    public final Pojo pojo() {
        if (this._pojo == null) {
            this._pojo = Pojo.create();
        }
        if (!this._pojo.isInitialized()) {
            if (this.hasSerializedBuffer()) {
                this._pojo.deserialize(this.deserializer());
                this._pojo.clearDirty();
            } else {
                this._pojo.setInitialized();
            }
            if (this.readOnly) {
                this._pojo.setAsReadOnly();
            }
        }
        return this._pojo;
    }

    public final void disposeSerializedBuffer() {
        if (this._serializedBuffer != null) {
            int capacity = this._serializedBuffer.getCapacity();
            this._serializedBuffer.dispose();
            _memoryStats.onEntityDataDisposed(MessageHeader.class, MemoryStats.EntityType.EmbeddedEntity, capacity, true);
            this._serializedBuffer = null;
            this._serializedBufferLength = 0;
        }
    }

    public final void disposeSerializer() {
        if (this._serializer != null) {
            this._serializer.dispose();
            this._serializer = null;
        }
    }

    public final void disposeDeserializer() {
        if (this._deserializer != null) {
            this._deserializer.dispose();
            this._deserializer = null;
        }
    }

    public final void disposePojo(boolean sync) {
        if (sync) {
            this.sync();
        }
        if (this._pojo != null) {
            this._pojo.dispose();
            this._pojo = null;
        }
    }

    public final void disposePojo() {
        this.disposePojo(false);
    }

    private final void conserveMemory() {
        this.sync();
        this.disposeSerializer();
        this.disposeDeserializer();
        this.disposePojo(false);
    }

    public final void clear(boolean disposeMembers) {
        if (this._pojo != null) {
            if (disposeMembers) {
                this.disposePojo(false);
            } else {
                this._pojo.reset();
            }
        }
        if (disposeMembers) {
            this.disposeSerializedBuffer();
        } else {
            this._serializedBufferLength = 0;
        }
        this.readOnly = false;
    }

    public final void clear() {
        this.clear(false);
    }

    @Deprecated
    public final void clearContent() {
        this.clear();
    }

    public final void reset(boolean disposeMembers) {
        this.clear(disposeMembers);
        if (disposeMembers) {
            this.disposeSerializer();
            this.disposeDeserializer();
        }
    }

    public final void reset() {
        this.reset(XRuntime.optimizeMemoryUsage());
    }

    public final String serializeToRawJson() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            MessageFactory.mapper.writeValue((OutputStream)baos, (Object)this);
            return new String(baos.toByteArray(), "utf-8");
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public final int serializeTo(Serializer serializer) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            serializer.putFrom(this._serializedBuffer, 0, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final int serializeTo(QuarkBuffer buffer, int offset) {
        this.sync();
        if (this._serializedBufferLength > buffer.getLength() - offset) {
            throw new IllegalArgumentException("buffer too small");
        }
        if (this.hasSerializedBuffer()) {
            this._serializedBuffer.getTo(0, buffer, offset, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final void sync() {
        if (!this.hasDirtyPojo()) {
            return;
        }
        this._serializedBufferLength = this._pojo.serialize(this.serializer(this._pojo.getSerializedLength(), false));
        this._pojo.clearDirty();
    }

    public final byte[] serializeToByteArray() {
        this.sync();
        byte[] array = new byte[this._serializedBufferLength];
        this.serializeTo(array, 0);
        return array;
    }

    public final int serializeTo(byte[] array, int offset) {
        this.sync();
        if (this._serializedBufferLength > array.length - offset) {
            throw new IllegalArgumentException("array too small");
        }
        if (this.hasSerializedBuffer()) {
            this._serializedBuffer.getTo(0, array, offset, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final ByteBuffer serializeToByteBuffer() {
        this.sync();
        ByteBuffer buffer = ByteBuffer.allocate(this._serializedBufferLength);
        this.serializeTo(buffer);
        return buffer;
    }

    public final int serializeTo(ByteBuffer buffer) {
        this.sync();
        if (this._serializedBufferLength > buffer.capacity() - buffer.position()) {
            throw new IllegalArgumentException("buffer too small");
        }
        buffer.limit(buffer.position() + this._serializedBufferLength);
        if (this.hasSerializedBuffer()) {
            this._serializedBuffer.getTo(0, buffer, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final IOBuffer serializeToIOBuffer(boolean useNative) {
        this.sync();
        IOBuffer buffer = IOBuffer.create((int)this._serializedBufferLength, (boolean)useNative);
        this.serializeTo(buffer, 0);
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int serializeTo(IOBuffer buffer, int offset) {
        this.sync();
        ByteBuffer bytebuf = buffer.takeBuffer();
        try {
            bytebuf.limit(bytebuf.capacity());
            bytebuf.position(offset);
            int n = this.serializeTo(bytebuf);
            return n;
        }
        finally {
            buffer.releaseBuffer();
        }
    }

    public final int serializeTo(IOElasticBuffer buffer, int offset) {
        this.sync();
        buffer.setLength(offset + this._serializedBufferLength);
        return this.serializeTo(buffer.getIOBuffer(), buffer.getOffset() + offset);
    }

    public final PktPacket serializeToPacket() {
        PktPacket packet = PktFactory.getInstance().createPacket(257);
        this.serializeTo(packet);
        return packet;
    }

    public final int serializeTo(PktPacket packet) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            packet.getBody().deserialize(this._serializedBuffer, 0, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final int serializeTo(long addr, int offset) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            this._serializedBuffer.getTo(0, addr, offset, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    @Deprecated
    public final int serializeToNative(long addr, int offset) {
        return this.serializeTo(addr, offset);
    }

    public final String serializeToJson() {
        return this.serializeToRawJson();
    }

    public final MessageHeader deserializeFromRawJson(String json) {
        try {
            MessageFactory.mapper.reader().withValueToUpdate((Object)this).readValue(json);
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final MessageHeader deserializeFrom(Deserializer deserializer) {
        if (!deserializer.isInitialized()) {
            throw new IllegalArgumentException("can only deserialize from an initialized deserializer");
        }
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this._serializedBufferLength = 0;
        if (deserializer != null) {
            this._serializedBufferLength = deserializer.getSerializedLength();
            deserializer.getTo(this.serializedBuffer(this._serializedBufferLength), 0);
        }
        return this;
    }

    public final MessageHeader deserializeFrom(MessageHeader val) {
        return this.deserializeFrom(val.getSerializedBuffer(), 0, val.getSerializedBufferLength());
    }

    public final MessageHeader deserializeFrom(QuarkBuffer buffer, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = buffer != null ? len : 0;
        if (buffer != null) {
            this.serializedBuffer(len).putFrom(0, buffer, offset, len);
        }
        return this;
    }

    public final MessageHeader wrap(QuarkBuffer buffer, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this.disposeSerializedBuffer();
        this._serializedBuffer = buffer;
        this._serializedBufferLength = len;
        return this;
    }

    public final MessageHeader deserializeFromByteArray(byte[] array) {
        return this.deserializeFrom(array, 0, array.length);
    }

    public final MessageHeader deserializeFrom(byte[] array, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = array != null ? len : 0;
        if (array != null) {
            this.serializedBuffer(len).putFrom(0, array, offset, len);
        }
        return this;
    }

    public final MessageHeader deserializeFromByteBuffer(ByteBuffer buffer) {
        return this.deserializeFrom(buffer);
    }

    public final MessageHeader deserializeFrom(ByteBuffer buffer) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = buffer != null ? buffer.remaining() : 0;
        if (buffer != null) {
            this.serializedBuffer(this._serializedBufferLength).putFrom(0, buffer);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MessageHeader deserializeFrom(IOBuffer buffer, int offset, int len) {
        if (buffer == null) {
            return this.deserializeFrom((ByteBuffer)null);
        }
        ByteBuffer bytebuf = buffer.takeBuffer();
        try {
            bytebuf.limit(offset + len).position(offset);
            MessageHeader messageHeader = this.deserializeFrom(bytebuf);
            return messageHeader;
        }
        finally {
            buffer.releaseBuffer();
        }
    }

    public final MessageHeader deserializeFrom(IOElasticBuffer buffer, int offset, int len) {
        return this.deserializeFrom(buffer.getIOBuffer(), buffer.getOffset() + offset, len);
    }

    public final MessageHeader deserializeFromPacket(PktPacket packet) {
        return this.deserializeFrom(packet);
    }

    public final MessageHeader deserializeFrom(PktPacket packet) {
        try {
            PktBuffer buffer = packet.getBody().getBuffer();
            MessageHeader messageHeader = this.deserializeFrom((IOElasticBuffer)buffer, 0, buffer.getLength());
            return messageHeader;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            packet.dispose();
        }
    }

    public final MessageHeader deserializeFrom(long addr, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this._serializedBufferLength = len;
        this.serializedBuffer(this._serializedBufferLength).putFrom(0, addr, offset, len);
        return this;
    }

    @Deprecated
    public final MessageHeader deserializeFromNative(long addr, int offset, int len) {
        return this.deserializeFrom(addr, offset, len);
    }

    public final MessageHeader deserializeFromJson(String json) {
        this.deserializeFromRawJson(json);
        return this;
    }

    public final void copyInto(MessageHeader copy) {
        copy.clear();
        this.sync();
        copy.deserializeFrom(this._serializedBuffer, 0, this._serializedBufferLength);
    }

    public final MessageHeader copy() {
        MessageHeader copy = MessageHeader.create();
        this.copyInto(copy);
        return copy;
    }

    public final void setAsReadOnly() {
        this.readOnly = true;
        if (this._pojo != null) {
            this._pojo.setAsReadOnly();
        }
    }

    public static final int getOriginFieldId() {
        return 32752;
    }

    @Override
    @JsonProperty(value="origin")
    public final void setOrigin(String val) {
        this.pojo().setOriginFrom(val);
    }

    @Override
    @JsonProperty(value="origin")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final String getOrigin() {
        if (!this.hasOrigin()) {
            return null;
        }
        return this.pojo()._usrOrigin.getValue();
    }

    @Override
    @JsonIgnore
    public final void lendOrigin(XString val) {
        if (val == null || !val.isInitialized() || val.isNull()) {
            this.setOrigin(null);
            return;
        }
        if (!val.isImmutable()) {
            throw new IllegalArgumentException("value is mutable");
        }
        this.pojo().setOriginFrom(val);
    }

    @Override
    @JsonIgnore
    public final void setOriginFrom(long val) {
        this.pojo().setOriginFrom(val);
    }

    @Override
    @JsonIgnore
    public final <T extends XString> T getOriginTo(XString.Factory<T> factory) {
        XString to = factory.create(false);
        this.pojo().getOriginTo(to);
        return (T)to;
    }

    @Override
    @JsonIgnore
    public final void setOriginFrom(XString val) {
        this.pojo().setOriginFrom(val);
    }

    @Override
    @JsonIgnore
    public final void getOriginTo(XString val) {
        this.pojo().getOriginTo(val);
    }

    @Override
    @JsonIgnore
    public final XString getOriginUnsafe() {
        return this.pojo().getOrigin();
    }

    @Override
    public final boolean hasOrigin() {
        return this.pojo().hasOrigin();
    }

    @Override
    public final void clearOrigin() {
        this.pojo().clearOrigin();
    }

    public static final int getSourceIdFieldId() {
        return 32751;
    }

    @Override
    @JsonProperty(value="sourceId")
    public final void setSourceId(String val) {
        this.pojo().setSourceIdFrom(val);
    }

    @Override
    @JsonProperty(value="sourceId")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final String getSourceId() {
        if (!this.hasSourceId()) {
            return null;
        }
        return this.pojo()._usrSourceId.getValue();
    }

    @Override
    @JsonIgnore
    public final void lendSourceId(XString val) {
        if (val == null || !val.isInitialized() || val.isNull()) {
            this.setSourceId(null);
            return;
        }
        if (!val.isImmutable()) {
            throw new IllegalArgumentException("value is mutable");
        }
        this.pojo().setSourceIdFrom(val);
    }

    @Override
    @JsonIgnore
    public final void setSourceIdFrom(long val) {
        this.pojo().setSourceIdFrom(val);
    }

    @Override
    @JsonIgnore
    public final <T extends XString> T getSourceIdTo(XString.Factory<T> factory) {
        XString to = factory.create(false);
        this.pojo().getSourceIdTo(to);
        return (T)to;
    }

    @Override
    @JsonIgnore
    public final void setSourceIdFrom(XString val) {
        this.pojo().setSourceIdFrom(val);
    }

    @Override
    @JsonIgnore
    public final void getSourceIdTo(XString val) {
        this.pojo().getSourceIdTo(val);
    }

    @Override
    @JsonIgnore
    public final XString getSourceIdUnsafe() {
        return this.pojo().getSourceId();
    }

    @Override
    public final boolean hasSourceId() {
        return this.pojo().hasSourceId();
    }

    @Override
    public final void clearSourceId() {
        this.pojo().clearSourceId();
    }

    public static final int getChannelIdFieldId() {
        return 32744;
    }

    @Override
    @JsonProperty(value="channelId")
    public final void setChannelId(String val) {
        this.pojo().setChannelIdFrom(val);
    }

    @Override
    @JsonProperty(value="channelId")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final String getChannelId() {
        if (!this.hasChannelId()) {
            return null;
        }
        return this.pojo()._usrChannelId.getValue();
    }

    @Override
    @JsonIgnore
    public final void lendChannelId(XString val) {
        if (val == null || !val.isInitialized() || val.isNull()) {
            this.setChannelId(null);
            return;
        }
        if (!val.isImmutable()) {
            throw new IllegalArgumentException("value is mutable");
        }
        this.pojo().setChannelIdFrom(val);
    }

    @Override
    @JsonIgnore
    public final void setChannelIdFrom(long val) {
        this.pojo().setChannelIdFrom(val);
    }

    @Override
    @JsonIgnore
    public final <T extends XString> T getChannelIdTo(XString.Factory<T> factory) {
        XString to = factory.create(false);
        this.pojo().getChannelIdTo(to);
        return (T)to;
    }

    @Override
    @JsonIgnore
    public final void setChannelIdFrom(XString val) {
        this.pojo().setChannelIdFrom(val);
    }

    @Override
    @JsonIgnore
    public final void getChannelIdTo(XString val) {
        this.pojo().getChannelIdTo(val);
    }

    @Override
    @JsonIgnore
    public final XString getChannelIdUnsafe() {
        return this.pojo().getChannelId();
    }

    @Override
    public final boolean hasChannelId() {
        return this.pojo().hasChannelId();
    }

    @Override
    public final void clearChannelId() {
        this.pojo().clearChannelId();
    }

    public static final int getSessionIdFieldId() {
        return 32750;
    }

    @Override
    @JsonProperty(value="sessionId")
    public final void setSessionId(String val) {
        this.pojo().setSessionIdFrom(val);
    }

    @Override
    @JsonProperty(value="sessionId")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final String getSessionId() {
        if (!this.hasSessionId()) {
            return null;
        }
        return this.pojo()._usrSessionId.getValue();
    }

    @Override
    @JsonIgnore
    public final void lendSessionId(XString val) {
        if (val == null || !val.isInitialized() || val.isNull()) {
            this.setSessionId(null);
            return;
        }
        if (!val.isImmutable()) {
            throw new IllegalArgumentException("value is mutable");
        }
        this.pojo().setSessionIdFrom(val);
    }

    @Override
    @JsonIgnore
    public final void setSessionIdFrom(long val) {
        this.pojo().setSessionIdFrom(val);
    }

    @Override
    @JsonIgnore
    public final <T extends XString> T getSessionIdTo(XString.Factory<T> factory) {
        XString to = factory.create(false);
        this.pojo().getSessionIdTo(to);
        return (T)to;
    }

    @Override
    @JsonIgnore
    public final void setSessionIdFrom(XString val) {
        this.pojo().setSessionIdFrom(val);
    }

    @Override
    @JsonIgnore
    public final void getSessionIdTo(XString val) {
        this.pojo().getSessionIdTo(val);
    }

    @Override
    @JsonIgnore
    public final XString getSessionIdUnsafe() {
        return this.pojo().getSessionId();
    }

    @Override
    public final boolean hasSessionId() {
        return this.pojo().hasSessionId();
    }

    @Override
    public final void clearSessionId() {
        this.pojo().clearSessionId();
    }

    public static final int getTransactionIdFieldId() {
        return 32749;
    }

    @Override
    @JsonProperty(value="transactionId")
    public final void setTransactionId(String val) {
        this.pojo().setTransactionIdFrom(val);
    }

    @Override
    @JsonProperty(value="transactionId")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final String getTransactionId() {
        if (!this.hasTransactionId()) {
            return null;
        }
        return this.pojo()._usrTransactionId.getValue();
    }

    @Override
    @JsonIgnore
    public final void lendTransactionId(XString val) {
        if (val == null || !val.isInitialized() || val.isNull()) {
            this.setTransactionId(null);
            return;
        }
        if (!val.isImmutable()) {
            throw new IllegalArgumentException("value is mutable");
        }
        this.pojo().setTransactionIdFrom(val);
    }

    @Override
    @JsonIgnore
    public final void setTransactionIdFrom(long val) {
        this.pojo().setTransactionIdFrom(val);
    }

    @Override
    @JsonIgnore
    public final <T extends XString> T getTransactionIdTo(XString.Factory<T> factory) {
        XString to = factory.create(false);
        this.pojo().getTransactionIdTo(to);
        return (T)to;
    }

    @Override
    @JsonIgnore
    public final void setTransactionIdFrom(XString val) {
        this.pojo().setTransactionIdFrom(val);
    }

    @Override
    @JsonIgnore
    public final void getTransactionIdTo(XString val) {
        this.pojo().getTransactionIdTo(val);
    }

    @Override
    @JsonIgnore
    public final XString getTransactionIdUnsafe() {
        return this.pojo().getTransactionId();
    }

    @Override
    public final boolean hasTransactionId() {
        return this.pojo().hasTransactionId();
    }

    @Override
    public final void clearTransactionId() {
        this.pojo().clearTransactionId();
    }

    public static final int getRequestIdFieldId() {
        return 32748;
    }

    @Override
    @JsonProperty(value="requestId")
    public final void setRequestId(String val) {
        this.pojo().setRequestIdFrom(val);
    }

    @Override
    @JsonProperty(value="requestId")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final String getRequestId() {
        if (!this.hasRequestId()) {
            return null;
        }
        return this.pojo()._usrRequestId.getValue();
    }

    @Override
    @JsonIgnore
    public final void lendRequestId(XString val) {
        if (val == null || !val.isInitialized() || val.isNull()) {
            this.setRequestId(null);
            return;
        }
        if (!val.isImmutable()) {
            throw new IllegalArgumentException("value is mutable");
        }
        this.pojo().setRequestIdFrom(val);
    }

    @Override
    @JsonIgnore
    public final void setRequestIdFrom(long val) {
        this.pojo().setRequestIdFrom(val);
    }

    @Override
    @JsonIgnore
    public final <T extends XString> T getRequestIdTo(XString.Factory<T> factory) {
        XString to = factory.create(false);
        this.pojo().getRequestIdTo(to);
        return (T)to;
    }

    @Override
    @JsonIgnore
    public final void setRequestIdFrom(XString val) {
        this.pojo().setRequestIdFrom(val);
    }

    @Override
    @JsonIgnore
    public final void getRequestIdTo(XString val) {
        this.pojo().getRequestIdTo(val);
    }

    @Override
    @JsonIgnore
    public final XString getRequestIdUnsafe() {
        return this.pojo().getRequestId();
    }

    @Override
    public final boolean hasRequestId() {
        return this.pojo().hasRequestId();
    }

    @Override
    public final void clearRequestId() {
        this.pojo().clearRequestId();
    }

    public static final int getCredentialsFieldId() {
        return 32747;
    }

    @Override
    @JsonProperty(value="credentials")
    public final void setCredentials(Credentials val) {
        this.pojo().setCredentials(val);
    }

    @Override
    public final void lendCredentials(Credentials val) {
        this.pojo().lendCredentials(val);
    }

    @Override
    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Credentials getCredentials() {
        return this.pojo().getCredentials();
    }

    @Override
    @JsonIgnore
    public final void getCredentialsTo(Credentials to) {
        this.pojo().getCredentialsTo(to);
    }

    @Override
    public final Credentials takeCredentials() {
        return this.pojo().takeCredentials();
    }

    @Override
    public final boolean hasCredentials() {
        return this.pojo().hasCredentials();
    }

    @Override
    public final void clearCredentials() {
        this.pojo().clearCredentials();
    }

    public static final int getSenderVersionFieldId() {
        return 32746;
    }

    @Override
    @JsonProperty(value="senderVersion")
    public final void setSenderVersion(Version val) {
        this.pojo().setSenderVersion(val);
    }

    @Override
    public final void lendSenderVersion(Version val) {
        this.pojo().lendSenderVersion(val);
    }

    @Override
    @JsonProperty(value="senderVersion")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Version getSenderVersion() {
        return this.pojo().getSenderVersion();
    }

    @Override
    @JsonIgnore
    public final void getSenderVersionTo(Version to) {
        this.pojo().getSenderVersionTo(to);
    }

    @Override
    public final Version takeSenderVersion() {
        return this.pojo().takeSenderVersion();
    }

    @Override
    public final boolean hasSenderVersion() {
        return this.pojo().hasSenderVersion();
    }

    @Override
    public final void clearSenderVersion() {
        this.pojo().clearSenderVersion();
    }

    public static final int getErrorFieldId() {
        return 32745;
    }

    @Override
    @JsonProperty(value="error")
    public final void setError(ErrorContext val) {
        this.pojo().setError(val);
    }

    @Override
    public final void lendError(ErrorContext val) {
        this.pojo().lendError(val);
    }

    @Override
    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final ErrorContext getError() {
        return this.pojo().getError();
    }

    @Override
    @JsonIgnore
    public final void getErrorTo(ErrorContext to) {
        this.pojo().getErrorTo(to);
    }

    @Override
    public final ErrorContext takeError() {
        return this.pojo().takeError();
    }

    @Override
    public final boolean hasError() {
        return this.pojo().hasError();
    }

    @Override
    public final void clearError() {
        this.pojo().clearError();
    }

    public final MessageHeader init() {
        this.reset();
        this._ownershipCount.set(1);
        return this;
    }

    public final MessageHeader setPool(UtlPool<MessageHeader> pool) {
        this._pool = pool;
        return this;
    }

    public final UtlPool<MessageHeader> getPool() {
        return this._pool;
    }

    public final MessageHeader acquire() {
        int val = this._ownershipCount.incrementAndGet();
        if (val <= 1 && this._pool != null) {
            throw new IllegalStateException("attempt to acquire an already disposed entity");
        }
        return this;
    }

    public final int getOwnershipCount() {
        return this._ownershipCount.get();
    }

    public final void dispose() {
        int val = this._ownershipCount.decrementAndGet();
        if (val < 0 && this._pool != null) {
            throw new IllegalStateException("attempt to dispose an already disposed entity");
        }
        if (val == 0 && this._pool != null) {
            this.created = false;
            this._pool.put((UtlPool.Item)this);
            _memoryStats.onEntityDisposed(MessageHeader.class, MemoryStats.EntityType.EmbeddedEntity, true);
        }
    }

    public final Object clone() {
        Credentials cloner_credentials;
        MessageHeader clonee = MessageHeader.create();
        if (this.hasOrigin()) {
            clonee.setOrigin(this.getOrigin());
        }
        if (this.hasSourceId()) {
            clonee.setSourceId(this.getSourceId());
        }
        if (this.hasChannelId()) {
            clonee.setChannelId(this.getChannelId());
        }
        if (this.hasSessionId()) {
            clonee.setSessionId(this.getSessionId());
        }
        if (this.hasTransactionId()) {
            clonee.setTransactionId(this.getTransactionId());
        }
        if (this.hasRequestId()) {
            clonee.setRequestId(this.getRequestId());
        }
        if ((cloner_credentials = this.getCredentials()) != null) {
            clonee.setCredentials((Credentials)cloner_credentials.clone());
        } else {
            clonee.setCredentials(null);
        }
        Version cloner_senderVersion = this.getSenderVersion();
        if (cloner_senderVersion != null) {
            clonee.setSenderVersion((Version)cloner_senderVersion.clone());
        } else {
            clonee.setSenderVersion(null);
        }
        ErrorContext cloner_error = this.getError();
        if (cloner_error != null) {
            clonee.setError((ErrorContext)cloner_error.clone());
        } else {
            clonee.setError(null);
        }
        return clonee;
    }

    public final boolean isValid() {
        return true;
    }

    public final void getValidationErrors(List<XString> results, String errorPrefix) {
    }

    public final String toString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HH:mm:ss.SSS");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        int c = 0;
        if (this.hasOrigin()) {
            builder.append(0 == c++ ? "" : ",").append("Origin=").append(this.getOrigin());
        }
        if (this.hasSourceId()) {
            builder.append(0 == c++ ? "" : ",").append("SourceId=").append(this.getSourceId());
        }
        if (this.hasChannelId()) {
            builder.append(0 == c++ ? "" : ",").append("ChannelId=").append(this.getChannelId());
        }
        if (this.hasSessionId()) {
            builder.append(0 == c++ ? "" : ",").append("SessionId=").append(this.getSessionId());
        }
        if (this.hasTransactionId()) {
            builder.append(0 == c++ ? "" : ",").append("TransactionId=").append(this.getTransactionId());
        }
        if (this.hasRequestId()) {
            builder.append(0 == c++ ? "" : ",").append("RequestId=").append(this.getRequestId());
        }
        if (this.hasCredentials()) {
            builder.append(0 == c++ ? "" : ",").append("Credentials=").append(this.getCredentials());
        }
        if (this.hasSenderVersion()) {
            builder.append(0 == c++ ? "" : ",").append("SenderVersion=").append(this.getSenderVersion());
        }
        if (this.hasError()) {
            builder.append(0 == c++ ? "" : ",").append("Error=").append(this.getError());
        }
        builder.append("}");
        return builder.toString();
    }

    public static final class Pojo
    implements UtlPool.Item<Pojo> {
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final MemoryStats _memoryStats = MemoryStats.getInstance();
        private final long[] _fieldBitmask = new long[1];
        private final DeserializationCallback _deserializationCallback = new DeserializationCallback();
        private UtlPool<Pojo> _pool;
        private boolean _initialized;
        private boolean _readonly;
        private boolean _dirty;
        private byte _flags;
        private XString _usrOrigin = XString.create((int)0, (boolean)true, (boolean)true);
        private XString _usrSourceId = XString.create((int)0, (boolean)true, (boolean)true);
        private XString _usrChannelId = XString.create((int)0, (boolean)true, (boolean)true);
        private XString _usrSessionId = XString.create((int)0, (boolean)true, (boolean)true);
        private XString _usrTransactionId = XString.create((int)0, (boolean)true, (boolean)true);
        private XString _usrRequestId = XString.create((int)0, (boolean)true, (boolean)true);
        private Credentials _usrCredentials;
        private Version _usrSenderVersion;
        private ErrorContext _usrError;

        Pojo() {
            this.setCreated();
        }

        public static final Pojo create(boolean pvt) {
            Pojo pojo = (Pojo)_entityPojoPool.get(null);
            if (pvt) {
                pojo.setPrivate();
            } else {
                pojo.clearPrivate();
                _memoryStats.onEntityPojoAllocated(MessageHeader.class, MemoryStats.EntityType.EmbeddedEntity, !pojo.isCreated());
            }
            return pojo.clearPooled();
        }

        public static final Pojo create() {
            return Pojo.create(false);
        }

        public final boolean hasOrigin() {
            return (this._fieldBitmask[0] & 1L) != 0L;
        }

        public final XString getOrigin() {
            if (!this.hasOrigin() || this._usrOrigin.isNull()) {
                return null;
            }
            return this._usrOrigin;
        }

        public final void getOriginTo(XString val) {
            if (!this.hasOrigin() || this._usrOrigin.isNull()) {
                val.clear();
                return;
            }
            val.setValue(this._usrOrigin);
        }

        public final void setOriginFrom(String val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearOrigin();
                return;
            }
            this._usrOrigin.setValue(val);
            if (!this.hasOrigin()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 1L;
            }
            this._dirty = true;
        }

        public final void setOriginFrom(XString val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.isNull()) {
                this.clearOrigin();
                return;
            }
            this._usrOrigin.setValue(val);
            if (!this.hasOrigin()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 1L;
            }
            this._dirty = true;
        }

        public final void setOriginFrom(CharSequence val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearOrigin();
                return;
            }
            this._usrOrigin.setValue(val);
            if (!this.hasOrigin()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 1L;
            }
            this._dirty = true;
        }

        public final void setOriginFrom(long val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            this._usrOrigin.setValue(val);
            if (!this.hasOrigin()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 1L;
            }
            this._dirty = true;
        }

        public final void setOriginFrom(byte[] val, int offset, int len) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearOrigin();
                return;
            }
            this._usrOrigin.setValue(val, offset, len);
            if (!this.hasOrigin()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 1L;
            }
            this._dirty = true;
        }

        public final void setOriginFrom(QuarkString val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.isNull()) {
                this.clearOrigin();
                return;
            }
            val.getTo(this._usrOrigin);
            if (!this.hasOrigin()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 1L;
            }
            this._dirty = true;
        }

        public final void setOriginFrom(QuarkStringDeserializer val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearOrigin();
                return;
            }
            val.getTo(this._usrOrigin);
            if (!this.hasOrigin()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 1L;
            }
            this._dirty = true;
        }

        public final void clearOrigin() {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasOrigin()) {
                return;
            }
            this._usrOrigin.reset();
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFFEL;
            this._dirty = true;
        }

        public final boolean hasSourceId() {
            return (this._fieldBitmask[0] & 2L) != 0L;
        }

        public final XString getSourceId() {
            if (!this.hasSourceId() || this._usrSourceId.isNull()) {
                return null;
            }
            return this._usrSourceId;
        }

        public final void getSourceIdTo(XString val) {
            if (!this.hasSourceId() || this._usrSourceId.isNull()) {
                val.clear();
                return;
            }
            val.setValue(this._usrSourceId);
        }

        public final void setSourceIdFrom(String val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearSourceId();
                return;
            }
            this._usrSourceId.setValue(val);
            if (!this.hasSourceId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 2L;
            }
            this._dirty = true;
        }

        public final void setSourceIdFrom(XString val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.isNull()) {
                this.clearSourceId();
                return;
            }
            this._usrSourceId.setValue(val);
            if (!this.hasSourceId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 2L;
            }
            this._dirty = true;
        }

        public final void setSourceIdFrom(CharSequence val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearSourceId();
                return;
            }
            this._usrSourceId.setValue(val);
            if (!this.hasSourceId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 2L;
            }
            this._dirty = true;
        }

        public final void setSourceIdFrom(long val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            this._usrSourceId.setValue(val);
            if (!this.hasSourceId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 2L;
            }
            this._dirty = true;
        }

        public final void setSourceIdFrom(byte[] val, int offset, int len) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearSourceId();
                return;
            }
            this._usrSourceId.setValue(val, offset, len);
            if (!this.hasSourceId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 2L;
            }
            this._dirty = true;
        }

        public final void setSourceIdFrom(QuarkString val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.isNull()) {
                this.clearSourceId();
                return;
            }
            val.getTo(this._usrSourceId);
            if (!this.hasSourceId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 2L;
            }
            this._dirty = true;
        }

        public final void setSourceIdFrom(QuarkStringDeserializer val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearSourceId();
                return;
            }
            val.getTo(this._usrSourceId);
            if (!this.hasSourceId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 2L;
            }
            this._dirty = true;
        }

        public final void clearSourceId() {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasSourceId()) {
                return;
            }
            this._usrSourceId.reset();
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFFDL;
            this._dirty = true;
        }

        public final boolean hasChannelId() {
            return (this._fieldBitmask[0] & 4L) != 0L;
        }

        public final XString getChannelId() {
            if (!this.hasChannelId() || this._usrChannelId.isNull()) {
                return null;
            }
            return this._usrChannelId;
        }

        public final void getChannelIdTo(XString val) {
            if (!this.hasChannelId() || this._usrChannelId.isNull()) {
                val.clear();
                return;
            }
            val.setValue(this._usrChannelId);
        }

        public final void setChannelIdFrom(String val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearChannelId();
                return;
            }
            this._usrChannelId.setValue(val);
            if (!this.hasChannelId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 4L;
            }
            this._dirty = true;
        }

        public final void setChannelIdFrom(XString val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.isNull()) {
                this.clearChannelId();
                return;
            }
            this._usrChannelId.setValue(val);
            if (!this.hasChannelId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 4L;
            }
            this._dirty = true;
        }

        public final void setChannelIdFrom(CharSequence val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearChannelId();
                return;
            }
            this._usrChannelId.setValue(val);
            if (!this.hasChannelId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 4L;
            }
            this._dirty = true;
        }

        public final void setChannelIdFrom(long val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            this._usrChannelId.setValue(val);
            if (!this.hasChannelId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 4L;
            }
            this._dirty = true;
        }

        public final void setChannelIdFrom(byte[] val, int offset, int len) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearChannelId();
                return;
            }
            this._usrChannelId.setValue(val, offset, len);
            if (!this.hasChannelId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 4L;
            }
            this._dirty = true;
        }

        public final void setChannelIdFrom(QuarkString val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.isNull()) {
                this.clearChannelId();
                return;
            }
            val.getTo(this._usrChannelId);
            if (!this.hasChannelId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 4L;
            }
            this._dirty = true;
        }

        public final void setChannelIdFrom(QuarkStringDeserializer val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearChannelId();
                return;
            }
            val.getTo(this._usrChannelId);
            if (!this.hasChannelId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 4L;
            }
            this._dirty = true;
        }

        public final void clearChannelId() {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasChannelId()) {
                return;
            }
            this._usrChannelId.reset();
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFFBL;
            this._dirty = true;
        }

        public final boolean hasSessionId() {
            return (this._fieldBitmask[0] & 8L) != 0L;
        }

        public final XString getSessionId() {
            if (!this.hasSessionId() || this._usrSessionId.isNull()) {
                return null;
            }
            return this._usrSessionId;
        }

        public final void getSessionIdTo(XString val) {
            if (!this.hasSessionId() || this._usrSessionId.isNull()) {
                val.clear();
                return;
            }
            val.setValue(this._usrSessionId);
        }

        public final void setSessionIdFrom(String val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearSessionId();
                return;
            }
            this._usrSessionId.setValue(val);
            if (!this.hasSessionId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 8L;
            }
            this._dirty = true;
        }

        public final void setSessionIdFrom(XString val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.isNull()) {
                this.clearSessionId();
                return;
            }
            this._usrSessionId.setValue(val);
            if (!this.hasSessionId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 8L;
            }
            this._dirty = true;
        }

        public final void setSessionIdFrom(CharSequence val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearSessionId();
                return;
            }
            this._usrSessionId.setValue(val);
            if (!this.hasSessionId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 8L;
            }
            this._dirty = true;
        }

        public final void setSessionIdFrom(long val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            this._usrSessionId.setValue(val);
            if (!this.hasSessionId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 8L;
            }
            this._dirty = true;
        }

        public final void setSessionIdFrom(byte[] val, int offset, int len) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearSessionId();
                return;
            }
            this._usrSessionId.setValue(val, offset, len);
            if (!this.hasSessionId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 8L;
            }
            this._dirty = true;
        }

        public final void setSessionIdFrom(QuarkString val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.isNull()) {
                this.clearSessionId();
                return;
            }
            val.getTo(this._usrSessionId);
            if (!this.hasSessionId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 8L;
            }
            this._dirty = true;
        }

        public final void setSessionIdFrom(QuarkStringDeserializer val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearSessionId();
                return;
            }
            val.getTo(this._usrSessionId);
            if (!this.hasSessionId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 8L;
            }
            this._dirty = true;
        }

        public final void clearSessionId() {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasSessionId()) {
                return;
            }
            this._usrSessionId.reset();
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFF7L;
            this._dirty = true;
        }

        public final boolean hasTransactionId() {
            return (this._fieldBitmask[0] & 0x10L) != 0L;
        }

        public final XString getTransactionId() {
            if (!this.hasTransactionId() || this._usrTransactionId.isNull()) {
                return null;
            }
            return this._usrTransactionId;
        }

        public final void getTransactionIdTo(XString val) {
            if (!this.hasTransactionId() || this._usrTransactionId.isNull()) {
                val.clear();
                return;
            }
            val.setValue(this._usrTransactionId);
        }

        public final void setTransactionIdFrom(String val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearTransactionId();
                return;
            }
            this._usrTransactionId.setValue(val);
            if (!this.hasTransactionId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x10L;
            }
            this._dirty = true;
        }

        public final void setTransactionIdFrom(XString val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.isNull()) {
                this.clearTransactionId();
                return;
            }
            this._usrTransactionId.setValue(val);
            if (!this.hasTransactionId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x10L;
            }
            this._dirty = true;
        }

        public final void setTransactionIdFrom(CharSequence val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearTransactionId();
                return;
            }
            this._usrTransactionId.setValue(val);
            if (!this.hasTransactionId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x10L;
            }
            this._dirty = true;
        }

        public final void setTransactionIdFrom(long val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            this._usrTransactionId.setValue(val);
            if (!this.hasTransactionId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x10L;
            }
            this._dirty = true;
        }

        public final void setTransactionIdFrom(byte[] val, int offset, int len) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearTransactionId();
                return;
            }
            this._usrTransactionId.setValue(val, offset, len);
            if (!this.hasTransactionId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x10L;
            }
            this._dirty = true;
        }

        public final void setTransactionIdFrom(QuarkString val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.isNull()) {
                this.clearTransactionId();
                return;
            }
            val.getTo(this._usrTransactionId);
            if (!this.hasTransactionId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x10L;
            }
            this._dirty = true;
        }

        public final void setTransactionIdFrom(QuarkStringDeserializer val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearTransactionId();
                return;
            }
            val.getTo(this._usrTransactionId);
            if (!this.hasTransactionId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x10L;
            }
            this._dirty = true;
        }

        public final void clearTransactionId() {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasTransactionId()) {
                return;
            }
            this._usrTransactionId.reset();
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFEFL;
            this._dirty = true;
        }

        public final boolean hasRequestId() {
            return (this._fieldBitmask[0] & 0x20L) != 0L;
        }

        public final XString getRequestId() {
            if (!this.hasRequestId() || this._usrRequestId.isNull()) {
                return null;
            }
            return this._usrRequestId;
        }

        public final void getRequestIdTo(XString val) {
            if (!this.hasRequestId() || this._usrRequestId.isNull()) {
                val.clear();
                return;
            }
            val.setValue(this._usrRequestId);
        }

        public final void setRequestIdFrom(String val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearRequestId();
                return;
            }
            this._usrRequestId.setValue(val);
            if (!this.hasRequestId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x20L;
            }
            this._dirty = true;
        }

        public final void setRequestIdFrom(XString val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.isNull()) {
                this.clearRequestId();
                return;
            }
            this._usrRequestId.setValue(val);
            if (!this.hasRequestId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x20L;
            }
            this._dirty = true;
        }

        public final void setRequestIdFrom(CharSequence val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearRequestId();
                return;
            }
            this._usrRequestId.setValue(val);
            if (!this.hasRequestId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x20L;
            }
            this._dirty = true;
        }

        public final void setRequestIdFrom(long val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            this._usrRequestId.setValue(val);
            if (!this.hasRequestId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x20L;
            }
            this._dirty = true;
        }

        public final void setRequestIdFrom(byte[] val, int offset, int len) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearRequestId();
                return;
            }
            this._usrRequestId.setValue(val, offset, len);
            if (!this.hasRequestId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x20L;
            }
            this._dirty = true;
        }

        public final void setRequestIdFrom(QuarkString val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.isNull()) {
                this.clearRequestId();
                return;
            }
            val.getTo(this._usrRequestId);
            if (!this.hasRequestId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x20L;
            }
            this._dirty = true;
        }

        public final void setRequestIdFrom(QuarkStringDeserializer val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearRequestId();
                return;
            }
            val.getTo(this._usrRequestId);
            if (!this.hasRequestId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x20L;
            }
            this._dirty = true;
        }

        public final void clearRequestId() {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasRequestId()) {
                return;
            }
            this._usrRequestId.reset();
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFDFL;
            this._dirty = true;
        }

        public final boolean hasCredentials() {
            return (this._fieldBitmask[0] & 0x40L) != 0L;
        }

        public final Credentials getCredentials() {
            return this.hasCredentials() ? this._usrCredentials : null;
        }

        public final void getCredentialsTo(Credentials to) {
            to.clear();
            if (!this.hasCredentials()) {
                return;
            }
            this._usrCredentials.sync();
            to.deserializeFrom(this._usrCredentials.getSerializedBuffer(), 0, this._usrCredentials.getSerializedBufferLength());
        }

        public final Credentials takeCredentials() {
            if (this._usrCredentials != null) {
                this._usrCredentials.acquire();
            }
            return this._usrCredentials;
        }

        public final void setCredentials(Credentials val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (this._usrCredentials == val) {
                return;
            }
            if (val == null) {
                this.clearCredentials();
                return;
            }
            if (this._usrCredentials != null) {
                this._usrCredentials.clear();
            }
            this._usrCredentials = val;
            this._fieldBitmask[0] = this._fieldBitmask[0] | 0x40L;
            this._dirty = true;
        }

        public final void setCredentialsFrom(Credentials.Deserializer deserializer) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (deserializer == null) {
                this.clearCredentials();
                return;
            }
            if (this._usrCredentials != null) {
                this._usrCredentials.clear();
            }
            this._usrCredentials = Credentials.create();
            if (deserializer.getSerializedLength() > 0) {
                this._usrCredentials.deserializeFrom(deserializer);
            }
            this._fieldBitmask[0] = this._fieldBitmask[0] | 0x40L;
            this._dirty = true;
        }

        public final void lendCredentials(Credentials val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (this._usrCredentials == val) {
                return;
            }
            if (val == null) {
                this.clearCredentials();
                return;
            }
            if (this._usrCredentials != null) {
                this._usrCredentials.clear();
            }
            val.acquire();
            this._usrCredentials = val;
            this._fieldBitmask[0] = this._fieldBitmask[0] | 0x40L;
            this._dirty = true;
        }

        public final void clearCredentials() {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasCredentials()) {
                return;
            }
            this._usrCredentials.dispose();
            this._usrCredentials = null;
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFBFL;
            this._dirty = true;
        }

        public final boolean hasSenderVersion() {
            return (this._fieldBitmask[0] & 0x80L) != 0L;
        }

        public final Version getSenderVersion() {
            return this.hasSenderVersion() ? this._usrSenderVersion : null;
        }

        public final void getSenderVersionTo(Version to) {
            to.clear();
            if (!this.hasSenderVersion()) {
                return;
            }
            this._usrSenderVersion.sync();
            to.deserializeFrom(this._usrSenderVersion.getSerializedBuffer(), 0, this._usrSenderVersion.getSerializedBufferLength());
        }

        public final Version takeSenderVersion() {
            if (this._usrSenderVersion != null) {
                this._usrSenderVersion.acquire();
            }
            return this._usrSenderVersion;
        }

        public final void setSenderVersion(Version val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (this._usrSenderVersion == val) {
                return;
            }
            if (val == null) {
                this.clearSenderVersion();
                return;
            }
            if (this._usrSenderVersion != null) {
                this._usrSenderVersion.clear();
            }
            this._usrSenderVersion = val;
            this._fieldBitmask[0] = this._fieldBitmask[0] | 0x80L;
            this._dirty = true;
        }

        public final void setSenderVersionFrom(Version.Deserializer deserializer) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (deserializer == null) {
                this.clearSenderVersion();
                return;
            }
            if (this._usrSenderVersion != null) {
                this._usrSenderVersion.clear();
            }
            this._usrSenderVersion = Version.create();
            if (deserializer.getSerializedLength() > 0) {
                this._usrSenderVersion.deserializeFrom(deserializer);
            }
            this._fieldBitmask[0] = this._fieldBitmask[0] | 0x80L;
            this._dirty = true;
        }

        public final void lendSenderVersion(Version val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (this._usrSenderVersion == val) {
                return;
            }
            if (val == null) {
                this.clearSenderVersion();
                return;
            }
            if (this._usrSenderVersion != null) {
                this._usrSenderVersion.clear();
            }
            val.acquire();
            this._usrSenderVersion = val;
            this._fieldBitmask[0] = this._fieldBitmask[0] | 0x80L;
            this._dirty = true;
        }

        public final void clearSenderVersion() {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasSenderVersion()) {
                return;
            }
            this._usrSenderVersion.dispose();
            this._usrSenderVersion = null;
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFF7FL;
            this._dirty = true;
        }

        public final boolean hasError() {
            return (this._fieldBitmask[0] & 0x100L) != 0L;
        }

        public final ErrorContext getError() {
            return this.hasError() ? this._usrError : null;
        }

        public final void getErrorTo(ErrorContext to) {
            to.clear();
            if (!this.hasError()) {
                return;
            }
            this._usrError.sync();
            to.deserializeFrom(this._usrError.getSerializedBuffer(), 0, this._usrError.getSerializedBufferLength());
        }

        public final ErrorContext takeError() {
            if (this._usrError != null) {
                this._usrError.acquire();
            }
            return this._usrError;
        }

        public final void setError(ErrorContext val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (this._usrError == val) {
                return;
            }
            if (val == null) {
                this.clearError();
                return;
            }
            if (this._usrError != null) {
                this._usrError.clear();
            }
            this._usrError = val;
            this._fieldBitmask[0] = this._fieldBitmask[0] | 0x100L;
            this._dirty = true;
        }

        public final void setErrorFrom(ErrorContext.Deserializer deserializer) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (deserializer == null) {
                this.clearError();
                return;
            }
            if (this._usrError != null) {
                this._usrError.clear();
            }
            this._usrError = ErrorContext.create();
            if (deserializer.getSerializedLength() > 0) {
                this._usrError.deserializeFrom(deserializer);
            }
            this._fieldBitmask[0] = this._fieldBitmask[0] | 0x100L;
            this._dirty = true;
        }

        public final void lendError(ErrorContext val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (this._usrError == val) {
                return;
            }
            if (val == null) {
                this.clearError();
                return;
            }
            if (this._usrError != null) {
                this._usrError.clear();
            }
            val.acquire();
            this._usrError = val;
            this._fieldBitmask[0] = this._fieldBitmask[0] | 0x100L;
            this._dirty = true;
        }

        public final void clearError() {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasError()) {
                return;
            }
            this._usrError.dispose();
            this._usrError = null;
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFEFFL;
            this._dirty = true;
        }

        public final void clear() {
            this._readonly = false;
            this.clearCredentials();
            this.clearSenderVersion();
            this.clearError();
            this._fieldBitmask[0] = 0L;
            this._dirty = true;
        }

        private final Pojo setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Pojo clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Pojo setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Pojo clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Pojo setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Pojo clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        public final void setAsReadOnly() {
            this._readonly = true;
        }

        public final boolean isInitialized() {
            return this._initialized;
        }

        public final void setInitialized() {
            this._initialized = true;
        }

        public final void clearDirty() {
            this._dirty = false;
        }

        public final void forceDirty() {
            this._dirty = true;
        }

        public final boolean isDirty() {
            return this._dirty;
        }

        public final int getSerializedLength() {
            int len = 0;
            if (this.hasOrigin()) {
                len += XbufUtil.varlenFieldSerializedLength((int)32752, (int)this._usrOrigin.length());
            }
            if (this.hasSourceId()) {
                len += XbufUtil.varlenFieldSerializedLength((int)32751, (int)this._usrSourceId.length());
            }
            if (this.hasChannelId()) {
                len += XbufUtil.varlenFieldSerializedLength((int)32744, (int)this._usrChannelId.length());
            }
            if (this.hasSessionId()) {
                len += XbufUtil.varlenFieldSerializedLength((int)32750, (int)this._usrSessionId.length());
            }
            if (this.hasTransactionId()) {
                len += XbufUtil.varlenFieldSerializedLength((int)32749, (int)this._usrTransactionId.length());
            }
            if (this.hasRequestId()) {
                len += XbufUtil.varlenFieldSerializedLength((int)32748, (int)this._usrRequestId.length());
            }
            if (this.hasCredentials()) {
                len += this._usrCredentials.hasDirtyPojo() ? XbufUtil.varlenFieldSerializedLength((int)32747, (int)this._usrCredentials.pojo().getSerializedLength()) : XbufUtil.varlenFieldSerializedLength((int)32747, (int)this._usrCredentials.getSerializedBufferLength());
            }
            if (this.hasSenderVersion()) {
                len += this._usrSenderVersion.hasDirtyPojo() ? XbufUtil.varlenFieldSerializedLength((int)32746, (int)this._usrSenderVersion.pojo().getSerializedLength()) : XbufUtil.varlenFieldSerializedLength((int)32746, (int)this._usrSenderVersion.getSerializedBufferLength());
            }
            if (this.hasError()) {
                len += this._usrError.hasDirtyPojo() ? XbufUtil.varlenFieldSerializedLength((int)32745, (int)this._usrError.pojo().getSerializedLength()) : XbufUtil.varlenFieldSerializedLength((int)32745, (int)this._usrError.getSerializedBufferLength());
            }
            return len;
        }

        public final int serialize(Serializer serializer) {
            if (!serializer.isInitialized()) {
                throw new IllegalArgumentException("serializer not initialized");
            }
            if (this.hasOrigin()) {
                serializer.origin(this._usrOrigin);
            }
            if (this.hasSourceId()) {
                serializer.sourceId(this._usrSourceId);
            }
            if (this.hasChannelId()) {
                serializer.channelId(this._usrChannelId);
            }
            if (this.hasSessionId()) {
                serializer.sessionId(this._usrSessionId);
            }
            if (this.hasTransactionId()) {
                serializer.transactionId(this._usrTransactionId);
            }
            if (this.hasRequestId()) {
                serializer.requestId(this._usrRequestId);
            }
            if (this.hasCredentials()) {
                serializer.credentials(this._usrCredentials);
            }
            if (this.hasSenderVersion()) {
                serializer.senderVersion(this._usrSenderVersion);
            }
            if (this.hasError()) {
                serializer.error(this._usrError);
            }
            return serializer.done();
        }

        public final void deserialize(Deserializer deserializer) {
            if (!deserializer.isInitialized()) {
                throw new IllegalArgumentException("deserializer not initialized");
            }
            this.clear();
            deserializer.run(this._deserializationCallback);
            this._initialized = true;
        }

        public final Pojo reset() {
            this.clear();
            this._dirty = false;
            this._initialized = false;
            return this;
        }

        public final Pojo init() {
            return this.reset();
        }

        public final Pojo setPool(UtlPool<Pojo> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Pojo> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memoryStats.onEntityPojoDisposed(MessageHeader.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        private final class DeserializationCallback
        implements Deserializer.Callback {
            private DeserializationCallback() {
            }

            @Override
            public final void handleOrigin(QuarkStringDeserializer val) {
                Pojo.this.setOriginFrom(val);
            }

            @Override
            public final void handleSourceId(QuarkStringDeserializer val) {
                Pojo.this.setSourceIdFrom(val);
            }

            @Override
            public final void handleChannelId(QuarkStringDeserializer val) {
                Pojo.this.setChannelIdFrom(val);
            }

            @Override
            public final void handleSessionId(QuarkStringDeserializer val) {
                Pojo.this.setSessionIdFrom(val);
            }

            @Override
            public final void handleTransactionId(QuarkStringDeserializer val) {
                Pojo.this.setTransactionIdFrom(val);
            }

            @Override
            public final void handleRequestId(QuarkStringDeserializer val) {
                Pojo.this.setRequestIdFrom(val);
            }

            @Override
            public final void handleCredentials(Credentials.Deserializer val) {
                Pojo.this.setCredentialsFrom(val);
            }

            @Override
            public final void handleSenderVersion(Version.Deserializer val) {
                Pojo.this.setSenderVersionFrom(val);
            }

            @Override
            public final void handleError(ErrorContext.Deserializer val) {
                Pojo.this.setErrorFrom(val);
            }
        }
    }

    public static final class Deserializer
    implements UtlPool.Item<Deserializer> {
        private final QuarkStringDeserializer _stringDeserializer = QuarkStringDeserializer.create();
        private final Credentials.Deserializer _credentialsDeserializer = Credentials.Deserializer.create(true);
        private final Version.Deserializer _senderVersionDeserializer = Version.Deserializer.create(true);
        private final ErrorContext.Deserializer _errorDeserializer = ErrorContext.Deserializer.create(true);
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final MemoryStats _memoryStats = MemoryStats.getInstance();
        private final QuarkBuffer.VarintDeserializeLength _varintDeserializeLength = new QuarkBuffer.VarintDeserializeLength();
        private long _addr;
        private int _offset;
        private int _len;
        private UtlPool<Deserializer> _pool;
        private byte _flags;

        Deserializer() {
            this.setCreated();
        }

        public static final Deserializer create(boolean pvt) {
            Deserializer deserializer = (Deserializer)_entityDeserializerPool.get(null);
            if (pvt) {
                deserializer.setPrivate();
            } else {
                deserializer.clearPrivate();
                _memoryStats.onEntityDeserializerAllocated(MessageHeader.class, MemoryStats.EntityType.EmbeddedEntity, !deserializer.isCreated());
            }
            return deserializer.clearPooled();
        }

        public static final Deserializer create() {
            return Deserializer.create(false);
        }

        private final Deserializer setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Deserializer clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Deserializer setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Deserializer clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Deserializer setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Deserializer clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        public final Deserializer init(long addr, int offset, int len) {
            this._addr = addr;
            this._offset = offset;
            this._len = len;
            return this;
        }

        public final Deserializer init(QuarkBuffer buffer, int offset, int len) {
            this._addr = buffer.getNativeAddress();
            this._offset = offset;
            this._len = len;
            return this;
        }

        public final boolean isInitialized() {
            return this._addr != 0L;
        }

        public final int getSerializedLength() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            return this._len;
        }

        public final void getTo(QuarkBuffer buffer, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (buffer.getCapacity() - offset < this._len) {
                throw new IllegalArgumentException("not enough space in supplied buffer");
            }
            buffer.putFrom(offset, this._addr, this._offset, this._len);
        }

        public final int getTo(long addr, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            QuarkBuffer.copy((long)this._addr, (int)this._offset, (long)addr, (int)offset, (int)this._len);
            return this._len;
        }

        public final void run(Callback cb) {
            int flen;
            int tlen;
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            long addr = this._addr;
            int lim = this._offset + this._len;
            block17: for (int pos = this._offset; pos < lim; pos += tlen + flen) {
                int ftag = QuarkBuffer.getVarint32((long)addr, (int)pos, (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                int ftype = ftag & 7;
                switch (ftag >>> 3) {
                    case 32752: {
                        if (ftype != 2) {
                            throw new IllegalStateException("field type mismatch (exp=0x02, actual=" + ftype + ") for field 32752");
                        }
                        tlen = this._varintDeserializeLength.value;
                        flen = QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                        cb.handleOrigin(this._stringDeserializer.init(addr, pos + tlen + this._varintDeserializeLength.value, flen));
                        flen += this._varintDeserializeLength.value;
                        continue block17;
                    }
                    case 32751: {
                        if (ftype != 2) {
                            throw new IllegalStateException("field type mismatch (exp=0x02, actual=" + ftype + ") for field 32751");
                        }
                        tlen = this._varintDeserializeLength.value;
                        flen = QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                        cb.handleSourceId(this._stringDeserializer.init(addr, pos + tlen + this._varintDeserializeLength.value, flen));
                        flen += this._varintDeserializeLength.value;
                        continue block17;
                    }
                    case 32744: {
                        if (ftype != 2) {
                            throw new IllegalStateException("field type mismatch (exp=0x02, actual=" + ftype + ") for field 32744");
                        }
                        tlen = this._varintDeserializeLength.value;
                        flen = QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                        cb.handleChannelId(this._stringDeserializer.init(addr, pos + tlen + this._varintDeserializeLength.value, flen));
                        flen += this._varintDeserializeLength.value;
                        continue block17;
                    }
                    case 32750: {
                        if (ftype != 2) {
                            throw new IllegalStateException("field type mismatch (exp=0x02, actual=" + ftype + ") for field 32750");
                        }
                        tlen = this._varintDeserializeLength.value;
                        flen = QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                        cb.handleSessionId(this._stringDeserializer.init(addr, pos + tlen + this._varintDeserializeLength.value, flen));
                        flen += this._varintDeserializeLength.value;
                        continue block17;
                    }
                    case 32749: {
                        if (ftype != 2) {
                            throw new IllegalStateException("field type mismatch (exp=0x02, actual=" + ftype + ") for field 32749");
                        }
                        tlen = this._varintDeserializeLength.value;
                        flen = QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                        cb.handleTransactionId(this._stringDeserializer.init(addr, pos + tlen + this._varintDeserializeLength.value, flen));
                        flen += this._varintDeserializeLength.value;
                        continue block17;
                    }
                    case 32748: {
                        if (ftype != 2) {
                            throw new IllegalStateException("field type mismatch (exp=0x02, actual=" + ftype + ") for field 32748");
                        }
                        tlen = this._varintDeserializeLength.value;
                        flen = QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                        cb.handleRequestId(this._stringDeserializer.init(addr, pos + tlen + this._varintDeserializeLength.value, flen));
                        flen += this._varintDeserializeLength.value;
                        continue block17;
                    }
                    case 32747: {
                        if (ftype != 2) {
                            throw new IllegalStateException("field type mismatch (exp=0x02, actual=" + ftype + ") for field 32747");
                        }
                        tlen = this._varintDeserializeLength.value;
                        flen = QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                        cb.handleCredentials(this._credentialsDeserializer.init(addr, pos + tlen + this._varintDeserializeLength.value, flen));
                        flen += this._varintDeserializeLength.value;
                        continue block17;
                    }
                    case 32746: {
                        if (ftype != 2) {
                            throw new IllegalStateException("field type mismatch (exp=0x02, actual=" + ftype + ") for field 32746");
                        }
                        tlen = this._varintDeserializeLength.value;
                        flen = QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                        cb.handleSenderVersion(this._senderVersionDeserializer.init(addr, pos + tlen + this._varintDeserializeLength.value, flen));
                        flen += this._varintDeserializeLength.value;
                        continue block17;
                    }
                    case 32745: {
                        if (ftype != 2) {
                            throw new IllegalStateException("field type mismatch (exp=0x02, actual=" + ftype + ") for field 32745");
                        }
                        tlen = this._varintDeserializeLength.value;
                        flen = QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                        cb.handleError(this._errorDeserializer.init(addr, pos + tlen + this._varintDeserializeLength.value, flen));
                        flen += this._varintDeserializeLength.value;
                        continue block17;
                    }
                    default: {
                        switch (ftype) {
                            case 0: {
                                tlen = this._varintDeserializeLength.value;
                                QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                                flen = this._varintDeserializeLength.value;
                                continue block17;
                            }
                            case 1: {
                                tlen = this._varintDeserializeLength.value;
                                flen = 8;
                                continue block17;
                            }
                            case 2: {
                                tlen = this._varintDeserializeLength.value;
                                flen = QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                                flen += this._varintDeserializeLength.value;
                                continue block17;
                            }
                            case 5: {
                                tlen = this._varintDeserializeLength.value;
                                flen = 4;
                                continue block17;
                            }
                        }
                        throw new IllegalStateException("corrupt field - #" + (QuarkBuffer.getVarint32((long)addr, (int)pos, (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength) >>> 3));
                    }
                }
            }
        }

        public final Deserializer init() {
            return this;
        }

        public final Deserializer setPool(UtlPool<Deserializer> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Deserializer> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memoryStats.onEntityDeserializerDisposed(MessageHeader.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        public static interface Callback {
            public void handleOrigin(QuarkStringDeserializer var1);

            public void handleSourceId(QuarkStringDeserializer var1);

            public void handleChannelId(QuarkStringDeserializer var1);

            public void handleSessionId(QuarkStringDeserializer var1);

            public void handleTransactionId(QuarkStringDeserializer var1);

            public void handleRequestId(QuarkStringDeserializer var1);

            public void handleCredentials(Credentials.Deserializer var1);

            public void handleSenderVersion(Version.Deserializer var1);

            public void handleError(ErrorContext.Deserializer var1);
        }
    }

    public static final class Serializer
    implements UtlPool.Item<Serializer>,
    AdmRuntime.BufferSizer {
        private final Credentials.Serializer _credentialsSerializer = Credentials.Serializer.create(true);
        private final Version.Serializer _senderVersionSerializer = Version.Serializer.create(true);
        private final ErrorContext.Serializer _errorSerializer = ErrorContext.Serializer.create(true);
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final MemoryStats _memoryStats = MemoryStats.getInstance();
        private MessageHeader _entity;
        private int _len;
        private long _addr;
        private AdmRuntime.BufferSizer _sizer;
        private UtlPool<Serializer> _pool;
        private byte _flags;

        Serializer() {
            this.setCreated();
        }

        public static final Serializer create(boolean pvt) {
            Serializer serializer = (Serializer)_entitySerializerPool.get(null);
            if (pvt) {
                serializer.setPrivate();
            } else {
                serializer.clearPrivate();
                _memoryStats.onEntitySerializerAllocated(MessageHeader.class, MemoryStats.EntityType.EmbeddedEntity, !serializer.isCreated());
            }
            return serializer.clearPooled();
        }

        public static final Serializer create() {
            return Serializer.create(false);
        }

        private final Serializer setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Serializer clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Serializer setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Serializer clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Serializer setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Serializer clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        private final void ensureCapacity(int val) {
            if (this._sizer != null) {
                this._addr = this._sizer.ensureCapacity(this._addr, val);
            }
        }

        final Serializer init(MessageHeader entity) {
            this.init(entity.getSerializedBuffer(), 0);
            this._entity = entity;
            return this;
        }

        public final Serializer init(long addr, int len) {
            this._entity = null;
            this._len = len;
            this._addr = addr;
            return this;
        }

        public final Serializer init(QuarkBuffer buffer, int len) {
            return this.init(buffer.getNativeAddress(), len);
        }

        public final Serializer init(QuarkBuffer buffer) {
            return this.init(buffer.getNativeAddress(), 0);
        }

        public final Serializer setSizer(AdmRuntime.BufferSizer sizer) {
            this._sizer = sizer;
            return this;
        }

        public final boolean hasSizer() {
            return this._sizer != null;
        }

        public final boolean isInitialized() {
            return this._addr != 0L;
        }

        public final int getSerializedLength() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            return this._len;
        }

        public final void getTo(QuarkBuffer buffer, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (buffer.getCapacity() - offset < this._len) {
                throw new IllegalArgumentException("not enough space in supplied buffer");
            }
            buffer.putFrom(offset, this._addr, 0, this._len);
        }

        public final int getTo(long addr, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            QuarkBuffer.copy((long)this._addr, (int)0, (long)addr, (int)offset, (int)this._len);
            return this._len;
        }

        public final void putFrom(QuarkBuffer buffer, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + len);
            }
            buffer.getTo(offset, this._addr, this._len, len);
            this._len += len;
        }

        public final void putFrom(long addr, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + len);
            }
            QuarkBuffer.copy((long)addr, (int)offset, (long)this._addr, (int)this._len, (int)len);
            this._len += len;
        }

        public final Serializer origin(String val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32752, (int)QuarkBuffer.calculateUTF8Length((CharSequence)val)));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262018);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            this._len += QuarkBuffer.putUTF8CharSequence((long)this._addr, (int)this._len, (CharSequence)val);
            return this;
        }

        public final Serializer origin(QuarkString val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null || val.isNull()) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32752, (int)val.length()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262018);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer origin(XString val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null || val.isNull()) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32752, (int)val.serializedLength()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262018);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            val.getBackingBuffer().getToNative(val.getBackingBufferOffset(), this._addr, this._len, val.serializedLength());
            this._len += val.serializedLength();
            return this;
        }

        public final Serializer origin(byte[] val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32752, (int)len));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262018);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)len);
            QuarkBuffer.putFrom((long)this._addr, (int)this._len, (byte[])val, (int)offset, (int)len);
            this._len += len;
            return this;
        }

        public final Serializer origin(byte[] val) {
            return this.origin(val, 0, val.length);
        }

        public final Serializer origin(QuarkStringDeserializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32752, (int)val.serializedLength()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262018);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.serializedLength());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer origin(QuarkBuffer val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32752, (int)len));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262018);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)len);
            val.getTo(offset, this._addr, this._len, len);
            this._len += len;
            return this;
        }

        public final Serializer sourceId(String val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32751, (int)QuarkBuffer.calculateUTF8Length((CharSequence)val)));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262010);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            this._len += QuarkBuffer.putUTF8CharSequence((long)this._addr, (int)this._len, (CharSequence)val);
            return this;
        }

        public final Serializer sourceId(QuarkString val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null || val.isNull()) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32751, (int)val.length()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262010);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer sourceId(XString val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null || val.isNull()) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32751, (int)val.serializedLength()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262010);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            val.getBackingBuffer().getToNative(val.getBackingBufferOffset(), this._addr, this._len, val.serializedLength());
            this._len += val.serializedLength();
            return this;
        }

        public final Serializer sourceId(byte[] val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32751, (int)len));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262010);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)len);
            QuarkBuffer.putFrom((long)this._addr, (int)this._len, (byte[])val, (int)offset, (int)len);
            this._len += len;
            return this;
        }

        public final Serializer sourceId(byte[] val) {
            return this.sourceId(val, 0, val.length);
        }

        public final Serializer sourceId(QuarkStringDeserializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32751, (int)val.serializedLength()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262010);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.serializedLength());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer sourceId(QuarkBuffer val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32751, (int)len));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262010);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)len);
            val.getTo(offset, this._addr, this._len, len);
            this._len += len;
            return this;
        }

        public final Serializer channelId(String val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32744, (int)QuarkBuffer.calculateUTF8Length((CharSequence)val)));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)261954);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            this._len += QuarkBuffer.putUTF8CharSequence((long)this._addr, (int)this._len, (CharSequence)val);
            return this;
        }

        public final Serializer channelId(QuarkString val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null || val.isNull()) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32744, (int)val.length()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)261954);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer channelId(XString val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null || val.isNull()) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32744, (int)val.serializedLength()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)261954);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            val.getBackingBuffer().getToNative(val.getBackingBufferOffset(), this._addr, this._len, val.serializedLength());
            this._len += val.serializedLength();
            return this;
        }

        public final Serializer channelId(byte[] val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32744, (int)len));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)261954);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)len);
            QuarkBuffer.putFrom((long)this._addr, (int)this._len, (byte[])val, (int)offset, (int)len);
            this._len += len;
            return this;
        }

        public final Serializer channelId(byte[] val) {
            return this.channelId(val, 0, val.length);
        }

        public final Serializer channelId(QuarkStringDeserializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32744, (int)val.serializedLength()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)261954);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.serializedLength());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer channelId(QuarkBuffer val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32744, (int)len));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)261954);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)len);
            val.getTo(offset, this._addr, this._len, len);
            this._len += len;
            return this;
        }

        public final Serializer sessionId(String val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32750, (int)QuarkBuffer.calculateUTF8Length((CharSequence)val)));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262002);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            this._len += QuarkBuffer.putUTF8CharSequence((long)this._addr, (int)this._len, (CharSequence)val);
            return this;
        }

        public final Serializer sessionId(QuarkString val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null || val.isNull()) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32750, (int)val.length()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262002);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer sessionId(XString val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null || val.isNull()) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32750, (int)val.serializedLength()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262002);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            val.getBackingBuffer().getToNative(val.getBackingBufferOffset(), this._addr, this._len, val.serializedLength());
            this._len += val.serializedLength();
            return this;
        }

        public final Serializer sessionId(byte[] val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32750, (int)len));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262002);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)len);
            QuarkBuffer.putFrom((long)this._addr, (int)this._len, (byte[])val, (int)offset, (int)len);
            this._len += len;
            return this;
        }

        public final Serializer sessionId(byte[] val) {
            return this.sessionId(val, 0, val.length);
        }

        public final Serializer sessionId(QuarkStringDeserializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32750, (int)val.serializedLength()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262002);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.serializedLength());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer sessionId(QuarkBuffer val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32750, (int)len));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262002);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)len);
            val.getTo(offset, this._addr, this._len, len);
            this._len += len;
            return this;
        }

        public final Serializer transactionId(String val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32749, (int)QuarkBuffer.calculateUTF8Length((CharSequence)val)));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)261994);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            this._len += QuarkBuffer.putUTF8CharSequence((long)this._addr, (int)this._len, (CharSequence)val);
            return this;
        }

        public final Serializer transactionId(QuarkString val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null || val.isNull()) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32749, (int)val.length()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)261994);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer transactionId(XString val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null || val.isNull()) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32749, (int)val.serializedLength()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)261994);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            val.getBackingBuffer().getToNative(val.getBackingBufferOffset(), this._addr, this._len, val.serializedLength());
            this._len += val.serializedLength();
            return this;
        }

        public final Serializer transactionId(byte[] val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32749, (int)len));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)261994);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)len);
            QuarkBuffer.putFrom((long)this._addr, (int)this._len, (byte[])val, (int)offset, (int)len);
            this._len += len;
            return this;
        }

        public final Serializer transactionId(byte[] val) {
            return this.transactionId(val, 0, val.length);
        }

        public final Serializer transactionId(QuarkStringDeserializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32749, (int)val.serializedLength()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)261994);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.serializedLength());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer transactionId(QuarkBuffer val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32749, (int)len));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)261994);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)len);
            val.getTo(offset, this._addr, this._len, len);
            this._len += len;
            return this;
        }

        public final Serializer requestId(String val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32748, (int)QuarkBuffer.calculateUTF8Length((CharSequence)val)));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)261986);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            this._len += QuarkBuffer.putUTF8CharSequence((long)this._addr, (int)this._len, (CharSequence)val);
            return this;
        }

        public final Serializer requestId(QuarkString val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null || val.isNull()) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32748, (int)val.length()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)261986);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer requestId(XString val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null || val.isNull()) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32748, (int)val.serializedLength()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)261986);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            val.getBackingBuffer().getToNative(val.getBackingBufferOffset(), this._addr, this._len, val.serializedLength());
            this._len += val.serializedLength();
            return this;
        }

        public final Serializer requestId(byte[] val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32748, (int)len));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)261986);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)len);
            QuarkBuffer.putFrom((long)this._addr, (int)this._len, (byte[])val, (int)offset, (int)len);
            this._len += len;
            return this;
        }

        public final Serializer requestId(byte[] val) {
            return this.requestId(val, 0, val.length);
        }

        public final Serializer requestId(QuarkStringDeserializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32748, (int)val.serializedLength()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)261986);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.serializedLength());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer requestId(QuarkBuffer val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32748, (int)len));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)261986);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)len);
            val.getTo(offset, this._addr, this._len, len);
            this._len += len;
            return this;
        }

        public final Serializer credentials(Credentials val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            val.sync();
            int serializedEntityLength = val.getSerializedBufferLength();
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32747, (int)serializedEntityLength));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)261978);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)serializedEntityLength);
            val.serializeTo(this._addr, this._len);
            this._len += serializedEntityLength;
            return this;
        }

        public final Serializer credentials(Credentials.Serializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32747, (int)val.getSerializedLength()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)261978);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.getSerializedLength());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer credentials(Credentials.Deserializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32747, (int)val.getSerializedLength()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)261978);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.getSerializedLength());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer credentials(QuarkBuffer val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null && (offset > 0 || len > 0)) {
                throw new IllegalArgumentException("null buffer can only be specified with offset=0 and len=0 (to serialize an empty entity))");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32747, (int)len));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)261978);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)len);
            if (val != null) {
                val.getTo(offset, this._addr, this._len, len);
            }
            this._len += len;
            return this;
        }

        public final Serializer senderVersion(Version val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            val.sync();
            int serializedEntityLength = val.getSerializedBufferLength();
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32746, (int)serializedEntityLength));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)261970);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)serializedEntityLength);
            val.serializeTo(this._addr, this._len);
            this._len += serializedEntityLength;
            return this;
        }

        public final Serializer senderVersion(Version.Serializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32746, (int)val.getSerializedLength()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)261970);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.getSerializedLength());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer senderVersion(Version.Deserializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32746, (int)val.getSerializedLength()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)261970);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.getSerializedLength());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer senderVersion(QuarkBuffer val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null && (offset > 0 || len > 0)) {
                throw new IllegalArgumentException("null buffer can only be specified with offset=0 and len=0 (to serialize an empty entity))");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32746, (int)len));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)261970);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)len);
            if (val != null) {
                val.getTo(offset, this._addr, this._len, len);
            }
            this._len += len;
            return this;
        }

        public final Serializer error(ErrorContext val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            val.sync();
            int serializedEntityLength = val.getSerializedBufferLength();
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32745, (int)serializedEntityLength));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)261962);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)serializedEntityLength);
            val.serializeTo(this._addr, this._len);
            this._len += serializedEntityLength;
            return this;
        }

        public final Serializer error(ErrorContext.Serializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32745, (int)val.getSerializedLength()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)261962);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.getSerializedLength());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer error(ErrorContext.Deserializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32745, (int)val.getSerializedLength()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)261962);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.getSerializedLength());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer error(QuarkBuffer val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null && (offset > 0 || len > 0)) {
                throw new IllegalArgumentException("null buffer can only be specified with offset=0 and len=0 (to serialize an empty entity))");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32745, (int)len));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)261962);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)len);
            if (val != null) {
                val.getTo(offset, this._addr, this._len, len);
            }
            this._len += len;
            return this;
        }

        public final int done() {
            if (this._entity != null) {
                this._entity.setSerializedBufferLength(this._len);
            }
            return this._len;
        }

        public final Serializer init() {
            return this;
        }

        public final Serializer setPool(UtlPool<Serializer> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Serializer> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memoryStats.onEntitySerializerDisposed(MessageHeader.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        public final long ensureCapacity(long addr, int capacity) {
            this._addr = this._sizer.ensureCapacity(addr, capacity);
            return this._addr;
        }
    }

    private static final class MessageHeaderDeserializerPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Deserializer> {
        private MessageHeaderDeserializerPoolEvictedItemReceiver() {
        }

        public final void process(Deserializer evictedItem) {
            _memoryStats.onEntityDeserializerLeaked(MessageHeader.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class MessageHeaderDeserializerPoolFactory
    implements UtlPool.Factory<Deserializer> {
        private MessageHeaderDeserializerPoolFactory() {
        }

        public final Deserializer createItem(Object object) {
            return new Deserializer();
        }

        public final Deserializer[] createItemArray(int size) {
            return new Deserializer[size];
        }
    }

    private static final class MessageHeaderSerializerPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Serializer> {
        private MessageHeaderSerializerPoolEvictedItemReceiver() {
        }

        public final void process(Serializer evictedItem) {
            _memoryStats.onEntitySerializerLeaked(MessageHeader.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class MessageHeaderSerializerPoolFactory
    implements UtlPool.Factory<Serializer> {
        private MessageHeaderSerializerPoolFactory() {
        }

        public final Serializer createItem(Object object) {
            return new Serializer();
        }

        public final Serializer[] createItemArray(int size) {
            return new Serializer[size];
        }
    }

    private static final class MessageHeaderPojoPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Pojo> {
        private MessageHeaderPojoPoolEvictedItemReceiver() {
        }

        public final void process(Pojo evictedItem) {
            _memoryStats.onEntityPojoLeaked(MessageHeader.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class MessageHeaderPojoPoolFactory
    implements UtlPool.Factory<Pojo> {
        private MessageHeaderPojoPoolFactory() {
        }

        public final Pojo createItem(Object object) {
            return new Pojo();
        }

        public final Pojo[] createItemArray(int size) {
            return new Pojo[size];
        }
    }

    private static final class MessageHeaderPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<MessageHeader> {
        private MessageHeaderPoolEvictedItemReceiver() {
        }

        public final void process(MessageHeader evictedItem) {
            _memoryStats.onEntityLeaked(MessageHeader.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class MessageHeaderPoolFactory
    implements UtlPool.Factory<MessageHeader> {
        private MessageHeaderPoolFactory() {
        }

        public final MessageHeader createItem(Object object) {
            return new MessageHeader();
        }

        public final MessageHeader[] createItemArray(int size) {
            return new MessageHeader[size];
        }
    }

    static final class MessageHeaderPoolFactoryItemCreateArgument {
        UUID id;
        boolean wasCreated;

        MessageHeaderPoolFactoryItemCreateArgument() {
        }

        MessageHeaderPoolFactoryItemCreateArgument init(UUID id) {
            this.id = id;
            this.wasCreated = false;
            return this;
        }
    }

    public static final class PacketBody
    extends PktBodyData {
        private PacketBody(Properties props, boolean direct) {
            super(4330342, props, direct);
        }

        public static PktBody create(Properties props) {
            return new PacketBody(props, true);
        }

        public static PktBody create() {
            return PacketBody.create(null);
        }
    }
}

